<?php 

include_once "class.abs_class_trait.inc";

abstract class base_class {
	use base_class_trait;

	// 資料庫連線
	protected $pdo_sql;
	//四大系統資料庫
	protected $pdo_hty;
	//產量資料庫
	protected $pdo_ems;
	// 資料庫相關參數
	protected $datasource;
	protected $database_trend;
	protected $database_alarm;
	protected $uid;
	protected $pwd;
	
	
	public function SetDataBase ($ds, $db, $db2, $id, $pw, $is_conn) {
		$this->datasource     = $ds;
		$this->database_trend = $db;
		$this->database_alarm = $db2;
		$this->uid = $id;
		$this->pwd = $pw;
		if ($is_conn) {
			$this->SetPdoConn(new PDO(sprintf("sqlsrv:Server=%s; Database=%s;", $this->datasource, $this->database_trend), $this->uid, $this->pwd)); 
			//先確認連線位置的狀態，可以連接時再建立sql連線
			$check = @fsockopen(HTY_Server, '1433', $errno, $errstr, 0.2);	
			if ($check) {
				$this->pdo_hty = new PDO(sprintf("sqlsrv:Server=%s; Database=%s;ConnectionPooling=0", HTY_Server, HTY_Database), HTY_UserID, HTY_Password);
				// PDO 設定為例外模式(exception mode)，或是在捕捉例外的部分沒有處理到此類例外
				$this->pdo_hty->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
			}else{
				$this->pdo_hty = null;
			}

			//先確認連線位置的狀態，可以連接時再建立sql連線
			$check = @fsockopen(EMS_Server, '1433', $errno, $errstr, 0.2);	
			if ($check) {
				$this->pdo_ems = new PDO(sprintf("sqlsrv:Server=%s; Database=%s;ConnectionPooling=0", EMS_Server, EMS_Database), EMS_UserID, EMS_Password);
				// PDO 設定為例外模式(exception mode)，或是在捕捉例外的部分沒有處理到此類例外
				$this->pdo_ems->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
			}else{
				$this->pdo_ems = null;
			}
		}
	}
	
	public function SetPdoConn ($conn) {
		$this->pdo_sql = $conn;
		// PDO 設定為例外模式(exception mode)，或是在捕捉例外的部分沒有處理到此類例外
		$this->pdo_sql->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
	}
	
	
	public function InputDecode ($input) {
		$input_decode = json_decode($input, true);
		return is_string($input) && is_array($input_decode) && (json_last_error() == JSON_ERROR_NONE) ? $input_decode : $input;
	}
	
	public function XSSFilter ($val) {
		return htmlspecialchars(strip_tags($val), ENT_QUOTES);
	}
	
	private function _SetErrorLog ($msg, $sqlstr='', $params=array()) {
		file_put_contents("./Api_log/Error_".date("Ymd").".txt", print_r(array(
			"time_stamp" => date("Y-m-d H:i:s"),
			"message" => $msg,
			"sqlstr" => $sqlstr,
			"params" => $params
		), true)."\r\n", FILE_APPEND);
	}
}
?>