<?php
// 頁面專用WebAPI, 不管任何的頁面, class名稱固定為 [WebAPIForMenuPage], 不可變更
class WebAPIForMenuPage extends base_class
{


	//	撈取圓餅圖資料
	public function SelectPieData($params)
	{
		//時間條件
		$s_date = (string) $params['date'];
		//年月
		$s_year_month = (string) $params['year_month'];
		//條件範圍 單日:day 單月:month
		$s_range = (string) $params['range'];
		//要撈取的設備ID清單
		$a_id_list = (array) $params['id_list'];
		//要撈取的設備群組 電力、蒸汽、瓦斯、水
		$s_data_group = (string) $params['data_group'];


		$s_start_time = date("Y-m-d 00:00:00");
		$s_end_time = date("Y-m-d 23:59:59");
		if($s_range == "day")
		{
			$s_start_time = date("Y-m-d 00:00:00", strtotime($s_date));
			$s_end_time = date("Y-m-d 23:59:59", strtotime($s_date));
		}
		else if($s_range == "month")
		{
			$s_start_time = date("Y-m-d 00:00:00", strtotime($s_year_month));
			$s_end_time = date("Y-m-t 23:59:59", strtotime($s_year_month));
		}
		//整理設備ID清單
		$a_temp_id_list = explode(",", implode(",", $a_id_list));
		$a_temp_id_list = array_unique($a_temp_id_list);
		// $s_id_list = implode(",", $a_temp_id_list);

		// //區域條件設定
		// $s_where_cte = "";
		// $s_where_tid = "";
		// if ($s_id_list != "") {
		// 	$s_where_cte = " AND _rg.ID IN ($s_id_list) ";
		// 	$s_where_tid = " AND _sf.Tid IN ($s_id_list) ";
		// }
		//依據設備群組設定要撈取的資料表
		$s_tabel_prefix = "";
		switch ($s_data_group) {
			case '電力':
				$s_tabel_prefix = "PM";
				break;
			case '蒸汽':
				$s_tabel_prefix = "SM";
				break;
			case '瓦斯':
				$s_tabel_prefix = "GM";
				break;
			case '水':
				$s_tabel_prefix = "WM";
				break;
		}
		if ($s_tabel_prefix == "") {
			throw new Exception("設備群組錯誤", 1);
		}

		$res_data = [];
		if ($s_tabel_prefix == "PM")
		{
			$param_temp = [
				'id_list'=> $a_temp_id_list,
				'range'=> $s_range == "day" ? 'start_end_date' : $s_range,
				'month' => $s_year_month,
				'start'=> $s_start_time,
				'end'=> $s_end_time,
			];
			$res_data = $this->SelectDosageP($param_temp);
		}
		else
		{
			$param_temp = [
				't_class' => $s_tabel_prefix,
				'id_list'=> $a_temp_id_list,
				'range'=> $s_range == "day" ? 'start_end_date' : $s_range,
				'month' => $s_year_month,
				'start'=> $s_start_time,
				'end'=> $s_end_time,
			];
			$res_data = $this->SelectDosageSGW($param_temp);
		}
		return $res_data;
		
		// //資料暫存陣列
		// $a_temp_date = [];
		// //撈取設備ID清單 因R_GM資料表中的ID欄位沒有索引，所以把設備ID的部分分開查詢，避免影響效能
		// //並先預設好要取值的四個參數為0，防止新設備在R_GM沒有資料
		// $sql_id_list = "SELECT
		// 					_sf.Tid AS ID
		// 				FROM
		// 					[dbo].[surface] AS _sf
		// 				WHERE
		// 					_sf.Tclass = '$s_tabel_prefix'
		// 					$s_where_tid
		// 				ORDER BY
		// 					_sf.Tid ASC";
		// if ($this->pdo_hty != null) {
		// 	$sth = $this->pdo_hty->prepare($sql_id_list);
		// 	$sth->execute([]);
		// 	$rows = $sth->fetchAll(PDO::FETCH_ASSOC);
		// 	foreach ($rows as $k => $v) {
		// 		//資料初始化要區分
		// 		//電力
		// 		if ($s_tabel_prefix == "PM") {
		// 			$a_temp_date[(int) $v["ID"]] = [
		// 				"ID" => (int)$v["ID"],
		// 				"MIN_KWH" => 0,
		// 				"MAX_KWH" => 0,
		// 			];
		// 		}
		// 		//蒸汽、瓦斯、水 
		// 		else {
		// 			$a_temp_date[(int) $v["ID"]] = [
		// 				"ID" => (int)$v["ID"],
		// 				"MIN_Acc" => 0,
		// 				"MAX_Acc" => 0,
		// 				"MIN_Flow" => 0,
		// 				"MAX_Flow" => 0,
		// 			];
		// 		}
		// 	}
		// }
		// //電力
		// if ($s_tabel_prefix == "PM") {
		// 	$sql = "SELECT DISTINCT
		// 					ID,
		// 					(
		// 					SELECT TOP
		// 						1 KWH 
		// 					FROM
		// 						R_PM 
		// 					WHERE
		// 						ID = _rp.ID 
		// 						AND DATE_TIME BETWEEN '$s_start_time' AND '$s_end_time' 
		// 					ORDER BY
		// 						DATE_TIME ASC 
		// 					) AS MIN_KWH,
		// 					(
		// 					SELECT TOP
		// 						1 KWH 
		// 					FROM
		// 						R_PM 
		// 					WHERE
		// 						ID = _rp.ID 
		// 						AND DATE_TIME BETWEEN '$s_start_time' AND '$s_end_time' 
		// 					ORDER BY
		// 						DATE_TIME DESC 
		// 					) AS MAX_KWH
		// 				FROM
		// 					[dbo].[R_PM] AS _rp 
		// 				WHERE
		// 					_rp.DATE_TIME BETWEEN '$s_start_time' AND '$s_end_time' 
		// 					AND _rp.ID IN ($s_id_list)";
		// 	if ($this->pdo_hty != null) {
		// 		$sth = $this->pdo_hty->prepare($sql);
		// 		$sth->execute([]);
		// 		$rows = $sth->fetchAll(PDO::FETCH_ASSOC);
		// 		foreach ($rows as $k => &$v) {
		// 			$a_temp_date[(int) $v["ID"]]["ID"] = (int) $v["ID"];
		// 			$a_temp_date[(int) $v["ID"]]["MIN_KWH"] = number_format($v["MIN_KWH"], 2, ".", "");
		// 			$a_temp_date[(int) $v["ID"]]["MAX_KWH"] = number_format($v["MAX_KWH"], 2, ".", "");
		// 		}
		// 	}
		// }
		// //蒸汽、瓦斯、水 
		// else {
		// 	// $sql = "WITH range_row_no AS (
		// 	// 		SELECT MAX
		// 	// 			( _rg.RowNO ) AS Max_no,
		// 	// 			MIN ( _rg.RowNO ) AS Min_no,
		// 	// 			ID 
		// 	// 		FROM
		// 	// 			[dbo].[R_$s_tabel_prefix] AS _rg 
		// 	// 		WHERE
		// 	// 			_rg.DATE_TIME BETWEEN '$s_start_time' AND '$s_end_time' 
		// 	// 			$s_where_cte 
		// 	// 		GROUP BY
		// 	// 			_rg.ID 
		// 	// 		)
		// 	// 		SELECT
		// 	// 			_rg.ID ,
		// 	// 			( SELECT Acc FROM R_$s_tabel_prefix WHERE RowNO = _rg.Min_no ) AS MIN_Acc,
		// 	// 			(
		// 	// 			SELECT TOP
		// 	// 				1 Acc 
		// 	// 			FROM
		// 	// 				R_$s_tabel_prefix 
		// 	// 			WHERE
		// 	// 				RowNO = _rg.Max_no 
		// 	// 			) AS MAX_Acc,
		// 	// 			(
		// 	// 			SELECT TOP
		// 	// 				1 Flow 
		// 	// 			FROM
		// 	// 				R_$s_tabel_prefix 
		// 	// 			WHERE
		// 	// 				RowNO = _rg.Min_no 
		// 	// 			) AS MIN_Flow,
		// 	// 			(
		// 	// 			SELECT TOP
		// 	// 				1 Flow 
		// 	// 			FROM
		// 	// 				R_$s_tabel_prefix 
		// 	// 			WHERE
		// 	// 				RowNO = _rg.Max_no 
		// 	// 			) AS MAX_Flow 
		// 	// 		FROM
		// 	// 			range_row_no AS _rg ";

		// 	$sql = "WITH r_data AS (
		// 		SELECT DISTINCT
		// 			ID,
		// 			(
		// 			/* 第一筆Acc */
		// 			SELECT TOP 1 
		// 				Acc 
		// 			FROM
		// 				R_$s_tabel_prefix  WITH (NOLOCK)
		// 			WHERE
		// 				ID = _rg.ID 
		// 				AND DATE_TIME BETWEEN '$s_start_time' AND '$s_end_time' 
		// 			ORDER BY
		// 				DATE_TIME ASC 
		// 			) AS MIN_Acc,
		// 			(
		// 			/* 第一筆Flow */
		// 			SELECT TOP 1 
		// 				Flow 
		// 			FROM
		// 				R_$s_tabel_prefix  WITH (NOLOCK)
		// 			WHERE
		// 				ID = _rg.ID 
		// 				AND DATE_TIME BETWEEN '$s_start_time' AND '$s_end_time' 
		// 			ORDER BY
		// 				DATE_TIME ASC 
		// 			) AS MIN_Flow,
		// 			(
		// 			/* 最後一筆Acc */
		// 			SELECT TOP 1 
		// 				Acc 
		// 			FROM
		// 				R_$s_tabel_prefix  WITH (NOLOCK)
		// 			WHERE
		// 				ID = _rg.ID 
		// 				AND DATE_TIME BETWEEN '$s_start_time' AND '$s_end_time' 
		// 			ORDER BY
		// 				DATE_TIME DESC 
		// 			) AS MAX_Acc,
		// 			(
		// 			/* 最後一筆Flow */
		// 			SELECT TOP 1 
		// 				Flow 
		// 			FROM
		// 				R_$s_tabel_prefix  WITH (NOLOCK)
		// 			WHERE
		// 				ID = _rg.ID 
		// 				AND DATE_TIME BETWEEN '$s_start_time' AND '$s_end_time' 
		// 			ORDER BY
		// 				DATE_TIME DESC 
		// 			) AS MAX_Flow
		// 		FROM
		// 			[dbo].[R_$s_tabel_prefix] AS _rg  WITH (NOLOCK)
		// 		WHERE
		// 			_rg.DATE_TIME BETWEEN '$s_start_time' AND '$s_end_time' 
		// 			$s_where_cte
		// 	) 
		// 	SELECT
		// 	_pd.ID AS ID,
		// 	ISNULL(_pd.MIN_Acc,0) AS MIN_Acc,
		// 	ISNULL(_pd.MAX_Acc,0) AS MAX_Acc,
		// 	ISNULL(_pd.MIN_Flow,0) AS MIN_Flow,
		// 	ISNULL(_pd.MAX_Flow,0) AS MAX_Flow
		// 	FROM
		// 		r_data AS _pd	
		// 	ORDER BY 
		// 		_pd.ID ASC;";
		// 	// return $sql;

		// 	if ($this->pdo_hty != null) {
		// 		$sth = $this->pdo_hty->prepare($sql);
		// 		$sth->execute([]);
		// 		$rows = $sth->fetchAll(PDO::FETCH_ASSOC);
		// 		foreach ($rows as $k => &$v) {
		// 			$a_temp_date[(int)$v["ID"]]["ID"] = (int)$v["ID"];
		// 			$a_temp_date[(int)$v["ID"]]["MIN_Acc"] = number_format($v["MIN_Acc"], 2,".","");
		// 			$a_temp_date[(int)$v["ID"]]["MAX_Acc"] = number_format($v["MAX_Acc"], 2,".","");
		// 			$a_temp_date[(int)$v["ID"]]["MIN_Flow"] = number_format($v["MIN_Flow"], 2,".","");
		// 			$a_temp_date[(int)$v["ID"]]["MAX_Flow"] = number_format($v["MAX_Flow"], 2,".","");
		// 		}
		// 	}
		// }

		// //整理回傳陣列
		// $res = [];
		// if (!empty($a_temp_date)) {
		// 	foreach ($a_temp_date as $k => $v) {
		// 		$res[] = $v;
		// 	}
		// }

		// return $res;
	}
}
