<?php
// 頁面專用WebAPI, 不管任何的頁面, class名稱固定為 [WebAPIForMenuPage], 不可變更
class WebAPIForMenuPage extends base_class {

	public function SelectSearchData ($params) 
	{
		$search = $params['search'];
		$sql = sprintf("SELECT MIN([M1].[DATE_TIME]) AS [DATE_TIME]
											,[M1].[CurrentDemand] AS [需量]
										FROM [HTY].[dbo].[R_DMC] AS [M1]
										INNER JOIN (
											/* 取每日最高需量 */
											SELECT CAST([DATE_TIME] AS date) AS [DATE]
												,MAX([CurrentDemand]) AS [max_CurrentDemand]
											FROM [HTY].[dbo].[R_DMC]
											WHERE [DATE_TIME] BETWEEN :start_date AND :end_date
											GROUP BY CAST([DATE_TIME] AS date)
										) AS [M2]
										ON CAST([M1].[DATE_TIME] AS date) = [M2].[DATE] AND [M1].[CurrentDemand] = [M2].[max_CurrentDemand]
										GROUP BY CAST([M1].[DATE_TIME] AS date), [M1].[CurrentDemand]
										ORDER BY CAST([M1].[DATE_TIME] AS date)");
		$res = [];
		if ($this->pdo_hty != null)
		{
			$sth = $this->pdo_hty->prepare($sql);
			$sth->execute([
				'start_date'=> date('Y-m-d 00:00:00', strtotime($search['start_date'])),
				'end_date'=> date('Y-m-d 23:59:59', strtotime($search['end_date'])),
			]);
			$res = $sth->fetchAll(PDO::FETCH_ASSOC);
		}
		return $res;
	}
	
}
?>