<?php
// 頁面專用WebAPI, 不管任何的頁面, class名稱固定為 [WebAPIForMenuPage], 不可變更
class WebAPIForMenuPage extends base_class {

	// 首頁資料
	public function SelectSearchData ($params) 
	{
		$range = $params['range'];
		$year = $params['year'];
		$year_month = $params['year_month'];

		$energy_data = [];
		// 撈取能源參數
		$ep_temp = $this->SelectEnergyParam();
		$ep = [];
		foreach($ep_temp as $row)
		{
			foreach($row as $k => $v)
			{
				$ep[$row['item_label']][$k] = $v;
			}
		}

		// 電力用量
		$param_temp = [
			// 'id_list'=> [1],
			'range'=> $range,
			'year'=> $year,
			'month'=> $year_month,
		];
		$pm_data = $this->SelectDosageP($param_temp);
		if(count($pm_data) > 0)
		{
			$dosage = 0; // 使用量
			$foundInx = array_search(1,array_column($pm_data,'ID')); // 找ID=1
			if($foundInx !== false)
			{
				$dosage = $pm_data[$foundInx]['dosage'];
			}
			$mcal = (floatval($dosage) * floatval($ep['電力']['convert_rate_mcal'])) * floatval($ep['電力']['mcal']); // 熱值
			$kloe = (floatval($dosage) * floatval($ep['電力']['convert_rate_kloe'])) * floatval($ep['電力']['kloe']); // 公秉油當量
			$co2e = (floatval($dosage) * floatval($ep['電力']['convert_rate_co2e'])) * floatval($ep['電力']['co2e']); // 碳排量
			$energy_data[] = ['name'=> '電力', 'dosage'=> $dosage, 'mcal'=> $mcal, 'kloe'=> $kloe, 'co2e'=> $co2e];
		}
		
		// 蒸汽月用量
		$param_temp = [
			't_class'=> 'SM',
			// 'id_list'=> [1],
			'range'=> $range,
			'year'=> $year,
			'month'=> $year_month,
		];
		$sm_data = $this->SelectDosageSGW($param_temp);
		if(count($sm_data) > 0)
		{
			$dosage = 0; // 使用量
			$foundInx = array_search(1,array_column($sm_data,'ID')); // 找ID=1
			if($foundInx !== false)
			{
				$dosage = $sm_data[$foundInx]['dosage'];
			}
			$mcal = (floatval($dosage) * floatval($ep['蒸汽']['convert_rate_mcal'])) * floatval($ep['蒸汽']['mcal']); // 熱值
			$kloe = (floatval($dosage) * floatval($ep['蒸汽']['convert_rate_kloe'])) * floatval($ep['蒸汽']['kloe']); // 公秉油當量
			$co2e = (floatval($dosage) * floatval($ep['蒸汽']['convert_rate_co2e'])) * floatval($ep['蒸汽']['co2e']); // 碳排量	
			$energy_data[] = ['name'=> '蒸汽', 'dosage'=> $dosage, 'mcal'=> $mcal, 'kloe'=> $kloe, 'co2e'=> $co2e];	
		}

		// 瓦斯月用量
		$param_temp = [
			't_class'=> 'GM',
			// 'id_list'=> [1],
			'range'=> $range,
			'year'=> $year,
			'month'=> $year_month,
		];
		$gm_data = $this->SelectDosageSGW($param_temp);
		if(count($gm_data) > 0)
		{
			$dosage = 0; // 使用量
			$foundInx = array_search(1,array_column($gm_data,'ID')); // 找ID=1
			if($foundInx !== false)
			{
				$dosage = $gm_data[$foundInx]['dosage'];
			}
			$mcal = (floatval($dosage) * floatval($ep['液化石油氣（瓦斯LPG）']['convert_rate_mcal'])) * floatval($ep['液化石油氣（瓦斯LPG）']['mcal']); // 熱值
			$kloe = (floatval($dosage) * floatval($ep['液化石油氣（瓦斯LPG）']['convert_rate_kloe'])) * floatval($ep['液化石油氣（瓦斯LPG）']['kloe']); // 公秉油當量
			$co2e = (floatval($dosage) * floatval($ep['液化石油氣（瓦斯LPG）']['convert_rate_co2e'])) * floatval($ep['液化石油氣（瓦斯LPG）']['co2e']); // 碳排量
			$energy_data[] = ['name'=> '瓦斯', 'dosage'=> $dosage, 'mcal'=> $mcal, 'kloe'=> $kloe, 'co2e'=> $co2e];	
		}

		return compact('energy_data','pm_data','sm_data','gm_data','ep');
	}	


	
	
}
?>