<?php
// 頁面專用WebAPI, 不管任何的頁面, class名稱固定為 [WebAPIForMenuPage], 不可變更
class WebAPIForMenuPage extends base_class {

	// 首頁資料
	public function SelectIndex ($params) 
	{
		// 月能源用量占比變數
		$month_mcal = [
			'電力'=> 0,
			'蒸汽'=> 0,
			'蒸汽-燒臘區'=> 0,
			'瓦斯'=> 0,
			'天燃汽'=> 0,
			'total'=> 0,
		];
		// 撈取能源參數
		$ep_temp = $this->SelectEnergyParam();
		$ep = [];
		foreach($ep_temp as $row)
		{
			foreach($row as $k => $v)
			{
				$ep[$row['item_key']][$k] = $v;
			}
		}

		// 電力用量[年月日](id:1)
		$s_year_start_time = date("Y-01-01 00:00:00"); // 當年開始時間
		$s_month_start_time = date("Y-m-01 00:00:00"); // 當月開始時間
		$s_day_start_time = date("Y-m-d 00:00:00"); // 當日開始時間
		$s_end_time = date("Y-m-d H:i:s"); // 當下時間		
		$pm_id_list = [1];

		$sql = sprintf("WITH pm_year AS (
											SELECT [id] AS [ID]
													,SUM([incr_kwh]) AS [year_dosage]
											FROM [%s].[dbo].[R_PM_daily]
											WHERE [date_stamp] BETWEEN '$s_year_start_time ' AND '$s_end_time'
											GROUP BY [id]
										)
										SELECT *
											,(
												SELECT SUM([incr_kwh]) AS [dosage]
												FROM [%s].[dbo].[R_PM_daily]
												WHERE [date_stamp] BETWEEN '$s_month_start_time' AND '$s_end_time'
													AND [id] = py.[ID]
											) AS [month_dosage]
											,(
												SELECT SUM([incr_kwh]) AS [dosage]
												FROM [%s].[dbo].[R_PM_daily]
												WHERE [date_stamp] BETWEEN '$s_day_start_time' AND '$s_end_time'
													AND [id] = py.[ID]
											) AS [day_dosage]
										FROM pm_year AS [py]
										WHERE [ID] IN (%s)", $this->database_alarm, $this->database_alarm, $this->database_alarm, implode(',',$pm_id_list));
		$sth = $this->pdo_sql->prepare($sql);
		$sth->execute();
		$pm_data = $sth->fetch(PDO::FETCH_ASSOC);

		// 換算電力參數(碳排、熱值...)
		if($pm_data)
		{
			// 本年用電碳排放
			$pm_data['year_co2e'] = (floatval($pm_data['year_dosage']) * floatval($ep['PM1']['convert_rate_co2e'])) * floatval($ep['PM1']['co2e']);
			// 本年換算公秉油當量
			$pm_data['year_kloe'] = (floatval($pm_data['year_dosage']) * floatval($ep['PM1']['convert_rate_kloe'])) * floatval($ep['PM1']['kloe']);
			// 本年換算熱值
			$pm_data['year_mcal'] = (floatval($pm_data['year_dosage']) * floatval($ep['PM1']['convert_rate_mcal'])) * floatval($ep['PM1']['mcal']);
			// 本月電力熱值
			$month_mcal['電力'] = (floatval($pm_data['month_dosage']) * floatval($ep['PM1']['convert_rate_mcal'])) * floatval($ep['PM1']['mcal']);
		}

		// 蒸汽月用量
		$param_temp = [
			't_class'=> 'SM',
			'id_list'=> [1,16],
			'range'=> 'month',
			'month'=> date("Y-m")
		];
		$sm_data = $this->SelectDosageSGW($param_temp);
		
		if(count($sm_data) > 0)
		{
			$sm_kv = [];
			foreach ($sm_data as $r) 
			{
				$sm_kv[$r['ID']] = $r['dosage'];
			}
			// 本月蒸汽熱值
			$month_mcal['蒸汽'] = (floatval($sm_kv['1']['dosage']) * floatval($ep['SM1']['convert_rate_mcal'])) * floatval($ep['SM1']['mcal']);
			$month_mcal['蒸汽-燒臘區'] = (floatval($sm_kv['16']['dosage']) * floatval($ep['SM1']['convert_rate_mcal'])) * floatval($ep['SM1']['mcal']);
		}

		// 瓦斯月用量
		$param_temp = [
			't_class'=> 'GM',
			'id_list'=> [1,12],
			'range'=> 'month',
			'month'=> date("Y-m")
		];
		$gm_data = $this->SelectDosageSGW($param_temp);
		if(count($gm_data) > 0)
		{
			$gm_kv = [];
			foreach ($gm_data as $r) 
			{
				$gm_kv[$r['ID']] = $r['dosage'];
			}
			// 本月瓦斯熱值
			$month_mcal['瓦斯'] = (floatval($gm_kv['1']['dosage']) * floatval($ep['GM1']['convert_rate_mcal'])) * floatval($ep['GM1']['mcal']);
			$month_mcal['天燃汽'] = (floatval($gm_kv['12']['dosage']) * floatval($ep['GM1']['convert_rate_mcal'])) * floatval($ep['GM1']['mcal']);
		}

		// 本日電力
		$pm_day_temp = $this->SelectDosageP([]);
		$pm_day = [];
		foreach($pm_day_temp as $row)
		{
			$pm_day[intval($row['ID'])] = $row['dosage'];
		}
		// 本日蒸汽
		$param_temp = [
			't_class'=> 'SM',
		];
		$sm_day_temp = $this->SelectDosageSGW($param_temp);
		$sm_day = [];
		foreach($sm_day_temp as $row)
		{
			$sm_day[intval($row['ID'])] = $row['dosage'];
		}
		// 本日瓦斯
		$param_temp = [
			't_class'=> 'GM',
		];
		$gm_day_temp = $this->SelectDosageSGW($param_temp);
		$gm_day = [];
		foreach($gm_day_temp as $row)
		{
			$gm_day[intval($row['ID'])] = $row['dosage'];
		}

		$month_mcal['total'] = array_sum(array_values($month_mcal));

		// 超約次數
		// 目前需量 > 契約, 先不做=>連續15次
		$start_of_month = date("Y-m-01 00:00:00");
		$start_of_year = date("Y-01-01 00:00:00");
		$sql = "SELECT
						(
							SELECT COUNT([RowNO])
							FROM [HTY].[dbo].[R_DMC]
							WHERE [DATE_TIME] BETWEEN '$start_of_month' AND GETDATE() AND [CurrentDemand] > [ContractDemand]
						) AS [month],
						(
							SELECT COUNT([RowNO])
							FROM [HTY].[dbo].[R_DMC]
							WHERE [DATE_TIME] BETWEEN '$start_of_year' AND GETDATE() AND [CurrentDemand] > [ContractDemand]
						) AS [year]";
		$over_contract = [];
		if ($this->pdo_hty != null)
		{
			$sth = $this->pdo_hty->prepare($sql);
			$sth->execute();
			$over_contract = $sth->fetch(PDO::FETCH_ASSOC);
		}

		return compact('pm_data','month_mcal','pm_day','sm_day','gm_day','over_contract');
	}	


	
	
}
?>