<?php
// 頁面專用WebAPI, 不管任何的頁面, class名稱固定為 [WebAPIForMenuPage], 不可變更
class WebAPIForMenuPage extends base_class
{

	// 	抓取資料夾清單
	public function SelectReportFileList($params)
	{

		$startTime  = date('Y-m-01');	//	初始開始時間
		$endTime = date('Y-m-t'); 		//	初始結束時間
		$dates = [];					//	檔案日期範圍

		switch ($params['folder']) {
			case 'energy_saving_comparison':
				$startTime = date('Y', strtotime($params['dataRange'][0]));
				$endTime = date('Y', strtotime($params['dataRange'][1]));
				break;
			case 'energy_saving_rate':
				$startTime = date('Y', strtotime($params['dataRange'][0]));
				$endTime = date('Y', strtotime($params['dataRange'][1]));
				break;
			default:			
		}

		$startDate = new DateTime($startTime . '-01-01');
		$endDate = new DateTime($endTime . '-12-31');

		while ($startDate <= $endDate) {
		    if ($params['folder'] == 'energy_saving_comparison') {
		        $dates[] = $startDate->format('Y');
		        $startDate->modify('+1 year');
		    } elseif ($params['folder'] == 'energy_saving_rate') {
		        $dates[] = $startDate->format('Y');
		        $startDate->modify('+1 year');
		    } else {
		        break;
		    }
		}

		// 將日期轉換為正則表達式
		$datePatterns = array_map(function($date) {
		    return preg_quote($date, '/');
		}, $dates);


		//	目錄檔案明確規劃
		$pattern = '';
		/*
			$params['fileType'] = power => 電力
			$params['fileType'] = steam => 蒸汽
			$params['fileType'] = gas => 瓦斯
			$params['fileType'] = water => 水
        */
		if ( $params['folder'] == 'energy_saving_comparison' ) {
			$pattern = '/節能比較表_(' . implode('|', $datePatterns) . ')\.xlsx/';
			
		} elseif ( $params['folder'] == 'energy_saving_rate') {
			$pattern = '/年度能源節約率_(' . implode('|', $datePatterns) . ')\.xlsx/';
		} else {
		}

		//	完整檔案路徑
		$fileLinks = array();
		//	資料夾路徑
		$folderPath = "../../hsintungyang_excel/".$params['folder']; 
		//	檔案類型 
		$files = glob($folderPath . '/*.xlsx');	
		if ($files !== false) {
			// 篩選檔案
			$filterFiles = array_filter($files, function($file) use ($pattern) {
			    // 取得所有檔案名稱
			    $allFilename = basename($file);
			    // 使用正則表達式進行匹配
			    return preg_match($pattern, $allFilename);
			});
			$resultObjects = array(); // 建立空陣列用於存放物件
			// 輸出結果
			foreach ($filterFiles as $file) {
				// 這裡可以對每個檔案進行處理
				$fileName = $this->mb_basename($file);
				// 將陣列元素轉換為物件並存入物件陣列
				$object = new stdClass();
				$object->FileName = $fileName;
				$object->FileUrl = $file;
				$resultObjects[] = $object;
			}
		} else {
			echo "找不到符合條件的檔案";
		}
		return $resultObjects;
	}

	//	小郭：我忘記這是什麼了
	private function mb_basename($path) {
		// 將路徑的字符編碼轉換為 UTF-8
		$filename = iconv(mb_detect_encoding($path, mb_detect_order(), true), 'UTF-8', $path);
		// 使用正則表達式去掉路徑中的目錄部分，只保留檔案名稱
		$filename = preg_replace('@^.*/@', '', $filename);
		// 返回檔案名稱
		return $filename;
	}

	
}
