<?php
// 頁面專用WebAPI, 不管任何的頁面, class名稱固定為 [WebAPIForMenuPage], 不可變更
class WebAPIForMenuPage extends base_class
{
	//	撈取趨勢圖資料
	public function SelectSearchData($params)
	{ 
		$range = $params['range'];
		$year = $params['year'];
		$year_month = $params['year_month'];
		
		$start_time = date("Y-m-d 00:00:00");
		$end_time = date("Y-m-d 23:59:59");
		$group_str = '';
		if($range == 'month')
		{
			$start_time = date("Y-m-01 00:00:00", strtotime($year_month));
			$end_time = date("Y-m-t 23:59:59", strtotime($year_month));
			$group_str = "[date_stamp]";
		}
		else if($range == 'year')
		{
			$start_time = date("Y-01-01 00:00:00", strtotime("$year-01"));
			$end_time = date("Y-12-31 23:59:59", strtotime("$year-01"));
			$group_str = "CONVERT(varchar(7),[date_stamp],120)";
		}

		$sql = sprintf("SELECT $group_str AS [Date],
											SUM([peak_1]) AS '尖峰',
											SUM([peak_2_1]) AS '半尖峰',
											SUM([peak_2_6]) AS '周六半',
											SUM([peak_3]) AS '離峰'
										FROM
											[%s].[dbo].[PM_range_daily]
										WHERE
											[date_stamp] BETWEEN '$start_time' AND '$end_time' AND id = '1' 
										GROUP BY
											$group_str
										ORDER BY $group_str ASC", $this->database_alarm);
										// return $sql;
		$sth = $this->pdo_sql->prepare($sql);
		$sth->execute();
		return $sth->fetchAll(PDO::FETCH_ASSOC);
	}
	
}
