<?php
// 頁面專用WebAPI, 不管任何的頁面, class名稱固定為 [WebAPIForMenuPage], 不可變更
class WebAPIForMenuPage extends base_class
{
	//	撈取趨勢圖資料
	public function SelectSearchData($params)
	{ 
		$search = $params['search'];

		$sql = sprintf("SELECT *
										FROM [%s].[dbo].[R_WM_daily]
										WHERE [date_stamp] BETWEEN :start_date AND :end_date
										ORDER BY [date_stamp] ASC", $this->database_alarm);
		$sth = $this->pdo_sql->prepare($sql);
		$sth->execute([
			'start_date'=> date('Y-m-d', strtotime($search['start_date'])),
			'end_date'=> date('Y-m-d', strtotime($search['end_date'])),
		]);
		$res = $sth->fetchAll(PDO::FETCH_ASSOC);
		$date_group = [];
		foreach($res as $r)
		{
			$date_group[$r['date_stamp']][] = $r;
		}
		// return $date_group;
		$date_data = [];
		foreach($date_group as $dt => $row)
		{
			$data_temp = ['date_stamp' => $dt];
			foreach($row as $r)
			{
				$data_temp[$r['id']] = $r['incr_acc'];
			}
			$date_data[] = $data_temp;
		}
		return $date_data;
	}
	
}
