<?php
// 頁面專用WebAPI, 不管任何的頁面, class名稱固定為 [WebAPIForMenuPage], 不可變更
class WebAPIForMenuPage extends base_class
{
	//樹狀圖即時資料顯示用
	public function SelectLoadPageData($params)
	{
		//指定ID資料
		$s_id_list = (string) $params["id_list"];
		$s_id_list = trim($s_id_list);

		//設定查詢時間
		//資料結束時間 
		$s_end_time = date("Y-m-d 23:59:59");
		//資料起始時間
		$s_start_time = date("Y-m-d 00:00:00");

		//區域條件設定
		$s_where_1 = "";
		$s_where_2 = "";
		$s_where_cte_2 = "";
		if ($s_id_list != "") {
			$s_where_1 = " AND _r.ID IN ($s_id_list) ";
			$s_where_2 = " AND _sf.Tid IN ($s_id_list) ";
			$s_where_cte_2 = " AND _rpd.id IN ($s_id_list)";
		}

		$sql = "WITH r_data AS (
						SELECT DISTINCT
							ID,
							(
							/* 最後一筆Flow */
							SELECT TOP 1 
								Flow 
							FROM
								R_SM  WITH (NOLOCK)
							WHERE
								ID = _r.ID 
								AND DATE_TIME BETWEEN '$s_start_time' AND '$s_end_time' 
							ORDER BY
								DATE_TIME DESC 
							) AS MAX_Flow
						FROM
							[dbo].[R_SM] AS _r  WITH (NOLOCK)
						WHERE
							_r.DATE_TIME BETWEEN '$s_start_time' AND '$s_end_time' 
							$s_where_1
					) 
					SELECT
					_sf.Tid AS ID,
					ISNULL(_pd.MAX_Flow,0) AS MAX_Flow
					FROM
						[dbo].[surface] AS _sf
						LEFT JOIN r_data AS _pd ON _pd.ID = _sf.Tid		
					WHERE
						_sf.Tclass = 'SM'
						$s_where_2 
					ORDER BY 
						_sf.Tid ASC;";
		
		$res = [];
		if ($this->pdo_hty != null) {
			$sth = $this->pdo_hty->prepare($sql);
			$sth->execute([]);
			$res = $sth->fetchAll(PDO::FETCH_ASSOC);
		}

		$sql = sprintf("SELECT DISTINCT
							id AS [ID],
							ISNULL((
								SELECT incr_acc
								FROM [%s].[dbo].[R_SM_daily] WITH (NOLOCK)
								WHERE id = _rpd.id AND date_stamp BETWEEN '$s_start_time' AND '$s_end_time' 
							),0) AS today_Acc
						FROM [%s].[dbo].[R_SM_daily] AS _rpd
						WHERE _rpd.date_stamp BETWEEN '$s_start_time' AND '$s_end_time' $s_where_cte_2 
						", $this->database_alarm, $this->database_alarm, $this->database_alarm);
		$sth = $this->pdo_sql->prepare($sql);
  		$sth->execute();
  		$today_month_data = $sth->fetchAll(PDO::FETCH_ASSOC);


		$mergedArray = array_map(function($item1) use ($res) {
		    foreach ($res as $item2) {
		        if ($item1['ID'] == $item2['ID']) {
		            return array_merge($item1, $item2);
		        }
		    }
		    return $item1;
		}, $today_month_data);

		return $mergedArray;
	}



	// //樹狀圖即時資料顯示用
	// public function SelectLoadPageData($params)
	// {


	// 	//指定ID資料
	// 	$s_id_list = (string) $params["id_list"];
	// 	$s_id_list = trim($s_id_list);

	// 	//設定查詢時間
	// 	//資料結束時間 
	// 	$s_end_time = date("Y-m-d 23:59:59");
	// 	//資料起始時間
	// 	$s_start_time = date("Y-m-d 00:00:00");

	// 	//區域條件設定
	// 	$s_where_cte = "";
	// 	$s_where_tid = "";
	// 	if ($s_id_list != "") {
	// 		$s_where_cte = " AND _rs.ID IN ($s_id_list) ";
	// 		$s_where_tid = " AND _sf.Tid IN ($s_id_list) ";
	// 	}
	// 	//暫存用資料陣列
	// 	$a_temp_date = [];

	// 	//撈取設備ID清單 因R_SM資料表中的ID欄位沒有索引，所以把設備ID的部分分開查詢，避免影響效能
	// 	//並先預設好要取值的四個參數為0，防止新設備在R_SM沒有資料
	// 	$sql_id_list = "SELECT
	// 						_sf.Tid AS ID
	// 					FROM
	// 						[dbo].[surface] AS _sf
	// 					WHERE
	// 						_sf.Tclass = 'SM'
	// 					$s_where_tid
	// 					ORDER BY
	// 						_sf.Tid ASC";
	// 	if ($this->pdo_hty != null) {
	// 		$sth = $this->pdo_hty->prepare($sql_id_list);
	// 		$sth->execute([]);
	// 		$rows = $sth->fetchAll(PDO::FETCH_ASSOC);
	// 		foreach ($rows as $k => $v) {
	// 			$a_temp_date[(int) $v["ID"]] = [
	// 				"ID" => (int)$v["ID"],
	// 				"MIN_Acc" => 0,
	// 				"MAX_Acc" => 0,
	// 				"MIN_Flow" => 0,
	// 				"MAX_Flow" => 0,
	// 			];
	// 		}
	// 	}
	// 	//撈取設備資料
	// 	$sql_sm_date = "WITH range_row_no AS (
	// 				SELECT MAX
	// 					( _rs.RowNO ) AS Max_no,
	// 					MIN ( _rs.RowNO ) AS Min_no,
	// 					ID 
	// 				FROM
	// 					[dbo].[R_SM] AS _rs 
	// 				WHERE
	// 					_rs.DATE_TIME BETWEEN '$s_start_time' 
	// 					AND '$s_end_time' 
	// 					$s_where_cte 
	// 				GROUP BY
	// 					_rs.ID 
	// 				)
	// 				SELECT
	// 					_rs.ID ,
	// 					( SELECT Acc FROM R_SM WHERE RowNO = _rs.Min_no ) AS MIN_Acc,
	// 					(
	// 					SELECT TOP
	// 						1 Acc 
	// 					FROM
	// 						R_SM 
	// 					WHERE
	// 						RowNO = _rs.Max_no 
	// 					) AS MAX_Acc,
	// 					(
	// 					SELECT TOP
	// 						1 Flow 
	// 					FROM
	// 						R_SM 
	// 					WHERE
	// 						RowNO = _rs.Min_no 
	// 					) AS MIN_Flow,
	// 					(
	// 					SELECT TOP
	// 						1 Flow 
	// 					FROM
	// 						R_SM 
	// 					WHERE
	// 						RowNO = _rs.Max_no 
	// 					) AS MAX_Flow 
	// 				FROM
	// 					range_row_no AS _rs 
	// 				";
	// 	if ($this->pdo_hty != null) {
	// 		$sth = $this->pdo_hty->prepare($sql_sm_date);
	// 		$sth->execute([]);
	// 		$rows = $sth->fetchAll(PDO::FETCH_ASSOC);
	// 		foreach ($rows as $k => $v) {
	// 			$a_temp_date[(int)$v["ID"]]["ID"] = (int)$v["ID"];
	// 			$a_temp_date[(int)$v["ID"]]["MIN_Acc"] = number_format($v["MIN_Acc"], 2,".","");
	// 			$a_temp_date[(int)$v["ID"]]["MAX_Acc"] = number_format($v["MAX_Acc"], 2,".","");
	// 			$a_temp_date[(int)$v["ID"]]["MIN_Flow"] = number_format($v["MIN_Flow"], 2,".","");
	// 			$a_temp_date[(int)$v["ID"]]["MAX_Flow"] = number_format($v["MAX_Flow"], 2,".","");
	// 		}
	// 	}
	// 	//整理回傳陣列
	// 	$res = [];
	// 	if (!empty($a_temp_date)) {
	// 		foreach ($a_temp_date as $k => $v) {
	// 			$res[] = $v;
	// 		}
	// 	}

	// 	return $res;
	// }
}
