<!DOCTYPE html>
<html lang="zh-tw">

<head><?php
      // 引用 head.inc
      include_once "html_head.inc";
      ?></head>

<body>
  <div id="q-app" :visible="IsVueReady==true" @mousemove="FnIdleReset">
    <?php
    // include_once "html_menu.inc";
    include_once "html_layout_header.inc";
    ?>
    <!-- 內容區域 //-->
    <data-table :show-search-field="true" :show-search-btn="false" :show-search-panel="false" :title="$t('menu.admin_users')" :columns="columns" :data="tableData" row-key="name" @search-ok="searchOk">

      <template v-slot:row_col_role_name="props">
        <div class="w3-left-align" style="overflow:hidden;white-space: nowrap;text-overflow: ellipsis;">
          {{props.row_data.row.role_name}}
        </div>
      </template>

      <template v-slot:page-sticky>
        <q-btn round color="primary" @click="addUser()" icon="add"></q-btn>
      </template>
      
      <template v-slot:row-control="props">
        <q-btn glossy color="primary" :label="$t('sys.edit')" @click.native="editUser(props.row_data)" style="min-width:80px; min-height: 36px; font-size: 20px; font-weight: 600;"></q-btn>
      </template>

    </data-table>

    <template>
     <q-modal
        v-model="addUserInfo['show']"
        minimized
        no-route-dismiss
        no-esc-dismiss
        no-backdrop-dismiss
        :content-css="{minWidth: '40vw', maxHeight: '100vh'}"
      >

        <div class="modal-title">
          <span v-if="addUserInfo['editUserDisable']">編輯使用者</span>
          <span v-else>新增使用者</span>
        </div>

        <div class="modal-scroll-box" style="padding:15px; font-weight: 700; font-size:16px"> 
          
          <div style="margin-top: 0px;">
            <label style="color:#979797;">{{ "帳號" }}</label><a style="color:red">＊</a>
            <q-input 
              v-model="addUserInfo['userID']"  
              :disable="addUserInfo['editUserDisable']"
            ></q-input>
          </div>

          <div style="margin-top: 15px;">
            <label style="color:#979797;">{{ addUserInfo['showEditBtn'] == true ? "新密碼" : "密碼" }}</label>
            <a style="color:red" v-text="addUserInfo['showEditBtn'] == true ? '':'＊'"></a>
            <q-input 
              v-model="addUserInfo['password']" 
              type="password"  
            ></q-input>
          </div>

          <div style="margin-top: 15px;">
            <label style="color:#979797;">{{ addUserInfo['showEditBtn'] == true ? "再次輸入新密碼" : "再次輸入密碼" }}</label>
            <a style="color:red" v-text="addUserInfo['showEditBtn'] == true ? '':'＊'"></a>
            <q-input 
              v-model="addUserInfo['checkPassword']"
              type="password"
            ></q-input>
          </div>

          <div style="margin-top: 15px;">
            <label style="color:#979797;">姓名</label><a style="color:red">＊</a>
            <q-input 
              v-model="addUserInfo['name']"  
            ></q-input>
          </div>

          <div style="margin-top: 15px;">  
            <label style="color:#979797;">角色</label><a style="color:red">＊</a>
            <q-select  
              filter
              :multiple="addUserInfo['multiple']"
              v-model="addUserInfo['role']['value']" 
              :options="addUserInfo['role']['options']" 
            ></q-select>
          </div>  

          <div style="margin-top: 15px;">
            <label style="color:#979797;">電話號碼</label>
            <q-input 
              v-model="addUserInfo['telephone']" 
              type="text" 
              inputmode="tel"
              placeholder="0X-XXXXXXX"
              required  
              minlength="9"
              maxlength="14"
              pattern="[0-9]{2}-[0-9]{7}"
            ></q-input>
          </div>

          <div style="margin-top: 15px;">
            <label style="color:#979797;">手機號碼</label>
            <q-input 
              v-model="addUserInfo['cellphone']"  
              type="text"
              inputmode="tel"
              placeholder="09XXXXXXXX"
              required 
              minlength="9"
              maxlength="14"
              pattern="09[0-9]{8}" 
            ></q-input>
          </div>

          <div style="margin-top: 15px;">
            <label style="color:#979797;">電子郵件</label>
            <q-input 
              v-model="addUserInfo['email']" 
              type="email"  
              pattern="[a-z0-9._%+-]+@[a-z0-9.-]+\.[a-z]{2,4}$"
              required
            ></q-input>
          </div>
            
          

        </div>  

        <div style="display: flex; flex-flow: row wrap; justify-content: flex-end; align-items: center;margin-right: 20px;font-size:14px">
            <a>(</a>
            <a style="color:red">＊</a>
            <a>)</a>
            <a>&nbsp必填項目</a>
        </div> 

        <div style="display:flex; flex-grow: row; justify-content: center;margin: 20px;">
          <q-btn glossy color="primary" :label="$t('sys.save')"  class="btn-style2 id-btn" @click="saveAddUser()" v-if="addUserInfo['showAddBtn']"></q-btn>
          <q-btn glossy color="primary" :label="$t('sys.update')"  class="btn-style2 id-btn" @click="saveEditUser()" v-if="addUserInfo['showEditBtn']"></q-btn>
          <q-btn glossy color="negative" :label="$t('sys.delete')"  class="btn-style2 id-btn" @click="deleteUser()" v-if="addUserInfo['showDeleteBtn']"></q-btn>
          <q-btn :color="addUserInfo['showEditBtn'] == true ? 'secondary' : 'secondary'" :label="$t('sys.close')" glossy class="btn-style2 id-btn"  @click="cancelAddUser()"></q-btn>
          
        </div>  
        

      </q-modal>  
    </template>  

   
      
    



    <!-- /內容區域 //-->
    <?php
    include_once "html_layout_footer.inc";
    ?>
  </div>
  <?php
  // loading.inc
  include_once "html_loading.inc";
  ?>
</body><?php
        $is_report_download = true;
        // 引用 down.inc
        include_once "html_down.inc";
        ?>

</html>