<!DOCTYPE html>
<html lang="zh-tw">

<head><?php
      include_once "html_head.inc";
      ?></head>

<body>
<div id="q-app" :visible="IsVueReady==true" @mousemove="FnIdleReset" >
    <?php
    include_once "html_layout_header.inc";
    ?>

	<div class="container" >
		<div class="w3-row ">
			<div class="w3-col l2 m2 s2">
				<q-field label="開始日期" :label-width="5" class = 'inputs input-blue q-ma-sm'>
					<q-datetime 
						v-model="search.start_time" 
						align="center" type="date"
					></q-datetime>
				</q-field>
			</div>
			<div class="w3-col l2 m2 s2">
				<q-field label="結束日期" :label-width="5" class = 'inputs input-blue q-ma-sm'>
					<q-datetime 
						v-model="search.end_time" 
						align="center" type="date"
					></q-datetime>
				</q-field>
			</div>
			<div class="w3-col l2 m2 s2">
				<q-field label="訂單單號" :label-width="5" class = 'inputs input-blue q-ma-sm'>
					<q-select 
						v-model="search.machine" 
						align="center" type="text" :options = "machineList"
					></q-select>
				</q-field>
			</div>
			<div class="w3-col l4 m4 s4">
				<button class = "buttons" style = "background-color: #027BE3; margin:10px;">查詢</button>
				<button class = "buttons" style = "background-color: #ADADAD; margin:10px;">清除</button>
				<button class = "buttons" style = "background-color: #00A587; margin:10px;">匯出</button>
			</div>
		</div>
		<div style="display: flex; justify-content: center; margin: 50px 0 0 0;">	
			<q-table
				:data="qTable.data"
				:columns="qTable.columns"
				row-key="user_id"
				:pagination.sync="qTable.pagination"
				:style="{width:'80%'}"
			>
				<template slot="body" slot-scope="props">
					<q-tr :props="props">
						<q-td v-for="col in props.cols" :key="col.name" :props="props">
								<span v-if = "col.name == 'edit'">
									<span class="material-icons" style="cursor:pointer; color: #FF0000; font-size: 1.6em;">warning</span>
									<span class="material-icons" style="cursor:pointer; color: #2C8CE4; font-size: 1.6em;">bar_chart</span>	
									<span class="material-icons" style="cursor:pointer; color: #E4842C; font-size: 1.6em;">edit_square</span>
									<span class="material-icons" style="cursor:pointer; color: #FF0000; font-size: 1.6em;">delete</span>	
								</span>
								<span v-else>{{ _.isFunction(col.format) ? col.format(props.row[col.name]) : props.row[col.name] }}</span>
						</q-td>
					</q-tr>
				</template>
			</q-table>
		</div>
	</div>
    <div style="height: 50px;"></div>   
</div>
      
    <?php
    include_once "html_layout_footer.inc";
    ?>
  </div>
  <?php
  include_once "html_loading.inc";
  ?>
</body><?php
        $is_report_download = true;
        $is_googlemap = true;
        $is_echarts = true;
        include_once "html_down.inc";
        ?>

</html>