<!DOCTYPE html>
<html lang="zh-tw">

<head>
  <?php
      include_once "html_head.inc";
      ?>
  <style>
    /* 設置 img 動畫效果 */
    .img-animation {
        animation: fadeEffect 1s ease-in-out infinite; /* 設置動畫 */
    }
    /* 定義 @keyframes 來實現透明度的漸變 */
    @keyframes fadeEffect {
        0% {
            opacity: 1; /* 初始為不透明 */
        }
        10% {
            opacity: 0.85; /* 初始為快半透明 */
        }
        20% {
            opacity: 0.65; /* 初始為快半透明 */
        }
        30% {
            opacity: 0.35; /* 初始為快半透明 */
        }
        40% {
            opacity: 0.20; /* 初始為快半透明 */
        }
        50% {
            opacity: 0.1; /* 初始為快半透明 */
        }
        60% {
            opacity: 0.20; /* 初始為快半透明 */
        }
        70% {
            opacity: 0.35; /* 初始為快半透明 */
        }
        80% {
            opacity: 0.65; /* 初始為快半透明 */
        }
        90% {
            opacity: 0.85; /* 初始為快半透明 */
        }
        100% {
            opacity: 1; /* 初始為快半透明 */
        }
    }
  </style>    
</head>

<body>
  <div id="q-app" :visible="IsVueReady==true" @mousemove="FnIdleReset" >
    <?php
    include_once "html_layout_header.inc";
    ?>

    <div style="box-sizing: border-box; width: 1920px; height: 1015px; ">
      <!-- 管線圖 底圖 -->
      <img src="img/water_system/回收水處理圖.png" ></img>
      <!-- 設備固定 底圖 -->
      <img 
        :class="item['animation'] ? 'img-animation' : ''" 
        :title="item['label']"
        v-for="(item , key) in diagram_recycled_base_pic" 
        v-if="item['show']" 
        :src="item['imgUrl']" 
        :style="getBillboardAddr(item['top'], item['left'] , item['width'] , item['height'])">
      </img>
      <!-- 箭頭 底圖 -->
      <img 
        class="bg-tertiary" 
        :title="item['label']"
        v-for="(item , key) in arrow_direction" 
        v-if="item['show']" 
        :src="item['imgUrl']" 
        :style="getBillboardAddr(item['top'], item['left'] , item['width'] , item['height'])">
      </img>
    </div>
      
      


    <?php
    include_once "html_layout_footer.inc";
    ?>
  </div>
  <?php
  include_once "html_loading.inc";
  ?>
</body>
<script src="cfg/diagram_recycled_config.js"></script>
<?php
  include_once "html_down.inc";
?>
</html>