<!DOCTYPE html>
<html lang="zh-tw">

<head>
  <?php
      include_once "html_head.inc";
      ?>
    </head>

<body>
  <div id="q-app" :visible="IsVueReady==true" @mousemove="FnIdleReset" class="index-container" >
    <?php
    include_once "html_layout_header.inc";
    ?>
    
    <div class="w3-row">
      <!-- 左邊各項清單小看板 -->
      <div class="w3-col l2 m3 s12 q-pa-sm">
        <div class="flex-frwfsfs" >
            <div class="q-mt-sm" v-for="info in billboard['info']" style="width: 100%">
              <!-- one -->
              <div  v-if="info['layout'] == 'one'" :class="!_.isNull(info['class']) ? info['class'] : ''" :style="!_.isNull(info['style']) ? info['style'] : ''">
                <div class="flex-fcwcc">
                  <span class="text-white"> {{ info['label'] }} </span>
                  <div class="block-list-radius">
                    <div class="flex-fcwcc q-mt-sm q-px-xl" v-for="item in info['value']" >
                      <span :class="item['value'] == '0' ? 'text-bright' : 'text-blue-9' " style="font-size:2rem;">{{ item['value'] }}</span>
                      <span class="text-white">{{ item['label'] }}</span>  
                    </div>  
                  </div>
                </div>
              </div>
              <!-- two -->
              <div  v-if="info['layout'] == 'two'" :class="!_.isNull(info['class']) ? info['class'] : ''" :style="!_.isNull(info['style']) ? info['style'] : ''">
                <div class="flex-fcwcc">
                  <div class="flex-frwsbc">
                    <span class="text-white flex-fws"> {{ info['label'] }} </span>
                    <div v-for="btn in info['button']" v-if="btn['show']">
                      <q-btn 
                        :size="btn['size']"
                        :round="btn['round']"
                        :color="btn['color']"
                        :text-color="btn['textColor']" 
                        :icon="btn['icon']" 
                        :glossy="btn['glossy']"
                        @click="btnEvent(btn)" 
                      ></q-btn>
                    </div>  
                  </div>
                  <span class="text-bright flex-fwe"> {{ info['value'] }} </span>
                  <span class="text-white flex-fwe" style="font-size:1rem;"> {{ info['unit'] }} </span>
                </div>  
              </div>  

           </div>
        </div>     
      </div>  
      <!-- 右邊各項趨勢圖，分布圖 -->
      <div class="w3-col l10 m9 s12 q-pa-sm">
        <!-- 上兩個區塊 -->
        <div class="w3-row">
          <!-- 月能源用量占比 -->
          <div class="w3-col l4 m12 s12 q-pa-sm">
            <div class="w3-row q-pa-sm shadow-1 index-flexRadius">
              <div class="flex-fws">
                <span class="text-white"> {{ billboard['monthEnergy']['label'] }} </span>
              </div>
              <div class="w3-col l4 m4 s12">
                <echart :options="billboard['monthEnergy']['pieOptions']" autoresize="true" style="width: 100%; height: 200px;"></echart>
              </div>    
              <div class="w3-col l8 m8 s12 flex-fcwfsfs block-list">
                <div class="q-mb-sm q-pl-md" v-for="item in billboard['monthEnergy']['info']" v-if="item['show']" style="width: 50%;">
                  <div class="flex-frwfsc" >
                    <span :class="`bg-${item['color']} q-pa-xs q-mr-sm` " style="width:10%; border-radius: 25px;"></span> 
                    <span class="text-white" style="width:80%">{{ item['label'] }}</span>  
                  </div>
                  <div class="flex-frwfsc  text-bright">
                    <span class="">{{ item['data']['value'] }}<a class="q-pl-xs text-white">{{ item['data']['unit'] }}</a></span> 
                  </div>   
                </div>  
              </div>  
            </div>
          </div>  
          <!-- 每月最高需量時間 -->
          <div class="w3-col l8 m12 s12 q-pa-sm">
            <div class="w3-row q-pa-sm shadow-1 index-flexRadius">
              <div class="flex-frwsbc">
                <span class="text-white"> {{ billboard['monthNeedTime']['label'] }} </span>
                <div v-for="btn in billboard['monthNeedTime']['button']" v-if="btn['show']">
                  <q-btn 
                    :size="btn['size']"
                    :round="btn['round']"
                    :color="btn['color']" 
                    :text-color="btn['textColor']"
                    :icon="btn['icon']" 
                    :glossy="btn['glossy']"
                    @click="btnEvent(btn)" 
                  ></q-btn>
                </div>  
              </div>
              <div class="w3-col l12 m12 s12">
                <echart :options="billboard['monthNeedTime']['chartOptions']" autoresize="true" style="width: 100%; height: 200px;"></echart>
              </div>    
            </div>
          </div>
        </div>  
        <!-- 下三個區塊 分布圖-->
        <div class="w3-row q-mt-sm">
          <div class="w3-col l4 m12 s12 q-pa-sm" v-for="item in billboard['distribution']">
            <div class="q-pa-sm shadow-1 flex-fcwsbfs move index-flexRadius"  style="cursor: pointer; height: 692px;" @click="jumpToDashboard(item['link'])">
              <!-- 標題 -->
              <div class="flex-fws">
                <div style="width: 95%;">
                  <span class="text-white"> {{ item['label'] }} </span>
                </div>
                <div>
                  <span class="loader"></span>
                </div>
              </div>
              <!-- 圓餅圖 -->
              <div class="q-pt-sm" style="width: 100%;">
                <echart :options="item['pieOptions']" autoresize="true" style="width: 100%; height:400px"></echart>
              </div>
              <!-- 明細 -->
              <div class="q-pa-sm " style="border-radius:10px; width: 100%; height: 200px;">
                <div class="flex-frwfsc"  style="width:100%">
                  <div class="flex-frwfsc q-my-sm" style="font-size: 1rem; font-weight: 700;width: 50%" v-for="info in item['info']" v-if="info['show']" >
                    <div class="flex-frwsbc" style="width: 95%;">
                      <div class="flex-frwfsc" style="width:65%">
                        <div :style="`width: 10px; height: 10px; border-radius: 25px; background: ${info['color']}`"></div> 
                        <span class="q-pl-xs text-white"   >{{ info['label'] }}</span>  
                      </div>
                      <span class="text-bright" style="width:35% ;text-align: end;">{{ info['value'] }}<a class="text-white">{{ info['unit'] }}</a></span> 
                    </div>
                    <div class="" v-if="info['showBorder']" style="width: 5%;">
                      <span  style="border-right: 3px solid rgba(0, 0, 0, 0.2); font-size: 1.5rem;"></span>
                    </div>
                  </div> 
                </div>  
              </div>    

            </div>  
          </div>  
        </div>    

      </div>   
    </div> 

    
    <?php
    include_once "html_layout_footer.inc";
    ?>
  </div>
  <?php
  include_once "html_loading.inc";
  ?>
</body><?php
        $is_echarts = true;
        include_once "html_down.inc";
        ?>

</html>