/*
  FILE: i18n_messages.js
  在 html_down.inc 引入
  usage:
    <div>{{ $t("lbl.hello") }}</div>
    this.$t("lbl.hello")
*/
if ($$i18n_messages == undefined) {
  var $$i18n_messages = {}
}
$$i18n_messages["zh-hant"] = { // zh-hant 繁中
  "language": "中文",
  "sys": {
    "version": "版本",
    "loading_wait": "正在載入資料，請稍候",
    "plz_try_again": "請稍後再試",
    "user": "使用者",
    "ok": "確定",
    "cancel": "取消",
    "edit": "編輯",
    "view": "檢視",
    "export": "匯出",
    "search": "查詢",
    "setting": "設定",
    "save": "儲存",
    "update": "更新",
    "delete": "刪除",
    "void": "作廢",
    "close": "關閉",
    "recovery": "還原",
    "default": "預設",
    "column": "欄位",
    "phase": {
      "draft": "草稿",
      "execute": "進行",
      "completed": "完工",
      "complete": "完工",
      "end": "結案",
      "void": "作廢",
    },
    "message": {
      "info": "訊息",
      "confirm": "確認",
      "download_error": "檔案下載出錯",
      "are_sure_to_execute": "確定要執行嗎？",
      "execute_success": "執行成功",
    },
  },
  "options": {
    "time": {
      "all_time": "所有時間",
      "ten_min": "十分鐘",
      "thirty_min": "三十分鐘",
      "one_hour": "一小時",
      "one_day": "一日",
    },
  },
  "layout": {
    "system_name": "太陽能系統",
    "menu": "選單",
    "collapse_menu": "收合選單",
    "expand_menu": "展開選單",
    "right_menu": "右側選單",
    "nav_menu": {
      "home": "首頁",
      "station_list": "案場清單",
      "back": "上一頁",
    },
    "change_password": {
      "title": "變更密碼",
      "label": {
        "user_id": "使用者帳號",
        "user_name": "使用者名稱",
        "old_pwd": "舊密碼",
        "new_pwd1": "新密碼",
        "new_pwd2": "確認新密碼",
      },
      "msg": {
        "new_pwd_empty": "新密碼不可為空白",
        "new_pwd_not_same": "新密碼與確認新密碼不相同",
        "old_pwd_error": "舊密碼錯誤",
        "other_error": "其他錯誤",
        "change_pwd_success": "密碼變更成功",
      },
    },
  },
  "page": {
    "login": {
      "system_login": "系統登入",
      "account": "帳號",
      "password": "密碼",
      "login": "登入",
      "logout": "登出",
      "plz_login_again": "請重新登入",
      "login_expire": "登入資料已過期",
      "login_failed": "登入失敗",
      "verify_failed": "驗證失敗",
    },
  },
  "api_msg": { // 後端的 message 訊息
    "menu": {
      "test": "測試選單",
    },
  },
   "menu": {
    "index": "全廠能源分佈",
    "admin" : "管理",
    "admin_users" : "使用者管理",
    "admin_page_permission_setting" : "角色頁面權限設定",
    "system_power" : "電力系統",
    "system_steam" : "蒸汽系統",
    "system_gas" : "瓦斯系統",
    "system_water" : "用水系統",
    "system_water_flow_chart" : "用水系統流程圖",
    "data_analysis_power_baseline" : "數據分析-全廠用電基線",
    "data_analysis_single_baseline" : "數據分析-單項基線分析",
    "data_analysis_station_indicatros" : "數據分析-全廠指標總覽",
    "indicatros_trend" : "指標趨勢圖",
    "system_power_demand" : "全廠能源系統-電力需量系統",
    "system_air_ice" : "空調及製程冰水系統",
    "report_output" : "報表産出",
    "energy_estimation" : "全廠能源估比",
    "demand_query" : "需量查詢",
    "search_power" : "用電度數查詢",
    "parameter_settings" : "參數設定",
    "chart_bar" : "長條圖",
    "chart_pie" : "圓餅圖",
    "report_frugal" : "節約報表",
    "report_date" : "日月年報",
    "search_water_daily":"用水系統每日用量查詢",
    "search_station_indicatros_daily":"全廠每日指標查詢",
    "diagram_recycled" : "回收水處理圖",
    "diagram_purification" : "淨水流程圖",
    "diagram_wastewater" : "廢水處理流程圖",
  },
};