/*
<script src="js/quasar.mat.umd.min.js"></script>
<script src="js/quasar.i18n.en-us.umd.min.js"></script>
<script src="js/quasar.i18n.zh-hant.umd.min.js"></script>
<script src="js/quasar.i18n.vi.umd.min.js"></script>
<script src="js/vue-i18n.js"></script>
<script src="js/mixins/i18n_messages.js"></script>
<script src="js/i18n_messages.js"></script>
*/
// en-us: 英, zh-hant: 繁中, vi: 越
var $$mixins_i18n = {
  data () {
    return {
      "varLangSaveLocalStorage": "zh-hant", // 目前的語系: en-us, zh-hang (可在此改預設)
      "varLangSaveLocalStorage": false, // 語系儲存 local storage
      "varLangList": [
        {
          "name": "中文", "lang": "zh-hant", "short_name": "中文"
        },
        {
          "name": "english", "lang": "en-us", "short_name": "EN"
        },
      ],
    }
  },
  computed: {
    varLangMap () {
      return _.reduce(this.varLangList, (obj, val) => {
        obj[val["lang"]] = val;
        return obj;
      }, {});
    }
  },
  i18n: new VueI18n({
    // locale: Quasar.i18n.zhHant,
    messages: $$i18n_messages // 指定字典
  }),
  beforeMount: function () { // 必須要先於 base_function.js 的 mounted
    this.fnInitLang();
    // console.log(this.$t("lbl.hello"))
  },
  methods: {
    fnInitLang: function () {
      var str_lang = this.$q.sessionStorage.get.item("$$locale");
      if (this.varLangSaveLocalStorage) {
        str_lang = this.$q.localStorage.get.item("$$locale");
      }
      if (str_lang == null || str_lang == undefined) {
        str_lang = Quasar.i18n.zhHant.lang // 若都沒有, 則為繁中
        if (this.varLangSaveLocalStorage != "") { // 在 base_function.js 可設定預設語系
          str_lang = this.varLangSaveLocalStorage;
        } else {
          str_lang = "zh-hant"
        }
      }
      this.varLangSaveLocalStorage = str_lang;
      this.FnChgLang(str_lang);
    },
    // usage: this.FnChgLang("en-us"); or this.FnChgLang("zh-hant");
    FnChgLang: function (sLang) {
      if (_.isString(sLang)) {
        this.varLangSaveLocalStorage = sLang;
      }
      // console.log(Quasar.i18n);
      // console.log(this.varLangSaveLocalStorage);
      for (var k in Quasar.i18n) {
        // console.log(k);
        if (Quasar.i18n[k]['lang'] == this.varLangSaveLocalStorage) {
          Quasar.i18n.set(Quasar.i18n[k]);
          break;
        }
      }
      this.$i18n.locale = Quasar.i18n['name'];
      this.$q.sessionStorage.set("$$locale", this.$i18n.locale);
      if (this.varLangSaveLocalStorage) {
        this.$q.localStorage.set("$$locale", this.$i18n.locale);

      }
      //this.fnChgLangAfter()
    },

    //test
    // fnChgLangAfter :function(){

    // },
  }
}