var page_function = {
	components: {
		"data-table": httpVueLoader("components/layout/data_table.vue"),
	},
	data () {
		return {
			"VarMenuPage": "admin_page_permission_setting",
			"VarMenu": "area",
			"VarPageContainerCss" : "padding:20px 20px;",
			"tableData": [],
			
			"formPageSet" : {
				"view" : false,
				"edit" : true,
				"update" : false,
				"role" : null,
				"tempPageName" : [],
				"tempSelectUse" : [],
			}

		}
	},
	computed: {
		columns () { // 為了配合多國語系, columns 需使用 computed
			return [
				{
					name: "role_name",
					required: true,
					label: "角色名稱",
					align: "center",
					field: "role_name",
					sortable: true,
					style: "width: 100px",
				},
				{
					name: "view_page",
					required: true,
					label: "頁面權限設定",
					align: "center",
					field: "view_page",
					sortable: true,
					style: "width: 100px",
					$$is_slot: true,
				},
			]
		},
		pageEditBtn () {
			if ( _.includes(this.LoginSetup.roles, 'admin' ) ) {
				return true;
			} else {
				return false;
			}
		}
	},

	watch : {
		
	},

	mounted () {
		this.$set(this.WebSetup, "caption", '角色頁面權限設定');
		this.MenuSetup.opened = false;
		this.VarMenuIsOverlay = false;
		this.getData();
	},

	methods: {

		btnSwitch () {
			let that = this;
			that.formPageSet['edit'] = false;
			that.formPageSet['update'] = true;
		},

		getData () {
			let that = this;
			var params = {
				Action: 'Roles',
				Datas: {},
			};
			return that.FnWebAPIGet(params).then((res) => {
				if (res.data.result) {
					var resData = res.data.data;
					that.tableData = resData;
				} else {
					that.FnNotify(res.data.message, "error");
				}
			});
		},

		//	step.1 檢視撈資料
		viewRoleId (props) {
			let that = this;
			that.formPageSet['tempSelectUse'] = [];
			that.formPageSet['view'] = true;
			that.formPageSet['edit'] = true;
			that.formPageSet['update'] = false;
			that.formPageSet['role'] = props.role_id;
			var params = {
				Action: 'MenuLoad',
				Datas: {
					"menu" : "permissions"
				},
				menu_page: 'sys_component',
			};
			return that.FnWebAPIGet(params).then((res) => {
				if (res.data.result) {
					var resData = res.data.data;
					that.formPageSet['tempPageName'] = resData;
					that.viewRoleViewPage ();
				} else {
					that.FnNotify(res.data.message, "error");
				}
			});
		},

		//	step.1-2 檢視之前的紀錄 => 更新資料
		viewRoleViewPage (){
			let that = this;
			var params = {
				Action: 'Menu',
				Datas: {
					"role_id" : that.formPageSet['role'],
				},
			};
			return that.FnWebAPIGet(params).then((res) => {
				if (res.data.result) {
					var resData = res.data.data;
					_.each(resData, (item, idx) => {
						that.formPageSet['tempSelectUse'].push(item['menu_id']);
					})
				} else {
					that.FnNotify(res.data.message, "error");
				}
			});
		},

		//	step.2 更新角色頁面權限設定
		updateRoleMenu (props) {
			let that = this;
			var params = {
				Action: 'RoleMenu',
				Datas: {
					role : that.formPageSet['role'],
					page_arr : that.formPageSet['tempSelectUse'],
				},
			};
			return that.FnWebAPIPost(params).then((res) => {
				if (res.data.result) {
					that.FnNotify(res.data.message, "success");
					that.formPageSet['view'] = false;
				} else {
					that.FnNotify(res.data.message, "error");
				}
			});

		},
		
		// 表單checkbox狀態連動判斷
		checkbox_link(inx) {
		    let that = this;
		    inx = inx.toString();
		    let inx_split = inx.split("-");
		    let inx_1 = null;
		    let inx_2 = null;

		    inx_split.forEach((el, i) => {
		        if (i == 0) {
		            inx_1 = el.split(".")[0];
		        } else if (i == 1) {
		            inx_2 = el.split(".")[0];
		        }
		    });

		    let page_name_1 = that.formPageSet.tempPageName[inx_1].menu_id;
		    let page_name_2 = inx_2 != null ? that.formPageSet.tempPageName[inx_1].children[inx_2].menu_id : "";

		    let check_menu_id = page_name_2 === "" ? page_name_1 : page_name_2;
		    let checked_type = that.formPageSet.tempSelectUse.includes(check_menu_id);

		    if (checked_type) {
		        // 如果選中，確保父選項和子選項都被選中
		        if (!that.formPageSet.tempSelectUse.includes(page_name_1) && page_name_1 != "") {
		            that.formPageSet.tempSelectUse.push(page_name_1);
		        }
		        if (page_name_2 != "" && !that.formPageSet.tempSelectUse.includes(page_name_2)) {
		            that.formPageSet.tempSelectUse.push(page_name_2);
		        }
		        if (page_name_2 === "") {
		            // 父選項被選中，選中所有子選項
		            if (that.formPageSet.tempPageName[inx_1].children != undefined) {
		                that.formPageSet.tempPageName[inx_1].children.forEach((child) => {
		                    if (!that.formPageSet.tempSelectUse.includes(child.menu_id)) {
		                        that.formPageSet.tempSelectUse.push(child.menu_id);
		                    }
		                });
		            }
		        }
		    } else {
		        // 如果取消選中
		        if (page_name_2 != "") {
		            // 子選項取消
		            that.formPageSet.tempSelectUse = that.formPageSet.tempSelectUse.filter(item => item !== page_name_2);
		            // 檢查父選項下是否所有子選項都被取消
		            let allChildrenUnchecked = that.formPageSet.tempPageName[inx_1].children.every(child => 
		                !that.formPageSet.tempSelectUse.includes(child.menu_id)
		            );
		            if (allChildrenUnchecked) {
		                that.formPageSet.tempSelectUse = that.formPageSet.tempSelectUse.filter(item => item !== page_name_1);
		            }
		        } else {
		            // 父選項取消
		            if (that.formPageSet.tempPageName[inx_1].children != undefined) {
		                that.formPageSet.tempPageName[inx_1].children.forEach((el) => {
		                    that.formPageSet.tempSelectUse = that.formPageSet.tempSelectUse.filter(item => item !== el.menu_id);
		                });
		            }
		            that.formPageSet.tempSelectUse = that.formPageSet.tempSelectUse.filter(item => item !== page_name_1);
		        }
		    }
		}


	}
}