var page_function = {
	components: {
		"data-table": httpVueLoader("components/layout/data_table.vue"),
	},
	data () {
		return {
			"VarMenuPage": "admin_users",
			"VarMenu": "area",
			"VarPageContainerCss" : "padding:20px",
			"tableData": [],
			"selectedItem": 1,
			"list": [],

			"addUserInfo" : {
				"show" : false,				// 新增/編輯使用者版面顯示
				"showAddBtn" : false,		// 新增使用者按鈕
				"showEditBtn" : false, 		// 編輯使用者按鈕
				"showDeleteBtn" : false, 	// 刪除使用者按鈕	
				"editUserDisable" : false,	// 編輯那些資料不能更新設定
				"multiple" : true,			// Select多選功能
				"userID" : null,			// 使用者ID
				"name" : null,				// 使用者名稱
				"password" : null,			// 使用者密碼
				"checkPassword" : null,		// 使用者二次確認輸入密碼
				"email" : null,				// 電子郵件	
				"telephone" : null,			// 電話號碼
				"cellphone" : null,			// 手機號碼

				"role" : {					// role_id
					"value" : [],
					"options" : []
				},
				
				"priv_no" : 0,
				"enabled" : false,
				"hide_password" : null,
				"hide_checkPassword" : null,
			},

		}
	},
	computed: {
		columns () { // 為了配合多國語系, columns 需使用 computed
			return [{
				name: "user_id",
				required: true,
				label: "帳號",
				align: "center",
				field: "user_id",
				sortable: true,
				style: "width: 50px",
			},
			{
				name: "user_name",
				required: true,
				label: "姓名",
				align: "center",
				field: "user_name",
				sortable: true,
				style: "width: 50px",
			},
			{
				name: "role_name",
				required: true,
				label: "角色",
				align: "left",
				field: "role_name",
				sortable: true,
				$$is_slot: true,
				style: "width: 100px",
			},
			{
				name: "email",
				required: true,
				label: "電子郵件",
				align: "center",
				field: "email",
				sortable: true,
				style: "width: 50px",
			},
			{
				name: "mobile",
				required: true,
				label: "手機號碼",
				align: "center",
				field: "mobile",
				sortable: true,
				style: "width: 50px",
			},
			]
		},

		message_alart () {
			return [
				{ label : "未輸入帳號", value : this.$t("page.admin_users.message.id"), },
				{ label : "未輸入密碼", value : this.$t("page.admin_users.message.password"), },
				{ label : "未輸入確認密碼", value : this.$t("page.admin_users.message.checkPassword"), },
				{ label : "兩個密碼不一致，請輸入正確", value : this.$t("page.admin_users.message.password_dc"), },
				{ label : "未輸入姓名", value : this.$t("page.admin_users.message.name"), },
				{ label : "電話號碼格式不正確", value : this.$t("page.admin_users.message.telephone"), },
				{ label : "手機號碼格式不正確", value : this.$t("page.admin_users.message.cellphone"), },
				{ label : "電子郵件格式不正確", value : this.$t("page.admin_users.message.email"), },
				{ label : "未可查看案場角色", value : this.$t("page.admin_users.message.roleStationSpec"), },
				{ label : "新增成功", value : this.$t("page.admin_users.message.success"), },
				{ label : "新增失敗", value : this.$t("page.admin_users.message.success_error"), },
				{ label : "刪除成功", value : this.$t("page.admin_users.message.delete"), },
				{ label : "刪除失敗", value : this.$t("page.admin_users.message.delete_error"), },
				{ label : "更新成功", value : this.$t("page.admin_users.message.update"), },
				{ label : "更新失敗", value : this.$t("page.admin_users.message.update_error"), },
				{ label : "提醒", value : this.$t("page.admin_users.message.alart"), },
				{ label : "確定刪除此使用者？", value : this.$t("page.admin_users.message.delete_user"), },
			]
		}
	},

	watch : {
		
	},

	mounted () {
		this.$set(this.WebSetup, "caption", '使用者管理');
		this.MenuSetup.opened = false;
		this.VarMenuIsOverlay = false;
		this.getData();
	},

	methods: {
		getData () {
			let that = this;
			var params = {
				Action: 'Users',
				Datas: {},
			};
			return that.FnWebAPIGet(params).then((res) => {
				if (res.data.result) {
					var resData = res.data.data;
					that.tableData = resData;
				} else {
					that.FnNotify(res.data.message, "error");
				}
			});
		},
		rowClick (props, evt) {
			console.log(props);
			console.log(evt);
		},
		searchOk () {
			this.getData();
		},

		//	開啟新增畫面
		addUser () {
			let that = this ;
			that.addUserInfo['show'] = true;
			that.addUserInfo['showEditBtn'] = false;
			that.addUserInfo['showDeleteBtn'] = false;
			that.addUserInfo['showAddBtn'] = true;
			that.addUserInfo['editUserDisable'] = false;
			that.addUserInfo['userID'] = null;
			that.addUserInfo['name'] = null;
			that.addUserInfo['password'] = null;
			that.addUserInfo['checkPassword'] = null;
			that.addUserInfo['email'] = null;
			that.addUserInfo['telephone'] = null;
			that.addUserInfo['cellphone'] = null;
			that.addUserInfo['role']['value'] = [];

			var param = {
				Action: "AddUserInfoLoadingOptios",
				Datas: {},
			}
			that.FnWebAPIGet(param).then(function(res){
				// 角色清單 下拉式選單
				if ( res.data.result ){
					that.addUserInfo['role']['options'] = _.map(res.data.data, (item) => {
						return {
							"label" : item['role_name'],
							"value" : item['role_id'],
						}
					});
				} 
			}).catch(async function(err){
				console.log(err);
			});
		},

		//	儲存新增使用者資訊
		async saveAddUser(){
			let that = this ;

			//	帳號確認
			if ( that.addUserInfo['userID'] == null || that.addUserInfo['userID'] == '' ){
				that.FnNotify( "未輸入帳號" , 'warning' );
				return 
			}
			//	密碼確認
			if ( that.addUserInfo['password'] == null ||  that.addUserInfo['password'] == '' ){
				that.FnNotify( "未輸入新密碼" , 'warning' );
				return
			}
			//	第二次密碼確認
			if ( that.addUserInfo['checkPassword'] == null ||  that.addUserInfo['checkPassword'] == '' ){
				that.FnNotify( "未輸入再次輸入新密碼" , 'warning' );
				return
			}
			//	密碼與第二次輸入密碼是否一致
			if (  that.addUserInfo['password'] != that.addUserInfo['checkPassword'] ) {
				that.FnNotify( "密碼與再次輸入密碼不一致" , 'warning' );
				that.addUserInfo['checkPassword'] = null;
				return
			}
			//	姓名確認
			if ( that.addUserInfo['name'] == null ||  that.addUserInfo['name'] == '' ){
				that.FnNotify( "未輸入姓名" , 'warning' );
				return
			}
			// 	電話	
			if ( that.addUserInfo['telephone'] != null && that.addUserInfo['telephone'] != "" ){
				var regex = /^[0-9]{2}-[0-9]{7}$/;
				if( !regex.test(that.addUserInfo['telephone']) ) {
					that.FnNotify(  "電話號碼格式不正確" , 'warning' );	
					return 	false
	  			} 	
			}
			// 	手機	
			if ( that.addUserInfo['cellphone'] != null && that.addUserInfo['cellphone'] != "" ){
				var regex = /^09[0-9]{8}$/;
				if( !regex.test(that.addUserInfo['cellphone']) ) {
					that.FnNotify( "手機號碼格式不正確" , 'warning' );	
					return 	false
	  			} 
			}
			// 	電子郵件	
			if ( that.addUserInfo['email'] != null && that.addUserInfo['email'] != "" ){
				var regex = /^([a-zA-Z0-9_\.\-\+])+\@(([a-zA-Z0-9\-])+\.)+([a-zA-Z0-9]{2,4})+$/;
				if( !regex.test(that.addUserInfo['email']) ) {
					that.FnNotify( "電子郵件格式不正確" , 'warning' );	
					return 	false
	  			} 
			}

			//	角色未輸入
			if ( _.size(that.addUserInfo['role']['value']) == 0 ){
				that.FnNotify( "未選取角色" , 'warning' );
				return 
			}

			var formData = new FormData();
    		formData.append("Action", 'AddUserInfo');
    		formData.append("Datas",JSON.stringify(that.addUserInfo));

    		await that.FnWebAPIPost(formData).then(function(res){
    			let result = res.data.data;
    			if (result){
    				that.FnNotify( `新增使用者${that.addUserInfo['name']}成功`, 'success');	
	    			that.getData();
	    			that.addUserInfo['show'] = false;
    			}else {
    				that.FnNotify( `新增使用者${that.addUserInfo['name']}失敗`, 'error');	
	    			that.getData();
	    			that.addUserInfo['show'] = true;
    			}
    		}).catch(async function(err){
				console.log(err);
			});
	
		},

		//	取消新增使用者資訊
		cancelAddUser(){
			let that = this ;
			that.addUserInfo['show'] = false;
		},

		// 編輯使用者 
		async editUser(rowData) {
			this.addUser();
			let that = this ;
			that.addUserInfo['show'] = true;
			that.addUserInfo['showEditBtn'] = true;
			if ( that.LoginSetup['user_name'] == rowData['row']['user_name'] ){
				that.addUserInfo['showDeleteBtn'] = false;
			}else{
				that.addUserInfo['showDeleteBtn'] = true;
			}
			that.addUserInfo['editUserDisable'] = true;
			that.addUserInfo['showAddBtn'] = false;

			that.addUserInfo['userID'] = null;
			that.addUserInfo['name'] = null;
			that.addUserInfo['password'] = null;
			that.addUserInfo['checkPassword'] = null;
			that.addUserInfo['email'] = null;
			that.addUserInfo['telephone'] = null;
			that.addUserInfo['cellphone'] = null;
			that.addUserInfo['role']['value'] = [];

			var name = rowData['row']['user_id']

			let param = {
				Action: "editUserInfo",
				Datas: {
					user_id : name,
				}
			}
			await that.FnWebAPIGet(param).then(function(res){
				var user_data = res.data.data;
				that.$set(that.addUserInfo, "userID", user_data['user_id']);
				that.$set(that.addUserInfo, "name", user_data['user_name']);
				that.$set(that.addUserInfo, "email", user_data['email']);
				if ( user_data['enabled'] == "1"){
					that.$set(that.addUserInfo, "enabled", true);
				} else {
					that.$set(that.addUserInfo, "enabled", false);
				}
				that.$set(that.addUserInfo, "cellphone", user_data['mobile']);
				that.$set(that.addUserInfo, "telephone", user_data['tel']);
				if ( user_data['role_name'] != null ){
					that.$set(that.addUserInfo['role'], "value", user_data['role_name'].split(','));
				}
				//隱藏密碼
				that.$set(that.addUserInfo, "hide_password", user_data['password']);
				that.$set(that.addUserInfo, "hide_checkPassword", user_data['password']);
			}).catch(async function(err){
				console.log(err);
			});
		},


		//	更新
		async saveEditUser() {

			let that = this;
			//	密碼確認
			if (  that.addUserInfo['password'] != that.addUserInfo['checkPassword'] ) {
				that.FnNotify( '新密碼與再次輸入新密碼不一致' ,'warning' );
				return
			}
			//	姓名確認
			if ( that.addUserInfo['name'] == null ||  that.addUserInfo['name'] == '' ){
				that.FnNotify( '未輸入姓名' ,'warning' );
				return
			}
			// 	電話	
			if ( that.addUserInfo['telephone'] != null && that.addUserInfo['telephone'] != "" ){
				var regex = /^[0-9]{2}-[0-9]{7}$/;
				if( !regex.test(that.addUserInfo['telephone']) ) {
					that.FnNotify( "電話號碼格式不正確" ,'warning' );	
					return 	false
	  			} 	
			}
			// 	手機	
			if ( that.addUserInfo['cellphone'] != null && that.addUserInfo['cellphone'] != "" ){
				var regex = /^09[0-9]{8}$/;
				if( !regex.test(that.addUserInfo['cellphone']) ) {
					that.FnNotify( "手機號碼格式不正確" ,'warning' );	
					return 	false
	  			} 
			}
			// 	電子郵件	
			if ( that.addUserInfo['email'] != null && that.addUserInfo['email'] != "" ){
				var regex = /^([a-zA-Z0-9_\.\-\+])+\@(([a-zA-Z0-9\-])+\.)+([a-zA-Z0-9]{2,4})+$/;
				if( !regex.test(that.addUserInfo['email']) ) {
					that.FnNotify( "電子郵件格式不正確" ,'warning' );	
					return 	false
	  			} 	
			}

			//	角色未輸入
			if ( _.size(that.addUserInfo['role']['value']) == 0 ){
				that.FnNotify( "未選取角色" , 'warning' );
				return 
			}
	  		
			var formData = new FormData();
    		formData.append("Action", 'UpdateUserInfo');
    		formData.append("Datas",JSON.stringify(that.addUserInfo));

    		await that.FnWebAPIPost(formData).then(function(res){
    			let result = res.data.data;
    			if (result){
    				that.FnNotify( `更新使用者${that.addUserInfo['name']}成功`, 'success');	
	    			that.getData();
	    			that.addUserInfo['show'] = false;
    			}else {
    				that.FnNotify( `更新使用者${that.addUserInfo['name']}失敗`, 'error');	
	    			that.getData();
	    			that.addUserInfo['show'] = true;
    			}
    			
    		}).catch(async function(err){
				console.log(err);
			});

		},

		//	刪除
		async deleteUser(){
			let that = this;

			if(await that.FnConfirm( "確定刪除此使用者？" ,"確認刪除資料將不存在！" )) {
				var formData = new FormData();
	    		formData.append("Action", 'DeleteUserInfo');
	    		formData.append("Datas",JSON.stringify(that.addUserInfo));

	    		await that.FnWebAPIPost(formData).then(function(res){
	    			let result = res.data.data;
	    			if (result){
	    				that.FnNotify( `刪除使用者${that.addUserInfo['name']}成功` , 'success');	
		    			that.getData();
		    			that.addUserInfo['show'] = false;
	    			}else {
	    				that.FnNotify( `刪除使用者${that.addUserInfo['name']}成功` , 'error');	
		    			that.getData();
		    			that.addUserInfo['show'] = false;
	    			}
	    		}).catch(async function(err){
					console.log(err);
				});
    		}
		} 

	}
}