var page_function = {
	components: {},
	data () {
		return {
			"VarMenuPage": "data_analysis_power_baseline",
			"VarMenu": "area",
			"VarPageContainerCss" : "padding:20px",

			"search": {
				"year":  new Date(),
				"year_month": new Date(),
				"range": 'month',	//	月：month、年：year
			},

			"chart" : {
				"title" : {
					"text" : "產量長條圖",
					"textStyle" : {
						"color" : "#fff",
						"align" : "center",
						"verticalAlign" : "middle",
						"fontSize" : "20",
						"fontWeight" : "600",
					},	
				},
				"tooltip" : {
					"trigger" : "axis",
					"axisPointer" : {
						"type" : "shadow",
					},
				},
				"legend" : { 
					"show" : true,
					"selectedMode" : false,
					"right" : 10,
					"textStyle" : {
						// "fontSize" : 16,
						"fontWeight" : "bold",
						"color" : "#fff",
					},
				},
				"grid" : {
					"top" : 50,
					"bottom" : 25,
					"right" : 10,
					"left" : 10,
					"containLabel" : true
				},
				dataset : {
					dimensions : ["Date", "基線", "MCB", "肉乾產量", "罐頭產量", "鳳梨酥產量", "肉鬆產量"],
					source : [
						{"Date" : 1,"Note_1" : (Math.random()*50).toFixed(2), "Note_2" : (Math.random()*50).toFixed(2), "Note_3" : (Math.random()*50).toFixed(2), "Note_4" : (Math.random()*50).toFixed(2), "Note_5" : (Math.random()*50).toFixed(2), "Note_6" : (Math.random()*50).toFixed(2)}
					],
				},
				"xAxis" : {
					"type" : "category",
					"axisLine": {
						"lineStyle": {
							"color": "#ffffff"  // x軸的線條設置為白色
						}
					},
					"axisLabel" : {
						"fontSize" : 16,
						"color": "#ffffff"  // x軸的標籤文字設置為白色
					},
					"axisPointer" : {
						"type" : "shadow",
					}
				},
				"yAxis" : {
					"type" : "value",
					"name" : "",
					"axisLine": {
						"lineStyle": {
							"color": "#ffffff"  // y軸的線條設置為白色
						}
					},
					"axisLabel": {
						"color": "#ffffff"  // y軸的標籤文字設置為白色
					}			
				},
				"series" : [
					{
						"type" : 'line',
						"symbolSize" : 10,
						"symbol" : "circle",
						"lineStyle" : {
							"width" : 3,
						},
						"itemStyle" : { "color" : "#7fddee" },
						// "stack" : "one"
					},
					{
						"type" : 'line',
						"symbolSize" : 10,
						"symbol" : "circle",
						"lineStyle" : {
							"width" : 3,
						},
						"itemStyle" : { "color" : "#acf4b0" },
						// "stack" : "one"
					},
					{
						"type" : 'bar',
						"itemStyle" : { "color" : "#90cc74" },
						"stack" : "one"
					},
					{
						"type" : 'bar',
						"itemStyle" : { "color" : "#fac857" },
						"stack" : "one"
					},
					{
						"type" : 'bar',
						"itemStyle" : { "color" : "#ee6464" },
						"stack" : "one"
					},
					{
						"type" : 'bar',
						"itemStyle" : { "color" : "#526fc5" },
						"stack" : "one"
					},
				]
			}
			
		}
	},

	computed :{},
	watch : {},

	mounted () {
		this.$set(this.WebSetup, "caption", '全廠用電基線');
		this.MenuSetup.opened = false;
		this.VarMenuIsOverlay = true;
		this.searchData();
	},
	methods: {
		
		yearOptions() {
			var options = [], i, year ;
			for ( i = -3 ; i <= 0 ; i++ ) {
				year = Number(moment().format('YYYY')) + i
				options.push({ "label" : `${year} 年 `, "value" : year })
			}
			return options
		},

		searchData() {
			this.chart['dataset']['source'] =  []
			var params = {
				Action : 'SearchData',
				Datas : {
					year : this.search['year'],
					year_month : this.search['year_month'],
					range : this.search['range']
				},
			};
			this.FnWebAPIGet(params).then((res)=> {
				_.each(res.data.data, (item) => {
					item['Date'] = this.search.range == 'year' ? moment(item['Date']).format('YYYY-MM') : moment(item['Date']).format('MM/DD')
					item['基線'] = this.FnRoundToDecimal(item['基線'], 2)
					item['MCB'] = this.FnRoundToDecimal(item['MCB'], 2)
					item['肉乾產量'] = this.FnRoundToDecimal(item['肉乾產量'], 2)
					item['罐頭產量'] = this.FnRoundToDecimal(item['罐頭產量'], 2)
					item['鳳梨酥產量'] = this.FnRoundToDecimal(item['鳳梨酥產量'], 2)
					item['肉鬆產量'] = this.FnRoundToDecimal(item['肉鬆產量'], 2)					
				})
				console.log(res.data.data)
				this.chart['dataset']['source'] = res.data.data
			}).catch((err)=> {
				console.log(err);
			});
		}
		
	}
}