var page_function = {
	components: {},
	data () {
		return {
			"VarMenuPage": "demand_query",
			"VarMenu": "area",
			"VarPageContainerCss" : "padding:20px",

			"search": {
				"start_date": new Date(new Date().getFullYear(), new Date().getMonth() , 1),
				"end_date": new Date(),
			},

			"chart" : {
				"title" : {
					"text" : "每日最高需量時間",
					left: 'center',
					"textStyle": {
						"color": "#fff"  // 標題顏色設為白色
					}
				},
				"tooltip" : {
					"trigger" : "axis",
					"axisPointer" : {
						"type" : "line",
					},
				},
				"legend" : { 
					"show" : false,
				},
				"grid" : {
					"top" : 50,
					"bottom" : 25,
					"right" : 25,
					"left" : 80,
					"containLabel" : true
				},
				dataset : {
					dimensions : ["DATE_TIME", "需量"],
					source : [],
				},
				"xAxis" : {
					"type" : "category",
					"axisLabel" : {
						"fontSize" : 16,
						"color" : "#fff",  // x軸標籤顏色設為白色
						formatter: function (value, index) {
								return moment(value).isValid() ? moment(value).format('MM/DD') : '';
						}
					},
					"axisLine" : {
						"lineStyle" : {
							"color" : "#fff"  // x軸線條顏色設為白色
						}
					},
					"splitLine" : {
						"lineStyle" : {
							"color" : "#fff"  // x軸分隔線顏色設為白色
						}
					}
				},
				"yAxis" : {
					"name" : "需量(kW)",
					"type" : "value",
					nameLocation: "middle",
					nameGap: 60,
					"nameTextStyle": {
						"color" : "#fff"  // y軸名稱顏色設為白色
					},
					"axisLabel" : {
						"color" : "#fff",  // y軸標籤顏色設為白色
					},
					"axisLine" : {
						"lineStyle" : {
							"color" : "#fff"  // y軸線條顏色設為白色
						}
					},
					"splitLine" : {
						"lineStyle" : {
							"color" : "#fff"  // y軸分隔線顏色設為白色
						}
					}
					// axisPointer: {
					// 	type: "line",
					// 	show: true
					// }
				},
				"series" : [
					{
						"type" : 'line',
						"lineStyle": {
							"opacity": 0,
						},
						"symbol": "triangle",
						"symbolSize": 16,
					},
				]
			}
			
		}
	},
	computed :{},
	watch : {},
	mounted () {
		this.$set(this.WebSetup, "caption", '需量查詢');
		this.MenuSetup.opened = false;
		this.VarMenuIsOverlay = true;
		this.searchData();
	},
	methods: {

		searchData() {
			this.chart['dataset']['source'] =  []
			var params = {
				Action : 'SearchData',
				Datas : {
					search : this.search,
				},
			};
			this.FnWebAPIGet(params).then((res)=> {
				if(_.isArray(res.data.data)) {
					var resData = res.data.data;
					// 補滿缺漏日期
					for (var d = moment(this.search.start_date) ; d.isSameOrBefore(this.search.end_date) ; d.add(1, 'days')) {
						var found = _.find(resData, (r)=> { return moment(r.DATE_TIME).format('YYYY-MM-DD') == d.format('YYYY-MM-DD'); });
						if(!found) {
							resData.push({'DATE_TIME': d.format('YYYY-MM-DD'), '需量': null});
						}
					}
					// 排序
					resData = _.sortBy(resData, (r)=> {
						return +moment(r.DATE_TIME);
					});

					this.chart['dataset']['source'] = resData;
				}
			}).catch((err)=> {
				console.log(err);
			});
		}
		
	}
}