var page_function = {
    components: {},
    data() {
        return {
            VarMenuPage: "diagram_recycled",
            VarMenu: "area",
            VarPageContainerCss: "padding:0px",

            

        };
    },

    computed: {},
    watch: {},

    mounted() {
        this.$set(this.WebSetup, "caption", "回收水處理圖");
        this.MenuSetup.opened = false;
        this.VarMenuIsOverlay = true;
        this.loadStatus();
        this.sysNowTime();
    },
    methods: {
        //  刷新頁面
        sysNowTime() {
          let that = this;
          setInterval(function () {
            that.loadStatus();
          }, count_sec * 1000);
        },
        //  區塊定位
        getBillboardAddr(top , left, width , height) {
            return {
                "position" : "absolute",
                "zIndex" : 5,
                "top" : `${!_.isNil(top) ? top : '0' }%`,
                "left" : `${!_.isNil(left) ? left : '0' }%`,
                "width" : `${!_.isNil(width) ? width : '250' }px`,
                "height" : `${!_.isNil(height) ? height : '250' }px`
            }
        },
        //  狀態更新
        loadStatus() {
            var params = {
                Action: "Status",
                Datas: {},
                menu_page : "system_water_flow_chart"
            };
            this.FnWebAPIGet(params).then((res) => {
                var resData = res.data.data;
                // resData = {
                //     "35" : {'status': "1"}
                // }
                _.each(diagram_recycled_base_pic, (item) => {
                    if ( !_.isNil(item['id']) ) {
                        item['animation'] = item['status'][resData[item['id']]['status']] != 0 ? true : false
                        item['imgUrl'] = item['status'][resData[item['id']]['status']] 
                    }
                })


            }).catch((err) => {
                console.log(err);
            });
        }
    },
};
