var page_function = {
  components: {},
  data() {
    return {
      VarMenuPage: "indicatros_trend",
      VarMenu: "area",
      VarPageContainerCss: "padding:20px",
      
      search: {
        year_month: moment().format('YYYY-MM'),
        item: null,
      },
      itemOptions: _.map(meter_index, (i) => { return {label: i.name, value: i.key} }),
      chartOptions: {
        color: ['#5470c6', '#91cc75', '#fac858'],
        title: {
          text: "",
        },
        tooltip: {
          trigger: "axis",
          axisPointer: {
            type: "cross"
          }
        },
        legend: {
          textStyle: {
            fontSize: 17,
            color: "#fff"  // 也可以將 legend 的顏色設為白色
          }
        },
        grid: {
          left: "1%",
          right: "4%",
          bottom: "3%",
          containLabel: true,
        },
        dataset : {
					dimensions : ["day_date", "used_val", "day_weight", "point_val"],
					source : [],
				},
        xAxis: {
          name: "日",
          nameGap: 25,
          nameLocation: "start",
          nameTextStyle: {
            fontSize: 18,
            color: "#fff"  // x軸名稱顏色設為白色
          },
          type: "category",
          boundaryGap: false,
          splitLine: {
            show: true,
            lineStyle: {
              color: "#fff"  // x軸的分隔線顏色設為白色
            }
          },
          axisLine: {
            lineStyle: {
                color: "#5470c6"  // x軸線條顏色設為白色
            }
          },
          axisLabel: {
              color: "#fff"  // x軸標籤顏色設為白色
          }
        },
        yAxis: [
          {
            id: 'used_val',
            name: "用量",
            type: "value",
            nameTextStyle: {
              fontSize: 18,
              color: "#fff"  // y軸名稱顏色設為白色
            },
            axisLine: {
              lineStyle: {
                  color: "#fff"  // y軸線條顏色設為白色
              }
            },
            splitLine: {
                show: true,
                lineStyle: {
                    color: "#fff"  // y軸的分隔線顏色設為白色
                }
            },
            axisLabel: {
                color: "#fff"  // y軸標籤顏色設為白色
            }
          },
          {
            id: "day_weight",
            name: "產量",
            type: "value",
            nameTextStyle: {
              fontSize: 18,
              color: "#fff"  // y軸名稱顏色設為白色
            },
            axisLine: {
              lineStyle: {
                  color: "#fff"  // y軸線條顏色設為白色
              }
            },
            splitLine: {
                show: false
            },
            axisLabel: {
                color: "#fff"  // y軸標籤顏色設為白色
            }
          },
          {
            id: "point_val",
            name: "指標",
            type: "value",
            offset: 80,
            nameTextStyle: {
              fontSize: 18,
              color: "#fff"  // y軸名稱顏色設為白色
            },
            axisLine: {
              lineStyle: {
                  color: "#fff"  // y軸線條顏色設為白色
              }
            },
            splitLine: {
                show: false
            },
            axisLabel: {
                color: "#fff"  // y軸標籤顏色設為白色
            }
          }
        ],
        series: [
          {
            id: 'used_val',
            name: "用量",
            type: "line",
            yAxisIndex: 0,
          },
          {
            id: "day_weight",
            name: "產量",
            type: "line",
            yAxisIndex: 1,
          },
          {
            id: "point_val",
            name: "指標",
            type: "line",
            yAxisIndex: 2,
          },
        ],
      },
    };
  },
  computed: {},
  watch: {},
  mounted() {
    this.$set(this.WebSetup, "caption", "指標趨勢圖");
    this.MenuSetup.opened = false;
    this.VarMenuIsOverlay = true;
    this.initPage();
  },
  methods: {
    initPage() {
      // 載入url參數
      let sp = new URLSearchParams(window.location.search);
      var key = sp.get("key");
      if(key != null) {
        this.search.item = key;
      } else {
        this.search.item = _.first(this.itemOptions)["value"];
      }
      this.searchData();
      // 設定 yAxis顏色
      _.each(this.chartOptions.yAxis, (ya,i)=> {
        ya['axisLine'] = {
          lineStyle: {
            color: this.chartOptions['color'][i]
          }
        }
      });
    },
    searchData() {
      var filData = _.filter(meter_index, {key: this.search.item});
      this.chartOptions.yAxis[0].name = `用量(${filData[0]['unit1']})`;
      this.chartOptions.yAxis[1].name = `產量(${filData[0]['unit2']})`;
      var dataList = _.map(filData, (mi)=> {
				return {
					key: mi.key, 
					name: mi.name, 
					id: mi.ID, 
					table: mi.tableName,
					pid: mi.ProductionID.join()
				}
			});
      var params = {
        Action: "MeterIndex",
        menu_page: "data_analysis_station_indicatros",
        Datas: {
          id_list: dataList,
          date: this.search.year_month, //查當天不用帶date
        },
      };
      this.FnWebAPIGet(params).then((res) => {
        var resData = res.data.data[this.search.item];
        var dataSource = _.map(resData, (r)=> {
          var usedVal = Number(r.dosage);
          // var usedVal = Number(r.Max_value) - Number(r.Min_value);
          var dayWeight = Number(r.day_weight);
          var pointerVal = usedVal / dayWeight;
          if (!_.isFinite(pointerVal) || isNaN(pointerVal)) {
            pointerVal = 0;
          }
          return {
            'day_date': r.day_date,
            'used_val': this.FnRoundToDecimal(usedVal,2),
            'day_weight': this.FnRoundToDecimal(dayWeight,2),
            'point_val': this.FnRoundToDecimal(pointerVal,2),
          }
        });
        this.chartOptions.dataset.source = dataSource;
      })
      .catch((err) => {
        console.log(err);
      });
    },    
  },
};
