var  page_function  =  {
    components: {
    	"data-table": httpVueLoader("components/layout/data_table.vue"),
    },
    data()  {
        return  {
            VarMenuPage:  "report_frugal",
            VarMenu:  "area",
            VarPageContainerCss:  "padding:20px",

           "tableData": [],

           "search" : {
           		"dateType" : {
           			"label": "報表類型",
           			"value" : "energy_saving_comparison",
           			"options" : [
           				{ "label": "能源比較", "value": "energy_saving_comparison" },
           				{ "label": "能源節約率", "value": "energy_saving_rate"},
           			],
           		},
           		
           		"data" : {
           			"title" : "資料區間",
					"year" : [ new Date(new Date().getFullYear() -1, 0) , new Date() ], 
           		}
           }
        };
    },
    computed:  {

    	tableTitle () {
    		return _.reduce(this.search['dateType']['options'] , (obj , key) => {
				obj[key['value']] = key['label']
				return obj
			},{})
    	},

    	columns () { // 為了配合多國語系, columns 需使用 computed
			return [{
				name: "FileName",
				required: true,
				label: "檔案名稱",
				align: "center",
				field: "FileName",
				sortable: true,
				$$is_num_format: false,
				style: "font-size: 20px",
			} ]
		},
    },
    watch:  {},
    mounted()  {
        this.$set(this.WebSetup,  "caption",  "節約報表");
        this.MenuSetup.opened  =  false;
        this.VarMenuIsOverlay  =  true;
        this.searchList();
    },
    methods:  {
        searchList()  {
            this.tableData = []
            var  params  =  {
                Action:  "ReportFileList",
                Datas:  {
                    "folder" : this.search['dateType']['value'],
                    "dataRange" : this.search['data']['year']
                },
            };
            this.FnWebAPIGet(params).then((res)  =>  {
                var resData = res.data.data    
                if ( _.size(resData) > 0) {
                    this.tableData = resData
                } else {
                    this.FnNotify('查無檔案', 'warning')
                }
            })
            .catch((err)  =>  {
                console.log(err);
            });
        },
        
        //  檔案下載
        reportdownload(row){
          //console.log(row.FileName)
          var url = row.FileUrl
          var parameters = {
            fileName: row.FileName
          }
          var request = new XMLHttpRequest()
          request.open('GET', url + '?' + 'fileName=' + parameters.fileName, true)
          request.responseType = 'blob'

          request.onload = function (e) {
            if (this.status === 200) {
              var blob = this.response
              if (window.navigator.msSaveOrOpenBlob) {
                window.navigator.msSaveBlob(blob, parameters.fileName)
              } else {
                var downloadLink = window.document.createElement('a')
                downloadLink.href = window.URL.createObjectURL(new Blob([blob], { type: 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet' }))
                downloadLink.download = parameters.fileName
                document.body.appendChild(downloadLink)
                downloadLink.click()
                document.body.removeChild(downloadLink)
              }
            }
          }
          request.send(parameters)  
        },
        
    },
};
