var page_function = {
	components: {},
	data() {
    	return {
			VarMenuPage: "search_power",
			VarMenu: "area",
			VarPageContainerCss: "padding:20px",

			"search": {
				"year": new Date(),
				"year_month": new Date(),
				"range": 'month',	//	月：month、年：year
			},

			"echart" : {
				"tooltip" : {
					"trigger" : "axis",
					"axisPointer" : {
						"type" : "shadow"
					}
				},
				"legend" : {
					"show" : true,
					"selectedMode" : false,
					"right" : 2,
					"textStyle" : {
						// "fontSize" : 16,
						"fontWeight" : "bold",
						"color" : "#fff"  // 標籤文字顏色設為白色
					},
					"data" : ["尖峰","半尖峰","周六半","離峰"]
				},
				"grid" : {
					"left" : "2%",
					"right" : "0%",
					"bottom" : "3%",
					"containLabel" : true,
				},
				"xAxis" : {
					"type" : "category",
					"axisLabel" : {
						"fontSize" : 16,
						"color" : "#fff"  // x軸標籤顏色設為白色
					},
					"axisLine" : {
						"lineStyle" : {
							"color" : "#fff"  // x軸線條顏色設為白色
						}
					},
					"splitLine" : {
						"lineStyle" : {
							"color" : "#fff"  // x軸分隔線顏色設為白色
						}
					},
					"axisPointer" : {
						"type" : "shadow",
					}
				},
				"yAxis" : [
					{
						"type" : "value",
						"name" : "度",
						"nameTextStyle": {
							"fontSize": 16,
							"color": "#fff"  // y軸名稱顏色設為白色
						},
						"axisLabel": {
      						"fontSize": 16,
							"color": "#fff"  // y軸標籤顏色設為白色
						},
						"axisLine" : {
							"lineStyle" : {
								"color" : "#fff"  // y軸線條顏色設為白色
							}
						},
						"splitLine" : {
							"lineStyle" : {
								"color" : "#fff"  // y軸分隔線顏色設為白色
							}
						}
					}
				],
				"series" : [
					{
						// "name" : "離峰",
						"type" : "bar",
						"stack" : "electricity",
						"emphasis" : {
							"focus" : "series",
						},
						"itemStyle" : { "color" : "#91cc75" },
					},
					{
						// "name" : "周六半",
						"type" : "bar",
						"stack" : "electricity",
						"emphasis" : {
							"focus" : "series",
						},
						"itemStyle" : { "color" : "#7cdded" },
					},
					{
						// "name" : "半尖峰",
						"type" : "bar",
						"stack" : "electricity",
						"emphasis" : {
							"focus" : "series",
						},
						"itemStyle" : { "color" : "#fac858" },
					},
					{
						// "name" : "尖峰",
						"type" : "bar",
						"stack" : "electricity",
						"emphasis" : {
							"focus" : "series",
						},
						"itemStyle" : { "color" : "#ee6666" },
					},
					
				],
				dataset : {
					dimensions : ["Date", "離峰", "周六半", "半尖峰", "尖峰"],
					source : [],
				},
			}

		};
  	},
	computed: {},
	watch: {},
  	mounted() {
		this.$set(this.WebSetup, "caption", "用電度數查詢");
		this.MenuSetup.opened = false;
		this.VarMenuIsOverlay = true;
		this.searchData();
	},
	methods: {
		searchData() {
			this.echart['dataset']['source'] =  []
			var params = {
				Action : 'SearchData',
				Datas : {
					year : this.search['year'],
					year_month : this.search['year_month'],
					range : this.search['range']
				},
			};
			this.FnWebAPIGet(params).then((res)=> {
				_.each(res.data.data, (item) => {
					item['Date'] = this.search.range == 'year' ? moment(item['Date']).format('YYYY-MM') : moment(item['Date']).format('MM/DD')
					item['尖峰'] = this.FnRoundToDecimal(item['尖峰'], 0)
					item['半尖峰'] = this.FnRoundToDecimal(item['半尖峰'], 0)
					item['周六半'] = this.FnRoundToDecimal(item['周六半'], 0)
					item['離峰'] = this.FnRoundToDecimal(item['離峰'], 0)				
				})
				this.echart['dataset']['source'] = res.data.data
			}).catch((err)=> {
				console.log(err);
			});
		},
	},
};
