var page_function = {
	components: {
		"data-table": httpVueLoader("components/layout/data_table.vue"),
	},
	data () {
		return {
			"VarMenuPage": "search_water_daily",
			"VarMenu": "area",
			"VarPageContainerCss" : "padding:20px",

			"search": {
				"start_date": new Date(new Date().getFullYear(), new Date().getMonth() , 1),
				"end_date": new Date(),
			},

			"tableData" : [],
			
			
		}
	},
	computed :{
		columns () { // 為了配合多國語系, columns 需使用 computed
			return [
				{
					name: "date_stamp",
					required: true,
					label: "日期",
					align: "left",
					field: "date_stamp",
					sortable: true,
					style: "font-size: 20px; width: 200px;",
					$$is_num_format: false,
				}, {
					name: "item01",
					required: true,
					label: "水系統",
					align: "center",
					field: "item01",
					sortable: true,
					style: "font-size: 20px; width: 100px;",
					$$is_num_format: true,
					format : (data) => {
						var invName = 0	
						if (!_.isNil(data)) {
							invName = data
						}
						return invName 
					}
					
				}, {
					name: "item02",
					required: true,
					label: "一期屋頂",
					align: "center",
					field: "item02",
					sortable: true,
					style: "font-size: 20px; width: 100px;",
					$$is_num_format: true,
					format : (data) => {
						var invName = 0	
						if (!_.isNil(data)) {
							invName = data
						}
						return invName 
					}
				}, {
					name: "1",
					required: true,
					label: "屋頂熱水槽出水",
					align: "center",
					field: "1",
					sortable: true,
					style: "font-size: 20px; width: 100px;",
					$$is_num_format: true,
					format : (data) => {
						var invName = 0	
						if (!_.isNil(data)) {
							invName = data
						}
						return invName 
					}
				}, {
					name: "2",
					required: true,
					label: "屋頂蒸汽冷凝水回收",
					align: "center",
					field: "2",
					sortable: true,
					style: "font-size: 20px; width: 100px;",
					$$is_num_format: true,
					format : (data) => {
						var invName = 0	
						if (!_.isNil(data)) {
							invName = data
						}
						return invName 
					}
				}, {
					name: "3",
					required: true,
					label: "屋頂燒臘生飲水",
					align: "center",
					field: "3",
					sortable: true,
					style: "font-size: 20px; width: 100px;",
					$$is_num_format: true,
					format : (data) => {
						var invName = 0	
						if (!_.isNil(data)) {
							invName = data
						}
						return invName 
					}
				}, {
					name: "4",
					required: true,
					label: "屋頂一般水",
					align: "center",
					field: "4",
					sortable: true,
					style: "font-size: 20px; width: 100px;",
					$$is_num_format: true,
					format : (data) => {
						var invName = 0	
						if (!_.isNil(data)) {
							invName = data
						}
						return invName 
					}
				}, {
					name: "item07",
					required: true,
					label: "淨水房",
					align: "center",
					field: "item07",
					sortable: true,
					style: "font-size: 20px; width: 100px;",
					$$is_num_format: true,
					format : (data) => {
						var invName = 0	
						if (!_.isNil(data)) {
							invName = data
						}
						return invName 
					}
				}, {
					name: "5",
					required: true,
					label: "自來水總表",
					align: "center",
					field: "5",
					sortable: true,
					style: "font-size: 20px; width: 100px;",
					$$is_num_format: true,
					format : (data) => {
						var invName = 0	
						if (!_.isNil(data)) {
							invName = data
						}
						return invName 
					}
				}, {
					name: "6",
					required: true,
					label: "350T--100T蓄水池",
					align: "center",
					field: "6",
					sortable: true,
					style: "font-size: 20px; width: 100px;",
					$$is_num_format: true,
					format : (data) => {
						var invName = 0	
						if (!_.isNil(data)) {
							invName = data
						}
						return invName 
					}
				}, {
					name: "7",
					required: true,
					label: "宿舍用水",
					align: "center",
					field: "7",
					sortable: true,
					style: "font-size: 20px; width: 100px;",
					$$is_num_format: true,
					format : (data) => {
						var invName = 0	
						if (!_.isNil(data)) {
							invName = data
						}
						return invName 
					}
				}, {
					name: "8",
					required: true,
					label: "軟化水",
					align: "center",
					field: "8",
					sortable: true,
					style: "font-size: 20px; width: 100px;",
					$$is_num_format: true,
					format : (data) => {
						var invName = 0	
						if (!_.isNil(data)) {
							invName = data
						}
						return invName 
					}
				}, {
					name: "item12",
					required: true,
					label: "小地下室",
					align: "center",
					field: "item12",
					sortable: true,
					style: "font-size: 20px; width: 100px;",
					$$is_num_format: true,
					format : (data) => {
						var invName = 0	
						if (!_.isNil(data)) {
							invName = data
						}
						return invName 
					}
				}, {
					name: "9",
					required: true,
					label: "100T--10T一般水槽",
					align: "center",
					field: "9",
					sortable: true,
					style: "font-size: 20px; width: 100px;",
					$$is_num_format: true,
					format : (data) => {
						var invName = 0	
						if (!_.isNil(data)) {
							invName = data
						}
						return invName 
					}
				}, {
					name: "10",
					required: true,
					label: "100T--地下室生飲水",
					align: "center",
					field: "10",
					sortable: true,
					style: "font-size: 20px; width: 100px;",
					$$is_num_format: true,
					format : (data) => {
						var invName = 0	
						if (!_.isNil(data)) {
							invName = data
						}
						return invName 
					}
				}, {
					name: "11",
					required: true,
					label: "生飲水槽--10T屋頂生飲水槽",
					align: "center",
					field: "11",
					sortable: true,
					style: "font-size: 20px; width: 100px;",
					$$is_num_format: true,
					format : (data) => {
						var invName = 0	
						if (!_.isNil(data)) {
							invName = data
						}
						return invName 
					}
				}, {
					name: "12",
					required: true,
					label: "消防水",
					align: "center",
					field: "12",
					sortable: true,
					style: "font-size: 20px; width: 100px;",
					$$is_num_format: true,
					format : (data) => {
						var invName = 0	
						if (!_.isNil(data)) {
							invName = data
						}
						return invName 
					}
				}, {
					name: "item17",
					required: true,
					label: "廢水區",
					align: "center",
					field: "item17",
					sortable: true,
					style: "font-size: 20px; width: 100px;",
					$$is_num_format: true,
					format : (data) => {
						var invName = 0	
						if (!_.isNil(data)) {
							invName = data
						}
						return invName 
					}
				}, {
					name: "13",
					required: true,
					label: "閥基及回收水",
					align: "center",
					field: "13",
					sortable: true,
					style: "font-size: 20px; width: 100px;",
					$$is_num_format: true,
					format : (data) => {
						var invName = 0	
						if (!_.isNil(data)) {
							invName = data
						}
						return invName 
					}
				}, {
					name: "14",
					required: true,
					label: "廢水流浪計",
					align: "center",
					field: "14",
					sortable: true,
					style: "font-size: 20px; width: 100px;",
					$$is_num_format: true,
					format : (data) => {
						var invName = 0	
						if (!_.isNil(data)) {
							invName = data
						}
						return invName 
					}
				}, {
					name: "15",
					required: true,
					label: "SS監測儀",
					align: "center",
					field: "15",
					sortable: true,
					style: "font-size: 20px; width: 100px;",
					$$is_num_format: true,
					format : (data) => {
						var invName = 0	
						if (!_.isNil(data)) {
							invName = data
						}
						return invName 
					}
				}, 
			]
		},
	},
	watch : {},
	mounted () {
		this.$set(this.WebSetup, "caption", '用水系統每日用量查詢');
		this.MenuSetup.opened = false;
		this.VarMenuIsOverlay = true;
		this.searchData();
	},
	methods: {

		searchData() {

			var params = {
				Action : 'SearchData',
				Datas : {
					search : this.search,
				},
			};
			this.FnWebAPIGet(params).then((res)=> {
				if(_.isArray(res.data.data)) {
					var resData = res.data.data;
					
					_.each(resData, (item) => {
						item['item01'] = 0 
						item['item02'] = 0
						item['item07'] = 0
						item['item12'] = 0
						item['item17'] = 0
						_.each(this.treeMap('水', '一期屋頂'), (id) => {
							var temp = _.isNil(item[id['value']]) ? 0 : Number(item[id['value']])
							item['item01'] += temp
							item['item02'] += temp 
		                })
		                _.each(this.treeMap('水', '淨水房'), (id) => {
		                	var temp = _.isNil(item[id['value']]) ? 0 : Number(item[id['value']])
		                	item['item01'] += temp
							item['item07'] += temp 
		                })
		                _.each(this.treeMap('水', '小地下室'), (id) => {
							var temp = _.isNil(item[id['value']]) ? 0 : Number(item[id['value']])
							item['item01'] += temp
							item['item12'] += temp 
		                })
		                _.each(this.treeMap('水', '廢水區'), (id) => {
		                	var temp = _.isNil(item[id['value']]) ? 0 : Number(item[id['value']])
		                	item['item01'] += temp
							item['item17'] += temp 
		                })
					})
					this.tableData = resData
				}
			}).catch((err)=> {
				console.log(err);
			});
		},

		//  樹狀爸爸
	    treeMap (item_type, keyWord) {
	    	return _.map(device_item[item_type][keyWord]['options'] , (item ) => {
	        	return {  "value" : item['value'] } 
	      	})
	    }
		
	}
}