var page_function = {
  components: {},
  data() {
    return {
      VarMenuPage: "system_power",
      VarMenu: "area",
      VarPageContainerCss: "padding:0px",

      deviceKey: "照明", //	Var_Config 設定檔 對應的key
      fromPage: "system_power.php", //	從哪個頁面來的
      data_group: "電力", //  隸屬於device_item 內的哪一個群組
      previousPage: true,
      previousPageName: "電力系統",

      billboard: {
        item01: {
          show: true, //	要不要顯示此區塊
          title: "照明", //	標題
          title_style: "background: linear-gradient(to right, #246ab5 5% , #1565c0 50% , #115eaa 95%);",  //  標體底色
          caption : "",  
          showButton: true,
          button: {
            //	標題同一列的按鈕功能
            item01: {
              show: true, //	要不要顯示此按鈕
              label: "長條圖", //	標題 (標示定義名稱)
              icon: "leaderboard", //	按鈕圖樣
              linkto: "chart_bar.php", //	轉跳頁面 定義為 null 不會觸發
              params: { options: "照明" , item_type: "電力"}, //	轉跳頁面後面帶參數
            },
            item02: {
              show: true,
              label: "圓餅圖",
              icon: "pie_chart",
              linkto: "chart_pie.php",
              params: { options: "照明" , item_type: "電力"},
            },
          },
          data: {
            item01: {
              show: true,
              label: "今日用電",
              isDBValue: true,
              DBvalue: 0,
              isSoft: false,
              SoftValue: "",
              unit: "度",
              icon: "bolt",
            },
            item02: {
              show: true,
              label: "本月用電",
              isDBValue: true,
              DBvalue: 0,
              isSoft: false,
              SoftValue: "",
              unit: "度",
              icon: "bolt",
            },
            item03: {
              show: true,
              label: "即時功率",
              isDBValue: true,
              DBvalue: 0,
              isSoft: false,
              SoftValue: "",
              unit: "kW",
              icon: "bolt",
            },
          },
          top: "8",
          left: "42.5",
          width: "350",
        },
        "23": {
          show: true,
          title: "1LA 西式調理區照明",
          title_style: "background: linear-gradient(to right, #246ab5 5% , #1565c0 50% , #115eaa 95%);",  //  標體底色
          caption : "ID = 23",  
          showButton: true,
          button: {
            item01: {
              show: true,
              label: "長條圖",
              icon: "leaderboard",
              linkto: "chart_bar.php",
              params: { options: "1LA 西式調理區照明", item_type: "電力" },
            },
            item02: {
              show: false,
              label: "圓餅圖",
              icon: "pie_chart",
              linkto: "chart_pie.php",
              params: { options: "1LA 西式調理區照明", item_type: "電力" },
            },
          },
          data: {
            item01: {
              show: true,
              label: "今日用電",
              isDBValue: true,
              DBvalue: 0,
              isSoft: false,
              SoftValue: "",
              unit: "度",
              icon: "bolt",
            },
            item02: {
              show: true,
              label: "本月用電",
              isDBValue: true,
              DBvalue: 0,
              isSoft: false,
              SoftValue: "",
              unit: "度",
              icon: "bolt",
            },
            item03: {
              show: true,
              label: "即時功率",
              isDBValue: true,
              DBvalue: 0,
              isSoft: false,
              SoftValue: "",
              unit: "kW",
              icon: "bolt",
            },
          },
          top: "27",
          left: "5",
          width: "350",
        },
        "22": {
          show: true,
          title: "1LB 209月台照明",
          title_style: "background: linear-gradient(to right, #246ab5 5% , #1565c0 50% , #115eaa 95%);",  //  標體底色
          caption : "ID = 22",  
          showButton: true,
          button: {
            item01: {
              show: true,
              label: "長條圖",
              icon: "leaderboard",
              linkto: "chart_bar.php",
              params: { options: "1LB 209月台照明", item_type: "電力" },
            },
            item02: {
              show: false,
              label: "圓餅圖",
              icon: "pie_chart",
              linkto: "chart_pie.php",
              params: { options: "1LB 209月台照明", item_type: "電力" },
            },
          },
          data: {
            item01: {
              show: true,
              label: "今日用電",
              isDBValue: true,
              DBvalue: 0,
              isSoft: false,
              SoftValue: "",
              unit: "度",
              icon: "bolt",
            },
            item02: {
              show: true,
              label: "本月用電",
              isDBValue: true,
              DBvalue: 0,
              isSoft: false,
              SoftValue: "",
              unit: "度",
              icon: "bolt",
            },
            item03: {
              show: true,
              label: "即時功率",
              isDBValue: true,
              DBvalue: 0,
              isSoft: false,
              SoftValue: "",
              unit: "kW",
              icon: "bolt",
            },
          },
          top: "27",
          left: "30",
          width: "350",
        },
        "21": {
          show: true,
          title: "1LC 蒸煮區照明",
          title_style: "background: linear-gradient(to right, #246ab5 5% , #1565c0 50% , #115eaa 95%);",  //  標體底色
          caption : "ID = 21",  
          showButton: true,
          button: {
            item01: {
              show: true,
              label: "長條圖",
              icon: "leaderboard",
              linkto: "chart_bar.php",
              params: { options: "1LC 蒸煮區照明", item_type: "電力" },
            },
            item02: {
              show: false,
              label: "圓餅圖",
              icon: "pie_chart",
              linkto: "chart_pie.php",
              params: { options: "1LC 蒸煮區照明", item_type: "電力" },
            },
          },
          data: {
            item01: {
              show: true,
              label: "今日用電",
              isDBValue: true,
              DBvalue: 0,
              isSoft: false,
              SoftValue: "",
              unit: "度",
              icon: "bolt",
            },
            item02: {
              show: true,
              label: "本月用電",
              isDBValue: true,
              DBvalue: 0,
              isSoft: false,
              SoftValue: "",
              unit: "度",
              icon: "bolt",
            },
            item03: {
              show: true,
              label: "即時功率",
              isDBValue: true,
              DBvalue: 0,
              isSoft: false,
              SoftValue: "",
              unit: "kW",
              icon: "bolt",
            },
          },
          top: "27",
          left: "55",
          width: "350",
        },
        "20": {
          show: true,
          title: "1LD 烘烤區照明",
          title_style: "background: linear-gradient(to right, #246ab5 5% , #1565c0 50% , #115eaa 95%);",  //  標體底色
          caption : "ID = 20",  
          showButton: true,
          button: {
            item01: {
              show: true,
              label: "長條圖",
              icon: "leaderboard",
              linkto: "chart_bar.php",
              params: { options: "1LD 烘烤區照明", item_type: "電力" },
            },
            item02: {
              show: false,
              label: "圓餅圖",
              icon: "pie_chart",
              linkto: "chart_pie.php",
              params: { options: "1LD 烘烤區照明", item_type: "電力" },
            },
          },
          data: {
            item01: {
              show: true,
              label: "今日用電",
              isDBValue: true,
              DBvalue: 0,
              isSoft: false,
              SoftValue: "",
              unit: "度",
              icon: "bolt",
            },
            item02: {
              show: true,
              label: "本月用電",
              isDBValue: true,
              DBvalue: 0,
              isSoft: false,
              SoftValue: "",
              unit: "度",
              icon: "bolt",
            },
            item03: {
              show: true,
              label: "即時功率",
              isDBValue: true,
              DBvalue: 0,
              isSoft: false,
              SoftValue: "",
              unit: "kW",
              icon: "bolt",
            },
          },
          top: "27",
          left: "80",
          width: "350",
        },
        "19": {
          show: true,
          title: "1LE 罐頭加工區照明",
          title_style: "background: linear-gradient(to right, #246ab5 5% , #1565c0 50% , #115eaa 95%);",  //  標體底色
          caption : "ID = 19",  
          showButton: true,
          button: {
            item01: {
              show: true,
              label: "長條圖",
              icon: "leaderboard",
              linkto: "chart_bar.php",
              params: { options: "1LE 罐頭加工區照明", item_type: "電力" },
            },
            item02: {
              show: false,
              label: "圓餅圖",
              icon: "pie_chart",
              linkto: "chart_pie.php",
              params: { options: "1LE 罐頭加工區照明", item_type: "電力" },
            },
          },
          data: {
            item01: {
              show: true,
              label: "今日用電",
              isDBValue: true,
              DBvalue: 0,
              isSoft: false,
              SoftValue: "",
              unit: "度",
              icon: "bolt",
            },
            item02: {
              show: true,
              label: "本月用電",
              isDBValue: true,
              DBvalue: 0,
              isSoft: false,
              SoftValue: "",
              unit: "度",
              icon: "bolt",
            },
            item03: {
              show: true,
              label: "即時功率",
              isDBValue: true,
              DBvalue: 0,
              isSoft: false,
              SoftValue: "",
              unit: "kW",
              icon: "bolt",
            },
          },
          top: "42.5",
          left: "5",
          width: "350",
        },
        "32": {
          show: true,
          title: "1LF 肉品包裝、中西照明",
          title_style: "background: linear-gradient(to right, #246ab5 5% , #1565c0 50% , #115eaa 95%);",  //  標體底色
          caption : "ID = 32",  
          showButton: true,
          button: {
            item01: {
              show: true,
              label: "長條圖",
              icon: "leaderboard",
              linkto: "chart_bar.php",
              params: { options: "1LF 肉品包裝、中西照明", item_type: "電力" },
            },
            item02: {
              show: false,
              label: "圓餅圖",
              icon: "pie_chart",
              linkto: "chart_pie.php",
              params: { options: "1LF 肉品包裝、中西照明", item_type: "電力" },
            },
          },
          data: {
            item01: {
              show: true,
              label: "今日用電",
              isDBValue: true,
              DBvalue: 0,
              isSoft: false,
              SoftValue: "",
              unit: "度",
              icon: "bolt",
            },
            item02: {
              show: true,
              label: "本月用電",
              isDBValue: true,
              DBvalue: 0,
              isSoft: false,
              SoftValue: "",
              unit: "度",
              icon: "bolt",
            },
            item03: {
              show: true,
              label: "即時功率",
              isDBValue: true,
              DBvalue: 0,
              isSoft: false,
              SoftValue: "",
              unit: "kW",
              icon: "bolt",
            },
          },
          top: "42.5",
          left: "30",
          width: "350",
        },
        "33": {
          show: true,
          title: "1LG 物資倉庫照明",
          title_style: "background: linear-gradient(to right, #246ab5 5% , #1565c0 50% , #115eaa 95%);",  //  標體底色
          caption : "ID = 33",  
          showButton: true,
          button: {
            item01: {
              show: true,
              label: "長條圖",
              icon: "leaderboard",
              linkto: "chart_bar.php",
              params: { options: "1LG 物資倉庫照明", item_type: "電力" },
            },
            item02: {
              show: false,
              label: "圓餅圖",
              icon: "pie_chart",
              linkto: "chart_pie.php",
              params: { options: "1LG 物資倉庫照明", item_type: "電力" },
            },
          },
          data: {
            item01: {
              show: true,
              label: "今日用電",
              isDBValue: true,
              DBvalue: 0,
              isSoft: false,
              SoftValue: "",
              unit: "度",
              icon: "bolt",
            },
            item02: {
              show: true,
              label: "本月用電",
              isDBValue: true,
              DBvalue: 0,
              isSoft: false,
              SoftValue: "",
              unit: "度",
              icon: "bolt",
            },
            item03: {
              show: true,
              label: "即時功率",
              isDBValue: true,
              DBvalue: 0,
              isSoft: false,
              SoftValue: "",
              unit: "kW",
              icon: "bolt",
            },
          },
          top: "42.5",
          left: "55",
          width: "350",
        },
        "34": {
          show: true,
          title: "1LH 糕餅中西整型區照明",
          title_style: "background: linear-gradient(to right, #246ab5 5% , #1565c0 50% , #115eaa 95%);",  //  標體底色
          caption : "ID = 34",  
          showButton: true,
          button: {
            item01: {
              show: true,
              label: "長條圖",
              icon: "leaderboard",
              linkto: "chart_bar.php",
              params: { options: "1LH 糕餅中西整型區照明", item_type: "電力" },
            },
            item02: {
              show: false,
              label: "圓餅圖",
              icon: "pie_chart",
              linkto: "chart_pie.php",
              params: { options: "1LH 糕餅中西整型區照明", item_type: "電力" },
            },
          },
          data: {
            item01: {
              show: true,
              label: "今日用電",
              isDBValue: true,
              DBvalue: 0,
              isSoft: false,
              SoftValue: "",
              unit: "度",
              icon: "bolt",
            },
            item02: {
              show: true,
              label: "本月用電",
              isDBValue: true,
              DBvalue: 0,
              isSoft: false,
              SoftValue: "",
              unit: "度",
              icon: "bolt",
            },
            item03: {
              show: true,
              label: "即時功率",
              isDBValue: true,
              DBvalue: 0,
              isSoft: false,
              SoftValue: "",
              unit: "kW",
              icon: "bolt",
            },
          },
          top: "42.5",
          left: "80",
          width: "350",
        },
        "35": {
          show: true,
          title: "1LI 1樓照明",
          title_style: "background: linear-gradient(to right, #246ab5 5% , #1565c0 50% , #115eaa 95%);",  //  標體底色
          caption : "ID = 35",  
          showButton: true,
          button: {
            item01: {
              show: true,
              label: "長條圖",
              icon: "leaderboard",
              linkto: "chart_bar.php",
              params: { options: "1LI 1樓照明" , item_type: "電力"},
            },
            item02: {
              show: false,
              label: "圓餅圖",
              icon: "pie_chart",
              linkto: "chart_pie.php",
              params: { options: "1LI 1樓照明" , item_type: "電力"},
            },
          },
          data: {
            item01: {
              show: true,
              label: "今日用電",
              isDBValue: true,
              DBvalue: 0,
              isSoft: false,
              SoftValue: "",
              unit: "度",
              icon: "bolt",
            },
            item02: {
              show: true,
              label: "本月用電",
              isDBValue: true,
              DBvalue: 0,
              isSoft: false,
              SoftValue: "",
              unit: "度",
              icon: "bolt",
            },
            item03: {
              show: true,
              label: "即時功率",
              isDBValue: true,
              DBvalue: 0,
              isSoft: false,
              SoftValue: "",
              unit: "kW",
              icon: "bolt",
            },
          },
          top: "58",
          left: "5",
          width: "350",
        },
        "15": {
          show: true,
          title: "1ELA 1F緊急電源",
          title_style: "background: linear-gradient(to right, #246ab5 5% , #1565c0 50% , #115eaa 95%);",  //  標體底色
          caption : "ID = 15",  
          showButton: true,
          button: {
            item01: {
              show: true,
              label: "長條圖",
              icon: "leaderboard",
              linkto: "chart_bar.php",
              params: { options: "1ELA 1F緊急電源" , item_type: "電力"},
            },
            item02: {
              show: false,
              label: "圓餅圖",
              icon: "pie_chart",
              linkto: "chart_pie.php",
              params: { options: "1ELA 1F緊急電源" , item_type: "電力"},
            },
          },
          data: {
            item01: {
              show: true,
              label: "今日用電",
              isDBValue: true,
              DBvalue: 0,
              isSoft: false,
              SoftValue: "",
              unit: "度",
              icon: "bolt",
            },
            item02: {
              show: true,
              label: "本月用電",
              isDBValue: true,
              DBvalue: 0,
              isSoft: false,
              SoftValue: "",
              unit: "度",
              icon: "bolt",
            },
            item03: {
              show: true,
              label: "即時功率",
              isDBValue: true,
              DBvalue: 0,
              isSoft: false,
              SoftValue: "",
              unit: "kW",
              icon: "bolt",
            },
          },
          top: "58",
          left: "30",
          width: "350",
        },
        "24": {
          show: true,
          title: "2LA 2F辦公區照明",
          title_style: "background: linear-gradient(to right, #246ab5 5% , #1565c0 50% , #115eaa 95%);",  //  標體底色
          caption : "ID = 24",  
          showButton: true,
          button: {
            item01: {
              show: true,
              label: "長條圖",
              icon: "leaderboard",
              linkto: "chart_bar.php",
              params: { options: "2LA 2F辦公區照明" , item_type: "電力"},
            },
            item02: {
              show: false,
              label: "圓餅圖",
              icon: "pie_chart",
              linkto: "chart_pie.php",
              params: { options: "2LA 2F辦公區照明" , item_type: "電力"},
            },
          },
          data: {
            item01: {
              show: true,
              label: "今日用電",
              isDBValue: true,
              DBvalue: 0,
              isSoft: false,
              SoftValue: "",
              unit: "度",
              icon: "bolt",
            },
            item02: {
              show: true,
              label: "本月用電",
              isDBValue: true,
              DBvalue: 0,
              isSoft: false,
              SoftValue: "",
              unit: "度",
              icon: "bolt",
            },
            item03: {
              show: true,
              label: "即時功率",
              isDBValue: true,
              DBvalue: 0,
              isSoft: false,
              SoftValue: "",
              unit: "kW",
              icon: "bolt",
            },
          },
          top: "73.5",
          left: "5",
          width: "350",
        },
        "31": {
          show: true,
          title: "2LB 2F右餐廳照明",
          title_style: "background: linear-gradient(to right, #246ab5 5% , #1565c0 50% , #115eaa 95%);",  //  標體底色
          caption : "ID = 31",  
          showButton: true,
          button: {
            item01: {
              show: true,
              label: "長條圖",
              icon: "leaderboard",
              linkto: "chart_bar.php",
              params: { options: "2LB 2F右餐廳照明" , item_type: "電力"},
            },
            item02: {
              show: false,
              label: "圓餅圖",
              icon: "pie_chart",
              linkto: "chart_pie.php",
              params: { options: "2LB 2F右餐廳照明" , item_type: "電力"},
            },
          },
          data: {
            item01: {
              show: true,
              label: "今日用電",
              isDBValue: true,
              DBvalue: 0,
              isSoft: false,
              SoftValue: "",
              unit: "度",
              icon: "bolt",
            },
            item02: {
              show: true,
              label: "本月用電",
              isDBValue: true,
              DBvalue: 0,
              isSoft: false,
              SoftValue: "",
              unit: "度",
              icon: "bolt",
            },
            item03: {
              show: true,
              label: "即時功率",
              isDBValue: true,
              DBvalue: 0,
              isSoft: false,
              SoftValue: "",
              unit: "kW",
              icon: "bolt",
            },
          },
          top: "73.5",
          left: "30",
          width: "350",
        },
        "30": {
          show: true,
          title: "2LC 2F左員工活動中心",
          title_style: "background: linear-gradient(to right, #246ab5 5% , #1565c0 50% , #115eaa 95%);",  //  標體底色
          caption : "ID = 30",  
          showButton: true,
          button: {
            item01: {
              show: true,
              label: "長條圖",
              icon: "leaderboard",
              linkto: "chart_bar.php",
              params: { options: "2LC 2F左員工活動中心" , item_type: "電力"},
            },
            item02: {
              show: false,
              label: "圓餅圖",
              icon: "pie_chart",
              linkto: "chart_pie.php",
              params: { options: "2LC 2F左員工活動中心" , item_type: "電力"},
            },
          },
          data: {
            item01: {
              show: true,
              label: "今日用電",
              isDBValue: true,
              DBvalue: 0,
              isSoft: false,
              SoftValue: "",
              unit: "度",
              icon: "bolt",
            },
            item02: {
              show: true,
              label: "本月用電",
              isDBValue: true,
              DBvalue: 0,
              isSoft: false,
              SoftValue: "",
              unit: "度",
              icon: "bolt",
            },
            item03: {
              show: true,
              label: "即時功率",
              isDBValue: true,
              DBvalue: 0,
              isSoft: false,
              SoftValue: "",
              unit: "kW",
              icon: "bolt",
            },
          },
          top: "73.5",
          left: "55",
          width: "350",
        },
        "14": {
          show: true,
          title: "2EL 2F緊急電源、中控室",
          title_style: "background: linear-gradient(to right, #246ab5 5% , #1565c0 50% , #115eaa 95%);",  //  標體底色
          caption : "ID = 14",  
          showButton: true,
          button: {
            item01: {
              show: true,
              label: "長條圖",
              icon: "leaderboard",
              linkto: "chart_bar.php",
              params: { options: "2EL 2F緊急電源、中控室" , item_type: "電力"},
            },
            item02: {
              show: false,
              label: "圓餅圖",
              icon: "pie_chart",
              linkto: "chart_pie.php",
              params: { options: "2EL 2F緊急電源、中控室" , item_type: "電力"},
            },
          },
          data: {
            item01: {
              show: true,
              label: "今日用電",
              isDBValue: true,
              DBvalue: 0,
              isSoft: false,
              SoftValue: "",
              unit: "度",
              icon: "bolt",
            },
            item02: {
              show: true,
              label: "本月用電",
              isDBValue: true,
              DBvalue: 0,
              isSoft: false,
              SoftValue: "",
              unit: "度",
              icon: "bolt",
            },
            item03: {
              show: true,
              label: "即時功率",
              isDBValue: true,
              DBvalue: 0,
              isSoft: false,
              SoftValue: "",
              unit: "kW",
              icon: "bolt",
            },
          },
          top: "73.5",
          left: "80",
          width: "350",
        },
      },

      //	線條 => 定義 class 如果是line_h要設定height的長度(px)，width設為0，反之是line_w要設定width的長度(px)，height設為0
      line: [
        {
          show: true,
          class: "line_h",
          top: "23",
          left: "51.50",
          width: "0",
          height: "25",
          contect: "照明到各設備", //	註解這條線是什麼意思
          showArrow: false, //	要不要顯示箭頭
          arrow: { class: "", top: "0", left: "0" }, //	箭頭微調 (px) 方向設定 arrow right、left、up、down
        },
        {
          show: true,
          class: "line_w",
          top: "25",
          left: "26.75",
          width: "955",
          height: "0",
          showArrow: false,
          arrow: { class: "", top: "0", left: "0" },
          contect: "照明到各設備",
        },
        {
          show: true,
          class: "line_h",
          top: "25",
          left: "26.75",
          width: "0",
          height: "665",
          showArrow: false,
          arrow: { class: "", top: "0", left: "0" },
          contect: "照明到各設備",
        },
        {
          show: true,
          class: "line_h",
          top: "25",
          left: "76.5",
          width: "955",
          height: "665",
          showArrow: false,
          arrow: { class: "", top: "0", left: "0" },
          contect: "照明到各設備",
        },
        /*----------------------------------------------------------------------------------------------------------------------------------------------------------------*/
        {
          show: true,
          class: "line_w",
          top: "36",
          left: "23.25",
          width: "70",
          height: "0",
          showArrow: false,
          arrow: { class: "arrow left", top: "-6", left: "0" },
          contect: "照明 => 1LA 西式調理區照明",
        },
        {
          show: true,
          class: "line_w",
          top: "52",
          left: "23.25",
          width: "70",
          height: "0",
          showArrow: false,
          arrow: { class: "arrow left", top: "-6", left: "0" },
          contect: "照明 => 1LE 罐頭加工區照明",
        },
        {
          show: true,
          class: "line_w",
          top: "67",
          left: "23.25",
          width: "70",
          height: "0",
          showArrow: false,
          arrow: { class: "arrow left", top: "-6", left: "0" },
          contect: "照明 => 1LI 1樓照明",
        },
        {
          show: true,
          class: "line_w",
          top: "82.75",
          left: "23.25",
          width: "70",
          height: "0",
          showArrow: false,
          arrow: { class: "arrow left", top: "-6", left: "0" },
          contect: "照明 => 2LA 2F辦公區照明",
        },
        {
          show: true,
          class: "line_w",
          top: "36",
          left: "26.75",
          width: "70",
          height: "0",
          showArrow: false,
          arrow: { class: "arrow right", top: "-6", left: "46" },
          contect: "照明 => 1LB 209月台照明",
        },
        {
          show: true,
          class: "line_w",
          top: "52",
          left: "26.75",
          width: "70",
          height: "0",
          showArrow: false,
          arrow: { class: "arrow right", top: "-6", left: "46" },
          contect: "照明 => 1LF 肉品包裝、中西照明",
        },
        {
          show: true,
          class: "line_w",
          top: "67",
          left: "26.75",
          width: "70",
          height: "0",
          showArrow: false,
          arrow: { class: "arrow right", top: "-6", left: "46" },
          contect: "照明 => 1ELA 1F緊急電源",
        },
        {
          show: true,
          class: "line_w",
          top: "82.75",
          left: "26.75",
          width: "70",
          height: "0",
          showArrow: false,
          arrow: { class: "arrow right", top: "-6", left: "46" },
          contect: "照明 => 2LB 2F右餐廳照明",
        },
        {
          show: true,
          class: "line_w",
          top: "36",
          left: "73.25",
          width: "65",
          height: "0",
          showArrow: false,
          arrow: { class: "arrow left", top: "-6", left: "0" },
          contect: "照明 => 1LC 蒸煮區照明",
        },
        {
          show: true,
          class: "line_w",
          top: "52",
          left: "73.25",
          width: "65",
          height: "0",
          showArrow: false,
          arrow: { class: "arrow left", top: "-6", left: "0" },
          contect: "照明 => 1LG 物資倉庫照明",
        },
        {
          show: true,
          class: "line_w",
          top: "82.75",
          left: "73.25",
          width: "70",
          height: "0",
          showArrow: false,
          arrow: { class: "arrow left", top: "-6", left: "0" },
          contect: "照明 => 2LC 2F左員工活動中心",
        },
        {
          show: true,
          class: "line_w",
          top: "36",
          left: "76.25",
          width: "70",
          height: "0",
          showArrow: false,
          arrow: { class: "arrow right", top: "-6", left: "55" },
          contect: "照明 => 1LD 烘烤區照明",
        },
        {
          show: true,
          class: "line_w",
          top: "52",
          left: "76.25",
          width: "70",
          height: "0",
          showArrow: false,
          arrow: { class: "arrow right", top: "-6", left: "55" },
          contect: "照明 => 1LH 糕餅中西整型區照明",
        },
        {
          show: true,
          class: "line_w",
          top: "82.75",
          left: "76.25",
          width: "70",
          height: "0",
          showArrow: false,
          arrow: { class: "arrow right", top: "-6", left: "55" },
          contect: "照明 => 2EL 2F緊急電源、中控室",
        },
      ],
    };
  },

  computed: {},
  watch: {},

  mounted() {
    this.$set(this.WebSetup, "caption", "電力系統 - 照明");
    this.MenuSetup.opened = false;
    this.VarMenuIsOverlay = false;
    // this.deviceKey = new URLSearchParams(window.location.search).get("options");
    // this.fromPage = new URLSearchParams(window.location.search).get("from_page");
    this.loadPageData();
    this.sysNowTime();
  },
  methods: {
    //  刷新頁面
    sysNowTime () {
      let that = this;
      setInterval(function () {
        that.loadPageData();
      }, 60000);
    },
    loadPageData() {
      _.each(this.billboard, (item, key) => {
        _.each(item['data'], (data, data_key) => {
          data['DBvalue'] = 0
        })
      })
      var tempData = [];
      this.get_options_id(tempData, this.deviceKey, this.data_group);
      var params = {
        Action: "LoadPageData",
        Datas: { id_list: _.join(tempData) },
        menu_page: "system_power",
      };
      this.FnWebAPIGet(params)
        .then((res) => {
          var resData = res.data.data;
          var groupByIdData = _.groupBy(resData, 'ID')
          //  基本內容塞值
          _.each(this.billboard, (item, key) => {
            if (!_.isNil(groupByIdData[key])) {
              _.each(item['data'], (data, data_key) => {
                //  今日用電
                if ( data_key == "item01" && data['isDBValue']  ){
                  data['DBvalue'] = this.FnRoundToDecimal(!_.isNil(groupByIdData[key][0]['today_kwh']) ? groupByIdData[key][0]['today_kwh'] : 0, 2) 
                }
                //  本月用電
                if ( data_key == "item02" && data['isDBValue'] ){
                  data['DBvalue'] = this.FnRoundToDecimal(!_.isNil(groupByIdData[key][0]['month_kwh']) ? groupByIdData[key][0]['month_kwh'] : 0, 2) 
                }
                //  即時功率
                if ( data_key == "item03" && data['isDBValue'] ){
                  data['DBvalue'] = this.FnRoundToDecimal(!_.isNil(groupByIdData[key][0]['now_max_kw']) ? groupByIdData[key][0]['now_max_kw'] : 0, 2)  
                }
              })
            }
          })
          //  客製內容
          //  加總
          var SumToday_kwh = _.sumBy(resData, (item) => { return !_.isNil(item['today_kwh']) ? parseFloat(item['today_kwh']) : 0 } )
          var SumMonth_kwh = _.sumBy(resData, (item) => { return !_.isNil(item['month_kwh']) ? parseFloat(item['month_kwh']) : 0 } )
          var SumNowMaxKw = _.sumBy(resData, (item) => { return !_.isNil(item['now_max_kw']) ? parseFloat(item['now_max_kw']) : 0 } )

          //  照明加總
          this.billboard['item01']['data']['item01']['DBvalue'] = this.FnRoundToDecimal(SumToday_kwh, 2)
          this.billboard['item01']['data']['item02']['DBvalue'] = this.FnRoundToDecimal(SumMonth_kwh, 2)
          this.billboard['item01']['data']['item03']['DBvalue'] = this.FnRoundToDecimal(SumNowMaxKw, 2)
          //  數據格式化
          _.each(this.billboard , (detail) => {
            _.each(detail['data'] , (item)=> {
              item['DBvalue'] = this.FnFormatNumber(item['DBvalue'], 1 )
            })
          })
        })
        .catch((err) => {
          console.log(err);
        });
    },
    //樹狀陣列平扁化
    get_options_id(array, key, group) {
      var that = this;
      device_item[group][key]["options"].forEach((el) => {
        if (!isNaN(Number(el.value, 10))) {
          array.push(el.value);
        }
        if (device_item.hasOwnProperty(el.label)) {
          return that.get_options_id(array, el.label, group);
        }
      });
    },
  },
};
