var page_function = {
  components: {},
  data() {
    return {
      VarMenuPage: "system_power",
      VarMenu: "area",
      VarPageContainerCss: "padding:0px",

      deviceKey: "公用設備", // Var_Config 設定檔 對應的key
      fromPage: "system_power.php", //  從哪個頁面來的
      data_group: "電力", //  隸屬於device_item 內的哪一個群組
      previousPage: true,
      previousPageName: "電力系統",

      billboard: {
        item01: {
          show: true, //	要不要顯示此區塊
          title: "公用設備", //	標題
          title_style: "background: linear-gradient(to right, #246ab5 5% , #1565c0 50% , #115eaa 95%);",  //  標體底色
          caption : "",  
          showButton: true,
          button: {
            //	標題同一列的按鈕功能
            item01: {
              show: true, //	要不要顯示此按鈕
              label: "長條圖", //	標題 (標示定義名稱)
              icon: "leaderboard", //	按鈕圖樣
              linkto: "chart_bar.php", //	轉跳頁面 定義為 null 不會觸發
              params: { options: "公用設備" , item_type: "電力"}, //	轉跳頁面後面帶參數
            },
            item02: {
              show: true,
              label: "圓餅圖",
              icon: "pie_chart",
              linkto: "chart_pie.php",
              params: { options: "公用設備" , item_type: "電力"},
            },
          },
          data: {
            item01: {
              show: true,
              label: "今日用電",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "度",
              icon: "bolt",
            },
            item02: {
              show: true,
              label: "本月用電",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "度",
              icon: "bolt",
            },
            item03: {
              show: true,
              label: "即時功率",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "kW",
              icon: "bolt",
            },
          },
          top: "8",
          left: "41.5",
          width: "340",
        },
        "40": {
          show: true,
          title: "EBP水處理專用",
          title_style: "background: linear-gradient(to right, #246ab5 5% , #1565c0 50% , #115eaa 95%);",  //  標體底色
          caption : "ID = 40",  
          showButton: true,
          button: {
            item01: {
              show: true,
              label: "長條圖",
              icon: "leaderboard",
              linkto: "chart_bar.php",
              params: { options: "EBP水處理專用", item_type: "電力" },
            },
            item02: {
              show: false,
              label: "圓餅圖",
              icon: "pie_chart",
              linkto: "chart_pie.php",
              params: { options: "EBP水處理專用", item_type: "電力" },
            },
          },
          data: {
            item01: {
              show: true,
              label: "今日用電",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "度",
              icon: "bolt",
            },
            item02: {
              show: true,
              label: "本月用電",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "度",
              icon: "bolt",
            },
            item03: {
              show: true,
              label: "即時功率",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "kW",
              icon: "bolt",
            },
          },
          top: "28",
          left: "4.5",
          width: "340",
        },
        "42": {
          show: true,
          title: "宿舍",
          title_style: "background: linear-gradient(to right, #246ab5 5% , #1565c0 50% , #115eaa 95%);",  //  標體底色
          caption : "ID = 42",  
          showButton: true,
          button: {
            item01: {
              show: true,
              label: "長條圖",
              icon: "leaderboard",
              linkto: "chart_bar.php",
              params: { options: "宿舍", item_type: "電力" },
            },
            item02: {
              show: false,
              label: "圓餅圖",
              icon: "pie_chart",
              linkto: "chart_pie.php",
              params: { options: "宿舍", item_type: "電力" },
            },
          },
          data: {
            item01: {
              show: true,
              label: "今日用電",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "度",
              icon: "bolt",
            },
            item02: {
              show: true,
              label: "本月用電",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "度",
              icon: "bolt",
            },
            item03: {
              show: true,
              label: "即時功率",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "kW",
              icon: "bolt",
            },
          },
          top: "28",
          left: "26",
          width: "340",
        },
        "2610": {
          show: true,
          title: "A倉",
          title_style: "background: linear-gradient(to right, #246ab5 5% , #1565c0 50% , #115eaa 95%);",  //  標體底色
          caption : "ID = 26 - A倉冷凍庫總用電",  
          showButton: true,
          button: {
            item01: {
              show: true,
              label: "長條圖",
              icon: "leaderboard",
              linkto: "chart_bar.php",
              params: { options: "A倉" , item_type: "電力"},
            },
            item02: {
              show: false,
              label: "圓餅圖",
              icon: "pie_chart",
              linkto: "chart_pie.php",
              params: { options: "A倉", item_type: "電力" },
            },
          },
          data: {
            item01: {
              show: true,
              label: "今日用電",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "度",
              icon: "bolt",
            },
            item02: {
              show: true,
              label: "本月用電",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "度",
              icon: "bolt",
            },
            item03: {
              show: true,
              label: "即時功率",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "kW",
              icon: "bolt",
            },
          },
          top: "50",
          left: "4.5",
          width: "340",
        },
        "27": {
          show: true,
          title: "B倉",
          title_style: "background: linear-gradient(to right, #246ab5 5% , #1565c0 50% , #115eaa 95%);",  //  標體底色
          caption : "ID = 27",  
          showButton: true,
          button: {
            item01: {
              show: true,
              label: "長條圖",
              icon: "leaderboard",
              linkto: "chart_bar.php",
              params: { options: "B倉" , item_type: "電力"},
            },
            item02: {
              show: false,
              label: "圓餅圖",
              icon: "pie_chart",
              linkto: "chart_pie.php",
              params: { options: "B倉" , item_type: "電力"},
            },
          },
          data: {
            item01: {
              show: true,
              label: "今日用電",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "度",
              icon: "bolt",
            },
            item02: {
              show: true,
              label: "本月用電",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "度",
              icon: "bolt",
            },
            item03: {
              show: true,
              label: "即時功率",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "kW",
              icon: "bolt",
            },
          },
          top: "50",
          left: "26",
          width: "340",
        },
        "41": {
          show: true,
          title: "BP鍋爐機房",
          title_style: "background: linear-gradient(to right, #246ab5 5% , #1565c0 50% , #115eaa 95%);",  //  標體底色
          caption : "ID = 41",  
          showButton: true,
          button: {
            item01: {
              show: true,
              label: "長條圖",
              icon: "leaderboard",
              linkto: "chart_bar.php",
              params: { options: "BP鍋爐機房" , item_type: "電力"},
            },
            item02: {
              show: false,
              label: "圓餅圖",
              icon: "pie_chart",
              linkto: "chart_pie.php",
              params: { options: "BP鍋爐機房" , item_type: "電力"},
            },
          },
          data: {
            item01: {
              show: true,
              label: "今日用電",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "度",
              icon: "bolt",
            },
            item02: {
              show: true,
              label: "本月用電",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "度",
              icon: "bolt",
            },
            item03: {
              show: true,
              label: "即時功率",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "kW",
              icon: "bolt",
            },
          },
          top: "28",
          left: "57",
          width: "340",
        },
        "39": {
          show: true,
          title: "PLI工務周邊",
          title_style: "background: linear-gradient(to right, #246ab5 5% , #1565c0 50% , #115eaa 95%);",  //  標體底色
          caption : "ID = 39",  
          showButton: true,
          button: {
            item01: {
              show: true,
              label: "長條圖",
              icon: "leaderboard",
              linkto: "chart_bar.php",
              params: { options: "PLI工務周邊", item_type: "電力" },
            },
            item02: {
              show: true,
              label: "圓餅圖",
              icon: "pie_chart",
              linkto: "chart_pie.php",
              params: { options: "PLI工務周邊", item_type: "電力" },
            },
          },
          data: {
            item01: {
              show: true,
              label: "今日用電",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "度",
              icon: "bolt",
            },
            item02: {
              show: true,
              label: "本月用電",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "度",
              icon: "bolt",
            },
            item03: {
              show: true,
              label: "即時功率",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "kW",
              icon: "bolt",
            },
          },
          top: "50",
          left: "57",
          width: "340",
        },
        "2": {
          show: true,
          title: "汙水",
          title_style: "background: linear-gradient(to right, #246ab5 5% , #1565c0 50% , #115eaa 95%);",  //  標體底色
          caption : "ID = 2",  
          showButton: true,
          button: {
            item01: {
              show: true,
              label: "長條圖",
              icon: "leaderboard",
              linkto: "chart_bar.php",
              params: { options: "汙水" , item_type: "電力"},
            },
            item02: {
              show: false,
              label: "圓餅圖",
              icon: "pie_chart",
              linkto: "chart_pie.php",
              params: { options: "汙水" , item_type: "電力"},
            },
          },
          data: {
            item01: {
              show: true,
              label: "今日用電",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "度",
              icon: "bolt",
            },
            item02: {
              show: true,
              label: "本月用電",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "度",
              icon: "bolt",
            },
            item03: {
              show: true,
              label: "即時功率",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "kW",
              icon: "bolt",
            },
          },
          top: "50",
          left: "77",
          width: "340",
        },
        "10": {
          show: false, // 不顯示
          title: "A倉冷凍庫總用電",
          title_style: "background: linear-gradient(to right, #246ab5 5% , #1565c0 50% , #115eaa 95%);",  //  標體底色
          caption : "ID = 10",  
          showButton: true,
          button: {
            item01: {
              show: true,
              label: "長條圖",
              icon: "leaderboard",
              linkto: "chart_bar.php",
              params: { options: "汙水" , item_type: "電力"},
            },
            item02: {
              show: false,
              label: "圓餅圖",
              icon: "pie_chart",
              linkto: "chart_pie.php",
              params: { options: "汙水" , item_type: "電力"},
            },
          },
          data: {
            item01: {
              show: true,
              label: "今日用電",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "度",
              icon: "bolt",
            },
            item02: {
              show: true,
              label: "本月用電",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "度",
              icon: "bolt",
            },
            item03: {
              show: true,
              label: "即時功率",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "kW",
              icon: "bolt",
            },
          },
          top: "50",
          left: "77",
          width: "340",
        },
        "26": {
          show: false, // 不顯示
          title: "A倉",
          title_style: "background: linear-gradient(to right, #246ab5 5% , #1565c0 50% , #115eaa 95%);",  //  標體底色
          caption : "ID = 10",  
          showButton: true,
          button: {
            item01: {
              show: true,
              label: "長條圖",
              icon: "leaderboard",
              linkto: "chart_bar.php",
              params: { options: "汙水" , item_type: "電力"},
            },
            item02: {
              show: false,
              label: "圓餅圖",
              icon: "pie_chart",
              linkto: "chart_pie.php",
              params: { options: "汙水" , item_type: "電力"},
            },
          },
          data: {
            item01: {
              show: true,
              label: "今日用電",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "度",
              icon: "bolt",
            },
            item02: {
              show: true,
              label: "本月用電",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "度",
              icon: "bolt",
            },
            item03: {
              show: true,
              label: "即時功率",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "kW",
              icon: "bolt",
            },
          },
          top: "50",
          left: "77",
          width: "340",
        },
      },

      //	線條 => 定義 class 如果是line_h要設定height的長度(px)，width設為0，反之是line_w要設定width的長度(px)，height設為0
      line: [
        {
          show: true,
          class: "line_h",
          top: "23",
          left: "50.50",
          width: "0",
          height: "270",
          contect: "公用設備到其他設備", //	註解這條線是什麼意思
          showArrow: false, //	要不要顯示箭頭
          arrow: { class: "", top: "0", left: "0" }, //	箭頭微調 (px) 方向設定 arrow right、left、up、down
        },
        {
          show: true,
          class: "line_w",
          top: "25.5",
          left: "13.75",
          width: "1007",
          height: "0",
          showArrow: false,
          arrow: { class: "", top: "0", left: "0" },
          contect: "公用設備到其他設備",
        },
        {
          show: true,
          class: "line_w",
          top: "46.5",
          left: "13.75",
          width: "1007",
          height: "0",
          showArrow: false,
          arrow: { class: "", top: "0", left: "0" },
          contect: "公用設備到其他設備",
        },
        /*----------------------------------------------------------------------------------------------------------------------------------------------------------------*/
        {
          show: true,
          class: "line_h",
          top: "25.5",
          left: "13.75",
          width: "0",
          height: "30",
          showArrow: false,
          arrow: { class: "arrow down", top: "13", left: "-6" },
          contect: "公用設備 => EBP水處理專用",
        },
        {
          show: true,
          class: "line_h",
          top: "25.5",
          left: "35",
          width: "0",
          height: "30",
          showArrow: false,
          arrow: { class: "arrow down", top: "13", left: "-6" },
          contect: "公用設備 => 宿舍",
        },
        {
          show: true,
          class: "line_h",
          top: "25.5",
          left: "66",
          width: "0",
          height: "30",
          showArrow: false,
          arrow: { class: "arrow down", top: "13", left: "-6" },
          contect: "公用設備 => A倉",
        },
        {
          show: true,
          class: "line_h",
          top: "46.5",
          left: "13.75",
          width: "0",
          height: "40",
          showArrow: false,
          arrow: { class: "arrow down", top: "25", left: "-6" },
          contect: "公用設備 => B倉",
        },
        {
          show: true,
          class: "line_h",
          top: "46.5",
          left: "35",
          width: "0",
          height: "40",
          showArrow: false,
          arrow: { class: "arrow down", top: "25", left: "-6" },
          contect: "公用設備 => BP鍋爐機房",
        },
        {
          show: true,
          class: "line_h",
          top: "46.5",
          left: "66",
          width: "0",
          height: "40",
          showArrow: false,
          arrow: { class: "arrow down", top: "25", left: "-6" },
          contect: "公用設備 => PLI工務周邊",
        },
        {
          show: true,
          class: "line_w",
          top: "57.5",
          left: "74.5",
          width: "55",
          height: "0",
          showArrow: false,
          arrow: { class: "arrow right", top: "-6", left: "40" },
          contect: "PLI工務周邊 => 汙水",
        },
      ],
    };
  },

  computed: {},
  watch: {},

  mounted() {
    this.$set(this.WebSetup, "caption", "電力系統 - 公用設備");
    this.MenuSetup.opened = false;
    this.VarMenuIsOverlay = false;
    // this.deviceKey = new URLSearchParams(window.location.search).get("options");
    // this.fromPage = new URLSearchParams(window.location.search).get("from_page");
    this.loadPageData();
    this.sysNowTime();
  },
  methods: {
    sysNowTime () {
      let that = this;
      setInterval(function () {
        that.loadPageData();
      }, 600000);
    },
    loadPageData() {
      _.each(this.billboard, (item, key) => {
        _.each(item['data'], (data, data_key) => {
          data['DBvalue'] = 0
        })
      })
      var tempData = [];
      this.get_options_id(tempData, this.deviceKey, this.data_group);
      tempData.push(2,10,26); // 少了汙水ID，ID:26 要扣A倉冷凍庫總用電 ID:10
      var params = {
        Action: "LoadPageData",
        Datas: { id_list: _.join(tempData) },
        menu_page: "system_power",
      };
      this.FnWebAPIGet(params)
        .then((res) => {
          var resData = res.data.data;
          var groupByIdData = _.groupBy(resData , 'ID')
          //  基本內容塞值
          _.each(this.billboard , (item , key) => {
            if (!_.isNil(groupByIdData[key])) {
              _.each(item['data'] , (data ,data_key) => {
                //  今日用電
                if ( data_key == "item01" && data['isDBValue']  ){
                  data['DBvalue'] = this.FnRoundToDecimal(!_.isNil(groupByIdData[key][0]['today_kwh']) ? groupByIdData[key][0]['today_kwh'] : 0, 2) 
                }
                //  本月用電
                if ( data_key == "item02" && data['isDBValue'] ){
                  data['DBvalue'] = this.FnRoundToDecimal(!_.isNil(groupByIdData[key][0]['month_kwh']) ? groupByIdData[key][0]['month_kwh'] : 0, 2) 
                }
                //  即時功率
                if ( data_key == "item03" && data['isDBValue'] ){
                  data['DBvalue'] = this.FnRoundToDecimal(!_.isNil(groupByIdData[key][0]['now_max_kw']) ? groupByIdData[key][0]['now_max_kw'] : 0, 2)  
                }
              })
            }
          })
          //  客製內容
          //  加總
          this.billboard['2610']['data']['item03']['DBvalue'] = this.billboard['26']['data']['item03']['DBvalue']
          var SumToday_kwh = _.sumBy(resData, (item) => { return !_.isNil(item['today_kwh']) ? parseFloat(item['today_kwh']) : 0 } )
          var SumMonth_kwh = _.sumBy(resData, (item) => { return !_.isNil(item['month_kwh']) ? parseFloat(item['month_kwh']) : 0 } )
          var SumNowMaxKw = _.sumBy(resData, (item) => { return !_.isNil(item['now_max_kw']) ? parseFloat(item['now_max_kw']) : 0 } )
          //  公用設備加總
          this.billboard['item01']['data']['item01']['DBvalue'] = this.FnRoundToDecimal(SumToday_kwh, 2)
          this.billboard['item01']['data']['item02']['DBvalue'] = this.FnRoundToDecimal(SumMonth_kwh, 2)
          this.billboard['item01']['data']['item03']['DBvalue'] = this.FnRoundToDecimal(SumNowMaxKw, 2)
          //  數據格式化
          _.each(this.billboard , (detail) => {
            _.each(detail['data'] , (item)=> {
              item['DBvalue'] = this.FnFormatNumber(item['DBvalue'], 1 )
            })
          })
        })
        .catch((err) => {
          console.log(err);
        });
    },
    //樹狀陣列平扁化
    get_options_id(array, key, group) {
      var that = this;
      device_item[group][key]["options"].forEach((el) => {
        if (!isNaN(Number(el.value, 10))) {
          array.push(el.value);
        }
        if (device_item.hasOwnProperty(el.label)) {
          return that.get_options_id(array, el.label, group);
        }
      });
    },
  },
};
