var page_function = {
  components: {},
  data() {
    return {
      VarMenuPage: "system_power",
      VarMenu: "area",
      VarPageContainerCss: "padding:0px",

      deviceKey: "通風", // Var_Config 設定檔 對應的key
      fromPage: "system_power.php", //  從哪個頁面來的
      data_group: "電力", //  隸屬於device_item 內的哪一個群組
      previousPage: true,
      previousPageName: "電力系統",

      billboard: {
        item01: {
          show: true, //	要不要顯示此區塊
          title: "通風", //	標題
          title_style: "background: linear-gradient(to right, #246ab5 5% , #1565c0 50% , #115eaa 95%);",  //  標體底色
          caption : "",  
          showButton: true,
          button: {
            //	標題同一列的按鈕功能
            item01: {
              show: true, //	要不要顯示此按鈕
              label: "長條圖", //	標題 (標示定義名稱)
              icon: "leaderboard", //	按鈕圖樣
              linkto: "chart_bar.php", //	轉跳頁面 定義為 null 不會觸發
              params: { options: "通風" , item_type: "電力"}, //	轉跳頁面後面帶參數
            },
            item02: {
              show: true,
              label: "圓餅圖",
              icon: "pie_chart",
              linkto: "chart_pie.php",
              params: { options: "通風" , item_type: "電力"},
            },
          },
          data: {
            item01: {
              show: true,
              label: "今日用電",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "度",
              icon: "bolt",
            },
            item02: {
              show: true,
              label: "本月用電",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "度",
              icon: "bolt",
            },
            item03: {
              show: true,
              label: "即時功率",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "kW",
              icon: "bolt",
            },
          },
          top: "8",
          left: "42.5",
          width: "350",
        },
        "56": {
          show: true,
          title: "RAC7糕餅頂層排風機",
          title_style: "background: linear-gradient(to right, #246ab5 5% , #1565c0 50% , #115eaa 95%);",  //  標體底色
          caption : "ID = 56",  
          showButton: true,
          button: {
            item01: {
              show: true,
              label: "長條圖",
              icon: "leaderboard",
              linkto: "chart_bar.php",
              params: { options: "RAC7糕餅頂層排風機" , item_type: "電力"},
            },
            item02: {
              show: false,
              label: "圓餅圖",
              icon: "pie_chart",
              linkto: "chart_pie.php",
              params: { options: "RAC7糕餅頂層排風機" , item_type: "電力"},
            },
          },
          data: {
            item01: {
              show: true,
              label: "今日用電",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "度",
              icon: "bolt",
            },
            item02: {
              show: true,
              label: "本月用電",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "度",
              icon: "bolt",
            },
            item03: {
              show: true,
              label: "即時功率",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "kW",
              icon: "bolt",
            },
          },
          top: "32",
          left: "15",
          width: "350",
        },
        "28": {
          show: true,
          title: "RAC6烘烤區排風機",
          title_style: "background: linear-gradient(to right, #246ab5 5% , #1565c0 50% , #115eaa 95%);",  //  標體底色
          caption : "ID = 28",  
          showButton: true,
          button: {
            item01: {
              show: true,
              label: "長條圖",
              icon: "leaderboard",
              linkto: "chart_bar.php",
              params: { options: "RAC6烘烤區排風機" , item_type: "電力"},
            },
            item02: {
              show: false,
              label: "圓餅圖",
              icon: "pie_chart",
              linkto: "chart_pie.php",
              params: { options: "RAC6烘烤區排風機" , item_type: "電力"},
            },
          },
          data: {
            item01: {
              show: true,
              label: "今日用電",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "度",
              icon: "bolt",
            },
            item02: {
              show: true,
              label: "本月用電",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "度",
              icon: "bolt",
            },
            item03: {
              show: true,
              label: "即時功率",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "kW",
              icon: "bolt",
            },
          },
          top: "32",
          left: "42.5",
          width: "350",
        },
        "25": {
          show: true,
          title: "RAC2蒸煮區排風機",
          title_style: "background: linear-gradient(to right, #246ab5 5% , #1565c0 50% , #115eaa 95%);",  //  標體底色
          caption : "ID = 25",  
          showButton: true,
          button: {
            item01: {
              show: true,
              label: "長條圖",
              icon: "leaderboard",
              linkto: "chart_bar.php",
              params: { options: "RAC2蒸煮區排風機" , item_type: "電力"},
            },
            item02: {
              show: false,
              label: "圓餅圖",
              icon: "pie_chart",
              linkto: "chart_pie.php",
              params: { options: "RAC2蒸煮區排風機" , item_type: "電力"},
            },
          },
          data: {
            item01: {
              show: true,
              label: "今日用電",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "度",
              icon: "bolt",
            },
            item02: {
              show: true,
              label: "本月用電",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "度",
              icon: "bolt",
            },
            item03: {
              show: true,
              label: "即時功率",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "kW",
              icon: "bolt",
            },
          },
          top: "32",
          left: "70",
          width: "350",
        },
      },

      //	線條 => 定義 class 如果是line_h要設定height的長度(px)，width設為0，反之是line_w要設定width的長度(px)，height設為0
      line: [
        {
          show: true,
          class: "line_h",
          top: "23",
          left: "51.50",
          width: "0",
          height: "50",
          contect: "通風各設備", //	註解這條線是什麼意思
          showArrow: false, //	要不要顯示箭頭
          arrow: { class: "", top: "0", left: "0" }, //	箭頭微調 (px) 方向設定 arrow right、left、up、down
        },
        {
          show: true,
          class: "line_w",
          top: "27",
          left: "23.75",
          width: "1065",
          height: "0",
          showArrow: false,
          arrow: { class: "", top: "0", left: "0" },
          contect: "通風到各設備",
        },
        {
          show: true,
          class: "line_h",
          top: "27",
          left: "23.75",
          width: "0",
          height: "55",
          showArrow: false,
          arrow: { class: "arrow down", top: "40", left: "-6" },
          contect: "通風 => RAC7糕餅頂層排風機",
        },
        {
          show: true,
          class: "line_h",
          top: "27",
          left: "51.5",
          width: "0",
          height: "55",
          showArrow: false,
          arrow: { class: "arrow down", top: "40", left: "-6" },
          contect: "通風 => RAC6烘烤區排風機",
        },
        {
          show: true,
          class: "line_h",
          top: "27",
          left: "79",
          width: "0",
          height: "55",
          showArrow: false,
          arrow: { class: "arrow down", top: "40", left: "-6" },
          contect: "通風 => RAC2蒸煮區排風機",
        },
      ],
    };
  },

  computed: {},
  watch: {},

  mounted() {
    this.$set(this.WebSetup, "caption", "電力系統 - 通風");
    this.MenuSetup.opened = false;
    this.VarMenuIsOverlay = false;
    // this.deviceKey = new URLSearchParams(window.location.search).get("options");
    // this.fromPage = new URLSearchParams(window.location.search).get("from_page");
    this.loadPageData();
    this.sysNowTime();
  },
  methods: {
    sysNowTime () {
      let that = this;
      setInterval(function () {
        that.loadPageData();
      }, 600000);
    },
    loadPageData() {
      _.each(this.billboard, (item, key) => {
        _.each(item['data'], (data, data_key) => {
          data['DBvalue'] = 0
        })
      })
      var tempData = [];
      this.get_options_id(tempData, this.deviceKey, this.data_group);
      var params = {
        Action: "LoadPageData",
        Datas: { id_list: _.join(tempData) },
        menu_page: "system_power",
      };
      this.FnWebAPIGet(params)
        .then((res) => {
          var resData = res.data.data;
          var groupByIdData = _.groupBy(resData , 'ID')
          //  基本內容塞值
          _.each(this.billboard , (item , key) => {
            if (!_.isNil(groupByIdData[key])) {
              _.each(item['data'] , (data ,data_key) => {
                //  今日用電
                if ( data_key == "item01" && data['isDBValue']  ){
                  data['DBvalue'] = this.FnRoundToDecimal(!_.isNil(groupByIdData[key][0]['today_kwh']) ? groupByIdData[key][0]['today_kwh'] : 0, 2) 
                }
                //  本月用電
                if ( data_key == "item02" && data['isDBValue'] ){
                  data['DBvalue'] = this.FnRoundToDecimal(!_.isNil(groupByIdData[key][0]['month_kwh']) ? groupByIdData[key][0]['month_kwh'] : 0, 2) 
                }
                //  即時功率
                if ( data_key == "item03" && data['isDBValue'] ){
                  data['DBvalue'] = this.FnRoundToDecimal(!_.isNil(groupByIdData[key][0]['now_max_kw']) ? groupByIdData[key][0]['now_max_kw'] : 0, 2)  
                }
              })
            }
          })
          //  客製內容
          //  加總
          var SumToday_kwh = _.sumBy(resData, (item) => { return !_.isNil(item['today_kwh']) ? parseFloat(item['today_kwh']) : 0 } )
          var SumMonth_kwh = _.sumBy(resData, (item) => { return !_.isNil(item['month_kwh']) ? parseFloat(item['month_kwh']) : 0 } )
          var SumNowMaxKw = _.sumBy(resData, (item) => { return !_.isNil(item['now_max_kw']) ? parseFloat(item['now_max_kw']) : 0 } )
          //  通風加總
          this.billboard['item01']['data']['item01']['DBvalue'] = this.FnRoundToDecimal(SumToday_kwh , 2)
          this.billboard['item01']['data']['item02']['DBvalue'] = this.FnRoundToDecimal(SumMonth_kwh , 2)
          this.billboard['item01']['data']['item03']['DBvalue'] = this.FnRoundToDecimal(SumNowMaxKw , 2)
          //  數據格式化
          _.each(this.billboard , (detail) => {
            _.each(detail['data'] , (item)=> {
              item['DBvalue'] = this.FnFormatNumber(item['DBvalue'], 1 )
            })
          })
        })
        .catch((err) => {
          console.log(err);
        });
    },
    //樹狀陣列平扁化
    get_options_id(array, key, group) {
      var that = this;
      device_item[group][key]["options"].forEach((el) => {
        if (!isNaN(Number(el.value, 10))) {
          array.push(el.value);
        }
        if (device_item.hasOwnProperty(el.label)) {
          return that.get_options_id(array, el.label, group);
        }
      });
    },
  },
};
