var page_function = {
  components: {},
  data() {
    return {
      VarMenuPage: "system_steam",
      VarMenu: "area",
      VarPageContainerCss: "padding:0px",

      billboard: {
        "1": {
          show: true,
          title: "蒸汽總管線",
          title_style: "background: linear-gradient(to right, #246ab5 5% , #1565c0 50% , #115eaa 95%);",  //  標體底色
          caption: "ID = 1",
          showButton: true,
          button: {
            item01: {
              show: true,
              label: "長條圖",
              icon: "leaderboard",
              linkto: "chart_bar.php",
              params: { options: "蒸汽總管線" , item_type: "蒸汽"},
            },
            item02: {
              show: true,
              label: "圓餅圖",
              icon: "pie_chart",
              linkto: "chart_pie.php",
              params: { options: "蒸汽總管線" , item_type: "蒸汽"},
            },
          },
          data: {
            item01: {
              show: true,
              label: "即時值",
              isDBValue: true,
              DBvalue: 0,
              isSoft: false,
              SoftValue: "",
              unit: "kg",
              icon: "bolt",
            },
            item02: {
              show: true,
              label: "日用量",
              isDBValue: true,
              DBvalue: 0,
              isSoft: false,
              SoftValue: "",
              unit: "kg/hr",
              icon: "bolt",
            },
          },
          top: "7.5",
          left: "41.5",
          width: "340",
        },
        item03: {
          show: true,
          title: "蒸煮室",
          title_style: "background: linear-gradient(to right, #246ab5 5% , #1565c0 50% , #115eaa 95%);",  //  標體底色
          caption: "",
          showButton: true,
          button: {
            item01: {
              show: true,
              label: "長條圖",
              icon: "leaderboard",
              linkto: "chart_bar.php",
              params: { options: "蒸煮室" , item_type: "蒸汽"},
            },
            item02: {
              show: true,
              label: "圓餅圖",
              icon: "pie_chart",
              linkto: "chart_pie.php",
              params: { options: "蒸煮室" , item_type: "蒸汽"},
            },
          },
          data: {
            item01: {
              show: true,
              label: "即時值",
              isDBValue: true,
              DBvalue: 0,
              isSoft: false,
              SoftValue: "",
              unit: "kg",
              icon: "bolt",
            },
            item02: {
              show: true,
              label: "日用量",
              isDBValue: true,
              DBvalue: 0,
              isSoft: false,
              SoftValue: "",
              unit: "kg/hr",
              icon: "bolt",
            },
          },
          top: "22.5",
          left: "1.5",
          width: "340",
        },
        "2": {
          show: true,
          title: "罐頭煮釜",
          title_style: "background: linear-gradient(to right, #246ab5 5% , #1565c0 50% , #115eaa 95%);",  //  標體底色
          caption: "ID = 2",
          showButton: true,
          button: {
            item01: {
              show: true,
              label: "長條圖",
              icon: "leaderboard",
              linkto: "chart_bar.php",
              params: { options: "罐頭煮釜" , item_type: "蒸汽"},
            },
            item02: {
              show: false,
              label: "圓餅圖",
              icon: "pie_chart",
              linkto: "chart_pie.php",
              params: { options: "罐頭煮釜", item_type: "蒸汽" },
            },
          },
          data: {
            item01: {
              show: true,
              label: "即時值",
              isDBValue: true,
              DBvalue: 0,
              isSoft: false,
              SoftValue: "",
              unit: "kg",
              icon: "bolt",
            },
            item02: {
              show: true,
              label: "日用量",
              isDBValue: true,
              DBvalue: 0,
              isSoft: false,
              SoftValue: "",
              unit: "kg/hr",
              icon: "bolt",
            },
          },
          top: "35",
          left: "1.5",
          width: "340",
        },
        "3": {
          show: true,
          title: "二重鍋",
          title_style: "background: linear-gradient(to right, #246ab5 5% , #1565c0 50% , #115eaa 95%);",  //  標體底色
          caption: "ID = 3",
          showButton: true,
          button: {
            item01: {
              show: true,
              label: "長條圖",
              icon: "leaderboard",
              linkto: "chart_bar.php",
              params: { options: "二重鍋" , item_type: "蒸汽"},
            },
            item02: {
              show: false,
              label: "圓餅圖",
              icon: "pie_chart",
              linkto: "chart_pie.php",
              params: { options: "二重鍋" , item_type: "蒸汽"},
            },
          },
          data: {
            item01: {
              show: true,
              label: "即時值",
              isDBValue: true,
              DBvalue: 0,
              isSoft: false,
              SoftValue: "",
              unit: "kg",
              icon: "bolt",
            },
            item02: {
              show: true,
              label: "日用量",
              isDBValue: true,
              DBvalue: 0,
              isSoft: false,
              SoftValue: "",
              unit: "kg/hr",
              icon: "bolt",
            },
          },
          top: "47.5",
          left: "1.5",
          width: "340",
        },
        "4": {
          show: true,
          title: "四方煮鍋",
          title_style: "background: linear-gradient(to right, #246ab5 5% , #1565c0 50% , #115eaa 95%);",  //  標體底色
          caption: "ID = 4",
          showButton: true,
          button: {
            item01: {
              show: true,
              label: "長條圖",
              icon: "leaderboard",
              linkto: "chart_bar.php",
              params: { options: "四方煮鍋", item_type: "蒸汽" },
            },
            item02: {
              show: false,
              label: "圓餅圖",
              icon: "pie_chart",
              linkto: "chart_pie.php",
              params: { options: "四方煮鍋" , item_type: "蒸汽"},
            },
          },
          data: {
            item01: {
              show: true,
              label: "即時值",
              isDBValue: true,
              DBvalue: 0,
              isSoft: false,
              SoftValue: "",
              unit: "kg",
              icon: "bolt",
            },
            item02: {
              show: true,
              label: "日用量",
              isDBValue: true,
              DBvalue: 0,
              isSoft: false,
              SoftValue: "",
              unit: "kg/hr",
              icon: "bolt",
            },
          },
          top: "60",
          left: "1.5",
          width: "340",
        },
        "5": {
          show: true,
          title: "肉鬆炒鍋",
          title_style: "background: linear-gradient(to right, #246ab5 5% , #1565c0 50% , #115eaa 95%);",  //  標體底色
          caption: "ID = 5",
          showButton: true,
          button: {
            item01: {
              show: true,
              label: "長條圖",
              icon: "leaderboard",
              linkto: "chart_bar.php",
              params: { options: "肉鬆炒鍋", item_type: "蒸汽" },
            },
            item02: {
              show: false,
              label: "圓餅圖",
              icon: "pie_chart",
              linkto: "chart_pie.php",
              params: { options: "肉鬆炒鍋", item_type: "蒸汽" },
            },
          },
          data: {
            item01: {
              show: true,
              label: "即時值",
              isDBValue: true,
              DBvalue: 0,
              isSoft: false,
              SoftValue: "",
              unit: "kg",
              icon: "bolt",
            },
            item02: {
              show: true,
              label: "日用量",
              isDBValue: true,
              DBvalue: 0,
              isSoft: false,
              SoftValue: "",
              unit: "kg/hr",
              icon: "bolt",
            },
          },
          top: "72.5",
          left: "1.5",
          width: "340",
        },
        item08: {
          show: true,
          title: "罐頭加工室",
          title_style: "background: linear-gradient(to right, #246ab5 5% , #1565c0 50% , #115eaa 95%);",  //  標體底色
          caption: "",
          showButton: true,
          button: {
            item01: {
              show: true,
              label: "長條圖",
              icon: "leaderboard",
              linkto: "chart_bar.php",
              params: { options: "罐頭加工室", item_type: "蒸汽" },
            },
            item02: {
              show: true,
              label: "圓餅圖",
              icon: "pie_chart",
              linkto: "chart_pie.php",
              params: { options: "罐頭加工室" , item_type: "蒸汽"},
            },
          },
          data: {
            item01: {
              show: true,
              label: "即時值",
              isDBValue: true,
              DBvalue: 0,
              isSoft: false,
              SoftValue: "",
              unit: "kg",
              icon: "bolt",
            },
            item02: {
              show: true,
              label: "日用量",
              isDBValue: true,
              DBvalue: 0,
              isSoft: false,
              SoftValue: "",
              unit: "kg/hr",
              icon: "bolt",
            },
          },
          top: "22.5",
          left: "21.5",
          width: "340",
        },
        "6": {
          show: true,
          title: "遠紅外線",
          title_style: "background: linear-gradient(to right, #246ab5 5% , #1565c0 50% , #115eaa 95%);",  //  標體底色
          caption: "ID = 6",
          showButton: true,
          button: {
            item01: {
              show: true,
              label: "長條圖",
              icon: "leaderboard",
              linkto: "chart_bar.php",
              params: { options: "遠紅外線", item_type: "蒸汽"},
            },
            item02: {
              show: false,
              label: "圓餅圖",
              icon: "pie_chart",
              linkto: "chart_pie.php",
              params: { options: "遠紅外線", item_type: "蒸汽" },
            },
          },
          data: {
            item01: {
              show: true,
              label: "即時值",
              isDBValue: true,
              DBvalue: 0,
              isSoft: false,
              SoftValue: "",
              unit: "kg",
              icon: "bolt",
            },
            item02: {
              show: true,
              label: "日用量",
              isDBValue: true,
              DBvalue: 0,
              isSoft: false,
              SoftValue: "",
              unit: "kg/hr",
              icon: "bolt",
            },
          },
          top: "35",
          left: "21.5",
          width: "340",
        },
        "7": {
          show: true,
          title: "殺菌釜NO.1",
          title_style: "background: linear-gradient(to right, #246ab5 5% , #1565c0 50% , #115eaa 95%);",  //  標體底色
          caption: "ID = 7",
          showButton: true,
          button: {
            item01: {
              show: true,
              label: "長條圖",
              icon: "leaderboard",
              linkto: "chart_bar.php",
              params: { options: "殺菌釜NO.1" , item_type: "蒸汽"},
            },
            item02: {
              show: false,
              label: "圓餅圖",
              icon: "pie_chart",
              linkto: "chart_pie.php",
              params: { options: "殺菌釜NO.1" , item_type: "蒸汽"},
            },
          },
          data: {
            item01: {
              show: true,
              label: "即時值",
              isDBValue: true,
              DBvalue: 0,
              isSoft: false,
              SoftValue: "",
              unit: "kg",
              icon: "bolt",
            },
            item02: {
              show: true,
              label: "日用量",
              isDBValue: true,
              DBvalue: 0,
              isSoft: false,
              SoftValue: "",
              unit: "kg/hr",
              icon: "bolt",
            },
          },
          top: "47.5",
          left: "21.5",
          width: "340",
        },
        "8": {
          show: true,
          title: "殺菌釜NO.2",
          title_style: "background: linear-gradient(to right, #246ab5 5% , #1565c0 50% , #115eaa 95%);",  //  標體底色
          caption: "ID = 8",
          showButton: true,
          button: {
            item01: {
              show: true,
              label: "長條圖",
              icon: "leaderboard",
              linkto: "chart_bar.php",
              params: { options: "殺菌釜NO.2" , item_type: "蒸汽"},
            },
            item02: {
              show: false,
              label: "圓餅圖",
              icon: "pie_chart",
              linkto: "chart_pie.php",
              params: { options: "殺菌釜NO.2" , item_type: "蒸汽"},
            },
          },
          data: {
            item01: {
              show: true,
              label: "即時值",
              isDBValue: true,
              DBvalue: 0,
              isSoft: false,
              SoftValue: "",
              unit: "kg",
              icon: "bolt",
            },
            item02: {
              show: true,
              label: "日用量",
              isDBValue: true,
              DBvalue: 0,
              isSoft: false,
              SoftValue: "",
              unit: "kg/hr",
              icon: "bolt",
            },
          },
          top: "60",
          left: "21.5",
          width: "340",
        },
        "9": {
          show: true,
          title: "殺菌釜NO.3",
          title_style: "background: linear-gradient(to right, #246ab5 5% , #1565c0 50% , #115eaa 95%);",  //  標體底色
          caption: "ID = 9",
          showButton: true,
          button: {
            item01: {
              show: true,
              label: "長條圖",
              icon: "leaderboard",
              linkto: "chart_bar.php",
              params: { options: "殺菌釜NO.3" , item_type: "蒸汽"},
            },
            item02: {
              show: false,
              label: "圓餅圖",
              icon: "pie_chart",
              linkto: "chart_pie.php",
              params: { options: "殺菌釜NO.3" , item_type: "蒸汽"},
            },
          },
          data: {
            item01: {
              show: true,
              label: "即時值",
              isDBValue: true,
              DBvalue: 0,
              isSoft: false,
              SoftValue: "",
              unit: "kg",
              icon: "bolt",
            },
            item02: {
              show: true,
              label: "日用量",
              isDBValue: true,
              DBvalue: 0,
              isSoft: false,
              SoftValue: "",
              unit: "kg/hr",
              icon: "bolt",
            },
          },
          top: "72.5",
          left: "21.5",
          width: "340",
        },
        "10": {
          show: true,
          title: "殺菌釜NO.4",
          title_style: "background: linear-gradient(to right, #246ab5 5% , #1565c0 50% , #115eaa 95%);",  //  標體底色
          caption: "ID = 10",
          showButton: true,
          button: {
            item01: {
              show: true,
              label: "長條圖",
              icon: "leaderboard",
              linkto: "chart_bar.php",
              params: { options: "殺菌釜NO.4", item_type: "蒸汽" },
            },
            item02: {
              show: false,
              label: "圓餅圖",
              icon: "pie_chart",
              linkto: "chart_pie.php",
              params: { options: "殺菌釜NO.4" , item_type: "蒸汽"},
            },
          },
          data: {
            item01: {
              show: true,
              label: "即時值",
              isDBValue: true,
              DBvalue: 0,
              isSoft: false,
              SoftValue: "",
              unit: "kg",
              icon: "bolt",
            },
            item02: {
              show: true,
              label: "日用量",
              isDBValue: true,
              DBvalue: 0,
              isSoft: false,
              SoftValue: "",
              unit: "kg/hr",
              icon: "bolt",
            },
          },
          top: "85",
          left: "21.5",
          width: "340",
        },
        item14: {
          show: true,
          title: "肉品烘烤室",
          title_style: "background: linear-gradient(to right, #246ab5 5% , #1565c0 50% , #115eaa 95%);",  //  標體底色
          caption: "",
          showButton: true,
          button: {
            item01: {
              show: true,
              label: "長條圖",
              icon: "leaderboard",
              linkto: "chart_bar.php",
              params: { options: "肉品烘烤室" , item_type: "蒸汽"},
            },
            item02: {
              show: true,
              label: "圓餅圖",
              icon: "pie_chart",
              linkto: "chart_pie.php",
              params: { options: "肉品烘烤室" , item_type: "蒸汽"},
            },
          },
          data: {
            item01: {
              show: true,
              label: "即時值",
              isDBValue: true,
              DBvalue: 0,
              isSoft: false,
              SoftValue: "",
              unit: "kg",
              icon: "bolt",
            },
            item02: {
              show: true,
              label: "日用量",
              isDBValue: true,
              DBvalue: 0,
              isSoft: false,
              SoftValue: "",
              unit: "kg/hr",
              icon: "bolt",
            },
          },
          top: "22.5",
          left: "41.5",
          width: "340",
        },
        "11": {
          show: true,
          title: "Vemag隧道煙燻爐",
          title_style: "background: linear-gradient(to right, #246ab5 5% , #1565c0 50% , #115eaa 95%);",  //  標體底色
          caption: "ID = 11",
          showButton: true,
          button: {
            item01: {
              show: true,
              label: "長條圖",
              icon: "leaderboard",
              linkto: "chart_bar.php",
              params: { options: "Vemag隧道煙燻爐", item_type: "蒸汽" },
            },
            item02: {
              show: false,
              label: "圓餅圖",
              icon: "pie_chart",
              linkto: "chart_pie.php",
              params: { options: "Vemag隧道煙燻爐", item_type: "蒸汽" },
            },
          },
          data: {
            item01: {
              show: true,
              label: "即時值",
              isDBValue: true,
              DBvalue: 0,
              isSoft: false,
              SoftValue: "",
              unit: "kg",
              icon: "bolt",
            },
            item02: {
              show: true,
              label: "日用量",
              isDBValue: true,
              DBvalue: 0,
              isSoft: false,
              SoftValue: "",
              unit: "kg/hr",
              icon: "bolt",
            },
          },
          top: "35",
          left: "41.5",
          width: "340",
        },
        "12": {
          show: true,
          title: "Fessmann多功能爐",
          title_style: "background: linear-gradient(to right, #246ab5 5% , #1565c0 50% , #115eaa 95%);",  //  標體底色
          caption: "ID = 12",
          showButton: true,
          button: {
            item01: {
              show: true,
              label: "長條圖",
              icon: "leaderboard",
              linkto: "chart_bar.php",
              params: { options: "Fessmann多功能爐", item_type: "蒸汽" },
            },
            item02: {
              show: false,
              label: "圓餅圖",
              icon: "pie_chart",
              linkto: "chart_pie.php",
              params: { options: "Fessmann多功能爐", item_type: "蒸汽" },
            },
          },
          data: {
            item01: {
              show: true,
              label: "即時值",
              isDBValue: true,
              DBvalue: 0,
              isSoft: false,
              SoftValue: "",
              unit: "kg",
              icon: "bolt",
            },
            item02: {
              show: true,
              label: "日用量",
              isDBValue: true,
              DBvalue: 0,
              isSoft: false,
              SoftValue: "",
              unit: "kg/hr",
              icon: "bolt",
            },
          },
          top: "47.5",
          left: "41.5",
          width: "340",
        },
        "13": {
          show: true,
          title: "Fessmann多功能爐",
          title_style: "background: linear-gradient(to right, #246ab5 5% , #1565c0 50% , #115eaa 95%);",  //  標體底色
          caption: "ID = 13",
          showButton: true,
          button: {
            item01: {
              show: true,
              label: "長條圖",
              icon: "leaderboard",
              linkto: "chart_bar.php",
              params: { options: "Fessmann多功能爐", item_type: "蒸汽" },
            },
            item02: {
              show: false,
              label: "圓餅圖",
              icon: "pie_chart",
              linkto: "chart_pie.php",
              params: { options: "Fessmann多功能爐", item_type: "蒸汽" },
            },
          },
          data: {
            item01: {
              show: true,
              label: "即時值",
              isDBValue: true,
              DBvalue: 0,
              isSoft: false,
              SoftValue: "",
              unit: "kg",
              icon: "bolt",
            },
            item02: {
              show: true,
              label: "日用量",
              isDBValue: true,
              DBvalue: 0,
              isSoft: false,
              SoftValue: "",
              unit: "kg/hr",
              icon: "bolt",
            },
          },
          top: "60",
          left: "41.5",
          width: "340",
        },
        "14": {
          show: true,
          title: "宣柏蒸煮爐",
          title_style: "background: linear-gradient(to right, #246ab5 5% , #1565c0 50% , #115eaa 95%);",  //  標體底色
          caption: "ID = 14",
          showButton: true,
          button: {
            item01: {
              show: true,
              label: "長條圖",
              icon: "leaderboard",
              linkto: "chart_bar.php",
              params: { options: "宣柏蒸煮爐", item_type: "蒸汽" },
            },
            item02: {
              show: false,
              label: "圓餅圖",
              icon: "pie_chart",
              linkto: "chart_pie.php",
              params: { options: "宣柏蒸煮爐", item_type: "蒸汽" },
            },
          },
          data: {
            item01: {
              show: true,
              label: "即時值",
              isDBValue: true,
              DBvalue: 0,
              isSoft: false,
              SoftValue: "",
              unit: "kg",
              icon: "bolt",
            },
            item02: {
              show: true,
              label: "日用量",
              isDBValue: true,
              DBvalue: 0,
              isSoft: false,
              SoftValue: "",
              unit: "kg/hr",
              icon: "bolt",
            },
          },
          top: "72.5",
          left: "41.5",
          width: "340",
        },
        "15": {
          show: true,
          title: "KOCH乾燥爐",
          title_style: "background: linear-gradient(to right, #246ab5 5% , #1565c0 50% , #115eaa 95%);",  //  標體底色
          caption: "ID = 15",
          showButton: true,
          button: {
            item01: {
              show: true,
              label: "長條圖",
              icon: "leaderboard",
              linkto: "chart_bar.php",
              params: { options: "KOCH乾燥爐" , item_type: "蒸汽"},
            },
            item02: {
              show: false,
              label: "圓餅圖",
              icon: "pie_chart",
              linkto: "chart_pie.php",
              params: { options: "KOCH乾燥爐" , item_type: "蒸汽"},
            },
          },
          data: {
            item01: {
              show: true,
              label: "即時值",
              isDBValue: true,
              DBvalue: 0,
              isSoft: false,
              SoftValue: "",
              unit: "kg",
              icon: "bolt",
            },
            item02: {
              show: true,
              label: "日用量",
              isDBValue: true,
              DBvalue: 0,
              isSoft: false,
              SoftValue: "",
              unit: "kg/hr",
              icon: "bolt",
            },
          },
          top: "85",
          left: "41.5",
          width: "340",
        },
        item20: {
          show: true,
          title: "燒臘區蒸汽總管線",
          title_style: "background: linear-gradient(to right, #246ab5 5% , #1565c0 50% , #115eaa 95%);",  //  標體底色
          caption: "",
          showButton: true,
          button: {
            item01: {
              show: true,
              label: "長條圖",
              icon: "leaderboard",
              linkto: "chart_bar.php",
              params: { options: "燒臘區蒸汽總管線", item_type: "蒸汽" },
            },
            item02: {
              show: false,
              label: "圓餅圖",
              icon: "pie_chart",
              linkto: "chart_pie.php",
              params: { options: "燒臘區蒸汽總管線", item_type: "蒸汽"},
            },
          },
          data: {
            item01: {
              show: true,
              label: "即時值",
              isDBValue: true,
              DBvalue: 0,
              isSoft: false,
              SoftValue: "",
              unit: "kg",
              icon: "bolt",
            },
            item02: {
              show: true,
              label: "日用量",
              isDBValue: true,
              DBvalue: 0,
              isSoft: false,
              SoftValue: "",
              unit: "kg/hr",
              icon: "bolt",
            },
          },
          top: "22.5",
          left: "80.5",
          width: "340",
        },
        "16": {
          show: true,
          title: "蒸煮鍋",
          title_style: "background: linear-gradient(to right, #246ab5 5% , #1565c0 50% , #115eaa 95%);",  //  標體底色
          caption: "ID = 16",
          showButton: true,
          button: {
            item01: {
              show: true,
              label: "長條圖",
              icon: "leaderboard",
              linkto: "chart_bar.php",
              params: { options: "蒸煮鍋" , item_type: "蒸汽"},
            },
            item02: {
              show: false,
              label: "圓餅圖",
              icon: "pie_chart",
              linkto: "chart_pie.php",
              params: { options: "蒸煮鍋", item_type: "蒸汽" },
            },
          },
          data: {
            item01: {
              show: true,
              label: "即時值",
              isDBValue: true,
              DBvalue: 0,
              isSoft: false,
              SoftValue: "",
              unit: "kg",
              icon: "bolt",
            },
            item02: {
              show: true,
              label: "日用量",
              isDBValue: true,
              DBvalue: 0,
              isSoft: false,
              SoftValue: "",
              unit: "kg/hr",
              icon: "bolt",
            },
          },
          top: "35",
          left: "80.5",
          width: "340",
        },
        item22: {
          show: true,
          title: "屋頂",
          title_style: "background: linear-gradient(to right, #246ab5 5% , #1565c0 50% , #115eaa 95%);",  //  標體底色
          caption: "",
          showButton: true,
          button: {
            item01: {
              show: true,
              label: "長條圖",
              icon: "leaderboard",
              linkto: "chart_bar.php",
              params: { options: "屋頂" , item_type: "蒸汽"},
            },
            item02: {
              show: true,
              label: "圓餅圖",
              icon: "pie_chart",
              linkto: "chart_pie.php",
              params: { options: "屋頂" , item_type: "蒸汽"},
            },
          },
          data: {
            item01: {
              show: true,
              label: "即時值",
              isDBValue: true,
              DBvalue: 0,
              isSoft: false,
              SoftValue: "",
              unit: "kg",
              icon: "bolt",
            },
            item02: {
              show: true,
              label: "日用量",
              isDBValue: true,
              DBvalue: 0,
              isSoft: false,
              SoftValue: "",
              unit: "kg/hr",
              icon: "bolt",
            },
          },
          top: "60",
          left: "61",
          width: "340",
        },
        "17": {
          show: true,
          title: "熱水槽",
          title_style: "background: linear-gradient(to right, #246ab5 5% , #1565c0 50% , #115eaa 95%);",  //  標體底色
          caption: "ID = 17",
          showButton: true,
          button: {
            item01: {
              show: true,
              label: "長條圖",
              icon: "leaderboard",
              linkto: "chart_bar.php",
              params: { options: "熱水槽", item_type: "蒸汽" },
            },
            item02: {
              show: false,
              label: "圓餅圖",
              icon: "pie_chart",
              linkto: "chart_pie.php",
              params: { options: "熱水槽", item_type: "蒸汽" },
            },
          },
          data: {
            item01: {
              show: true,
              label: "即時值",
              isDBValue: true,
              DBvalue: 0,
              isSoft: false,
              SoftValue: "",
              unit: "kg",
              icon: "bolt",
            },
            item02: {
              show: true,
              label: "日用量",
              isDBValue: true,
              DBvalue: 0,
              isSoft: false,
              SoftValue: "",
              unit: "kg/hr",
              icon: "bolt",
            },
          },
          top: "72.5",
          left: "61",
          width: "340",
        },
        item24: {
          show: true,
          title: "熟食包裝室",
          title_style: "background: linear-gradient(to right, #246ab5 5% , #1565c0 50% , #115eaa 95%);",  //  標體底色
          caption: "ID = 17",
          showButton: true,
          button: {
            item01: {
              show: true,
              label: "長條圖",
              icon: "leaderboard",
              linkto: "chart_bar.php",
              params: { options: "熟食包裝室", item_type: "蒸汽" },
            },
            item02: {
              show: true,
              label: "圓餅圖",
              icon: "pie_chart",
              linkto: "chart_pie.php",
              params: { options: "熟食包裝室", item_type: "蒸汽" },
            },
          },
          data: {
            item01: {
              show: true,
              label: "即時值",
              isDBValue: true,
              DBvalue: 0,
              isSoft: false,
              SoftValue: "",
              unit: "kg",
              icon: "bolt",
            },
            item02: {
              show: true,
              label: "日用量",
              isDBValue: true,
              DBvalue: 0,
              isSoft: false,
              SoftValue: "",
              unit: "kg/hr",
              icon: "bolt",
            },
          },
          top: "22.5",
          left: "61",
          width: "340",
        },
        "18": {
          show: true,
          title: "殺菌槽",
          title_style: "background: linear-gradient(to right, #246ab5 5% , #1565c0 50% , #115eaa 95%);",  //  標體底色
          caption: "ID = 18",
          showButton: true,
          button: {
            item01: {
              show: true,
              label: "長條圖",
              icon: "leaderboard",
              linkto: "chart_bar.php",
              params: { options: "殺菌槽" , item_type: "蒸汽"},
            },
            item02: {
              show: false,
              label: "圓餅圖",
              icon: "pie_chart",
              linkto: "chart_pie.php",
              params: { options: "殺菌槽" , item_type: "蒸汽"},
            },
          },
          data: {
            item01: {
              show: true,
              label: "即時值",
              isDBValue: true,
              DBvalue: 0,
              isSoft: false,
              SoftValue: "",
              unit: "kg",
              icon: "bolt",
            },
            item02: {
              show: true,
              label: "日用量",
              isDBValue: true,
              DBvalue: 0,
              isSoft: false,
              SoftValue: "",
              unit: "kg/hr",
              icon: "bolt",
            },
          },
          top: "35",
          left: "61",
          width: "340",
        },
        item26: {
          show: true,
          title: "糕餅調理室",
          title_style: "background: linear-gradient(to right, #246ab5 5% , #1565c0 50% , #115eaa 95%);",  //  標體底色
          caption: "",
          showButton: true,
          button: {
            item01: {
              show: true,
              label: "長條圖",
              icon: "leaderboard",
              linkto: "chart_bar.php",
              params: { options: "糕餅調理室" , item_type: "蒸汽"},
            },
            item02: {
              show: true,
              label: "圓餅圖",
              icon: "pie_chart",
              linkto: "chart_pie.php",
              params: { options: "糕餅調理室" , item_type: "蒸汽"},
            },
          },
          data: {
            item01: {
              show: true,
              label: "即時值",
              isDBValue: true,
              DBvalue: 0,
              isSoft: false,
              SoftValue: "",
              unit: "kg",
              icon: "bolt",
            },
            item02: {
              show: true,
              label: "日用量",
              isDBValue: true,
              DBvalue: 0,
              isSoft: false,
              SoftValue: "",
              unit: "kg/hr",
              icon: "bolt",
            },
          },
          top: "60",
          left: "80.5",
          width: "340",
        },
        "19": {
          show: true,
          title: "炒焰鍋",
          title_style: "background: linear-gradient(to right, #246ab5 5% , #1565c0 50% , #115eaa 95%);",  //  標體底色
          caption: "ID = 19",
          showButton: true,
          button: {
            item01: {
              show: true,
              label: "長條圖",
              icon: "leaderboard",
              linkto: "chart_bar.php",
              params: { options: "炒焰鍋" , item_type: "蒸汽"},
            },
            item02: {
              show: false,
              label: "圓餅圖",
              icon: "pie_chart",
              linkto: "chart_pie.php",
              params: { options: "炒焰鍋" , item_type: "蒸汽"},
            },
          },
          data: {
            item01: {
              show: true,
              label: "即時值",
              isDBValue: true,
              DBvalue: 0,
              isSoft: false,
              SoftValue: "",
              unit: "kg",
              icon: "bolt",
            },
            item02: {
              show: true,
              label: "日用量",
              isDBValue: true,
              DBvalue: 0,
              isSoft: false,
              SoftValue: "",
              unit: "kg/hr",
              icon: "bolt",
            },
          },
          top: "72.5",
          left: "80.5",
          width: "340",
        },
      },

      //	線條 => 定義 class 如果是line_h要設定height的長度(px)，width設為0，反之是line_w要設定width的長度(px)，height設為0
      line: [
        {
          show: true,
          class: "line_h",
          top: "19",
          left: "50",
          width: "0",
          height: "20",
          showArrow: false,
          arrow: { class: "arrow", top: "0", left: "0" },
          contect: "蒸汽總管線連接各設備",
        },
        {
          show: true,
          class: "line_h",
          top: "20.5",
          left: "79.5",
          width: "0",
          height: "430",
          showArrow: false,
          arrow: { class: "arrow", top: "0", left: "0" },
          contect: "蒸汽總管線連接各設備",
        },
        {
          show: true,
          class: "line_w",
          top: "20.5",
          left: "10.5",
          width: "1325",
          height: "0",
          showArrow: false,
          arrow: { class: "arrow right", top: "0", left: "0" },
          contect: "蒸汽總管線連接各設備",
        },
        {
          show: true,
          class: "line_w",
          top: "57.75",
          left: "69.5",
          width: "388",
          height: "0",
          showArrow: false,
          arrow: { class: "arrow right", top: "0", left: "0" },
          contect: "蒸汽總管線連接各設備",
        },
        {
          show: true,
          class: "line_h",
          top: "20.5",
          left: "10.5",
          width: "0",
          height: "25",
          showArrow: false,
          arrow: { class: "arrow down", top: "8", left: "-6" },
          contect: "蒸汽總管線 => 蒸煮室",
        },
        {
          show: true,
          class: "line_h",
          top: "20.5",
          left: "30",
          width: "0",
          height: "25",
          showArrow: false,
          arrow: { class: "arrow down", top: "8", left: "-6" },
          contect: "蒸汽總管線 => 罐頭加工室",
        },
        {
          show: true,
          class: "line_h",
          top: "20.5",
          left: "50",
          width: "0",
          height: "25",
          showArrow: false,
          arrow: { class: "arrow down", top: "8", left: "-6" },
          contect: "蒸汽總管線 => 肉品烘烤室",
        },
        {
          show: true,
          class: "line_h",
          top: "20.5",
          left: "69.5",
          width: "0",
          height: "25",
          showArrow: false,
          arrow: { class: "arrow down", top: "8", left: "-6" },
          contect: "蒸汽總管線 => 燒臘區",
        },
        {
          show: true,
          class: "line_h",
          top: "58",
          left: "69.5",
          width: "0",
          height: "25",
          showArrow: false,
          arrow: { class: "arrow down", top: "8", left: "-6" },
          contect: "蒸汽總管線 => 熟食包裝室",
        },
        {
          show: true,
          class: "line_h",
          top: "58",
          left: "89.5",
          width: "0",
          height: "25",
          showArrow: false,
          arrow: { class: "arrow down", top: "8", left: "-6" },
          contect: "蒸汽總管線 => 糕餅調理室",
        },
        /*----------------------------------------------------------------------------------------------------------------------------------------------------------------*/
        {
          show: true,
          class: "line_h",
          top: "34",
          left: "69.5",
          width: "0",
          height: "40",
          showArrow: false,
          arrow: { class: "arrow down", top: "24", left: "-6" },
          contect: "熟食包裝室 => 殺菌槽",
        },
        {
          show: true,
          class: "line_h",
          top: "34",
          left: "89.5",
          width: "0",
          height: "40",
          showArrow: false,
          arrow: { class: "arrow down", top: "24", left: "-6" },
          contect: "燒臘區蒸汽總管線 => 蒸煮鍋",
        },
        {
          show: true,
          class: "line_h",
          top: "71.5",
          left: "69.5",
          width: "0",
          height: "40",
          showArrow: false,
          arrow: { class: "arrow down", top: "24", left: "-6" },
          contect: "熟食包裝室 => 殺菌槽",
        },
        {
          show: true,
          class: "line_h",
          top: "71.5",
          left: "89.5",
          width: "0",
          height: "40",
          showArrow: false,
          arrow: { class: "arrow down", top: "24", left: "-6" },
          contect: "糕餅調理室 => 炒焰鍋",
        },
        /*----------------------------------------------------------------------------------------------------------------------------------------------------------------*/
        {
          show: true,
          class: "line_w",
          top: "30",
          left: "18",
          width: "40",
          height: "0",
          showArrow: false,
          arrow: { class: "arrow down", top: "0", left: "0" },
          contect: "蒸煮室 => 蒸煮室各設備",
        },
        {
          show: true,
          class: "line_h",
          top: "30",
          left: "20",
          width: "0",
          height: "559",
          showArrow: false,
          arrow: { class: "arrow down", top: "0", left: "0" },
          contect: "蒸煮室 => 蒸煮室各設備",
        },
        {
          show: true,
          class: "line_w",
          top: "44",
          left: "18",
          width: "40",
          height: "0",
          showArrow: false,
          arrow: { class: "arrow left", top: "-6", left: "5" },
          contect: "蒸煮室 => 罐頭煮釜",
        },
        {
          show: true,
          class: "line_w",
          top: "55.5",
          left: "18",
          width: "40",
          height: "0",
          showArrow: false,
          arrow: { class: "arrow left", top: "-6", left: "5" },
          contect: "蒸煮室 => 二重鍋",
        },
        {
          show: true,
          class: "line_w",
          top: "67",
          left: "18",
          width: "40",
          height: "0",
          showArrow: false,
          arrow: { class: "arrow left", top: "-6", left: "5" },
          contect: "蒸煮室 => 四方煮鍋",
        },
        {
          show: true,
          class: "line_w",
          top: "78.5",
          left: "18",
          width: "40",
          height: "0",
          showArrow: false,
          arrow: { class: "arrow left", top: "-6", left: "5" },
          contect: "蒸煮室 => 肉鬆炒鍋",
        },
        /*----------------------------------------------------------------------------------------------------------------------------------------------------------------*/
        {
          show: true,
          class: "line_w",
          top: "30",
          left: "38",
          width: "40",
          height: "0",
          showArrow: false,
          arrow: { class: "arrow down", top: "0", left: "0" },
          contect: "罐頭加工室 => 罐頭加工室各設備",
        },
        {
          show: true,
          class: "line_h",
          top: "30",
          left: "40",
          width: "0",
          height: "691",
          showArrow: false,
          arrow: { class: "arrow down", top: "0", left: "0" },
          contect: "罐頭加工室 => 罐頭加工室各設備",
        },
        {
          show: true,
          class: "line_w",
          top: "44",
          left: "38",
          width: "40",
          height: "0",
          showArrow: false,
          arrow: { class: "arrow left", top: "-6", left: "5" },
          contect: "罐頭加工室 => 遠紅外線",
        },
        {
          show: true,
          class: "line_w",
          top: "55.5",
          left: "38",
          width: "40",
          height: "0",
          showArrow: false,
          arrow: { class: "arrow left", top: "-6", left: "5" },
          contect: "罐頭加工室 => 殺菌釜NO.1",
        },
        {
          show: true,
          class: "line_w",
          top: "67",
          left: "38",
          width: "40",
          height: "0",
          showArrow: false,
          arrow: { class: "arrow left", top: "-6", left: "5" },
          contect: "罐頭加工室 => 殺菌釜NO.2",
        },
        {
          show: true,
          class: "line_w",
          top: "78.5",
          left: "38",
          width: "40",
          height: "0",
          showArrow: false,
          arrow: { class: "arrow left", top: "-6", left: "5" },
          contect: "罐頭加工室 => 殺菌釜NO.3",
        },
        {
          show: true,
          class: "line_w",
          top: "90",
          left: "38",
          width: "40",
          height: "0",
          showArrow: false,
          arrow: { class: "arrow left", top: "-6", left: "5" },
          contect: "罐頭加工室 => 殺菌釜NO.4",
        },
        /*----------------------------------------------------------------------------------------------------------------------------------------------------------------*/
        {
          show: true,
          class: "line_w",
          top: "30",
          left: "58",
          width: "40",
          height: "0",
          showArrow: false,
          arrow: { class: "arrow down", top: "0", left: "0" },
          contect: "肉品烘烤室 => 肉品烘烤室各設備",
        },
        {
          show: true,
          class: "line_h",
          top: "30",
          left: "60",
          width: "0",
          height: "691",
          showArrow: false,
          arrow: { class: "arrow down", top: "0", left: "0" },
          contect: "肉品烘烤室 => 肉品烘烤室各設備",
        },
        {
          show: true,
          class: "line_w",
          top: "44",
          left: "58",
          width: "40",
          height: "0",
          showArrow: false,
          arrow: { class: "arrow left", top: "-6", left: "5" },
          contect: "肉品烘烤室 => Vemag隧道煙燻爐",
        },
        {
          show: true,
          class: "line_w",
          top: "55.5",
          left: "58",
          width: "40",
          height: "0",
          showArrow: false,
          arrow: { class: "arrow left", top: "-6", left: "5" },
          contect: "肉品烘烤室 => Fessmann多功能爐",
        },
        {
          show: true,
          class: "line_w",
          top: "67",
          left: "58",
          width: "40",
          height: "0",
          showArrow: false,
          arrow: { class: "arrow left", top: "-6", left: "5" },
          contect: "肉品烘烤室 => Fessmann多功能爐",
        },
        {
          show: true,
          class: "line_w",
          top: "78.5",
          left: "58",
          width: "40",
          height: "0",
          showArrow: false,
          arrow: { class: "arrow left", top: "-6", left: "5" },
          contect: "肉品烘烤室 => 宣柏蒸煮爐",
        },
        {
          show: true,
          class: "line_w",
          top: "90",
          left: "58",
          width: "40",
          height: "0",
          showArrow: false,
          arrow: { class: "arrow left", top: "-6", left: "5" },
          contect: "肉品烘烤室 => KOCH乾燥爐",
        },
      ],
    };
  },

  computed: {},
  watch: {},

  mounted() {
    this.$set(this.WebSetup, "caption", "蒸汽系統");
    this.MenuSetup.opened = false;
    this.VarMenuIsOverlay = false;
    this.loadPageData();
    this.sysNowTime();
  },
  methods: {
    //  刷新頁面
    sysNowTime () {
      let that = this;
      setInterval(function () {
        that.loadPageData();
      }, 60000);
    },
    loadPageData() {
      _.each(this.billboard, (item, key) => {
        _.each(item['data'], (data, data_key) => {
          data['DBvalue'] = 0
        })
      })
      var params = {
        Action: "LoadPageData",
        Datas: {},
      };

      this.FnWebAPIGet(params)
        .then((res) => {
          var resData = res.data.data;
          var groupByIdData = _.groupBy(resData, 'ID')
          _.each(this.billboard, (item, key) => {
            if (!_.isNil(groupByIdData[key])) {
              _.each(item['data'], (data , data_key) => {
                if (data_key == "item01" && data['isDBValue'] ) {
                  data['DBvalue'] = this.FnRoundToDecimal(!_.isNil(groupByIdData[key][0]['MAX_Flow']) ? groupByIdData[key][0]['MAX_Flow'] : 0, 2) 
                }
                if (data_key == "item02" && data['isDBValue'] ) {
                  data['DBvalue'] = this.FnRoundToDecimal(!_.isNil(groupByIdData[key][0]['today_Acc']) ? groupByIdData[key][0]['today_Acc'] : 0, 2) 
                }
              })
            }
            else {
              //  客制內容
              _.each(item['data'], (data , data_key) => {
                //  蒸煮室
                if ( key == "item03" && data['isDBValue'] ) {
                  _.each(this.treeMap('蒸汽', '蒸煮室') , (id) => {
                    if (data_key == "item01" && data['isDBValue'] && !_.isNil(groupByIdData[id['value']]) ) {
                      data['DBvalue'] += this.FnRoundToDecimal(!_.isNil(groupByIdData[id['value']][0]['MAX_Flow']) ? groupByIdData[id['value']][0]['MAX_Flow'] : 0 , 2) 
                    }
                    if (data_key == "item02" && data['isDBValue'] && !_.isNil(groupByIdData[id['value']]) ) {
                      data['DBvalue'] += this.FnRoundToDecimal(!_.isNil(groupByIdData[id['value']][0]['today_Acc']) ? groupByIdData[id['value']][0]['today_Acc'] : 0 , 2) 
                    } 
                  }) 
                }
                //  罐頭加工室
                if ( key == "item08" && data['isDBValue'] ) {
                  _.each(this.treeMap('蒸汽', '罐頭加工室') , (id) => {
                    if (data_key == "item01" && data['isDBValue'] && !_.isNil(groupByIdData[id['value']]) ) {
                      data['DBvalue'] += this.FnRoundToDecimal(!_.isNil(groupByIdData[id['value']][0]['MAX_Flow']) ? groupByIdData[id['value']][0]['MAX_Flow'] : 0 , 2) 
                    }
                    if (data_key == "item02" && data['isDBValue'] && !_.isNil(groupByIdData[id['value']]) ) {
                      data['DBvalue'] += this.FnRoundToDecimal(!_.isNil(groupByIdData[id['value']][0]['today_Acc']) ? groupByIdData[id['value']][0]['today_Acc'] : 0 , 2) 
                    } 
                  }) 
                }
                //  肉品烘烤室
                if ( key == "item14" && data['isDBValue'] ) {
                  _.each(this.treeMap('蒸汽', '肉品烘烤室') , (id) => {
                    if (data_key == "item01" && data['isDBValue'] && !_.isNil(groupByIdData[id['value']]) ) {
                      data['DBvalue'] += this.FnRoundToDecimal(!_.isNil(groupByIdData[id['value']][0]['MAX_Flow']) ? groupByIdData[id['value']][0]['MAX_Flow'] : 0 , 2) 
                    }
                    if (data_key == "item02" && data['isDBValue'] && !_.isNil(groupByIdData[id['value']]) ) {
                      data['DBvalue'] += this.FnRoundToDecimal(!_.isNil(groupByIdData[id['value']][0]['today_Acc']) ? groupByIdData[id['value']][0]['today_Acc'] : 0 , 2) 
                    } 
                  }) 
                }
                //  燒臘區
                if ( key == "item20" && data['isDBValue'] ) {
                  _.each(this.treeMap('蒸汽', '燒臘區蒸汽總管線') , (id) => {
                    if (data_key == "item01" && data['isDBValue'] && !_.isNil(groupByIdData[id['value']]) ) {
                      data['DBvalue'] += this.FnRoundToDecimal(!_.isNil(groupByIdData[id['value']][0]['MAX_Flow']) ? groupByIdData[id['value']][0]['MAX_Flow'] : 0 , 2)
                    }
                    if (data_key == "item02" && data['isDBValue'] && !_.isNil(groupByIdData[id['value']]) ) {
                      data['DBvalue'] += this.FnRoundToDecimal(!_.isNil(groupByIdData[id['value']][0]['today_Acc']) ? groupByIdData[id['value']][0]['today_Acc'] : 0 , 2)  
                    } 
                  }) 
                }
                // 熟食包裝室
                if ( key == "item24" && data['isDBValue'] ) {
                  _.each(this.treeMap('蒸汽', '熟食包裝室') , (id) => {
                    if (data_key == "item01" && data['isDBValue'] && !_.isNil(groupByIdData[id['value']]) ) {
                      data['DBvalue'] += this.FnRoundToDecimal(groupByIdData[id['value']][0]['MAX_Flow'] , 2)
                    }
                    if (data_key == "item02" && data['isDBValue'] && !_.isNil(groupByIdData[id['value']]) ) {
                      data['DBvalue'] += this.FnRoundToDecimal(!_.isNil(groupByIdData[id['value']][0]['today_Acc']) ? groupByIdData[id['value']][0]['today_Acc'] : 0 , 2) 
                    } 
                  }) 
                }
                // 屋頂
                if ( key == "item22" && data['isDBValue'] ) {
                  _.each(this.treeMap('蒸汽', '屋頂') , (id) => {
                    if (data_key == "item01" && data['isDBValue'] && !_.isNil(groupByIdData[id['value']]) ) {
                      data['DBvalue'] += this.FnRoundToDecimal(!_.isNil(groupByIdData[id['value']][0]['MAX_Flow']) ? groupByIdData[id['value']][0]['MAX_Flow'] : 0 , 2)
                    }
                    if (data_key == "item02" && data['isDBValue'] && !_.isNil(groupByIdData[id['value']]) ) {
                      data['DBvalue'] += this.FnRoundToDecimal(!_.isNil(groupByIdData[id['value']][0]['today_Acc']) ? groupByIdData[id['value']][0]['today_Acc'] : 0 , 2) 
                    } 
                  }) 
                }
                // 糕餅調理室
                if ( key == "item26" && data['isDBValue'] ) {
                  _.each(this.treeMap('蒸汽', '糕餅調理室') , (id) => {
                    if (data_key == "item01" && data['isDBValue'] && !_.isNil(groupByIdData[id['value']]) ) {
                      data['DBvalue'] += this.FnRoundToDecimal(!_.isNil(groupByIdData[id['value']][0]['MAX_Flow']) ? groupByIdData[id['value']][0]['MAX_Flow'] : 0 , 2)
                    }
                    if (data_key == "item02" && data['isDBValue'] && !_.isNil(groupByIdData[id['value']]) ) {
                      data['DBvalue'] += this.FnRoundToDecimal(!_.isNil(groupByIdData[id['value']][0]['today_Acc']) ? groupByIdData[id['value']][0]['today_Acc'] : 0 , 2) 
                    } 
                  }) 
                }
              })
            }
          })
          //  例外客制內容
          //  加總
         
          
          //  數據格式化
          _.each(this.billboard , (detail) => {
            _.each(detail['data'] , (item)=> {
              item['DBvalue'] = this.FnFormatNumber(item['DBvalue'], 1 )
            })
          })
        })
        .catch((err) => {
          console.log(err);
        });
    },

    //  樹狀爸爸
    treeMap (item_type, keyWord) {
      return _.map(device_item[item_type][keyWord]['options'] , (item ) => {
        return {  "value" : item['value'] } 
      })
    }

  },
};
