var page_function = {
  components: {},
  data() {
    return {
      VarMenuPage: "system_water",
      VarMenu: "area",
      VarPageContainerCss: "padding:0px",

      billboard: {
        "5": {
          show: true,
          title: "自來水總表",
         title_style: "background: linear-gradient(to right, #246ab5 5% , #1565c0 50% , #115eaa 95%);",  //  標體底色
          caption: "ID = 5",
          showButton: true,
          button: {
            item01: {
              show: true,
              label: "長條圖",
              icon: "leaderboard",
              linkto: "chart_bar.php",
              params: { options: "自來水總表" , item_type: "水"},
            },
            item02: {
              show: true,
              label: "圓餅圖",
              icon: "pie_chart",
              linkto: "chart_pie.php",
              params: { options: "自來水總表" , item_type: "水"},
            },
          },
          data: {
            item01: {
              show: true,
              label: "即時值",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "m³/hr",
              icon: "water_drop",
            },
            item02: {
              show: true,
              label: "日用量",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "m³/hr",
              icon: "water_drop",
            },
          },
          top: "7.5",
          left: "15.5",
          width: "340",
        },
        "item02": {
          show: true,
          title: "淨水房35噸儲水槽",
         title_style: "background: linear-gradient(to right, #246ab5 5% , #1565c0 50% , #115eaa 95%);",  //  標體底色
          caption: "",
          showButton: true,
          button: {
            item01: {
              show: true,
              label: "長條圖",
              icon: "leaderboard",
              linkto: "chart_bar.php",
              params: { options: "淨水房35噸儲水槽", item_type: "水"},
            },
            item02: {
              show: false,
              label: "圓餅圖",
              icon: "pie_chart",
              linkto: "chart_pie.php",
              params: { options: "淨水房35噸儲水槽", item_type: "水"},
            },
          },
          data: {
            item01: {
              show: true,
              label: "即時值",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "m³/hr",
              icon: "water_drop",
            },
            item02: {
              show: true,
              label: "日用量",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "m³/hr",
              icon: "water_drop",
            },
          },
          top: "22.5",
          left: "2.5",
          width: "340",
        },
        "7": {
          show: true,
          title: "宿舍",
         title_style: "background: linear-gradient(to right, #246ab5 5% , #1565c0 50% , #115eaa 95%);",  //  標體底色
          caption: "ID = 7",
          showButton: true,
          button: {
            item01: {
              show: true,
              label: "長條圖",
              icon: "leaderboard",
              linkto: "chart_bar.php",
              params: { options: "宿舍" , item_type: "水"},
            },
            item02: {
              show: false,
              label: "圓餅圖",
              icon: "pie_chart",
              linkto: "chart_pie.php",
              params: { options: "宿舍", item_type: "水"},
            },
          },
          data: {
            item01: {
              show: true,
              label: "即時值",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "m³/hr",
              icon: "water_drop",
            },
            item02: {
              show: true,
              label: "日用量",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "m³/hr",
              icon: "water_drop",
            },
          },
          top: "37.5",
          left: "2.5",
          width: "340",
        },
        "item04": {
          show: true,
          title: "地上300噸儲水槽",
         title_style: "background: linear-gradient(to right, #246ab5 5% , #1565c0 50% , #115eaa 95%);",  //  標體底色
          caption: "",
          showButton: true,
          button: {
            item01: {
              show: true,
              label: "長條圖",
              icon: "leaderboard",
              linkto: "chart_bar.php",
              params: { options: "地上300噸儲水槽" , item_type: "水"},
            },
            item02: {
              show: false,
              label: "圓餅圖",
              icon: "pie_chart",
              linkto: "chart_pie.php",
              params: { options: "地上300噸儲水槽", item_type: "水"},
            },
          },
          data: {
            item01: {
              show: true,
              label: "即時值",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "m³/hr",
              icon: "water_drop",
            },
            item02: {
              show: true,
              label: "日用量",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "m³/hr",
              icon: "water_drop",
            },
          },
          top: "22.5",
          left: "28.5",
          width: "340",
        },
        "6": {
          show: true,
          title: "地下100噸儲水槽",
         title_style: "background: linear-gradient(to right, #246ab5 5% , #1565c0 50% , #115eaa 95%);",  //  標體底色
          caption: "ID = 6",
          showButton: true,
          button: {
            item01: {
              show: true,
              label: "長條圖",
              icon: "leaderboard",
              linkto: "chart_bar.php",
              params: { options: "地下100噸儲水槽" , item_type: "水"},
            },
            item02: {
              show: true,
              label: "圓餅圖",
              icon: "pie_chart",
              linkto: "chart_pie.php",
              params: { options: "地下100噸儲水槽" , item_type: "水"},
            },
          },
          data: {
            item01: {
              show: true,
              label: "即時值",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "m³/hr",
              icon: "water_drop",
            },
            item02: {
              show: true,
              label: "日用量",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "m³/hr",
              icon: "water_drop",
            },
          },
          top: "37.5",
          left: "28.5",
          width: "340",
        },
        "10": {
          show: true,
          title: "生飲水處理",
         title_style: "background: linear-gradient(to right, #246ab5 5% , #1565c0 50% , #115eaa 95%);",  //  標體底色
          caption: "ID = 10",
          showButton: true,
          button: {
            item01: {
              show: true,
              label: "長條圖",
              icon: "leaderboard",
              linkto: "chart_bar.php",
              params: { options: "生飲水處理" , item_type: "水"},
            },
            item02: {
              show: false,
              label: "圓餅圖",
              icon: "pie_chart",
              linkto: "chart_pie.php",
              params: { options: "生飲水處理", item_type: "水" },
            },
          },
          data: {
            item01: {
              show: true,
              label: "即時值",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "m³/hr",
              icon: "water_drop",
            },
            item02: {
              show: true,
              label: "日用量",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "m³/hr",
              icon: "water_drop",
            },
          },
          top: "52.5",
          left: "2.5",
          width: "340",
        },
        "11": {
          show: true,
          title: "頂樓10噸生飲水",
         title_style: "background: linear-gradient(to right, #246ab5 5% , #1565c0 50% , #115eaa 95%);",  //  標體底色
          caption: "ID = 11",
          showButton: true,
          button: {
            item01: {
              show: true,
              label: "長條圖",
              icon: "leaderboard",
              linkto: "chart_bar.php",
              params: { options: "頂樓10噸生飲水", item_type: "水" },
            },
            item02: {
              show: false,
              label: "圓餅圖",
              icon: "pie_chart",
              linkto: "chart_pie.php",
              params: { options: "頂樓10噸生飲水", item_type: "水" },
            },
          },
          data: {
            item01: {
              show: true,
              label: "即時值",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "m³/hr",
              icon: "water_drop",
            },
            item02: {
              show: true,
              label: "日用量",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "m³/hr",
              icon: "water_drop",
            },
          },
          top: "65.8",
          left: "2.5",
          width: "340",
        },
        "3": {
          show: true,
          title: "屋頂燒臘生飲水",
         title_style: "background: linear-gradient(to right, #246ab5 5% , #1565c0 50% , #115eaa 95%);",  //  標體底色
          caption: "ID = 3",
          showButton: true,
          button: {
            item01: {
              show: true,
              label: "長條圖",
              icon: "leaderboard",
              linkto: "chart_bar.php",
              params: { options: "屋頂燒臘生飲水" , item_type: "水"},
            },
            item02: {
              show: false,
              label: "圓餅圖",
              icon: "pie_chart",
              linkto: "chart_pie.php",
              params: { options: "屋頂燒臘生飲水" , item_type: "水"},
            },
          },
          data: {
            item01: {
              show: true,
              label: "即時值",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "m³/hr",
              icon: "water_drop",
            },
            item02: {
              show: true,
              label: "日用量",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "m³/hr",
              icon: "water_drop",
            },
          },
          top: "79",
          left: "2.5",
          width: "340",
        },
        "12": {
          show: true,
          title: "消防水",
         title_style: "background: linear-gradient(to right, #246ab5 5% , #1565c0 50% , #115eaa 95%);",  //  標體底色
          caption: "ID = 12",
          showButton: true,
          button: {
            item01: {
              show: true,
              label: "長條圖",
              icon: "leaderboard",
              linkto: "chart_bar.php",
              params: { options: "消防水", item_type: "水" },
            },
            item02: {
              show: false,
              label: "圓餅圖",
              icon: "pie_chart",
              linkto: "chart_pie.php",
              params: { options: "消防水" , item_type: "水"},
            },
          },
          data: {
            item01: {
              show: true,
              label: "即時值",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "m³/hr",
              icon: "water_drop",
            },
            item02: {
              show: true,
              label: "日用量",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "m³/hr",
              icon: "water_drop",
            },
          },
          top: "52.5",
          left: "22.5",
          width: "340",
        },
        "4": {
          show: true,
          title: "屋頂10噸儲水槽",
         title_style: "background: linear-gradient(to right, #246ab5 5% , #1565c0 50% , #115eaa 95%);",  //  標體底色
          caption: "ID = 4",
          showButton: true,
          button: {
            item01: {
              show: true,
              label: "長條圖",
              icon: "leaderboard",
              linkto: "chart_bar.php",
              params: { options: "屋頂10噸儲水槽", item_type: "水" },
            },
            item02: {
              show: true,
              label: "圓餅圖",
              icon: "pie_chart",
              linkto: "chart_pie.php",
              params: { options: "屋頂10噸儲水槽", item_type: "水" },
            },
          },
          data: {
            item01: {
              show: true,
              label: "即時值",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "m³/hr",
              icon: "water_drop",
            },
            item02: {
              show: true,
              label: "日用量",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "m³/hr",
              icon: "water_drop",
            },
          },
          top: "52.5",
          left: "42.5",
          width: "340",
        },
        "1": {
          show: true,
          title: "屋頂熱水出水",
         title_style: "background: linear-gradient(to right, #246ab5 5% , #1565c0 50% , #115eaa 95%);",  //  標體底色
          caption: "ID = 1",
          showButton: true,
          button: {
            item01: {
              show: true,
              label: "長條圖",
              icon: "leaderboard",
              linkto: "chart_bar.php",
              params: { options: "屋頂熱水出水", item_type: "水" },
            },
            item02: {
              show: false,
              label: "圓餅圖",
              icon: "pie_chart",
              linkto: "chart_pie.php",
              params: { options: "屋頂熱水出水", item_type: "水" },
            },
          },
          data: {
            item01: {
              show: true,
              label: "即時值",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "m³/hr",
              icon: "water_drop",
            },
            item02: {
              show: true,
              label: "日用量",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "m³/hr",
              icon: "water_drop",
            },
          },
          top: "65.8",
          left: "28.5",
          width: "340",
        },
        "2": {
          show: true,
          title: "屋頂蒸汽冷凝水回收",
         title_style: "background: linear-gradient(to right, #246ab5 5% , #1565c0 50% , #115eaa 95%);",  //  標體底色
          caption: "ID = 2",
          showButton: true,
          button: {
            item01: {
              show: true,
              label: "長條圖",
              icon: "leaderboard",
              linkto: "chart_bar.php",
              params: { options: "屋頂蒸汽冷凝水回收", item_type: "水" },
            },
            item02: {
              show: false,
              label: "圓餅圖",
              icon: "pie_chart",
              linkto: "chart_pie.php",
              params: { options: "屋頂蒸汽冷凝水回收", item_type: "水"},
            },
          },
          data: {
            item01: {
              show: true,
              label: "即時值",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "m³/hr",
              icon: "water_drop",
            },
            item02: {
              show: true,
              label: "日用量",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "m³/hr",
              icon: "water_drop",
            },
          },
          top: "79",
          left: "28.5",
          width: "340",
        },
        "16": {
          show: true,
          title: "殺菌釜進水",
         title_style: "background: linear-gradient(to right, #246ab5 5% , #1565c0 50% , #115eaa 95%);",  //  標體底色
          caption: "ID = 16",
          showButton: true,
          button: {
            item01: {
              show: true,
              label: "長條圖",
              icon: "leaderboard",
              linkto: "chart_bar.php",
              params: { options: "殺菌釜進水", item_type: "水" },
            },
            item02: {
              show: false,
              label: "圓餅圖",
              icon: "pie_chart",
              linkto: "chart_pie.php",
              params: { options: "殺菌釜進水", item_type: "水" },
            },
          },
          data: {
            item01: {
              show: true,
              label: "即時值",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "m³/hr",
              icon: "water_drop",
            },
            item02: {
              show: true,
              label: "日用量",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "m³/hr",
              icon: "water_drop",
            },
          },
          top: "65.8",
          left: "52.9",
          width: "340",
        },
        "17": {
          show: true,
          title: "殺菌釜回收水",
         title_style: "background: linear-gradient(to right, #246ab5 5% , #1565c0 50% , #115eaa 95%);",  //  標體底色
          caption: "ID = 17",
          showButton: true,
          button: {
            item01: {
              show: true,
              label: "長條圖",
              icon: "leaderboard",
              linkto: "chart_bar.php",
              params: { options: "殺菌釜回收水", item_type: "水" },
            },
            item02: {
              show: false,
              label: "圓餅圖",
              icon: "pie_chart",
              linkto: "chart_pie.php",
              params: { options: "殺菌釜回收水" , item_type: "水"},
            },
          },
          data: {
            item01: {
              show: true,
              label: "即時值",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "m³/hr",
              icon: "water_drop",
            },
            item02: {
              show: true,
              label: "日用量",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "m³/hr",
              icon: "water_drop",
            },
          },
          top: "79",
          left: "52.9",
          width: "340",
        },
        "item15": {
          show: true,
          title: "廢水處理",
         title_style: "background: linear-gradient(to right, #246ab5 5% , #1565c0 50% , #115eaa 95%);",  //  標體底色
          caption: "",
          showButton: true,
          button: {
            item01: {
              show: true,
              label: "長條圖",
              icon: "leaderboard",
              linkto: "chart_bar.php",
              params: { options: "廢水處理" , item_type: "水"},
            },
            item02: {
              show: true,
              label: "圓餅圖",
              icon: "pie_chart",
              linkto: "chart_pie.php",
              params: { options: "廢水處理" , item_type: "水"},
            },
          },
          data: {
            item01: {
              show: true,
              label: "即時值",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "m³/hr",
              icon: "water_drop",
            },
            item02: {
              show: true,
              label: "日用量",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "m³/hr",
              icon: "water_drop",
            },
          },
          top: "7.5",
          left: "65",
          width: "340",
        },
        "14": {
          show: true,
          title: "廢水排放水",
         title_style: "background: linear-gradient(to right, #246ab5 5% , #1565c0 50% , #115eaa 95%);",  //  標體底色
          caption: "ID = 14",
          showButton: true,
          button: {
            item01: {
              show: true,
              label: "長條圖",
              icon: "leaderboard",
              linkto: "chart_bar.php",
              params: { options: "廢水排放水" , item_type: "水"},
            },
            item02: {
              show: false,
              label: "圓餅圖",
              icon: "pie_chart",
              linkto: "chart_pie.php",
              params: { options: "廢水排放水" , item_type: "水"},
            },
          },
          data: {
            item01: {
              show: true,
              label: "即時值",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "m³/hr",
              icon: "water_drop",
            },
            item02: {
              show: true,
              label: "日用量",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "m³/hr",
              icon: "water_drop",
            },
          },
          top: "22.5",
          left: "52.9",
          width: "340",
        },
        "13": {
          show: true,
          title: "筏基回收水",
         title_style: "background: linear-gradient(to right, #246ab5 5% , #1565c0 50% , #115eaa 95%);",  //  標體底色
          caption: "ID = 13",
          showButton: true,
          button: {
            item01: {
              show: true,
              label: "長條圖",
              icon: "leaderboard",
              linkto: "chart_bar.php",
              params: { options: "筏基回收水", item_type: "水" },
            },
            item02: {
              show: false,
              label: "圓餅圖",
              icon: "pie_chart",
              linkto: "chart_pie.php",
              params: { options: "筏基回收水", item_type: "水" },
            },
          },
          data: {
            item01: {
              show: true,
              label: "即時值",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "m³/hr",
              icon: "water_drop",
            },
            item02: {
              show: true,
              label: "日用量",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "m³/hr",
              icon: "water_drop",
            },
          },
          top: "22.5",
          left: "77.5",
          width: "340",
        },
        "item18": {
          show: true,
          title: "地上50噸X2回收水儲水槽",
         title_style: "background: linear-gradient(to right, #246ab5 5% , #1565c0 50% , #115eaa 95%);",  //  標體底色
          caption: "",
          showButton: true,
          button: {
            item01: {
              show: true,
              label: "長條圖",
              icon: "leaderboard",
              linkto: "chart_bar.php",
              params: { options: "地上50噸X2回收水儲水槽" , item_type: "水"},
            },
            item02: {
              show: true,
              label: "圓餅圖",
              icon: "pie_chart",
              linkto: "chart_pie.php",
              params: { options: "地上50噸X2回收水儲水槽" , item_type: "水"},
            },
          },
          data: {
            item01: {
              show: true,
              label: "即時值",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "m³/hr",
              icon: "water_drop",
            },
            item02: {
              show: true,
              label: "日用量",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "m³/hr",
              icon: "water_drop",
            },
          },
          top: "37.5",
          left: "71",
          width: "320",
        },
        "item19": {
          show: true,
          title: "馬桶沖廁",
         title_style: "background: linear-gradient(to right, #246ab5 5% , #1565c0 50% , #115eaa 95%);",  //  標體底色
          caption: "",
          showButton: true,
          button: {
            item01: {
              show: true,
              label: "長條圖",
              icon: "leaderboard",
              linkto: "chart_bar.php",
              params: { options: "馬桶沖廁", item_type: "水" },
            },
            item02: {
              show: false,
              label: "圓餅圖",
              icon: "pie_chart",
              linkto: "chart_pie.php",
              params: { options: "馬桶沖廁", item_type: "水" },
            },
          },
          data: {
            item01: {
              show: true,
              label: "即時值",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "m³/hr",
              icon: "water_drop",
            },
            item02: {
              show: true,
              label: "日用量",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "m³/hr",
              icon: "water_drop",
            },
          },
          top: "52.5",
          left: "62",
          width: "340",
        },
        "8": {
          show: true,
          title: "軟水處理",
         title_style: "background: linear-gradient(to right, #246ab5 5% , #1565c0 50% , #115eaa 95%);",  //  標體底色
          caption: "ID = 8",
          showButton: true,
          button: {
            item01: {
              show: true,
              label: "長條圖",
              icon: "leaderboard",
              linkto: "chart_bar.php",
              params: { options: "軟水處理", item_type: "水" },
            },
            item02: {
              show: false,
              label: "圓餅圖",
              icon: "pie_chart",
              linkto: "chart_pie.php",
              params: { options: "軟水處理", item_type: "水" },
            },
          },
          data: {
            item01: {
              show: true,
              label: "即時值",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "m³/hr",
              icon: "water_drop",
            },
            item02: {
              show: true,
              label: "日用量",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "m³/hr",
              icon: "water_drop",
            },
          },
          top: "52.5",
          left: "81.5",
          width: "340",
        },
      },

      //	線條 => 定義 class 如果是line_h要設定height的長度(px)，width設為0，反之是line_w要設定width的長度(px)，height設為0
      line: [
        {
          show: true,
          class: "line_h",
          top: "19",
          left: "23.25",
          width: "0",
          height: "110",
          showArrow: false,
          arrow: { class: "arrow", top: "0", left: "0" },
          contect: "自來水總表到各系統",
        },
        {
          show: true,
          class: "line_w",
          top: "28.5",
          left: "17.5",
          width: "220",
          height: "0",
          showArrow: false,
          arrow: { class: "arrow", top: "0", left: "0" },
          contect: "自來水總表到各系統",
        },
        {
          show: true,
          class: "line_h",
          top: "34",
          left: "10.5",
          width: "0",
          height: "40",
          showArrow: false,
          arrow: { class: "arrow down", top: "0", left: "0"  },
          contect: "淨水房35噸儲水槽到宿舍",
        },
        {
          show: true,
          class: "line_h",
          top: "34",
          left: "36.5",
          width: "0",
          height: "40",
          showArrow: false,
          arrow: { class: "arrow down", top: "0", left: "0"  },
          contect: "地上300噸儲水槽到地下100噸儲水槽",
        },
        {
          show: true,
          class: "line_h",
          top: "48",
          left: "36.5",
          width: "0",
          height: "30",
          showArrow: false,
          arrow: { class: "arrow down", top: "25", left: "-6" },
          contect: "地下100噸儲水槽到各設備",
        },
        {
          show: true,
          class: "line_w",
          top: "50.5",
          left: "10.5",
          width: "772",
          height: "0",
          showArrow: false,
          arrow: { class: "arrow", top: "0", left: "0" },
          contect: "地下100噸儲水槽到各系統",
        },
        {
          show: true,
          class: "line_h",
          top: "50.5",
          left: "10.5",
          width: "0",
          height: "40",
          showArrow: false,
          arrow: { class: "arrow down", top: "25", left: "-6" },
          contect: "地下100噸儲水槽到生飲水處理",
        },
        {
          show: true,
          class: "line_h",
          top: "50.5",
          left: "30.5",
          width: "0",
          height: "40",
          showArrow: false,
          arrow: { class: "arrow down", top: "25", left: "-6" },
          contect: "地下100噸儲水槽到消防水",
        },
        {
          show: true,
          class: "line_h",
          top: "50.5",
          left: "50.5",
          width: "0",
          height: "40",
          showArrow: false,
          arrow: { class: "arrow down", top: "25", left: "-6" },
          contect: "地下100噸儲水槽到屋頂10噸儲水槽",
        },
        /*----------------------------------------------------------------------------------------------------------------------------------------------------------------*/
        {
          show: true,
          class: "line_w",
          top: "60.5",
          left: "1",
          width: "30",
          height: "0",
          showArrow: false,
          arrow: { class: "arrow", top: "0", left: "0" },
          contect: "生飲水處理到各設備",
        },
        {
          show: true,
          class: "line_h",
          top: "60.5",
          left: "1",
          width: "0",
          height: "105",
          showArrow: false,
          arrow: { class: "arrow down", top: "0", left: "0"  },
          contect: "生飲水處理到各設備",
        },
        {
          show: true,
          class: "line_w",
          top: "69.5",
          left: "1",
          width: "30",
          height: "0",
          showArrow: false,
          arrow: { class: "arrow", top: "0", left: "0" },
          contect: "生飲水處理到頂樓10噸生飲水",
        },
        {
          show: true,
          class: "line_w",
          top: "75.5",
          left: "1",
          width: "30",
          height: "0",
          showArrow: false,
          arrow: { class: "arrow", top: "0", left: "0" },
          contect: "生飲水處理到頂樓10噸生飲水",
        },
        {
          show: true,
          class: "line_h",
          top: "75.5",
          left: "1",
          width: "0",
          height: "105",
          showArrow: false,
          arrow: { class: "arrow down", top: "0", left: "0"  },
          contect: "生飲水處理到頂樓10噸生飲水",
        },
        {
          show: true,
          class: "line_w",
          top: "84.5",
          left: "1",
          width: "30",
          height: "0",
          showArrow: false,
          arrow: { class: "arrow", top: "0", left: "0" },
          contect: "生飲水處理到頂樓10噸生飲水",
        },
        /*----------------------------------------------------------------------------------------------------------------------------------------------------------------*/
        {
          show: true,
          class: "line_h",
          top: "63.5",
          left: "48.5",
          width: "0",
          height: "71",
          showArrow: false,
          arrow: { class: "arrow down", top: "0", left: "0"  },
          contect: "屋頂10噸儲水槽到各設備",
        },
        {
          show: true,
          class: "line_w",
          top: "69.5",
          left: "44",
          width: "200",
          height: "0",
          showArrow: false,
          arrow: { class: "arrow", top: "0", left: "0" },
          contect: "屋頂10噸儲水槽到各設備",
        },
        {
          show: true,
          class: "line_w",
          top: "75.5",
          left: "27",
          width: "30",
          height: "0",
          showArrow: false,
          arrow: { class: "arrow", top: "0", left: "0" },
          contect: "屋頂熱水出水到屋頂蒸汽冷凝水回收",
        },
        {
          show: true,
          class: "line_h",
          top: "75.5",
          left: "27",
          width: "0",
          height: "105",
          showArrow: false,
          arrow: { class: "arrow down", top: "0", left: "0"  },
          contect: "屋頂熱水出水到屋頂蒸汽冷凝水回收",
        },
        {
          show: true,
          class: "line_w",
          top: "84.5",
          left: "27",
          width: "30",
          height: "0",
          showArrow: false,
          arrow: { class: "arrow", top: "0", left: "0" },
          contect: "屋頂熱水出水到屋頂蒸汽冷凝水回收",
        },
        {
          show: true,
          class: "line_w",
          top: "75.5",
          left: "51.5",
          width: "30",
          height: "0",
          showArrow: false,
          arrow: { class: "arrow", top: "0", left: "0" },
          contect: "殺菌釜進水到殺菌釜回收水",
        },
        {
          show: true,
          class: "line_h",
          top: "75.5",
          left: "51.5",
          width: "0",
          height: "105",
          showArrow: false,
          arrow: { class: "arrow down", top: "0", left: "0"  },
          contect: "殺菌釜進水到殺菌釜回收水",
        },
        {
          show: true,
          class: "line_w",
          top: "84.5",
          left: "51.5",
          width: "30",
          height: "0",
          showArrow: false,
          arrow: { class: "arrow", top: "0", left: "0" },
          contect: "殺菌釜進水到殺菌釜回收水",
        },
        /*----------------------------------------------------------------------------------------------------------------------------------------------------------------*/
        {
          show: true,
          class: "line_h",
          top: "19",
          left: "73",
          width: "0",
          height: "110",
          showArrow: false,
          arrow: { class: "arrow", top: "0", left: "0" },
          contect: "廢水處理到各系統",
        },
        {
          show: true,
          class: "line_w",
          top: "28.5",
          left: "67.5",
          width: "200",
          height: "0",
          showArrow: false,
          arrow: { class: "arrow", top: "0", left: "0" },
          contect: "廢水處理到各系統",
        },
        {
          show: true,
          class: "line_h",
          top: "34",
          left: "83",
          width: "0",
          height: "40",
          showArrow: false,
          arrow: { class: "arrow down", top: "0", left: "0"  },
          contect: "筏基回收水到地上50噸X2回收水儲水槽",
        },
        {
          show: true,
          class: "line_h",
          top: "48.5",
          left: "79.5",
          width: "0",
          height: "25",
          showArrow: false,
          arrow: { class: "arrow down", top: "25", left: "-6" },
          contect: "地上50噸X2回收水儲水槽到各設備",
        },
        {
          show: true,
          class: "line_w",
          top: "50.5",
          left: "69.75",
          width: "379",
          height: "0",
          showArrow: false,
          arrow: { class: "arrow", top: "0", left: "0" },
          contect: "地上50噸X2回收水儲水槽到各系統",
        },
        {
          show: true,
          class: "line_h",
          top: "50.5",
          left: "69.75",
          width: "0",
          height: "25",
          showArrow: false,
          arrow: { class: "arrow down", top: "25", left: "-6" },
          contect: "地上50噸X2回收水儲水槽到馬桶沖廁",
        },
        {
          show: true,
          class: "line_h",
          top: "50.5",
          left: "89.25",
          width: "0",
          height: "25",
          showArrow: false,
          arrow: { class: "arrow down", top: "25", left: "-6" },
          contect: "地上50噸X2回收水儲水槽到軟水處理",
        },
      ],
    };
  },

  computed: {},
  watch: {},

  mounted() {
    this.$set(this.WebSetup, "caption", "用水系統");
    this.MenuSetup.opened = false;
    this.VarMenuIsOverlay = false;
    this.loadPageData();
    this.sysNowTime();
  },
  methods: {
    //  刷新頁面
    sysNowTime () {
      let that = this;
      setInterval(function () {
        that.loadPageData();
      }, 600000);
    },
    loadPageData() {
      _.each(this.billboard, (item, key) => {
        _.each(item['data'], (data, data_key) => {
          data['DBvalue'] = 0
        })
      })
      var params = {
        Action: "LoadPageData",
        Datas: {},
      };

      this.FnWebAPIGet(params)
        .then((res) => {
          var resData = res.data.data;
          var groupByIdData = _.groupBy(resData, 'ID')
          //  基本內容塞值
          _.each(this.billboard, (item, key) => {
            if (!_.isNil(groupByIdData[key])) {
              _.each(item['data'], (data , data_key) => {
                if (data_key == "item01" && data['isDBValue'] ) {
                  data['DBvalue'] = this.FnRoundToDecimal(!_.isNil(groupByIdData[key][0]['MAX_Flow']) ? groupByIdData[key][0]['MAX_Flow'] : 0, 2) 
                }
                if (data_key == "item02" && data['isDBValue'] ) {
                  data['DBvalue'] = this.FnRoundToDecimal(!_.isNil(groupByIdData[key][0]['today_Acc']) ? groupByIdData[key][0]['today_Acc'] : 0, 2) 
                }
              })
            } else {
              _.each(item['data'], (data , data_key) => {
                //  淨水房35噸儲水槽
                if ( key == "item02" && data['isDBValue'] ) {
                  _.each(this.treeMap('水', '淨水房35噸儲水槽') , (id) => {
                    if (data_key == "item01" && data['isDBValue'] && !_.isNil(groupByIdData[id['value']]) ) {
                      data['DBvalue'] += this.FnRoundToDecimal(!_.isNil(groupByIdData[id['value']][0]['MAX_Flow']) ? groupByIdData[id['value']][0]['MAX_Flow'] : 0 , 2) 
                    }
                    if (data_key == "item02" && data['isDBValue'] && !_.isNil(groupByIdData[id['value']]) ) {
                      data['DBvalue'] += this.FnRoundToDecimal(!_.isNil(groupByIdData[id['value']][0]['today_Acc']) ? groupByIdData[id['value']][0]['today_Acc'] : 0 , 2) 
                    } 
                  }) 
                }
                //  地上300噸儲水槽
                if ( key == "item04" && data['isDBValue'] ) {
                  _.each(this.treeMap('水', '地上300噸儲水槽') , (id) => {
                    if (data_key == "item01" && data['isDBValue'] && !_.isNil(groupByIdData[id['value']]) ) {
                      data['DBvalue'] += this.FnRoundToDecimal(!_.isNil(groupByIdData[id['value']][0]['MAX_Flow']) ? groupByIdData[id['value']][0]['MAX_Flow'] : 0 , 2) 
                    }
                    if (data_key == "item02" && data['isDBValue'] && !_.isNil(groupByIdData[id['value']]) ) {
                      data['DBvalue'] += this.FnRoundToDecimal(!_.isNil(groupByIdData[id['value']][0]['today_Acc']) ? groupByIdData[id['value']][0]['today_Acc'] : 0 , 2) 
                    } 
                  }) 
                }
                //  廢水處理
                if ( key == "item15" && data['isDBValue'] ) {
                  _.each(this.treeMap('水', '廢水處理') , (id) => {
                    if (data_key == "item01" && data['isDBValue'] && !_.isNil(groupByIdData[id['value']]) ) {
                      data['DBvalue'] += this.FnRoundToDecimal(!_.isNil(groupByIdData[id['value']][0]['MAX_Flow']) ? groupByIdData[id['value']][0]['MAX_Flow'] : 0 , 2) 
                    }
                    if (data_key == "item02" && data['isDBValue'] && !_.isNil(groupByIdData[id['value']]) ) {
                      data['DBvalue'] += this.FnRoundToDecimal(!_.isNil(groupByIdData[id['value']][0]['today_Acc']) ? groupByIdData[id['value']][0]['today_Acc'] : 0 , 2) 
                    } 
                  }) 
                }
                //  地上50噸X2回收水儲水槽
                if ( key == "item18" && data['isDBValue'] ) {
                  _.each(this.treeMap('水', '地上50噸X2回收水儲水槽') , (id) => {
                    if (data_key == "item01" && data['isDBValue'] && !_.isNil(groupByIdData[id['value']]) ) {
                      data['DBvalue'] += this.FnRoundToDecimal(!_.isNil(groupByIdData[id['value']][0]['MAX_Flow']) ? groupByIdData[id['value']][0]['MAX_Flow'] : 0 , 2) 
                    }
                    if (data_key == "item02" && data['isDBValue'] && !_.isNil(groupByIdData[id['value']]) ) {
                      data['DBvalue'] += this.FnRoundToDecimal(!_.isNil(groupByIdData[id['value']][0]['today_Acc']) ? groupByIdData[id['value']][0]['today_Acc'] : 0 , 2) 
                    } 
                  }) 
                }
              })  
            }
          })
          //  客制內容
         
          //  數據格式化
          _.each(this.billboard , (detail) => {
            _.each(detail['data'] , (item)=> {
              item['DBvalue'] = this.FnFormatNumber(item['DBvalue'], 1 )
            })
          })
          
        })
        .catch((err) => {
          console.log(err);
        });
    },

    //  樹狀爸爸
    treeMap (item_type, keyWord) {
      return _.map(device_item[item_type][keyWord]['options'] , (item ) => {
        return {  "value" : item['value'] } 
      })
    }
  },
};
