var page_function = {
  components: {},
  data() {
    return {
      VarMenuPage: "system_water_flow_chart",
      VarMenu: "area",
      VarPageContainerCss: "padding:0px",

      deviceKey: ["一期屋頂", "淨水房", "小地下室", "廢水區"], //	Var_Config 設定檔 對應的key

      qTabForm: {
        recycled: {
          show: true,
          title: "回收水流程圖",
          hidden: false,
          default: true, //	預設選項
          // icon: "account_tree",
          backgroundImage: "img/source/新東陽-電腦-回收水系統_去背.png",
          billboard: {
            "13": {
              show: false, //	要不要顯示此區塊
              title: "筏基水表", //	標題
              showButton: false,
              button: {
                //	標題同一列的按鈕功能
                item01: {
                  show: true, //	要不要顯示此按鈕
                  label: "長條圖", //	標題 (標示定義名稱)
                  icon: "leaderboard", //	按鈕圖樣
                  linkto: "chart_bar.php", //	轉跳頁面 定義為 null 不會觸發
                  params: { options: "筏基水表" }, //	轉跳頁面後面帶參數
                },
                item02: {
                  show: true,
                  label: "圓餅圖",
                  icon: "pie_chart",
                  linkto: "chart_pie.php",
                  params: { options: "筏基水表" },
                },
              },
              data: {
                item01: {
                  show: true,
                  label: "即時值",
                  isDBValue: true,
                  DBvalue: 0,
                  isSoft: false,
                  SoftValue: "",
                  unit: "m³/hr",
                  icon: "water_drop",
                },
                item02: {
                  show: true,
                  label: "日用量",
                  isDBValue: true,
                  DBvalue: 0,
                  isSoft: false,
                  SoftValue: "",
                  unit: "m³/hr",
                  icon: "water_drop",
                },
              },
              top: "24",
              left: "4.5",
              width: "300",
            },
            item02: {
              show: false,
              title: "廢水回收水表",
              showButton: false,
              button: {
                item01: {
                  show: true,
                  label: "長條圖",
                  icon: "leaderboard",
                  linkto: "chart_bar.php",
                  params: { options: "廢水回收水表" },
                },
                item02: {
                  show: true,
                  label: "圓餅圖",
                  icon: "pie_chart",
                  linkto: "chart_pie.php",
                  params: { options: "廢水回收水表" },
                },
              },
              data: {
                item01: {
                  show: true,
                  label: "即時值",
                  isDBValue: false,
                  DBvalue: 0,
                  isSoft: false,
                  SoftValue: "",
                  unit: "m³/hr",
                  icon: "water_drop",
                },
                item02: {
                  show: true,
                  label: "日用量",
                  isDBValue: false,
                  DBvalue: 0,
                  isSoft: false,
                  SoftValue: "",
                  unit: "m³/hr",
                  icon: "water_drop",
                },
              },
              top: "47",
              left: "3",
              width: "300",
            },
            "16": {
              show: false,
              title: "過濾水表",
              showButton: false,
              button: {
                item01: {
                  show: true,
                  label: "長條圖",
                  icon: "leaderboard",
                  linkto: "chart_bar.php",
                  params: { options: "過濾水表" },
                },
                item02: {
                  show: true,
                  label: "圓餅圖",
                  icon: "pie_chart",
                  linkto: "chart_pie.php",
                  params: { options: "過濾水表" },
                },
              },
              data: {
                item01: {
                  show: true,
                  label: "即時值",
                  isDBValue: true,
                  DBvalue: 0,
                  isSoft: false,
                  SoftValue: "",
                  unit: "m³/hr",
                  icon: "water_drop",
                },
                item02: {
                  show: true,
                  label: "日用量",
                  isDBValue: true,
                  DBvalue: 0,
                  isSoft: false,
                  SoftValue: "",
                  unit: "m³/hr",
                  icon: "water_drop",
                },
              },
              top: "30",
              left: "47",
              width: "300",
            },
          },
        },
        purification: {
          show: true,
          title: "淨水流程圖",
          hidden: false,
          default: false,
          // icon: "account_tree",
          backgroundImage: "img/source/新東陽-電腦-淨水系統_去背.png",
          billboard: {
            "5": {
              show: false,
              title: "自來水總表",
              showButton: false,
              button: {
                item01: {
                  show: true,
                  label: "長條圖",
                  icon: "leaderboard",
                  linkto: "chart_bar.php",
                  params: { options: "淨水流程圖" },
                },
                item02: {
                  show: true,
                  label: "圓餅圖",
                  icon: "pie_chart",
                  linkto: "chart_pie.php",
                  params: { options: "淨水流程圖" },
                },
              },
              data: {
                item01: {
                  show: true,
                  label: "即時值",
                  isDBValue: true,
                  DBvalue: 0,
                  isSoft: false,
                  SoftValue: "",
                  unit: "m³/hr",
                  icon: "water_drop",
                },
                item02: {
                  show: true,
                  label: "日用量",
                  isDBValue: true,
                  DBvalue: 0,
                  isSoft: false,
                  SoftValue: "",
                  unit: "m³/hr",
                  icon: "water_drop",
                },
              },
              top: "15",
              left: "5",
              width: "300",
            },
            item02: {
              show: false,
              title: "生飲水槽",
              showButton: false,
              button: {
                item01: {
                  show: true,
                  label: "長條圖",
                  icon: "leaderboard",
                  linkto: "chart_bar.php",
                  params: { options: "生飲水槽" },
                },
                item02: {
                  show: true,
                  label: "圓餅圖",
                  icon: "pie_chart",
                  linkto: "chart_pie.php",
                  params: { options: "生飲水槽" },
                },
              },
              data: {
                item01: {
                  show: true,
                  label: "即時值",
                  isDBValue: false,
                  DBvalue: 0,
                  isSoft: false,
                  SoftValue: "",
                  unit: "m³/hr",
                  icon: "water_drop",
                },
                item02: {
                  show: true,
                  label: "日用量",
                  isDBValue: false,
                  DBvalue: 0,
                  isSoft: false,
                  SoftValue: "",
                  unit: "m³/hr",
                  icon: "water_drop",
                },
              },
              top: "15",
              left: "26.2",
              width: "300",
            },
            "8": {
              show: false,
              title: "軟水表",
              showButton: false,
              button: {
                item01: {
                  show: true,
                  label: "長條圖",
                  icon: "leaderboard",
                  linkto: "chart_bar.php",
                  params: { options: "軟水表" },
                },
                item02: {
                  show: true,
                  label: "圓餅圖",
                  icon: "pie_chart",
                  linkto: "chart_pie.php",
                  params: { options: "軟水表" },
                },
              },
              data: {
                item01: {
                  show: true,
                  label: "即時值",
                  isDBValue: true,
                  DBvalue: 0,
                  isSoft: false,
                  SoftValue: "",
                  unit: "m³/hr",
                  icon: "water_drop",
                },
                item02: {
                  show: true,
                  label: "日用量",
                  isDBValue: true,
                  DBvalue: 0,
                  isSoft: false,
                  SoftValue: "",
                  unit: "m³/hr",
                  icon: "water_drop",
                },
              },
              top: "15",
              left: "47",
              width: "300",
            },
            "6": {
              show: false,
              title: "300T-100T蓄水池",
              showButton: false,
              button: {
                item01: {
                  show: true,
                  label: "長條圖",
                  icon: "leaderboard",
                  linkto: "chart_bar.php",
                  params: { options: "300T-100T蓄水池" },
                },
                item02: {
                  show: true,
                  label: "圓餅圖",
                  icon: "pie_chart",
                  linkto: "chart_pie.php",
                  params: { options: "300T-100T蓄水池" },
                },
              },
              data: {
                item01: {
                  show: true,
                  label: "即時值",
                  isDBValue: true,
                  DBvalue: 0,
                  isSoft: false,
                  SoftValue: "",
                  unit: "m³/hr",
                  icon: "water_drop",
                },
                item02: {
                  show: true,
                  label: "日用量",
                  isDBValue: true,
                  DBvalue: 0,
                  isSoft: false,
                  SoftValue: "",
                  unit: "m³/hr",
                  icon: "water_drop",
                },
              },
              top: "48",
              left: "4",
              width: "300",
            },
            "4": {
              show: false,
              title: "屋頂一般用水",
              showButton: false,
              button: {
                item01: {
                  show: true,
                  label: "長條圖",
                  icon: "leaderboard",
                  linkto: "chart_bar.php",
                  params: { options: "屋頂一般用水" },
                },
                item02: {
                  show: true,
                  label: "圓餅圖",
                  icon: "pie_chart",
                  linkto: "chart_pie.php",
                  params: { options: "屋頂一般用水" },
                },
              },
              data: {
                item01: {
                  show: true,
                  label: "即時值",
                  isDBValue: true,
                  DBvalue: 0,
                  isSoft: false,
                  SoftValue: "",
                  unit: "m³/hr",
                  icon: "water_drop",
                },
                item02: {
                  show: true,
                  label: "日用量",
                  isDBValue: true,
                  DBvalue: 0,
                  isSoft: false,
                  SoftValue: "",
                  unit: "m³/hr",
                  icon: "water_drop",
                },
              },
              top: "67",
              left: "10",
              width: "300",
            },
            "7": {
              show: false,
              title: "宿舍用水",
              showButton: false,
              button: {
                item01: {
                  show: true,
                  label: "長條圖",
                  icon: "leaderboard",
                  linkto: "chart_bar.php",
                  params: { options: "宿舍用水" },
                },
                item02: {
                  show: true,
                  label: "圓餅圖",
                  icon: "pie_chart",
                  linkto: "chart_pie.php",
                  params: { options: "宿舍用水" },
                },
              },
              data: {
                item01: {
                  show: true,
                  label: "即時值",
                  isDBValue: true,
                  DBvalue: 0,
                  isSoft: false,
                  SoftValue: "",
                  unit: "m³/hr",
                  icon: "water_drop",
                },
                item02: {
                  show: true,
                  label: "日用量",
                  isDBValue: true,
                  DBvalue: 0,
                  isSoft: false,
                  SoftValue: "",
                  unit: "m³/hr",
                  icon: "water_drop",
                },
              },
              top: "58",
              left: "47",
              width: "300",
            },
          },
        },
        waste: {
          show: true,
          title: "廢水流程圖",
          hidden: false,
          default: false,
          // icon: "account_tree",
          backgroundImage: "img/source/新東陽-電腦-廢水流程圖.png",
          billboard: {
            "14": {
              show: false,
              title: "廢水流量計",
              showButton: false,
              button: {
                item01: {
                  show: true,
                  label: "長條圖",
                  icon: "leaderboard",
                  linkto: "chart_bar.php",
                  params: { options: "廢水流程圖" },
                },
                item02: {
                  show: true,
                  label: "圓餅圖",
                  icon: "pie_chart",
                  linkto: "chart_pie.php",
                  params: { options: "廢水流程圖" },
                },
              },
              data: {
                item01: {
                  show: true,
                  label: "即時值",
                  isDBValue: true,
                  DBvalue: 0,
                  isSoft: false,
                  SoftValue: "",
                  unit: "m³/hr",
                  icon: "water_drop",
                },
                item02: {
                  show: true,
                  label: "日用量",
                  isDBValue: true,
                  DBvalue: 0,
                  isSoft: false,
                  SoftValue: "",
                  unit: "m³/hr",
                  icon: "water_drop",
                },
              },
              top: "28",
              left: "82",
              width: "300",
            },
            "15": {
              show: false,
              title: "SS監測儀",
              showButton: false,
              button: {
                item01: {
                  show: true,
                  label: "長條圖",
                  icon: "leaderboard",
                  linkto: "chart_bar.php",
                  params: { options: "SS監測儀" },
                },
                item02: {
                  show: true,
                  label: "圓餅圖",
                  icon: "pie_chart",
                  linkto: "chart_pie.php",
                  params: { options: "SS監測儀" },
                },
              },
              data: {
                item01: {
                  show: true,
                  label: "即時值",
                  isDBValue: true,
                  DBvalue: 0,
                  isSoft: false,
                  SoftValue: "",
                  unit: "m³/hr",
                  icon: "water_drop",
                },
                item02: {
                  show: true,
                  label: "日用量",
                  isDBValue: true,
                  DBvalue: 0,
                  isSoft: false,
                  SoftValue: "",
                  unit: "m³/hr",
                  icon: "water_drop",
                },
              },
              top: "28",
              left: "61",
              width: "300",
            },
          },
        },
      },
    };
  },

  computed: {},
  watch: {},

  mounted() {
    this.$set(this.WebSetup, "caption", "用水系統流程圖");
    this.MenuSetup.opened = false;
    this.VarMenuIsOverlay = false;
    this.loadPageData();
    this.sysNowTime();
  },
  methods: {
    //  刷新頁面
    sysNowTime () {
      let that = this;
      setInterval(function () {
        that.loadPageData();
      }, 600000);
    },
    loadPageData() {
      var that = this;

      var tempData = [];
      this.deviceKey.forEach((el) => {
        that.get_options_id(tempData, el);
      });

      var params = {
        Action: "LoadPageData",
        Datas: { id_list: _.join(tempData) },
        menu_page: 'system_water'
      };
      this.FnWebAPIGet(params)
        .then((res) => {
          var resData = res.data.data;
          var groupByIdData = _.groupBy(resData, 'ID')

          //  回收水流程圖
          _.each(this.qTabForm['recycled']['billboard'], (item, key) => {
            if (!_.isNil(groupByIdData[key])) {
              _.each(item['data'], (data , data_key) => {
                if (data_key == "item01" && data['isDBValue'] ) {
                  data['DBvalue'] = this.FnRoundToDecimal(!_.isNil(groupByIdData[key][0]['MAX_Flow']) ? groupByIdData[key][0]['MAX_Flow'] : 0, 0) 
                }
                if (data_key == "item02" && data['isDBValue'] ) {
                  data['DBvalue'] = this.FnRoundToDecimal(!_.isNil(groupByIdData[key][0]['today_Acc']) ? groupByIdData[key][0]['today_Acc'] : 0, 0) 
                }
              })
            }
          })
          //  淨水流程圖
          _.each(this.qTabForm['purification']['billboard'], (item, key) => {
            if (!_.isNil(groupByIdData[key])) {
              _.each(item['data'], (data , data_key) => {
                if (data_key == "item01" && data['isDBValue'] ) {
                  data['DBvalue'] = this.FnRoundToDecimal(!_.isNil(groupByIdData[key][0]['MAX_Flow']) ? groupByIdData[key][0]['MAX_Flow'] : 0, 0) 
                }
                if (data_key == "item02" && data['isDBValue'] ) {
                  data['DBvalue'] = this.FnRoundToDecimal(!_.isNil(groupByIdData[key][0]['today_Acc']) ? groupByIdData[key][0]['today_Acc'] : 0, 0) 
                }
              })
            }
          })
          //  廢水流程圖
          _.each(this.qTabForm['waste']['billboard'], (item, key) => {
            if (!_.isNil(groupByIdData[key])) {
              _.each(item['data'], (data , data_key) => {
                if (data_key == "item01" && data['isDBValue'] ) {
                  data['DBvalue'] = this.FnRoundToDecimal(!_.isNil(groupByIdData[key][0]['MAX_Flow']) ? groupByIdData[key][0]['MAX_Flow'] : 0, 0) 
                }
                if (data_key == "item02" && data['isDBValue'] ) {
                  data['DBvalue'] = this.FnRoundToDecimal(!_.isNil(groupByIdData[key][0]['today_Acc']) ? groupByIdData[key][0]['today_Acc'] : 0, 0) 
                }
              })
            }
          })

        })
        .catch((err) => {
          console.log(err);
        });
    },
    //樹狀陣列平扁化
    get_options_id(array, key) {
      var that = this;
      device_item["水"][key]["options"].forEach((el) => {
        if (!isNaN(Number(el.value, 10))) {
          array.push(el.value);
        }
        if (device_item.hasOwnProperty(el.label)) {
          return that.get_options_id(array, el.label);
        }
      });
    },
  },
};
