<!DOCTYPE html>
<html lang="zh-tw">

<head>
<?php
include_once "html_head.inc";
?>
</head>

<body>
<div id="q-app" :visible="IsVueReady==true" @mousemove="FnIdleReset" >
  <?php
  include_once "html_layout_header.inc";
  ?>
  <div class="position-1">
    <q-tabs color="blue-grey-1"  text-color="primary">
      <q-tab default slot="title" name="tab-1" label="能源參數" @select="loadEnergyParameter()"></q-tab>
      <q-tab slot="title" name="tab-2" label="基線參數" @select="loadBaselineParameter()"></q-tab>
      <q-tab slot="title" name="tab-3" label="全廠指標警戒範圍" @select="loadIndicatorAlarm()"></q-tab>
      <q-tab slot="title" name="tab-4" label="用電電價" @select="loadCfgPowerRange()"></q-tab>

      <q-tab-pane name="tab-1" >
        <div class="w3-right-align q-mb-sm position-2">
          <q-btn v-if="EnergyParam.isEdit" glossy label="儲存" color="positive" text-color="white" class="id-btn" @click="SaveEnergyParameter()"></q-btn>
          <q-btn v-else glossy label="編輯" color="primary" text-color="white" class="id-btn" @click="EnergyParam.isEdit = true"></q-btn>
        </div>
        <div class="w3-responsive flex-shadow">
          <table class="w3-table-all" border="1">
            <tr>
              <th>能源種類</th>
              <th class="w3-right-align">單位</th>
              <th class="w3-right-align">溫室氣體係數(CO2e)</th>
              <th class="w3-right-align">公秉油當量</th>
              <th class="w3-right-align">熱值(Mcal)</th>
            </tr>
            <tr v-for="row in EnergyParam.data">
              <td>{{row.item_label}}</td>
              <td class="w3-right-align">{{row.item_unit}}</td>
              <td><q-input v-model="row.co2e" type="number" align="right" clearable :disable="!EnergyParam.isEdit" style="font-size: 1.3rem;"></q-input></td>
              <td><q-input v-model="row.kloe" type="number" align="right" clearable :disable="!EnergyParam.isEdit" style="font-size: 1.3rem;"></q-input></td>
              <td><q-input v-model="row.mcal" type="number" align="right" clearable :disable="!EnergyParam.isEdit" style="font-size: 1.3rem;"></q-input></td>
            </tr>
          </table>
        </div>
      </q-tab-pane>

      <q-tab-pane name="tab-2"> 
        <div class="w3-right-align q-mb-sm position-2">
          <q-btn v-if="BaselineParam.isEdit" glossy label="儲存" color="positive" text-color="white" class="id-btn" @click="SaveBaselineParam()"></q-btn>
          <q-btn v-else glossy label="編輯" color="primary" text-color="white" class="id-btn" @click="BaselineParam.isEdit = true"></q-btn>
        </div>
        <div class="w3-responsive shadow-6">
          <table class="w3-table-all" border="1">
            <tr>
              <th>項目</th>
              <th class="w3-right-align">截距</th>
              <th class="w3-right-align">產品係數</th>
              <th class="w3-right-align">溫度係數</th>
            </tr>
            <tr v-for="row in _.filter(BaselineParam.data, {item_key: 'BL01'})">
              <td>{{row.item_label}}</td>
              <td><q-input v-model="row.intercept" type="number" align="right" clearable :disable="!BaselineParam.isEdit" style="font-size: 1.3rem;"></q-input></td>
              <td><q-input v-model="row.product_coef" type="number" align="right" clearable :disable="!BaselineParam.isEdit" style="font-size: 1.3rem;"></q-input></td>
              <td><q-input v-model="row.temperature_coef" type="number" align="right" clearable :disable="!BaselineParam.isEdit" style="font-size: 1.3rem;"></q-input></td>
            </tr>
          </table>
        </div>
        <div class="w3-responsive shadow-6 w3-section">
          <table class="w3-table-all" border="1">
            <tr>
              <th>項目</th>
              <th class="w3-right-align">截距</th>
              <th class="w3-right-align">係數</th>
            </tr>
            <tr v-for="row in _.filter(BaselineParam.data, r => r.item_key != 'BL01')">
              <td>{{row.item_label}}</td>
              <td><q-input v-model="row.intercept" type="number" align="right" clearable :disable="!BaselineParam.isEdit" style="font-size: 1.3rem;"></q-input></td>
              <td><q-input v-model="row.coef" type="number" align="right" clearable :disable="!BaselineParam.isEdit" style="font-size: 1.3rem;"></q-input></td>
            </tr>
          </table>
        </div>
      </q-tab-pane>

      <q-tab-pane name="tab-3">
        <div class="w3-right-align q-mb-sm position-2">
          <q-btn v-if="IndicatorAlarm.isEdit" glossy label="儲存" color="positive" text-color="white" class="id-btn" @click="SaveIndicatorAlarm()"></q-btn>
          <q-btn v-else glossy label="編輯" color="primary" text-color="white" class="id-btn" @click="IndicatorAlarm.isEdit = true"></q-btn>
        </div>
        <div class="w3-responsive shadow-6">
          <table class="w3-table-all" border="1">
            <tr>
              <th>項目</th>
              <th class="w3-right-align">H</th>
              <th class="w3-right-align">HH</th>
            </tr>
            <tr v-for="row in IndicatorAlarm.data">
              <td>{{row.item_label}}</td>
              <td><q-input v-model="row.h" type="number" align="right" clearable :disable="!IndicatorAlarm.isEdit" style="font-size: 1.3rem;"></q-input></td>
              <td><q-input v-model="row.hh" type="number" align="right" clearable :disable="!IndicatorAlarm.isEdit" style="font-size: 1.3rem;"></q-input></td>
            </tr>
          </table>
        </div>
      </q-tab-pane>

      <q-tab-pane name="tab-4">
        <div class="w3-right-align q-mb-sm position-2">
          <q-btn v-if="CfgPowerRange.isEdit" glossy label="儲存" color="positive" text-color="white" class="id-btn" @click="SaveCfgPowerRange()"></q-btn>
          <q-btn v-else glossy label="編輯" color="primary" text-color="white" class="id-btn" @click="CfgPowerRange.isEdit = true"></q-btn>
        </div>
        <div class="w3-responsive shadow-6">
          <table class="w3-table-all" border="1">
            <tr>
              <th>項目</th>
              <th class="w3-right-align">開始時間</th>
              <th class="w3-right-align">結束時間</th>
              <th class="w3-right-align">電價</th>
            </tr>
            <tr v-for="row in CfgPowerRange.data">
              <td>{{ row.comment }}</td>
              <td class="w3-right-align">{{ row.start_time }}</td>
              <td class="w3-right-align">{{ row.end_time }}</td>
              <td><q-input v-model="row.price" type="number" align="right" clearable :disable="!CfgPowerRange.isEdit" style="font-size: 1.3rem;"></q-input></td>
            </tr>
          </table>
        </div>
      </q-tab-pane>

    </q-tabs>
  </div>
<?php
include_once "html_layout_footer.inc";
?>
</div>
  <?php
  include_once "html_loading.inc";
  ?>
</body><?php
        $is_echarts = true;
        include_once "html_down.inc";
        ?>

</html>