<!DOCTYPE html>
<html lang="zh-tw">

<head>
<?php
include_once "html_head.inc";
?>
</head>

<body>
<div id="q-app" :visible="IsVueReady==true" @mousemove="FnIdleReset" >
  <?php
  include_once "html_layout_header.inc";
  ?>

  <div class="w3-row">
    <div class="w3-col l12 m12 s12">

      <data-table 
        :show-search-field="true" 
        :show-search-btn="false" 
        :show-search-panel="true" 
        :show-download-btn="false" 
        :title="tableTitle[search['dateType']['value']]+'報表'" :columns="columns" :data="tableData" row-key="no" @search-ok="searchList()"  >
      
        <template v-slot:search-panel-actions>
          
        </template>
      
        <template v-slot:search-form>
          <div class="w3-row">
            <div class="position-1">
              <div class="w3-col l2 m2 s2 q-pa-sm black-option" >
                <span style="font-weight:700; font-size: 20px; color: #fff;"> {{  search['dateType']['label']  }}</span>
                <q-select v-model="search['dateType']['value']" :options="search['dateType']['options']"> </q-select>
              </div>  
              <div class="w3-col l2 m2 s2 q-pa-sm black-option">
                <span style="font-weight:700; font-size: 20px; color: #fff;"> {{  search['fileType']['label']  }}</span>
                <q-select v-model="search['fileType']['value']" :options="search['fileType']['options']" ></q-select>
              </div>  
              <div class="w3-col l2 m2 s2 q-pa-sm black-option">
                <span style="font-weight:700; font-size: 20px; color: #fff;"> {{  search['fileQuantity']['label']  }}</span>
                <q-select v-model="search['fileQuantity']['value']" :options="search['fileQuantity']['options'][search['fileType']['value']]"  ></q-select>
              </div>  
              <div class="w3-col l2 m2 s2 q-pa-sm" style="display:flex; flex-flow:column wrap;">
                <span style="font-weight:700; font-size: 20px; color: #fff;"> {{  search['data']['title']  }}</span>
                <!-- 當查詢條件是日 -->
                <date-picker v-model="search['data']['daily']" type="date" range placeholder="請選擇時間區間" :clearable="false" style="border-bottom: 1px solid #ccc; padding-bottom: 3px;" v-if="_.includes(search['dateType']['value'] , 'daily')"></date-picker>
                <!-- 當查詢條件是月 -->
                <date-picker v-model="search['data']['month']" type="month" range placeholder="請選擇時間區間" :clearable="false" style="border-bottom: 1px solid #ccc; padding-bottom: 3px;" v-if="_.includes(search['dateType']['value'] , 'month')"></date-picker>
                <!-- 當查詢條件是年 -->
                <date-picker v-model="search['data']['year']" type="year" range placeholder="請選擇時間區間" :clearable="false" style="border-bottom: 1px solid #ccc; padding-bottom: 3px;" v-if="_.includes(search['dateType']['value'] , 'year')"></date-picker>
              </div> 
            </div>  
          </div>  
        </template>
      
        <!--欄位下載功能-->
        <template v-slot:row-control="props">
          <q-btn class="id-btn" glossy color="primary" label="下載" @click.native="reportdownload(props.row_data.row)"></q-btn>
        </template>
    
      </data-table>

    </div>
  </div>  



<?php
include_once "html_layout_footer.inc";
?>
</div>
  <?php
  include_once "html_loading.inc";
  ?>
</body><?php
        $is_echarts = true;
        include_once "html_down.inc";
        ?>

</html>