<!DOCTYPE html>
<html lang="zh-tw">

<head>
  <?php
      include_once "html_head.inc";
      ?>
    </head>

<body>
  <div id="q-app" :visible="IsVueReady==true" @mousemove="FnIdleReset" >
    <?php
    include_once "html_layout_header.inc";
    ?>

    <div class="w3-row-padding w3-stretch flex-frwfsc" >
        <q-field label="查詢區間" label-width="5" class="search-field w3-col l2 m6 s12 flex-space search" >
          <q-radio label="年" v-model="search.range" val="year" class="q-ml-sm"></q-radio>
          <q-radio label="月" v-model="search.range" val="month" class="q-ml-sm"></q-radio>
        </q-field>
        <q-field label="年" label-width="4" class="search-field w3-col l2 m6 s12" v-if="search.range == 'year'" >
          <date-picker v-model="search.year" type="year" placeholder="請選年份" :clearable="false"></date-picker>
        </q-field>
        <q-field label="年月" label-width="4" class="search-field w3-col l2 m6 s12 flex-space" v-if="search.range == 'month'" >
          <date-picker v-model="search.year_month" type="month" placeholder="請選年月份" :clearable="false"></date-picker>
        </q-field>
        <q-btn glossy label="查詢" @click="searchData()" color="primary" size="1.2em" class="id-btn"></q-btn>
      </div>  
    

    <div class="q-my-lg flex-shadow" >
      <div>
        <echart :options="echart" autoresize style="width: 100%; " ></echart>
      </div>
    </div>

    <div class="w3-row ">
      <div class="w3-row-padding" style="padding: 0; font-size: 20px; font-weight: 600;">
        <div class="w3-col l3 m6 s12 flex-space">
          <div class="flex-shadow w3-responsive">
            <table class="w3-table-all">
              <thead>
                <tr style="border-radius: 15px; background: #4264d0; color: #fff;">
                  <th>Date</th>
                  <th class="w3-right-align" >{{echart['dataset']['dimensions'][4]}}</th>
                  <th class="w3-right-align" >{{echart['dataset']['dimensions'][3]}}</th>
                  <th class="w3-right-align" >{{echart['dataset']['dimensions'][2]}}</th>
                  <th class="w3-right-align" >{{echart['dataset']['dimensions'][1]}}</th>
                </tr>
              </thead>
              <tr v-for="row,inx in echart['dataset']['source']" v-if="inx < 10">
                <td>{{row.Date}}</td>
                <th class="w3-right-align" >{{row[echart['dataset']['dimensions'][4]]}}</th>
                <th class="w3-right-align" >{{row[echart['dataset']['dimensions'][3]]}}</th>
                <th class="w3-right-align" >{{row[echart['dataset']['dimensions'][2]]}}</th>
                <th class="w3-right-align" >{{row[echart['dataset']['dimensions'][1]]}}</th>
              </tr>
            </table>
          </div>
        </div>
        <div class="w3-col l3 m6 s12 flex-space">
          <div class="flex-shadow w3-responsive">
            <table class="w3-table-all">
              <thead>
                <tr style="border-radius: 15px; background: #4264d0; color: #fff;">
                  <th>Date</th>
                  <th class="w3-right-align" >{{echart['dataset']['dimensions'][4]}}</th>
                  <th class="w3-right-align" >{{echart['dataset']['dimensions'][3]}}</th>
                  <th class="w3-right-align" >{{echart['dataset']['dimensions'][2]}}</th>
                  <th class="w3-right-align" >{{echart['dataset']['dimensions'][1]}}</th>
                </tr>
              </thead>
              <tr v-for="row,inx in echart['dataset']['source']" v-if="inx >= 10 && inx < 20">
                <td>{{row.Date}}</td>
                <th class="w3-right-align" >{{row[echart['dataset']['dimensions'][4]]}}</th>
                <th class="w3-right-align" >{{row[echart['dataset']['dimensions'][3]]}}</th>
                <th class="w3-right-align" >{{row[echart['dataset']['dimensions'][2]]}}</th>
                <th class="w3-right-align" >{{row[echart['dataset']['dimensions'][1]]}}</th>
              </tr>
            </table>
          </div>
        </div>
        <div class="w3-col l3 m6 s12 flex-space">
          <div class="flex-shadow w3-responsive">
            <table class="w3-table-all">
              <thead>
                <tr style="border-radius: 15px; background: #4264d0; color: #fff;">
                  <th>Date</th>
                  <th class="w3-right-align" >{{echart['dataset']['dimensions'][4]}}</th>
                  <th class="w3-right-align" >{{echart['dataset']['dimensions'][3]}}</th>
                  <th class="w3-right-align" >{{echart['dataset']['dimensions'][2]}}</th>
                  <th class="w3-right-align" >{{echart['dataset']['dimensions'][1]}}</th>
                </tr>
              </thead>
              <tr v-for="row,inx in echart['dataset']['source']" v-if="inx >= 20 && inx < 30">
                <td>{{row.Date}}</td>
                <th class="w3-right-align" >{{row[echart['dataset']['dimensions'][4]]}}</th>
                <th class="w3-right-align" >{{row[echart['dataset']['dimensions'][3]]}}</th>
                <th class="w3-right-align" >{{row[echart['dataset']['dimensions'][2]]}}</th>
                <th class="w3-right-align" >{{row[echart['dataset']['dimensions'][1]]}}</th>
              </tr>
            </table>
          </div>
        </div>
        <div class="w3-col l3 m6 s12 flex-space">
          <div class="flex-shadow w3-responsive">
            <table class="w3-table-all">
              <thead>
                <tr style="border-radius: 15px; background: #4264d0; color: #fff;">
                  <th>Date</th>
                  <th class="w3-right-align" >{{echart['dataset']['dimensions'][4]}}</th>
                  <th class="w3-right-align" >{{echart['dataset']['dimensions'][3]}}</th>
                  <th class="w3-right-align" >{{echart['dataset']['dimensions'][2]}}</th>
                  <th class="w3-right-align" >{{echart['dataset']['dimensions'][1]}}</th>
                </tr>
              </thead>
              <tr v-for="row,inx in echart['dataset']['source']" v-if="inx >= 30 ">
                <td>{{row.Date}}</td>
                <th class="w3-right-align" >{{row[echart['dataset']['dimensions'][4]]}}</th>
                <th class="w3-right-align" >{{row[echart['dataset']['dimensions'][3]]}}</th>
                <th class="w3-right-align" >{{row[echart['dataset']['dimensions'][2]]}}</th>
                <th class="w3-right-align" >{{row[echart['dataset']['dimensions'][1]]}}</th>
              </tr>
            </table>
          </div>
        </div>
      </div>
    </div>  



    <?php
    include_once "html_layout_footer.inc";
    ?>
  </div>
  <?php
  include_once "html_loading.inc";
  ?>
</body><?php
        $is_echarts = true;
        include_once "html_down.inc";
        ?>

</html>