<?php
// 頁面專用WebAPI, 不管任何的頁面, class名稱固定為 [WebAPIForMenuPage], 不可變更
class WebAPIForMenuPage extends base_class
{

	// 撈取 能源參數設定
	public function SelectEnergyParameter($params)
	{
		$sql = sprintf("SELECT *
									FROM [energy_parameter_settings] 
									ORDER BY [sort]");
		$sth = $this->pdo_sql->prepare($sql);
		$sth->execute();
		return $sth->fetchAll(PDO::FETCH_ASSOC);
	}

	// 儲存 能源參數設定
	public function ChangeEnergyParameter($params)
	{
		foreach($params['input_data'] as $row)
		{
			$sql = sprintf("UPDATE [energy_parameter_settings]
											SET [updated_at] = GETDATE(),
													[updated_by] = :updated_by,
													[co2e] = :co2e,
													[kloe] = :kloe,
													[mcal] = :mcal
											WHERE [item_key] = :item_key");
			$sth = $this->pdo_sql->prepare($sql);
			$sth->execute([
				'updated_by'=> $this->user_id,
				'co2e'=> $row['co2e'],
				'kloe'=> $row['kloe'],
				'mcal'=> $row['mcal'],
				'item_key'=> $row['item_key'],
			]);
		}
		return $sth->rowCount() > 0;
	}

	// 撈取 基線參數設定
	public function SelectBaselineParameter($params)
	{
		$sql = sprintf("SELECT * FROM [baseline_parameter_settings] ORDER BY [sort]");
		$sth = $this->pdo_sql->prepare($sql);
		$sth->execute();
		return $sth->fetchAll(PDO::FETCH_ASSOC);
	}

	// 儲存 基線參數設定
	public function ChangeBaselineParameter($params)
	{
		foreach($params['input_data'] as $row)
		{
			$sql = sprintf("UPDATE [baseline_parameter_settings]
											SET [updated_at] = GETDATE(),
													[updated_by] = :updated_by,
													[intercept] = :intercept,
													[product_coef] = :product_coef,
													[temperature_coef] = :temperature_coef,
													[coef] = :coef
											WHERE [item_key] = :item_key");
			$sth = $this->pdo_sql->prepare($sql);
			$sth->execute([
				'updated_by'=> $this->user_id,
				'intercept'=> $row['intercept'],
				'product_coef'=> $row['product_coef'],
				'temperature_coef'=> $row['temperature_coef'],
				'coef'=> $row['coef'],
				'item_key'=> $row['item_key'],
			]);
		}
		return $sth->rowCount() > 0;
	}

	// 撈取 全廠指標警戒範圍
	public function SelectIndicatorAlarm($params)
	{
		$sql = sprintf("SELECT * FROM [indicator_alarm_settings] ORDER BY [sort]");
		$sth = $this->pdo_sql->prepare($sql);
		$sth->execute();
		return $sth->fetchAll(PDO::FETCH_ASSOC);
	}

	// 儲存 全廠指標警戒參數設定
	public function ChangeIndicatorAlarm($params)
	{
		foreach($params['input_data'] as $row)
		{
			$sql = sprintf("UPDATE [indicator_alarm_settings]
											SET [updated_at] = GETDATE(),
													[updated_by] = :updated_by,
													[h] = :h,
													[hh] = :hh
											WHERE [item_key] = :item_key");
			$sth = $this->pdo_sql->prepare($sql);
			$sth->execute([
				'updated_by'=> $this->user_id,
				'h'=> $row['h'],
				'hh'=> $row['hh'],
				'item_key'=> $row['item_key'],
			]);
		}
		return $sth->rowCount() > 0;
	}


	// 撈取 用電各時間價錢
	public function SelectCfgPowerRange($params)
	{
		$sql = sprintf("SELECT * FROM [cfg_power_range] ORDER BY [weekday_id], [is_summer] DESC , [start_time], [peak_id] ");
		$sth = $this->pdo_sql->prepare($sql);
		$sth->execute();
		return $sth->fetchAll(PDO::FETCH_ASSOC);
	}

	// 儲存 用電各時間價錢
	public function ChangeCfgPowerRange($params)
	{
		foreach($params['input_data'] as $row)
		{
			$sql = sprintf("UPDATE [cfg_power_range]
											SET [updated_at] = GETDATE(),
													[price] = :price
											WHERE [weekday_id] = :weekday_id AND [start_time] = :start_time AND [is_summer] = :is_summer AND [peak_id] = :peak_id");
			$sth = $this->pdo_sql->prepare($sql);
			$sth->execute([
				'weekday_id'=> $row['weekday_id'],
				'start_time'=> $row['start_time'],
				'is_summer'=> $row['is_summer'],
				'peak_id'=> $row['peak_id'],
				'price'=> $row['price'],
			]);
		}
		return $sth->rowCount() > 0;
	}
}
