<?php
// 頁面專用WebAPI, 不管任何的頁面, class名稱固定為 [WebAPIForMenuPage], 不可變更
class WebAPIForMenuPage extends base_class
{

	// 	抓取資料夾清單
	public function SelectReportFileList($params)
	{

		$startTime  = date('Y-m-01');	//	初始開始時間
		$endTime = date('Y-m-t'); 		//	初始結束時間
		$dates = [];					//	檔案日期範圍


		switch ($params['folder']) {
			case 'daily':
				$startTime = date('Y-m-d', strtotime($params['dataRange'][0]));
				$endTime = date('Y-m-d', strtotime($params['dataRange'][1]));
				break;
			case 'monthly':
				$startTime = date('Y-m', strtotime($params['dataRange'][0]));
				$endTime = date('Y-m', strtotime($params['dataRange'][1]));
				break;
			case 'yearly':
				$startTime = date('Y-01-01', strtotime($params['dataRange'][0]));
				$endTime = date('Y-01-01', strtotime($params['dataRange'][1]));
				break;
			default:			
		}

		$startDate = new DateTime($startTime);
		$endDate = new DateTime($endTime);

		while ($startDate <= $endDate) {
		    if ($params['folder'] == 'daily') {
		        $dates[] = $startDate->format('Y-m-d');
		        $startDate->modify('+1 day');
		    } elseif ($params['folder'] == 'monthly') {
		        $dates[] = $startDate->format('Y-m');
		        $startDate->modify('+1 month');
		    } elseif ($params['folder'] == 'yearly') {
		        $dates[] = $startDate->format('Y');
		        $startDate->modify('+1 year');
		    } else {
		        break;
		    }
		}

		// 將日期轉換為正則表達式
		$datePatterns = array_map(function($date) {
		    return preg_quote($date, '/');
		}, $dates);


		//	目錄檔案明確規劃
		$pattern = '';
		/*
			$params['fileType'] = power => 電力
			$params['fileType'] = steam => 蒸汽
			$params['fileType'] = gas => 瓦斯
			$params['fileType'] = water => 水
        */
		// if ( $params['folder'] == 'daily' ) {
		// 	switch ($params['fileType']) {
		// 		case 'power':
		// 			$pattern = '/日報表_電力_(' . implode('|', $datePatterns) . ')\.xlsx/';
		// 			break;
		// 		case 'steam':
		// 			$pattern = '/日報表_蒸汽_(' . implode('|', $datePatterns) . ')\.xlsx/';
		// 			break;
		// 		case 'gas':
		// 			$pattern = '/日報表_瓦斯_(' . implode('|', $datePatterns) . ')\.xlsx/';
		// 			break;
		// 		case 'water':
		// 			$pattern = '/日報表_水_(' . implode('|', $datePatterns) . ')\.xlsx/';
		// 			break;	
		// 		default:			
		// 	}
		// } elseif ( $params['folder'] == 'monthly') {
		// 	switch ($params['fileType']) {
		// 		case 'power':
		// 			$pattern = '/月報表_電力_(' . implode('|', $datePatterns) . ')\.xlsx/';
		// 			break;
		// 		case 'steam':
		// 			$pattern = '/月報表_蒸汽_(' . implode('|', $datePatterns) . ')\.xlsx/';
		// 			break;
		// 		case 'gas':
		// 			$pattern = '/月報表_瓦斯_(' . implode('|', $datePatterns) . ')\.xlsx/';
		// 			break;
		// 		case 'water':
		// 			$pattern = '/月報表_水_(' . implode('|', $datePatterns) . ')\.xlsx/';
		// 			break;	
		// 		default:			
		// 	}
		// } elseif ( $params['folder'] == 'yearly' ) {
		// 	switch ($params['fileType']) {
		// 		case 'power':
		// 			$pattern = '/年報表_電力_(' . implode('|', $datePatterns) . ')\.xlsx/';
		// 			break;
		// 		case 'steam':
		// 			$pattern = '/年報表_蒸汽_(' . implode('|', $datePatterns) . ')\.xlsx/';
		// 			break;
		// 		case 'gas':
		// 			$pattern = '/年報表_瓦斯_(' . implode('|', $datePatterns) . ')\.xlsx/';
		// 			break;
		// 		case 'water':
		// 			$pattern = '/年報表_水_(' . implode('|', $datePatterns) . ')\.xlsx/';
		// 			break;	
		// 		default:			
		// 	}
		// }


		// 20240912 更動
		if ( $params['folder'] == 'daily' ) {
			switch ($params['fileType']) {
				case 'power':
					switch ($params['fileQuantity']) {
						case 'dosage':
							$pattern = '/日報表_電力_用量_(' . implode('|', $datePatterns) . ')\.xlsx/';
							break;
						case 'carbon':
							$pattern = '/日報表_電力_碳排量_(' . implode('|', $datePatterns) . ')\.xlsx/';
							break;
						default:
							break;		
					}
					break;
				case 'steam':
					switch ($params['fileQuantity']) {
						case 'dosage':
							$pattern = '/日報表_蒸汽_用量_(' . implode('|', $datePatterns) . ')\.xlsx/';
							break;
						case 'carbon':
							$pattern = '/日報表_蒸汽_碳排量_(' . implode('|', $datePatterns) . ')\.xlsx/';
							break;
						default:
							break;		
					}
					break;
				case 'gas':
					switch ($params['fileQuantity']) {
						case 'dosage':
							$pattern = '/日報表_瓦斯_用量_(' . implode('|', $datePatterns) . ')\.xlsx/';
							break;
						case 'carbon':
							$pattern = '/日報表_瓦斯_碳排量_(' . implode('|', $datePatterns) . ')\.xlsx/';
							break;
						default:
							break;		
					}
					break;
				case 'water':
					switch ($params['fileQuantity']) {
						case 'dosage':
							$pattern = '/日報表_水_用量_(' . implode('|', $datePatterns) . ')\.xlsx/';
							break;
						case 'carbon':
							$pattern = '/日報表_水_碳排量_(' . implode('|', $datePatterns) . ')\.xlsx/';
							break;
						default:
							break;		
					}
					break;
				default:	
					break;		
			}
		} elseif ( $params['folder'] == 'monthly') {
			switch ($params['fileType']) {
				case 'power':
					switch ($params['fileQuantity']) {
						case 'dosage':
							$pattern = '/月報表_電力_用量_(' . implode('|', $datePatterns) . ')\.xlsx/';
							break;
						case 'carbon':
							$pattern = '/月報表_電力_碳排量_(' . implode('|', $datePatterns) . ')\.xlsx/';
							break;
						default:
							break;		
					}
					break;
				case 'steam':
					switch ($params['fileQuantity']) {
						case 'dosage':
							$pattern = '/月報表_蒸汽_用量_(' . implode('|', $datePatterns) . ')\.xlsx/';
							break;
						case 'carbon':
							$pattern = '/月報表_蒸汽_碳排量_(' . implode('|', $datePatterns) . ')\.xlsx/';
							break;
						default:
							break;		
					}
					break;
				case 'gas':
					switch ($params['fileQuantity']) {
						case 'dosage':
							$pattern = '/月報表_瓦斯_用量_(' . implode('|', $datePatterns) . ')\.xlsx/';
							break;
						case 'carbon':
							$pattern = '/月報表_瓦斯_碳排量_(' . implode('|', $datePatterns) . ')\.xlsx/';
							break;
						default:
							break;		
					}
					break;
				case 'water':
					switch ($params['fileQuantity']) {
						case 'dosage':
							$pattern = '/月報表_水_用量_(' . implode('|', $datePatterns) . ')\.xlsx/';
							break;
						case 'carbon':
							$pattern = '/月報表_水_碳排量_(' . implode('|', $datePatterns) . ')\.xlsx/';
							break;
						default:
							break;		
					}
					break;
				default:	
					break;		
			}
		} elseif ( $params['folder'] == 'yearly' ) {
			switch ($params['fileType']) {
				case 'power':
					switch ($params['fileQuantity']) {
						case 'dosage':
							$pattern = '/年報表_電力_用量_(' . implode('|', $datePatterns) . ')\.xlsx/';
							break;
						case 'carbon':
							$pattern = '/年報表_電力_碳排量_(' . implode('|', $datePatterns) . ')\.xlsx/';
							break;
						default:
							break;		
					}
					break;
				case 'steam':
					switch ($params['fileQuantity']) {
						case 'dosage':
							$pattern = '/年報表_蒸汽_用量_(' . implode('|', $datePatterns) . ')\.xlsx/';
							break;
						case 'carbon':
							$pattern = '/年報表_蒸汽_碳排量_(' . implode('|', $datePatterns) . ')\.xlsx/';
							break;
						default:
							break;		
					}
					break;
				case 'gas':
					switch ($params['fileQuantity']) {
						case 'dosage':
							$pattern = '/年報表_瓦斯_用量_(' . implode('|', $datePatterns) . ')\.xlsx/';
							break;
						case 'carbon':
							$pattern = '/年報表_瓦斯_碳排量_(' . implode('|', $datePatterns) . ')\.xlsx/';
							break;
						default:
							break;		
					}
					break;
				case 'water':
					switch ($params['fileQuantity']) {
						case 'dosage':
							$pattern = '/年報表_水_用量_(' . implode('|', $datePatterns) . ')\.xlsx/';
							break;
						case 'carbon':
							$pattern = '/年報表_水_碳排量_(' . implode('|', $datePatterns) . ')\.xlsx/';
							break;
						default:
							break;		
					}
					break;
				default:	
					break;					
			}
		}

		// print_r( $pattern);
		//	完整檔案路徑
		$fileLinks = array();
		//	資料夾路徑
		$folderPath = "../../hsintungyang_excel/".$params['folder']; 
		//	檔案類型 
		$files = glob($folderPath . '/*.xlsx');	
		if ($files !== false) {
			// 篩選檔案
			$filterFiles = array_filter($files, function($file) use ($pattern) {
			    // 取得所有檔案名稱
			    $allFilename = basename($file);
			    
			    // 使用正則表達式進行匹配
			    return preg_match($pattern, $allFilename);
			});
			// print_r( $filterFiles);
			$resultObjects = array(); // 建立空陣列用於存放物件
			// 輸出結果
			foreach ($filterFiles as $file) {
				// 這裡可以對每個檔案進行處理
				$fileName = $this->mb_basename($file);
				// 將陣列元素轉換為物件並存入物件陣列
				$object = new stdClass();
				$object->FileName = $fileName;
				$object->FileUrl = $file;
				$resultObjects[] = $object;
			}
		} else {
			echo "找不到符合條件的檔案";
		}
		return $resultObjects;
	}

	//	小郭：我忘記這是什麼了
	private function mb_basename($path) {
		// 將路徑的字符編碼轉換為 UTF-8
		$filename = iconv(mb_detect_encoding($path, mb_detect_order(), true), 'UTF-8', $path);
		// 使用正則表達式去掉路徑中的目錄部分，只保留檔案名稱
		$filename = preg_replace('@^.*/@', '', $filename);
		// 返回檔案名稱
		return $filename;
	}

	
}
