<?php
// 頁面專用WebAPI, 不管任何的頁面, class名稱固定為 [WebAPIForMenuPage], 不可變更
class WebAPIForMenuPage extends base_class
{


	//樹狀圖即時資料顯示用
	public function SelectLoadPageData($params)
	{


		//指定ID資料
		$s_id_list = (string) $params["id_list"];
		$s_id_list = trim($s_id_list);

		//設定查詢時間
		//資料結束時間 (預設當天23:59:59
		$s_end_time = date("Y-m-d 23:59:59");
		//當天起始時間
		$s_day_start_time = date("Y-m-d 00:00:00");
		//當月起始時間
		$s_month_start_time = date("Y-m-01 00:00:00");

		//區域條件設定
		$s_where_cte = "";
		$s_where_cte_2 = "";
		$s_where_tid = "";
		if ($s_id_list != "") {
			$s_where_cte = " AND _rp.ID IN ($s_id_list) ";
			$s_where_tid = " AND _sf.Tid IN ($s_id_list) ";
			$s_where_cte_2 = " AND _rpd.id IN ($s_id_list)";
		}

		$sql = "WITH 
					pm_day_date AS (
						SELECT DISTINCT
							ID,
							(
							SELECT TOP
								1 kw 
							FROM
								R_PM  WITH (NOLOCK)
							WHERE
								ID = _rp.ID 
								AND DATE_TIME BETWEEN '$s_day_start_time' AND '$s_end_time' 
							ORDER BY
								DATE_TIME DESC 
							) AS MAX_Kw 
						FROM
							[dbo].[R_PM] AS _rp  WITH (NOLOCK)
						WHERE
							_rp.DATE_TIME BETWEEN '$s_day_start_time' AND '$s_end_time' 
							$s_where_cte
				) SELECT
				_sf.Tid AS ID,
				ISNULL(_pdd.MAX_Kw,0) AS now_max_kw 
				FROM
					[dbo].[surface] AS _sf
					LEFT JOIN pm_day_date AS _pdd ON _pdd.ID = _sf.Tid		
				WHERE
					_sf.Tclass = 'PM'
					$s_where_tid 
				ORDER BY 
					_sf.Tid ASC;";
		// return $sql;
		$res = [];
		if ($this->pdo_hty != null) {
			$sth = $this->pdo_hty->prepare($sql);
			$sth->execute([]);
			$res = $sth->fetchAll(PDO::FETCH_ASSOC);
			// foreach ($res as $k => &$v) {
			// 	$v["now_max_kw"] = number_format($v["now_max_kw"], 2,".","");
			// }
		}


		$sql = sprintf("SELECT DISTINCT
							id AS [ID],
							ISNULL((
								SELECT incr_kwh
								FROM [%s].[dbo].[R_PM_daily] WITH (NOLOCK)
								WHERE id = _rpd.id AND date_stamp BETWEEN '$s_day_start_time' AND '$s_end_time' 
							),0) AS today_kwh,
							ISNULL((
								SELECT SUM(incr_kwh) 
								FROM [%s].[dbo].[R_PM_daily] WITH (NOLOCK)
								WHERE id = _rpd.id AND date_stamp BETWEEN '$s_month_start_time' AND '$s_end_time' 
								GROUP BY id
							),0) AS month_kwh
						FROM [%s].[dbo].[R_PM_daily] AS _rpd
						WHERE _rpd.date_stamp BETWEEN '$s_month_start_time' AND '$s_end_time' $s_where_cte_2 
						", $this->database_alarm, $this->database_alarm, $this->database_alarm);
		$sth = $this->pdo_sql->prepare($sql);
  		$sth->execute();
  		$today_month_data = $sth->fetchAll(PDO::FETCH_ASSOC);


  		// $mergedArray = array_map(function($item1) use ($today_month_data) {
		//     foreach ($today_month_data as $item2) {
		//         if ($item1['ID'] == $item2['ID']) {
		//             return array_merge($item1, $item2);
		//         }
		//     }
		//     return $item1;
		// }, $res);

		$mergedArray = array_map(function($item1) use ($res) {
		    foreach ($res as $item2) {
		        if ($item1['ID'] == $item2['ID']) {
		            return array_merge($item1, $item2);
		        }
		    }
		    return $item1;
		}, $today_month_data);

		return $mergedArray;
	}
}
