<?php
error_reporting(E_ALL & ~(E_NOTICE | E_WARNING)); // 關閉警示及錯誤訊息
// 允許跨網域呼叫
header("Access-Control-Allow-Origin: *");
// 防止session file lock
session_write_close();
require_once("Parameters.php");

$BasePath = str_replace("\\", "/", pathinfo(__FILE__, PATHINFO_DIRNAME));
$output = array();
// for 即時點位
$tagDef = array();
if (isset($_GET["tagDef"])) {
	$tagDef = explode(",", trim($_GET["tagDef"]));
}
foreach ($tagDef as $fn) {
	$file = sprintf("%s/../cfg/%s.csv", $BasePath, $fn);
	if (!is_file($file)) {
		continue;
	}
	$csv_rows = getBaseFile($file);
	$captions = array_shift($csv_rows);
	$output[$fn] = array();
	foreach ($csv_rows as $row) {
		$output[$fn][] = array(
			"Name"    => $row[0],
			"Soft"    => $row[1],
			"Type"    => $row[2],
			"Decimal" => $row[3],
			"Keyin"   => $row[4],
			"Desc"    => $row[5],
			"Unit"    => $row[6],
			"Icon"    => !in_array($row[2], array("data")) ? explode(";", $row[7]) : $row[7],
			"Class"   => in_array($row[2], array("text", "light")) ? explode(";", $row[8]) : $row[8],
		);
	}
}
// for 即時點位
$MQTT = array();
if (isset($_GET["MQTT"])) {
	$MQTT = explode(",", trim($_GET["MQTT"]));
}
foreach ($MQTT as $fn) {
	$file = sprintf("%s/../cfg/%s.csv", $BasePath, $fn);
	if (!is_file($file)) {
		continue;
	}
	$csv_rows = getBaseFile($file);
	$captions = array_shift($csv_rows);
	$output[$fn] = array();
	foreach ($csv_rows as $row) {
		$output[$fn][] = array(
			"Name"    => $row[0],
			"Soft"    => $row[1],
			"Type"    => $row[2],
			"Decimal" => $row[3],
			"Keyin"   => $row[4],
			"Desc"    => $row[5],
			"Unit"    => $row[6],
			"Icon"    => !in_array($row[2], array("data")) ? explode(";", $row[7]) : $row[7],
			"Class"   => in_array($row[2], array("text", "light")) ? explode(";", $row[8]) : $row[8],
		);
	}
}
// for 即時chart
$chart = array();
if (isset($_GET["chart"])) {
	$chart = explode(",", trim($_GET["chart"]));
}
foreach ($chart as $fn) {
	$file = sprintf("%s/../cfg/%s.csv", $BasePath, $fn);
	if (!is_file($file)) {
		continue;
	}
	$csv_rows = getBaseFile($file);
	$captions = array_shift($csv_rows);
	$output[$fn] = array();
	foreach ($csv_rows as $row) {
		$output[$fn][] = array(
			"Name"    => $row[0],
			"Soft"    => explode(";", $row[1]),
			"Type"    => $row[2],
			"Decimal" => $row[3],
			"Keyin"   => $row[4],
			"Desc"    => explode(";", $row[5]),
			"Unit"    => $row[6],
			"Icon"    => explode(";", $row[7]),
			"Class"   => explode(";", $row[8]),
		);
	}
	/*
	foreach ($csv_rows as $row) {
		$output[$fn][] = array(
			"Name" => $row[0],
			"Soft" => $row[1],
			"Type" => $row[2],
			"Decimal" => $row[3],
			"Keyin" => $row[4],
			"Unit" => $row[5],
			"Desc" => $row[6],
			"Relay" => $row[7],
			"Title" => $row[8],
			"Color" => $row[9],
			"Timer" => $row[10],
			"Width" => $row[11],
			"Height" => $row[12],
			"ScaleMax" => $row[13],
			"ScaleMin" => $row[14],
			"Ranges" => array(
				array("Low" => $row[15], "High" => $row[16]),
				array("Low" => $row[17], "High" => $row[18]),
				array("Low" => $row[19], "High" => $row[20])
			)
		);
	}
	*/
}

die(json_encode($output));
