const device_item = {
	// ================================================ 電力 ================================================
	"電力": {
		"電力系統": {
			"tableName": "R_PM",
			"options": [
				{"label": "發電機", "value": "發電機"},
				{"label": "儲能設備", "value": "儲能設備"},
				{"label": "照明", "value": "照明"},
				{"label": "冷凍空調", "value": "冷凍空調"},
				{"label": "製程動力", "value": "製程動力"},
				{"label": "通風", "value": "通風"},
				{"label": "空壓", "value": "37"},
				{"label": "公用設備", "value": "公用設備"},
				{"label": "其他", "value": "其他"},
			],
		},
		"照明": {
			"tableName": "R_PM",
			"options": [
				{"label": "1LA 西式調理區照明", "value": "23"},
				{"label": "1LB 209月台照明", "value": "22"},
				{"label": "1LC 蒸煮區照明", "value": "21"},
				{"label": "1LD 烘烤區照明", "value": "20"},
				{"label": "1LE 罐頭加工區照明", "value": "19"},
				{"label": "1LF 肉品包裝、中西照明", "value": "32"},
				{"label": "1LG 物資倉庫照明", "value": "33"},
				{"label": "1LH 糕餅中西整型區照明", "value": "34"},
				{"label": "1LI 1樓照明", "value": "35"},
				{"label": "1ELA 1F緊急電源", "value": "15"},
				{"label": "2LA 2F辦公區照明", "value": "24"},
				{"label": "2LB 2F右餐廳照明", "value": "31"},
				{"label": "2LC 2F左員工活動中心", "value": "30"},
				{"label": "2EL 2F緊急電源、中控室", "value": "14"},
			]
		},
		"冷凍空調": {
			"tableName": "R_PM",
			"options": [
				{"label": "BIP空調專用-地下室冰水泵", "value": "17"},
				{"label": "蒸發冷凝器", "value": "18"},
				{"label": "GRAM主機-頂樓肉乾胚冷凍庫", "value": "61"},
				{"label": "1PI糕餅冷凍庫", "value": "55"},
				{"label": "EPA一期冷凍庫控制盤", "value": "38"},
				{"label": "2°C冷凍主機包裝冷凍庫", "value": "9"},
				{"label": "空調冷藏系統ACMP", "value": "65"},
				{"label": "物資冷凍庫RFMPC", "value": "68"},
				{"label": "MCC", "value": "16"},
				{"label": "A倉冷凍庫總用電", "value": "10"},
			]
		},
		"MCC": {
			"tableName": "R_PM",
			"options": [
				{"label": "空調主機#1", "value": "3"},
				{"label": "空調主機#2", "value": "4"},
				{"label": "空調主機#3", "value": "5"},
				{"label": "空調主機#4", "value": "6"},
			]
		},
		"A倉冷凍庫總用電": {
			"tableName": "R_PM",
			"options": [
				{"label": "冷凍主機#1", "value": "11"},
				{"label": "冷凍主機#2", "value": "12"},
				{"label": "冷凍主機#3", "value": "13"},
			]
		},
		// new
		"空調冷藏系統ACMP": {
			"tableName": "R_PM",
			"options": [
				{"label": "空調主機RFMPP", "value": "66"},
				{"label": "低溫空調APMP-1", "value": "656667"}, // 特殊id
				{"label": "大冷藏庫RFMPB", "value": "67"},
			]
		},
		"製程動力": {
			"tableName": "R_PM",
			"options": [
				{"label": "中式生產線", "value": "中式生產線"},
				{"label": "西式生產線", "value": "西式生產線"},
				{"label": "糕餅生產線", "value": "糕餅生產線"},
				{"label": "包裝生產線", "value": "包裝生產線"},
				{"label": "燒臘生產線", "value": "燒臘生產線"},
			]
		},
		"製程動力detail": {	//	tingy：用來system_power顯示製程動力家加總
			"tableName": "R_PM",
			"options": [
				{"label": "1PC蒸煮區", "value": "44"},
				{"label": "1PE罐頭封罐機、遠紅外線", "value": "58"},
				{"label": "1PG罐頭加工區、殺菌釜", "value": "54"},
				{"label": "1PE-1金瑛發煮鍋、吊車", "value": "52"},
				{"label": "BLP大地下室", "value": "51"},
				{"label": "緊急動力電源台電ATS", "value": "60"},
				{"label": "醬油槽區", "value": "43"},
				{"label": "1PA大調理區", "value": "46"},
				{"label": "1PB切割區", "value": "45"},
				{"label": "1PD烘烤區1", "value": "57"},
				{"label": "EPB烘烤室3Ø220V電源", "value": "62"},
				{"label": "1PJ糕餅調理室", "value": "59"},
				{"label": "1PK糕餅瓦斯隧道爐", "value": "50"},
				{"label": "1PL糕餅走道", "value": "49"},
				{"label": "1PM糕餅旋轉烤爐", "value": "48"},
				{"label": "1PF香腸包裝區", "value": "53"},
				{"label": "RAC5肉鬆包裝區", "value": "29"},
				{"label": "脆片包裝作業區", "value": "47"},
				{"label": "MP滷味廠", "value": "36"},
			]
		},
		"中式生產線": {
			"tableName": "R_PM",
			"options": [
				{"label": "1PC蒸煮區", "value": "44"},
				{"label": "1PE罐頭封罐機、遠紅外線", "value": "58"},
				{"label": "1PG罐頭加工區、殺菌釜", "value": "54"},
				{"label": "1PE-1金瑛發煮鍋、吊車", "value": "52"},
				{"label": "BLP大地下室", "value": "51"},
				{"label": "緊急動力電源台電ATS", "value": "60"},
				{"label": "醬油槽區", "value": "43"},
			]
		},
		"西式生產線": {
			"tableName": "R_PM",
			"options": [
				{"label": "1PA大調理區", "value": "46"},
				{"label": "1PB切割區", "value": "45"},
				{"label": "1PD烘烤區1", "value": "57"},
				{"label": "EPB烘烤室3Ø220V電源", "value": "62"},
			]
		},
		"糕餅生產線": {
			"tableName": "R_PM",
			"options": [
				{"label": "1PJ糕餅調理室", "value": "59"},
				{"label": "1PK糕餅瓦斯隧道爐", "value": "50"},
				{"label": "1PL糕餅走道", "value": "49"},
				{"label": "1PM糕餅旋轉烤爐", "value": "48"},
			]
		},
		"包裝生產線": {
			"tableName": "R_PM",
			"options": [
				{"label": "1PF香腸包裝區", "value": "53"},
				{"label": "RAC5肉鬆包裝區", "value": "29"},
				{"label": "脆片包裝作業區", "value": "47"},
			]
		},
		"燒臘生產線": {
			"tableName": "R_PM",
			"options": [
				{"label": "MP滷味廠", "value": "36"},
			]
		},
		"通風": {
			"tableName": "R_PM",
			"options": [
				{"label": "RAC7糕餅頂層排風機", "value": "56"},
				{"label": "RAC6烘烤區排風機", "value": "28"},
				{"label": "RAC2蒸煮區排風機", "value": "25"},
			]
		},
		"空壓": {
			"tableName": "R_PM",
			"options": [
				// {"label": "空壓", "value": "37"},
				{"label": "空壓機#1", "value": "7"},
				{"label": "空壓機#2", "value": "8"},
			]
		},
		"公用設備": {
			"tableName": "R_PM",
			"options": [
				{"label": "EBP水處理專用", "value": "40"},
				{"label": "宿舍", "value": "42"},
				{"label": "A倉", "value": "2610"}, // 特殊id
				{"label": "B倉", "value": "27"},
				{"label": "BP鍋爐機房", "value": "41"},
				{"label": "PLI工務周邊", "value": "39"},
			]
		},
		"PLI工務周邊": {
			"tableName": "R_PM",
			"options": [
				{"label": "汙水", "value": "2"},
			]
		},
		"其他": {
			"tableName": "R_PM",
			"options": [
				{"label": "插座", "value": "插座"},
			]
		},
		"插座": {
			"tableName": "R_PM",
			"options": [
				{"label": "1PAA站110V插座", "value": "63"},
				{"label": "RP2B站110V插座", "value": "64"},
			]
		},
	},
	// ================================================ 蒸汽 ================================================
	"蒸汽": {
		"蒸汽總管線": {
			"tableName": "R_SM",
			"options": [
				{"label": "蒸煮室", "value": "蒸煮室"},
				{"label": "罐頭加工室", "value": "罐頭加工室"},
				{"label": "肉品烘烤室", "value": "肉品烘烤室"},
				// {"label": "燒臘區", "value": "燒臘區"},
				{"label": "屋頂", "value": "屋頂"},
				{"label": "熟食包裝室", "value": "熟食包裝室"},
				{"label": "糕餅調理室", "value": "糕餅調理室"},
			]
		},
		"燒臘區蒸汽總管線": {
			"tableName": "R_SM",
			"options": [
				{"label": "蒸煮鍋", "value": "16"},
			]
		},
		"蒸煮室": {
			"tableName": "R_SM",
			"options": [
				{"label": "罐頭煮釜", "value": "2"},
				{"label": "二重鍋", "value": "3"},
				{"label": "四方煮鍋", "value": "4"},
				{"label": "肉鬆炒鍋", "value": "5"},
			]
		},
		"罐頭加工室": {
			"tableName": "R_SM",
			"options": [
				{"label": "遠紅外線", "value": "6"},
				{"label": "殺菌釜NO.1", "value": "7"},
				{"label": "殺菌釜NO.2", "value": "8"},
				{"label": "殺菌釜NO.3", "value": "9"},
				{"label": "殺菌釜NO.4", "value": "10"},
			]
		},
		"肉品烘烤室": {
			"tableName": "R_SM",
			"options": [
				{"label": "Vemag隧道燻煙爐", "value": "11"},
				{"label": "Fessmann多功能爐", "value": "12"},
				{"label": "Fessmann多功能爐", "value": "13"},
				{"label": "宣柏蒸煮爐", "value": "14"},
				{"label": "KOCH乾燥爐", "value": "15"},
			]
		},
		// "燒臘區": {
		// 	"tableName": "R_SM",
		// 	"options": [
		// 		{"label": "蒸煮鍋", "value": "16"},
		// 	]
		// },
		"屋頂": {
			"tableName": "R_SM",
			"options": [
				{"label": "熱水槽", "value": "17"},
			]
		},
		"熟食包裝室": {
			"tableName": "R_SM",
			"options": [
				{"label": "殺菌槽", "value": "18"},
			]
		},
		"糕餅調理室": {
			"tableName": "R_SM",
			"options": [
				{"label": "炒焰鍋", "value": "19"},
			]
		},
	},
	// ================================================ 瓦斯 ================================================
	"瓦斯": {
		"瓦斯LPG總管": {
			"tableName": "R_GM",
			"options": [
				{"label": "肉品烘烤室", "value": "肉品烘烤室"},
				{"label": "蒸煮室", "value": "蒸煮室"},
				{"label": "西點烘培室", "value": "西點烘培室"},
				{"label": "廚房", "value": "廚房"},
				{"label": "燒臘區", "value": "10"},
				{"label": "中點調理室", "value": "中點調理室"},
			]
		},
		"天燃氣瓦斯": {
			"tableName": "R_GM",
			"options": [
				{"label": "燃氣發電機", "value": "12"},
			]
		},
		"肉品烘烤室": {
			"tableName": "R_GM",
			"options": [
				{"label": "炒肉鬆機", "value": "2"},
				{"label": "肉乾隧道烤爐", "value": "3"},
				{"label": "肉乾乾燥爐NO.1", "value": "4"},
				{"label": "肉乾乾燥爐NO.2", "value": "5"},
			]
		},
		"蒸煮室": {
			"tableName": "R_GM",
			"options": [
				{"label": "炒牛肉", "value": "6"},
				{"label": "炸豬油鍋", "value": "炸豬油鍋"},
			]
		},
		"西點烘培室": {
			"tableName": "R_GM",
			"options": [
				{"label": "瓦斯隧道爐(舊)", "value": "7"},
				{"label": "瓦斯隧道爐(新)", "value": "8"},
				{"label": "旋風烤爐", "value": "9"},
			]
		},
		"中點調理室": {
			"tableName": "R_GM",
			"options": [
				{"label": "炒焰鍋", "value": "11"},
			]
		},
	},
	// ================================================ 水 ================================================
	"水": {
		"水系統": {
			"tableName": "R_WM",
			"options": [
				{"label": "一期屋頂", "value": "一期屋頂"},
				{"label": "淨水房", "value": "淨水房"},
				{"label": "小地下室", "value": "小地下室"},
				{"label": "廢水區", "value": "廢水區"},
			]
		},
		"一期屋頂": {
			"tableName": "R_WM",
			"options": [
				{"label": "屋頂熱水槽出水", "value": "1"},
				{"label": "屋頂蒸汽冷凝水回收", "value": "2"},
				{"label": "屋頂燒臘生飲水", "value": "3"},
				{"label": "屋頂一般水", "value": "4"},
			]
		},
		"淨水房": {
			"tableName": "R_WM",
			"options": [
				{"label": "自來水總表", "value": "5"},
				{"label": "300T--100T蓄水池", "value": "6"},
				{"label": "宿舍用水", "value": "7"},
				{"label": "軟化水", "value": "8"},
			]
		},
		"小地下室": {
			"tableName": "R_WM",
			"options": [
				{"label": "100T--10T一般水槽", "value": "9"},
				{"label": "100T--地下室生飲水", "value": "10"},
				{"label": "生飲水槽--10T屋頂生飲水槽", "value": "11"},
				{"label": "消防水", "value": "12"},
			]
		},
		"廢水區": {
			"tableName": "R_WM",
			"options": [
				{"label": "閥基及回收水", "value": "13"},
				{"label": "廢水流量計", "value": "14"},
				{"label": "SS監測儀", "value": "15"},
			]
		},
		// ------------ new ------------
		"自來水總表": {
			"tableName": "R_WM",
			"options": [
				{"label": "淨水房35噸儲水槽", "value": "淨水房35噸儲水槽"},
				{"label": "地上300噸儲水槽", "value": "地上300噸儲水槽"},
			]
		},
		"淨水房35噸儲水槽": {
			"tableName": "R_WM",
			"options": [
				{"label": "宿舍用水", "value": "7"},
			]
		},
		"地上300噸儲水槽": {
			"tableName": "R_WM",
			"options": [
				{"label": "地下100噸儲水槽進水", "value": "6"},
			]
		},
		"地下100噸儲水槽進水": {
			"tableName": "R_WM",
			"options": [
				{"label": "生飲水處理槽", "value": "10"},
				{"label": "消防水", "value": "12"},
				{"label": "屋頂10噸儲水槽", "value": "4"},
			]
		},
		"生飲水處理槽": {
			"tableName": "R_WM",
			"options": [
				{"label": "頂樓10噸生飲水進水", "value": "11"},
			]
		},
		"頂樓10噸生飲水進水": {
			"tableName": "R_WM",
			"options": [
				{"label": "屋頂燒臘生飲水", "value": "3"},
			]
		},
		"屋頂10噸儲水槽": {
			"tableName": "R_WM",
			"options": [
				{"label": "屋頂熱水出水", "value": "1"},
				{"label": "殺菌釜進水", "value": "16"},
			]
		},
		"屋頂熱水出水": {
			"tableName": "R_WM",
			"options": [
				{"label": "屋頂蒸汽冷凝水回收", "value": "2"},
			]
		},
		"殺菌釜進水": {
			"tableName": "R_WM",
			"options": [
				{"label": "殺菌釜回收水", "value": "17"},
			]
		},
		"廢水處理": {
			"tableName": "R_WM",
			"options": [
				{"label": "廢水排放水", "value": "14"},
				{"label": "筏基回收水", "value": "13"},
			]
		},
		"筏基回收水": {
			"tableName": "R_WM",
			"options": [
				{"label": "地上50噸X2回收水儲水槽", "value": "地上50噸X2回收水儲水槽"},
			]
		},
		"地上50噸X2回收水儲水槽": {
			"tableName": "R_WM",
			"options": [
				{"label": "馬桶沖廁", "value": "馬桶沖廁"},
				{"label": "軟水處理", "value": "8"},
			]
		},
	},
};

const device_item_bar = {
	// ================================================ 電力 ================================================
	"電力": {
		"電力系統": {
			"tableName": "R_PM",
			"options": [
				{"label": "電力系統", "value": "1", "from_page": "system_power.php"},
				{"label": "空壓", "value": "37"}
			],
		},
		"照明": {
			"tableName": "R_PM",
			"options": [
				{"label": "1LA 西式調理區照明", "value": "23"},
				{"label": "1LB 209月台照明", "value": "22"},
				{"label": "1LC 蒸煮區照明", "value": "21"},
				{"label": "1LD 烘烤區照明", "value": "20"},
				{"label": "1LE 罐頭加工區照明", "value": "19"},
				{"label": "1LF 肉品包裝、中西照明", "value": "32"},
				{"label": "1LG 物資倉庫照明", "value": "33"},
				{"label": "1LH 糕餅中西整型區照明", "value": "34"},
				{"label": "1LI 1樓照明", "value": "35"},
				{"label": "1ELA 1F緊急電源", "value": "15"},
				{"label": "2LA 2F辦公區照明", "value": "24"},
				{"label": "2LB 2F右餐廳照明", "value": "31"},
				{"label": "2LC 2F左員工活動中心", "value": "30"},
				{"label": "2EL 2F緊急電源、中控室", "value": "14"},
			]
		},
		"冷凍空調": {
			"tableName": "R_PM",
			"options": [
				{"label": "BIP空調專用-地下室冰水泵", "value": "17"},
				{"label": "蒸發冷凝器", "value": "18"},
				{"label": "GRAM主機-頂樓肉乾胚冷凍庫", "value": "61"},
				{"label": "1PI糕餅冷凍庫", "value": "55"},
				{"label": "EPA一期冷凍庫控制盤", "value": "38"},
				{"label": "2°C冷凍主機包裝冷凍庫", "value": "9"},
				{"label": "空調冷藏系統ACMP", "value": "65"}, // 空調主機 65
				{"label": "物資冷凍庫RFMPC", "value": "68"}, // 冷凍主機 66
				{"label": "MCC", "value": "16"},
				{"label": "A倉冷凍庫總用電", "value": "10"},
			]
		},
		"MCC": {
			"tableName": "R_PM",
			"options": [
				{"label": "空調主機#1", "value": "3"},
				{"label": "空調主機#2", "value": "4"},
				{"label": "空調主機#3", "value": "5"},
				{"label": "空調主機#4", "value": "6"},
			]
		},
		"A倉冷凍庫總用電": {
			"tableName": "R_PM",
			"options": [
				{"label": "冷凍主機#1", "value": "11"},
				{"label": "冷凍主機#2", "value": "12"},
				{"label": "冷凍主機#3", "value": "13"},
			]
		},
		// new
		"空調冷藏系統ACMP": {
			"tableName": "R_PM",
			"options": [
				{"label": "空調主機RFMPP", "value": "66"},
				{"label": "低溫空調APMP-1", "value": "656667"}, // 特殊id
				{"label": "大冷藏庫RFMPB", "value": "67"},
			]
		},
		"製程動力": {
			"tableName": "R_PM",
			"options": [
				{"label": "中式生產線", "value": "中式生產線"},
				{"label": "西式生產線", "value": "西式生產線"},
				{"label": "糕餅生產線", "value": "糕餅生產線"},
				{"label": "包裝生產線", "value": "包裝生產線"},
				{"label": "燒臘生產線", "value": "燒臘生產線"},
			]
		},
		"製程動力detail": {	//	tingy：用來system_power顯示製程動力家加總
			"tableName": "R_PM",
			"options": [
				{"label": "1PC蒸煮區", "value": "44"},
				{"label": "1PE罐頭封罐機、遠紅外線", "value": "58"},
				{"label": "1PG罐頭加工區、殺菌釜", "value": "54"},
				{"label": "1PE-1金瑛發煮鍋、吊車", "value": "52"},
				{"label": "BLP大地下室", "value": "51"},
				{"label": "緊急動力電源台電ATS", "value": "60"},
				{"label": "醬油槽區", "value": "43"},
				{"label": "1PA大調理區", "value": "46"},
				{"label": "1PB切割區", "value": "45"},
				{"label": "1PD烘烤區1", "value": "57"},
				{"label": "EPB烘烤室3Ø220V電源", "value": "62"},
				{"label": "1PJ糕餅調理室", "value": "59"},
				{"label": "1PK糕餅瓦斯隧道爐", "value": "50"},
				{"label": "1PL糕餅走道", "value": "49"},
				{"label": "1PM糕餅旋轉烤爐", "value": "48"},
				{"label": "1PF香腸包裝區", "value": "53"},
				{"label": "RAC5肉鬆包裝區", "value": "29"},
				{"label": "脆片包裝作業區", "value": "47"},
				{"label": "MP滷味廠", "value": "36"},
			]
		},
		"中式生產線": {
			"tableName": "R_PM",
			"options": [
				{"label": "1PC蒸煮區", "value": "44"},
				{"label": "1PE罐頭封罐機、遠紅外線", "value": "58"},
				{"label": "1PG罐頭加工區、殺菌釜", "value": "54"},
				{"label": "1PE-1金瑛發煮鍋、吊車", "value": "52"},
				{"label": "BLP大地下室", "value": "51"},
				{"label": "緊急動力電源台電ATS", "value": "60"},
				{"label": "醬油槽區", "value": "43"},
			]
		},
		"西式生產線": {
			"tableName": "R_PM",
			"options": [
				{"label": "1PA大調理區", "value": "46"},
				{"label": "1PB切割區", "value": "45"},
				{"label": "1PD烘烤區1", "value": "57"},
				{"label": "EPB烘烤室3Ø220V電源", "value": "62"},
			]
		},
		"糕餅生產線": {
			"tableName": "R_PM",
			"options": [
				{"label": "1PJ糕餅調理室", "value": "59"},
				{"label": "1PK糕餅瓦斯隧道爐", "value": "50"},
				{"label": "1PL糕餅走道", "value": "49"},
				{"label": "1PM糕餅旋轉烤爐", "value": "48"},
			]
		},
		"包裝生產線": {
			"tableName": "R_PM",
			"options": [
				{"label": "1PF香腸包裝區", "value": "53"},
				{"label": "RAC5肉鬆包裝區", "value": "29"},
				{"label": "脆片包裝作業區", "value": "47"},
			]
		},
		"燒臘生產線": {
			"tableName": "R_PM",
			"options": [
				{"label": "MP滷味廠", "value": "36"},
			]
		},
		"通風": {
			"tableName": "R_PM",
			"options": [
				{"label": "RAC7糕餅頂層排風機", "value": "56"},
				{"label": "RAC6烘烤區排風機", "value": "28"},
				{"label": "RAC2蒸煮區排風機", "value": "25"},
			]
		},
		"空壓": {
			"tableName": "R_PM",
			"options": [
				// {"label": "空壓", "value": "37"},
				{"label": "空壓機#1", "value": "7"},
				{"label": "空壓機#2", "value": "8"},
			]
		},
		"公用設備": {
			"tableName": "R_PM",
			"options": [
				{"label": "EBP水處理專用", "value": "40"},
				{"label": "宿舍", "value": "42"},
				{"label": "A倉", "value": "2610"}, // 特殊id
				{"label": "B倉", "value": "27"},
				{"label": "BP鍋爐機房", "value": "41"},
				{"label": "PLI工務周邊", "value": "39"},
			]
		},
		"PLI工務周邊": {
			"tableName": "R_PM",
			"options": [
				{"label": "汙水", "value": "2"},
			]
		},
		"其他": {
			"tableName": "R_PM",
			"options": [
				{"label": "插座", "value": "插座"},
			]
		},
		"插座": {
			"tableName": "R_PM",
			"options": [
				{"label": "1PAA站110V插座", "value": "63"},
				{"label": "RP2B站110V插座", "value": "64"},
			]
		},
	},
	// ================================================ 蒸汽 ================================================
	"蒸汽": {
		"蒸汽總管線": {
			"tableName": "R_SM",
			"options": [
				{"label": "蒸汽總管線", "value": "1", "from_page": "system_steam.php"},
			]
		},
		"燒臘區蒸汽總管線": {
			"tableName": "R_SM",
			"options": [
				{"label": "蒸煮鍋", "value": "16"},
			]
		},
		"蒸煮室": {
			"tableName": "R_SM",
			"options": [
				{"label": "罐頭煮釜", "value": "2"},
				{"label": "二重鍋", "value": "3"},
				{"label": "四方煮鍋", "value": "4"},
				{"label": "肉鬆炒鍋", "value": "5"},
			]
		},
		"罐頭加工室": {
			"tableName": "R_SM",
			"options": [
				{"label": "遠紅外線", "value": "6"},
				{"label": "殺菌釜NO.1", "value": "7"},
				{"label": "殺菌釜NO.2", "value": "8"},
				{"label": "殺菌釜NO.3", "value": "9"},
				{"label": "殺菌釜NO.4", "value": "10"},
			]
		},
		"肉品烘烤室": {
			"tableName": "R_SM",
			"options": [
				{"label": "Vemag隧道燻煙爐", "value": "11"},
				{"label": "Fessmann多功能爐", "value": "12"},
				{"label": "Fessmann多功能爐", "value": "13"},
				{"label": "宣柏蒸煮爐", "value": "14"},
				{"label": "KOCH乾燥爐", "value": "15"},
			]
		},
		"屋頂": {
			"tableName": "R_SM",
			"options": [
				{"label": "熱水槽", "value": "17"},
			]
		},
		"熟食包裝室": {
			"tableName": "R_SM",
			"options": [
				{"label": "殺菌槽", "value": "18"},
			]
		},
		"糕餅調理室": {
			"tableName": "R_SM",
			"options": [
				{"label": "炒焰鍋", "value": "19"},
			]
		},
	},
	// ================================================ 瓦斯 ================================================
	"瓦斯": {
		"瓦斯LPG總管": {
			"tableName": "R_GM",
			"options": [
				{"label": "瓦斯LPG總管", "value": "1", "from_page": "system_gas.php"},
			]
		},
		"天燃氣瓦斯": {
			"tableName": "R_GM",
			"options": [
				{"label": "燃氣發電機", "value": "12"},
			]
		},
		"肉品烘烤室": {
			"tableName": "R_GM",
			"options": [
				{"label": "炒肉鬆機", "value": "2"},
				{"label": "肉乾隧道烤爐", "value": "3"},
				{"label": "肉乾乾燥爐NO.1", "value": "4"},
				{"label": "肉乾乾燥爐NO.2", "value": "5"},
			]
		},
		"蒸煮室": {
			"tableName": "R_GM",
			"options": [
				{"label": "炒牛肉", "value": "6"},
				{"label": "炸豬油鍋", "value": "炸豬油鍋"},
			]
		},
		"西點烘培室": {
			"tableName": "R_GM",
			"options": [
				{"label": "瓦斯隧道爐(舊)", "value": "7"},
				{"label": "瓦斯隧道爐(新)", "value": "8"},
				{"label": "旋風烤爐", "value": "9"},
			]
		},
		// "廚房": {
		// 	"tableName": "R_GM",
		// 	"options": [
		// 		{"label": "廚房", "value": "廚房"},
		// 	]
		// },
		"燒臘區": {
			"tableName": "R_GM",
			"options": [
				{"label": "燒臘區", "value": "10"},
			]
		},
		"中點調理室": {
			"tableName": "R_GM",
			"options": [
				{"label": "炒焰鍋", "value": "11"},
			]
		},
	},
	// ================================================ 水 ================================================
	"水": {
		"水系統": {
			"tableName": "R_WM",
			"options": [
				{"label": "一期屋頂", "value": "一期屋頂"},
				{"label": "淨水房", "value": "淨水房"},
				{"label": "小地下室", "value": "小地下室"},
				{"label": "廢水區", "value": "廢水區"},
			]
		},
		"一期屋頂": {
			"tableName": "R_WM",
			"options": [
				{"label": "屋頂熱水槽出水", "value": "1"},
				{"label": "屋頂蒸汽冷凝水回收", "value": "2"},
				{"label": "屋頂燒臘生飲水", "value": "3"},
				{"label": "屋頂一般水", "value": "4"},
			]
		},
		"淨水房": {
			"tableName": "R_WM",
			"options": [
				{"label": "自來水總表", "value": "5"},
				{"label": "300T--100T蓄水池", "value": "6"},
				{"label": "宿舍用水", "value": "7"},
				{"label": "軟化水", "value": "8"},
			]
		},
		"小地下室": {
			"tableName": "R_WM",
			"options": [
				{"label": "100T--10T一般水槽", "value": "9"},
				{"label": "100T--地下室生飲水", "value": "10"},
				{"label": "生飲水槽--10T屋頂生飲水槽", "value": "11"},
				{"label": "消防水", "value": "12"},
			]
		},
		"廢水區": {
			"tableName": "R_WM",
			"options": [
				{"label": "閥基及回收水", "value": "13"},
				{"label": "廢水流量計", "value": "14"},
				{"label": "SS監測儀", "value": "15"},
			]
		},
		// ------------ new ------------
		"自來水總表": {
			"tableName": "R_WM",
			"options": [
				{"label": "自來水總表", "value": "5"},
			]
		},
		"淨水房35噸儲水槽": {
			"tableName": "R_WM",
			"options": [
				{"label": "宿舍用水", "value": "7"},
			]
		},
		"地上300噸儲水槽": {
			"tableName": "R_WM",
			"options": [
				{"label": "地下100噸儲水槽進水", "value": "6"},
			]
		},
		"地下100噸儲水槽進水": {
			"tableName": "R_WM",
			"options": [
				{"label": "生飲水處理槽", "value": "10"},
				{"label": "消防水", "value": "12"},
				{"label": "屋頂10噸儲水槽", "value": "4"},
			]
		},
		"生飲水處理槽": {
			"tableName": "R_WM",
			"options": [
				{"label": "頂樓10噸生飲水進水", "value": "11"},
			]
		},
		"頂樓10噸生飲水進水": {
			"tableName": "R_WM",
			"options": [
				{"label": "屋頂燒臘生飲水", "value": "3"},
			]
		},
		"屋頂10噸儲水槽": {
			"tableName": "R_WM",
			"options": [
				{"label": "屋頂熱水出水", "value": "1"},
				{"label": "殺菌釜進水", "value": "16"},
			]
		},
		"屋頂熱水出水": {
			"tableName": "R_WM",
			"options": [
				{"label": "屋頂蒸汽冷凝水回收", "value": "2"},
			]
		},
		"殺菌釜進水": {
			"tableName": "R_WM",
			"options": [
				{"label": "殺菌釜回收水", "value": "17"},
			]
		},
		"廢水處理": {
			"tableName": "R_WM",
			"options": [
				{"label": "廢水排放水", "value": "14"},
				{"label": "筏基回收水", "value": "13"},
			]
		},
		"筏基回收水": {
			"tableName": "R_WM",
			"options": [
				{"label": "地上50噸X2回收水儲水槽", "value": "地上50噸X2回收水儲水槽"},
			]
		},
		"地上50噸X2回收水儲水槽": {
			"tableName": "R_WM",
			"options": [
				{"label": "馬桶沖廁", "value": "馬桶沖廁"},
				{"label": "軟水處理", "value": "8"},
			]
		},
	},
};

// 全廠指標總覽
const meter_index = [
	// 和諧
	{"key": "MI01", "name": "全廠用電指標", "type": "電力", "unit1": "kwh", "unit2": "kg", "tableName": "R_PM", "ID": "1", "ProductionID": ['F-25']},
	{"key": "MI02", "name": "一期冷凍系統能號指標", "type": "電力", "unit1": "kwh", "unit2": "RT", "tableName": "R_PM", "ID": "0", "ProductionID": ['F-01']}, // ID:16
	{"key": "MI03", "name": "遠紅外線乾燥機能耗指標", "type": "蒸汽", "unit1": "kg", "unit2": "kg", "tableName": "R_SM", "ID": "6", "ProductionID": ['M-CAN-15']},
	{"key": "MI04", "name": "迴轉式自動殺菌釜能耗指標-1", "type": "蒸汽", "unit1": "kg", "unit2": "kg", "tableName": "R_SM", "ID": "7", "ProductionID": ['M-CAN-08']},
	{"key": "MI05", "name": "迴轉式自動殺菌釜能耗指標-2", "type": "蒸汽", "unit1": "kg", "unit2": "kg", "tableName": "R_SM", "ID": "8", "ProductionID": ['M-CAN-09']},
	{"key": "MI06", "name": "迴轉式自動殺菌釜能耗指標-3", "type": "蒸汽", "unit1": "kg", "unit2": "kg", "tableName": "R_SM", "ID": "9", "ProductionID": ['M-CAN-38']},
	{"key": "MI09", "name": "瓦斯隧道爐能耗指標B線", "type": "瓦斯", "unit1": "kg", "unit2": "kg", "tableName": "R_GM", "ID": "8", "ProductionID": ['C-BAK-22']},
	{"key": "MI07", "name": "水浴室殺菌釜能耗指標-4", "type": "蒸汽", "unit1": "kg", "unit2": "kg", "tableName": "R_SM", "ID": "10", "ProductionID": ['M-CAN-10']},
	{"key": "MI10", "name": "臥式炒煮釜能耗指標", "type": "蒸汽", "unit1": "kg", "unit2": "kg", "tableName": "R_SM", "ID": "5", "ProductionID": ['M-COK-12','M-COK-13','M-COK-14','M-COK-15','M-COK-16','M-COK-17']},
	{"key": "MI08", "name": "瓦斯隧道爐能耗指標A線", "type": "瓦斯", "unit1": "kg", "unit2": "kg", "tableName": "R_GM", "ID": "7", "ProductionID": ['C-BAK-01']},
	{"key": "MI11", "name": "肉乾隧道式烤爐能耗指標", "type": "瓦斯", "unit1": "kg", "unit2": "kg", "tableName": "R_GM", "ID": "3", "ProductionID": ['M-SMK-66']},
	{"key": "MI12", "name": "肉鬆滾桶式炒食機能耗指標", "type": "瓦斯", "unit1": "kg", "unit2": "kg", "tableName": "R_GM", "ID": "2", "ProductionID": ['M-COK-01','M-COK-02','M-COK-03','M-COK-04','M-COK-05','M-COK-06','M-COK-07','M-COK-08','M-COK-09','M-COK-10','M-COK-11','M-COK-12']},
	// 永昱(Trend)
	{"key": "MI13", "name": "一期空調系統能耗指標", "type": "電力", "unit1": "kW", "unit2": "RT", "tableName": "test001","ID":"0", "ProductionID": ['F-19']},
	{"key": "MI14", "name": "一期冷凍庫系統能耗指標", "type": "電力", "unit1": "kW", "unit2": "RT", "tableName": "test001","ID":"0", "ProductionID": ['NEW']},
	{"key": "MI15", "name": "一期冷藏庫系統能耗指標", "type": "電力", "unit1": "kW", "unit2": "RT", "tableName": "test001","ID":"0", "ProductionID": ['NEW']},

];

// 能源單位(圓餅圖,曲線圖用)
const energy_unit = {
	"電力": "kwh",
	"蒸汽": "kg/hr",
	"瓦斯": "m³/hr",
	"水": "m³/hr",
};


//	首頁圓餅圖用
const index_chartPie_config = {
	"電力" : {
		"照明" : {
			"options" : [
				{"label": "1LA 西式調理區照明", "value": "23"},
				{"label": "1LB 209月台照明", "value": "22"},
				{"label": "1LC 蒸煮區照明", "value": "21"},
				{"label": "1LD 烘烤區照明", "value": "20"},
				{"label": "1LE 罐頭加工區照明", "value": "19"},
				{"label": "1LF 肉品包裝、中西照明", "value": "32"},
				{"label": "1LG 物資倉庫照明", "value": "33"},
				{"label": "1LH 糕餅中西整型區照明", "value": "34"},
				{"label": "1LI 1樓照明", "value": "35"},
				{"label": "1ELA 1F緊急電源", "value": "15"},
				{"label": "2LA 2F辦公區照明", "value": "24"},
				{"label": "2LB 2F右餐廳照明", "value": "31"},
				{"label": "2LC 2F左員工活動中心", "value": "30"},
				{"label": "2EL 2F緊急電源、中控室", "value": "14"},
			]
		},
		"冷凍空調" : {
			"options" : [
				{"label": "BIP空調專用-地下室冰水泵", "value": "17"},
				{"label": "蒸發冷凝器", "value": "18"},
				{"label": "GRAM主機-頂樓肉乾胚冷凍庫", "value": "61"},
				{"label": "1PI糕餅冷凍庫", "value": "55"},
				{"label": "EPA一期冷凍庫控制盤", "value": "38"},
				{"label": "2°C冷凍主機包裝冷凍庫", "value": "9"},
				{"label": "空調冷藏系統ACMP", "value": "65"}, // 空調主機 65
				{"label": "物資冷凍庫RFMPC", "value": "68"}, // 冷凍主機 66
				{"label": "MCC", "value": "16"},
				{"label": "A倉冷凍庫總用電", "value": "10"},
				// {"label": "空調主機#1", "value": "3"},
				// {"label": "空調主機#2", "value": "4"},
				// {"label": "空調主機#3", "value": "5"},
				// {"label": "空調主機#4", "value": "6"},
				// {"label": "冷凍主機#1", "value": "11"},
				// {"label": "冷凍主機#2", "value": "12"},
				// {"label": "冷凍主機#3", "value": "13"},
			]
		},
		"製程動力" : {
			"options" : [
				{"label": "1PC蒸煮區", "value": "44"},
				{"label": "1PE罐頭封罐機、遠紅外線", "value": "58"},
				{"label": "1PG罐頭加工區、殺菌釜", "value": "54"},
				{"label": "1PE-1金瑛發煮鍋、吊車", "value": "52"},
				{"label": "BLP大地下室", "value": "51"},
				{"label": "緊急動力電源台電ATS", "value": "60"},
				{"label": "醬油槽區", "value": "43"},
				{"label": "1PA大調理區", "value": "46"},
				{"label": "1PB切割區", "value": "45"},
				{"label": "1PD烘烤區1", "value": "57"},
				{"label": "EPB烘烤室3Ø220V電源", "value": "62"},
				{"label": "1PJ糕餅調理室", "value": "59"},
				{"label": "1PK糕餅瓦斯隧道爐", "value": "50"},
				{"label": "1PL糕餅走道", "value": "49"},
				{"label": "1PM糕餅旋轉烤爐", "value": "48"},
				{"label": "1PF香腸包裝區", "value": "53"},
				{"label": "RAC5肉鬆包裝區", "value": "29"},
				{"label": "脆片包裝作業區", "value": "47"},
				{"label": "MP滷味廠", "value": "36"},
			]
		},
		"通風" : {
			"options" : [
				{"label": "RAC7糕餅頂層排風機", "value": "56"},
				{"label": "RAC6烘烤區排風機", "value": "28"},
				{"label": "RAC2蒸煮區排風機", "value": "25"},
			]
		},
		"空壓" : {
			"options" : [
				{"label": "空壓", "value": "37"},
				// {"label": "空壓機#1", "value": "7"},
				// {"label": "空壓機#2", "value": "8"},
			]
		},
		"公用設備" : {
			"options" : [
				{"label": "EBP水處理專用", "value": "40"},
				{"label": "宿舍", "value": "42"},
				{"label": "A倉", "value": "2610"}, // 特殊id
				{"label": "B倉", "value": "27"},
				{"label": "BP鍋爐機房", "value": "41"},
				{"label": "PLI工務周邊", "value": "39"},
				// {"label": "汙水", "value": "2"},
			]
		},
		"其他" : {
			"options" : [
				{"label": "1PAA站110V插座", "value": "63"},
				{"label": "RP2B站110V插座", "value": "64"},
			]
		},	
	},
	"蒸汽" : {
		"燒臘區" : {
			"options": [
				{"label": "蒸煮鍋", "value": "16"},
			]
		},
		"蒸煮室" : {
			"options": [
				{"label": "罐頭煮釜", "value": "2"},
				{"label": "二重鍋", "value": "3"},
				{"label": "四方煮鍋", "value": "4"},
				{"label": "肉鬆炒鍋", "value": "5"},
			]
		},
		"罐頭加工室" : {
			"options": [
				{"label": "遠紅外線", "value": "6"},
				{"label": "殺菌釜NO.1", "value": "7"},
				{"label": "殺菌釜NO.2", "value": "8"},
				{"label": "殺菌釜NO.3", "value": "9"},
				{"label": "殺菌釜NO.4", "value": "10"},
			]
		},
		"肉品烘烤室" : {
			"options": [
				{"label": "Vemag隧道燻煙爐", "value": "11"},
				{"label": "Fessmann多功能爐", "value": "12"},
				{"label": "Fessmann多功能爐", "value": "13"},
				{"label": "宣柏蒸煮爐", "value": "14"},
				{"label": "KOCH乾燥爐", "value": "15"},
			]
		},
		"屋頂" : {
			"options": [
				{"label": "熱水槽", "value": "17"},
			]
		},
		"熟食包裝室" : {
			"options": [
				{"label": "殺菌槽", "value": "18"},
			]
		},
		"糕餅調理室" : {
			"options": [
				{"label": "炒焰鍋", "value": "19"},
			]
		},
	},
	"瓦斯" : {
		"天燃氣瓦斯" : {
			"options": [
				{"label": "燃氣發電機", "value": "12"},
			]
		},
		"肉品烘烤室" : {
			"options": [
				{"label": "炒肉鬆機", "value": "2"},
				{"label": "肉乾隧道烤爐", "value": "3"},
				{"label": "肉乾乾燥爐NO.1", "value": "4"},
				{"label": "肉乾乾燥爐NO.2", "value": "5"},
			]
		},
		"蒸煮室" : {
			"options": [
				{"label": "炒牛肉", "value": "6"},
				{"label": "炸豬油鍋", "value": "炸豬油鍋"},
			]
		},
		"西點烘培室" : {
			"options": [
				{"label": "瓦斯隧道爐(舊)", "value": "7"},
				{"label": "瓦斯隧道爐(新)", "value": "8"},
				{"label": "旋風烤爐", "value": "9"},
			]
		},
		// "廚房" : {
		// 	"options": [
		// 		{"label": "廚房", "value": "廚房"},
		// 	]
		// },
		"燒臘區" : {
			"options": [
				{"label": "燒臘區", "value": "10"},
			]
		},
		"中點調理室" : {
			"options": [
				{"label": "炒焰鍋", "value": "11"},
			]
		},
	},
};
