<!DOCTYPE html>
<html lang="zh-tw">

<head>
  <?php
      include_once "html_head.inc";
      ?>
    </head>

<body>
  <div id="q-app" :visible="IsVueReady==true" @mousemove="FnIdleReset" >
    <?php
    include_once "html_layout_header.inc";
    ?>
    
    <div class="w3-row">
      <div class="w3-row-padding w3-stretch flex-frwfsc" >
        <q-field label="查詢區間" label-width="5" class="search-field w3-col l2 m6 s12 flex-space">
          <q-radio label="年" v-model="search.range" val="year" class="q-ml-sm"></q-radio>
          <q-radio label="月" v-model="search.range" val="month" class="q-ml-sm"></q-radio>
        </q-field>
        <q-field label="年" label-width="4" class="search-field w3-col l2 m6 s12 " v-if="search.range == 'year'" >
          <date-picker v-model="search.year" type="year" placeholder="請選年份" :clearable="false"></date-picker>
        </q-field>
        <q-field label="年月" label-width="4" class="search-field w3-col l2 m6 s12 flex-space" v-if="search.range == 'month'" >
          <date-picker v-model="search.year_month" type="month" placeholder="請選年月份" :clearable="false"></date-picker>
        </q-field>
        <q-btn glossy label="查詢" @click="searchData()" color="primary" class="id-btn"></q-btn>
      </div> 
    </div> 

    <div class="w3-row q-my-lg" v-for="item in chart" style="padding:0;">
      <div class="w3-col l12 m12 s12 " style="height: 280px;" >
        <echart :options="item" autoresize style="width: 100%; height: 100%; padding-top: 10px;" ></echart>
      </div>
    </div>

    <?php
    include_once "html_layout_footer.inc";
    ?>
  </div>
  <?php
  include_once "html_loading.inc";
  ?>
</body><?php
        $is_echarts = true;
        include_once "html_down.inc";
        ?>

</html>