<!DOCTYPE html>
<html lang="zh-tw">

<head>
  <?php
      include_once "html_head.inc";
      ?>
    </head>

<body>
  <div id="q-app" :visible="IsVueReady==true" @mousemove="FnIdleReset" >
    <?php
    include_once "html_layout_header.inc";
    ?>
    
    <div class="w3-row">
       <div class="w3-row-padding w3-stretch flex-frwfsc" >
        <q-field label="開始日期" label-width="4" class="search-field w3-col l2 m6 s12 flex-space search" >
          <date-picker v-model="search.start_date" type="date" :clearable="false" placeholder="請選開始日期" ></date-picker>
        </q-field>
        <q-field label="結束日期" label-width="4" class="search-field w3-col l2 m6 s12 flex-space" >
          <date-picker v-model="search.end_date" type="date" :clearable="false" placeholder="請選結束日期" ></date-picker>
        </q-field>
        <q-btn glossy label="查詢" @click="searchData()" color="primary" class="id-btn"></q-btn>
      </div> 
    </div> 

    <div class="q-my-lg flex-shadow">
      <echart :options="chart" style="width: 100%;" autoresize></echart>
    </div>

    <div class="w3-section w3-row-padding" style="padding: 0; font-size: 20px; font-weight: 600;">
      <div class="w3-col l4 m6 s12 flex-space">
        <div class="flex-shadow w3-responsive">
          <table class="w3-table-all">
            <thead>
              <tr style="border-radius: 15px; background: #4264d0; color: #fff;">
                <th>日期</th>
                <th class="w3-right-align">時間</th>
                <th class="w3-right-align" >需量(kW)</th>
              </tr>
            </thead>
            <tr v-for="row,inx in chart['dataset']['source']" v-if="inx < 10">
              <td>{{moment(row[chart['dataset']['dimensions'][0]]).locale('zh-tw').format('YYYY/MM/DD(ddd)')}}</td>
              <td class="w3-right-align">{{moment(row[chart['dataset']['dimensions'][0]]).format('HH:mm')}}</td>
              <td class="w3-right-align">{{row[chart['dataset']['dimensions'][1]]}}</td>
            </tr>
          </table>
        </div>
      </div>
      <div class="w3-col l4 m6 s12 flex-space">
        <div class="w3-card w3-responsive">
          <table class="w3-table-all">
            <thead>
              <tr style="border-radius: 15px; background: #4264d0; color: #fff;">
                <th>日期</th>
                <th class="w3-right-align">時間</th>
                <th class="w3-right-align" >需量(kW)</th>
              </tr>
            </thead>
            <tr v-for="row,inx in chart['dataset']['source']" v-if="inx >= 10 && inx < 20">
              <td>{{moment(row[chart['dataset']['dimensions'][0]]).locale('zh-tw').format('YYYY/MM/DD(ddd)')}}</td>
              <td class="w3-right-align">{{moment(row[chart['dataset']['dimensions'][0]]).format('HH:mm')}}</td>
              <td class="w3-right-align">{{row[chart['dataset']['dimensions'][1]]}}</td>
            </tr>
          </table>
        </div>
      </div>
      <div class="w3-col l4 m6 s12 flex-space">
        <div class="w3-card w3-responsive">
          <table class="w3-table-all">
            <thead>
              <tr style="border-radius: 15px; background: #4264d0; color: #fff;">
                <th>日期</th>
                <th class="w3-right-align">時間</th>
                <th class="w3-right-align" >需量(kW)</th>
              </tr>
            </thead>
            <tr v-for="row,inx in chart['dataset']['source']" v-if="inx >= 20">
              <td>{{moment(row[chart['dataset']['dimensions'][0]]).locale('zh-tw').format('YYYY/MM/DD(ddd)')}}</td>
              <td class="w3-right-align">{{moment(row[chart['dataset']['dimensions'][0]]).format('HH:mm')}}</td>
              <td class="w3-right-align">{{row[chart['dataset']['dimensions'][1]]}}</td>
            </tr>
          </table>
        </div>
      </div>
    </div>


    
    <?php
    include_once "html_layout_footer.inc";
    ?>
  </div>
  <?php
  include_once "html_loading.inc";
  ?>
</body><?php
        $is_echarts = true;
        include_once "html_down.inc";
        ?>

</html>