<!DOCTYPE html>
<html lang="zh-tw">

<head>
  <?php
      include_once "html_head.inc";
      ?>
    </head>

<body>
  <div id="q-app" :visible="IsVueReady==true" @mousemove="FnIdleReset" class="energy-container">
    <?php
    include_once "html_layout_header.inc";
    ?>


    <div class="w3-row q-mt-sm" >
      <!-- 最上層 -->
      <div class="w3-col l2 m3 s12 q-pa-sm" >
          <div class="q-pa-sm w3-border text-white energy-flexRadius" style="height: 330px;">
            <div class="flex-fcwcc">
              <span class="q-mb-md">{{ search['title'] }}</span>
              <span class="q-mb-md">{{ search['subTitle'] }}</span>
              <!-- 查詢條件是月或是年 -->
             <!--  <q-select 
                class="w3-border q-pa-sm q-mb-md" 
                align="right"  
                v-model="search['range']['value']" 
                :options="search['range']['options']" 
                style="width: 75%; font-size: 1.5rem; font-weight: 700;"
              ></q-select>  -->
              <div class="q-pa- q-mb-md" style="width: 61%;  font-weight: 700;">
                <q-radio label="月" v-model="search['range']['value']" val="month" class="q-ml-sm"></q-radio>
                <q-radio label="年" v-model="search['range']['value']" val="year" class="q-ml-sm"></q-radio>
              </div>  
              <!-- 當查詢條件是月 -->
              <div class="w3-border q-mb-md w3-text-right" v-if="_.includes(search['range']['value'] , 'month')" style="height: 100%; width: 75%; text-align: center">
                <date-picker v-model="search['data']['month']" type="month" :clearable="false" placeholder="請選年月份"  ></date-picker>
              </div>
              
              <!-- 當查詢條件是年 -->
              <div class="w3-border q-mb-md w3-text-right" v-if="_.includes(search['range']['value'] , 'year')" style="height: 100%; width: 75%; text-align: center">
                <date-picker v-model="search['data']['year']" type="year" :clearable="false" placeholder="請選年份"  ></date-picker>
              </div>
             
              <q-btn 
                label="搜尋" 
                icon="search" 
                push color="primary"
                text-color="white"
                @click="searchData()"
                class="id-btn"
              ></q-btn>
            </div>  
          </div>      
      </div>  

      <div class="w3-col l10 m9 s12 ">
        <div class="w3-row">
          <div class="w3-col l4 m12 s12 q-pa-sm">
            <!-- 月能源用量占比 -->
            <div class="w3-row q-pa-sm shadow-1 index-flexRadius" style="height: 330px;">
              <div class="flex-fws">
                <span class="text-white"> {{ titleName[search['range']['value']]+monthEnergy['label'] }} </span>
              </div>
              <div class="w3-col l4 m4 s12">
                <echart :options="monthEnergy['pieOptions']" autoresize="true" style="width: 100%; height: 280px;"></echart>
              </div>    
              <div class="w3-col l8 m8 s12 flex-fcwfsfs block-list">
                <div class="q-mb-sm q-pl-md" v-for="item in monthEnergy['info']" v-if="item['show']" style="width: 50%; ">
                  <div class="flex-frwfsc"  >
                    <span :class="`bg-${item['color']} q-pa-xs q-mr-sm` " style="width:10%; border-radius: 25px;"></span> 
                    <span class="text-white"   style="width:80%">{{ item['label'] }}</span>  
                  </div>
                  <div class="flex-frwfsc text-bright"  >
                    <span class="">{{ item['data']['value'] }}<a class="q-pl-xs text-white">{{ item['data']['unit'] }}</a></span> 
                  </div>   
                </div>  
              </div>  
            </div>
          </div>
          <div class="w3-col l8 m12 s12 q-pa-sm" >
            
            <div class="w3-row q-pa-sm w3-border energy-flexRadius" style="height: 330px;">
              <!-- 標題 -->
              <div class="w3-row w3-center q-pa-sm bg-blue-9 text-white q-ma-sm" style="border-radius: 10px;font-size: 1.1rem; font-weight:700">
                <div class="w3-col l2 m2 s2" v-for="item in EnergyParamTable.title">
                  <span :style="item.style">{{ item['label'] }}</span>
                </div>  
              </div>
              <!-- 數據 -->
              <div class="w3-row w3-center q-pa-sm q-ma-sm bg-blue-1 text-black" style="border-radius: 10px;font-size: 1.1rem; font-weight:700" v-for="item in EnergyParamTable.data">
                <div class="w3-col l2 m2 s2 w3-left-align"><span>{{ item['label'] }}</span></div>  
                <div class="w3-col l2 m2 s2 w3-right-align q-pr-sm"><span>{{ item['total'] }}</span></div> 
                <div class="w3-col l2 m2 s2 w3-right-align q-pr-sm"><span>{{ item['mcal'] }}</span></div> 
                <div class="w3-col l2 m2 s2 w3-right-align q-pr-sm"><span>{{ item['oil'] }}</span></div> 
                <div class="w3-col l2 m2 s2 w3-right-align q-pr-sm"><span>{{ item['co2e'] }}</span></div> 
                <div class="w3-col l2 m2 s2 w3-right-align q-pr-sm"><span>{{ item['percent'] }}</span></div> 
              </div>
            </div>  
          </div>
        </div>
      </div>



    </div> 

    <div class="w3-row q-mt-sm ">
      <div class="w3-col l12 m12 s12 q-pa-sm ">
        <q-tabs color="blue-grey-1" text-color="primary">
          <!-- 選項卡 ： signIn => 登入 / signUp => 註冊 -->
          <!-- key => signIn、 signUp -->  
          <q-tab 
            slot="title"
            :name="key"  
            :icon="sort['icon']"  
            :label="sort['title']"  
            :default="sort['default']" 
            :hidden="sort['hidden']" 
            v-for="(sort, key) in qTabForm">
          </q-tab>  
          <!-- 選項卡內容-->
          <q-tab-pane class="flex-fcwsbc" :name="key"  v-for="(item, key) in qTabForm">
            <!-- 填寫內容 -->
            <div class="w3-row">
              <div class="w3-col l5 m12 s12 q-pa-md ">
                <!-- 圓餅圖 -->
                <div class="q-pt-sm" style="width: 100%;">
                  <echart :options="item['pieOptions']" autoresize="true" style="width: 100%; height:400px"></echart>
                </div>
                <!-- 明細 -->
                <div class="q-pa-sm " style="border-radius:10px; width: 100%; height: 180px;">
                  <div class="flex-frwfsc"  style="width:100%">
                    <div class="flex-frwfsc q-my-sm" style="font-size: 20px; font-weight: 700;width: 33%" v-for="info in item['pieInfo']" v-if="info['show']" >
                      <div class="flex-frwsbc" style="width: 95%;">
                        <div class="flex-frwfsc" style="width:65%">
                          <div :style="`width: 10px; height: 10px; border-radius: 25px; background: ${info['color']}`"></div> 
                          <span class="q-pl-xs text-white">{{ info['label'] }}</span>  
                        </div>
                        <span class="text-bright" style="width:35% ;text-align: end; font-size:20px;">{{ info['value'] }}<a class="text-white">{{ info['unit'] }}</a></span> 
                      </div>
                      <div class="" v-if="info['showBorder']" style="width: 5%;">
                        <span  style="border-right: 3px solid rgba(0, 0, 0, 0.2); font-size: 1.5rem;"></span>
                      </div>
                    </div> 
                  </div>  
                </div>    
              </div>  
              <div class="w3-col l7 m12 s12" style="padding-left:7px;">
                <div class="w3-row q-pa-sm w3-border q-mb-md energy-tableRadius" style="border-radius: 10px; " v-for="block in item['table']">
                  <!-- 標題 -->
                  <div :class="block['titleClass']" class="q-ma-sm" style="border-radius: 10px;font-size: 1.1rem; font-weight:700">
                    <div :class="item['class']" v-for="item in block.title">
                      <span>{{ item['label'] }}</span>
                    </div>  
                  </div>
                  <!-- 數據 -->
                  <div :class="block['dataClass']" v-for="item in block.data" style="border-radius: 10px;font-size: 1.1rem; font-weight:700;" >
                    <div class="w3-col l2 m2 s2 w3-left-align"><span>{{ item['label'] }}</span></div>  
                    <div class="w3-col l2 m2 s2 w3-right-align q-pr-sm"><span>{{ item['total'] }}</span></div> 
                    <div class="w3-col l2 m2 s2 w3-right-align q-pr-sm"><span>{{ item['mcal'] }}</span></div> 
                    <div class="w3-col l2 m2 s2 w3-right-align q-pr-sm"><span>{{ item['oil'] }}</span></div> 
                    <div class="w3-col l2 m2 s2 w3-right-align q-pr-sm"><span>{{ item['co2e'] }}</span></div> 
                    <div class="w3-col l2 m2 s2 w3-right-align q-pr-sm"><span>{{ item['percent'] }}</span></div> 
                    <!-- 例外狀況 -->
                    <div class="w3-col l2 m2 s2 w3-right-align q-pr-sm" v-if="item['exception']" >
                      <q-btn color="secondary" glossy label="詳細" @click="FnPageSwitch(item['linkTo'], null, true)" class="id-btn"></q-btn>
                    </div> 
                  </div>
                </div>  
              </div> 
            </div>

           
          </q-tab-pane> 
        </q-tabs>
      </div>
    </div>
    
    <?php
    include_once "html_layout_footer.inc";
    ?>
  </div>
  <?php
  include_once "html_loading.inc";
  ?>
</body><?php
        $is_echarts = true;
        include_once "html_down.inc";
        ?>

</html>