var page_function = {
  components: {},
  data() {
    return {
      VarMenuPage: "chart_bar",
      VarMenu: "area",
      VarPageContainerCss: "padding:30px",

      deviceKey: null,
      fromPage: null,
      itemType: null,
      modeOptions: [
        { label: "小時", value: "hour" },
        { label: "日", value: "day" },
      ],
      search: {
        mode: "day",
        // date1: moment(),
        // date2: moment(),
        year_month1: new Date(new Date().getFullYear(), new Date().getMonth() - 1, 1),
        year_month2: new Date(),
        id_list: [],
      },
      itemOptions: [],
      chartOption: {
        title: {
          text: "",
          textStyle: {
              color: "#fff",  // 標題顏色設為白色
          },
        },
        tooltip: {
          trigger: "axis",
        },
        legend: {
          bottom: 0,
          textStyle: {
            color: "#fff",  // 圖例文字設為白色
          },
        },
        grid: {
          left: "2%",
          right: "2%",
          bottom: "4%",
          containLabel: true,
        },
        xAxis: {
          name: "日", // 區間
          type: "category",
          boundaryGap: false,
          axisLabel: {
            color: "#fff",  // x軸標籤顏色設為白色
          },
          axisLine: {
              lineStyle: {
                  color: "#fff",  // x軸線條顏色設為白色
              }
          },
          splitLine: {
              lineStyle: {
                  color: "#fff",  // x軸分隔線顏色設為白色
              }
          },
          splitLine: {
            show: true,
          },
          data: [],
        },
        yAxis: {
          name: "用量", // 單位
          type: "value",
          axisLine: {
            show: true,
          },
          axisLabel: {
            color: "#fff",  // y軸標籤顏色設為白色
          },
          axisLine: {
              lineStyle: {
                  color: "#fff",  // y軸線條顏色設為白色
              }
          },
          splitLine: {
              lineStyle: {
                  color: "#fff",  // y軸分隔線顏色設為白色
              }
          }
        },
        series: [
          {
            name: "",
            type: "line",
            data: [],
          },
          {
            name: "",
            type: "line",
            data: [],
          },
        ],
      },
      // specialId: { // 特殊處理id
      //   "656667": {
      //     "id_list": "65,66,67",
      //     "fomula": "65-(66+67)"
      //   },
      //   "2610": {
      //     "id_list": "26,10",
      //     "fomula": "26-10"
      //   },
      // },
    };
  },
  computed: {},
  watch: {},
  mounted() {
    this.MenuSetup.opened = false;
    this.VarMenuIsOverlay = false;
    this.initPage();
  },
  methods: {
    initPage() {
      // 載入url參數
      var that = this;
      let sp = new URLSearchParams(decodeURIComponent(window.location.search));
      this.deviceKey = sp.get("options");
      this.$set(this.WebSetup, "caption", this.deviceKey); // 頁面標題
      this.fromPage = sp.get("from_page");
      this.itemType = sp.get("item_type");
      var opVal = sp.get("value"); // 葉子節點會對應
      this.itemOptions = [];
      // 先去葉子節點找value
      _.each(_.values(device_item_bar[this.itemType]), (obj)=> {
        var foundOp = _.find(obj['options'], (op)=> {
          return op.label == this.deviceKey && op.value == opVal
        });
        if(foundOp) {
          this.itemOptions.push(foundOp);
          return false;
        }
      });
      // 沒value，才去對應options
      if (this.itemOptions.length == 0 && device_item_bar[this.itemType][this.deviceKey]) {
        this.itemOptions = device_item_bar[this.itemType][this.deviceKey]["options"];
      }
      _.each(this.itemOptions, (op)=> {
        let temp_id_list = [];
        if (!isNaN(Number(op.value, 10))) {
          temp_id_list.push(op.value);
        } else {
          that.get_options_id(temp_id_list, op.label, that.itemType);
        }
        op.id_list = temp_id_list.join(",");
      });
      this.searchData();
    },
    async searchData() {
      if(this.itemOptions.length == 0) {
        this.FnNotify("查無設定資料", "error");
        return;
      }
      this.chartOption.series[0].name = moment(this.search.year_month1).format('YYYY-MM'); // 曲線1名稱
      this.chartOption.series[1].name = moment(this.search.year_month2).format('YYYY-MM'); // 曲線2名稱
      this.chartOption.title.text = `[${moment(this.search.year_month1).format('YYYY-MM')}/${moment(this.search.year_month2).format('YYYY-MM')}]${this.deviceKey}比較圖`; // 標題
      this.chartOption.yAxis.name = `用量(${energy_unit[this.itemType]})`; // y軸名稱

      //把所有區的設備ID字串從itemOptions整理出來
      var opVal = _.map(this.itemOptions, "value");
      this.search.id_list = [];
      var spId = [];
      this.itemOptions.forEach((el) => {
        if (opVal.includes(el.value)) {
          if (el.id_list.trim() != "") {
            this.search.id_list.push(el.id_list);
            // if(this.specialId.hasOwnProperty(el.id_list)) {
            //   // 特殊id，需要經過計算
            //   this.search.id_list.push(this.specialId[el.id_list]['id_list']);
            //   spId.push(el.id_list);
            // } else {
            //   this.search.id_list.push(el.id_list);
            // }
          }
        }
      });
      // await this.FnAlert(JSON.stringify(this.search.id_list))
      var params = {
        Action: "BarData",
        Datas: {
          date1: this.search.year_month1,
          date2: this.search.year_month2,
          id_list: this.search.id_list,
          data_group: this.itemType,
          sp_id: spId,
        },
      };
      await this.FnWebAPIGet(params)
        .then((res) => {
          var resData = res.data.data;
          this.chartOption.xAxis.data = _.map(resData.date_1, (d)=> { return d.Date.toString();});
          this.chartOption.series[0].data = _.map(resData.date_1, (d)=> {
            return [d.Date.toString(), d.Val];
          });
          this.chartOption.series[1].data = _.map(resData.date_2, (d)=> {
            return [d.Date.toString(), d.Val];
          });
        })
        .catch(async (err) => {
          console.log(err);
        });
    },
    //樹狀陣列平扁化
    get_options_id(array, key, group) {
      var that = this;
      if (device_item_bar[group][key]) {
        device_item_bar[group][key]["options"].forEach((el) => {
          if (!isNaN(Number(el.value, 10))) {
            array.push(el.value);
          } else if (device_item_bar[group].hasOwnProperty(el.label)) {
            return that.get_options_id(array, el.label, group);
          }
        });
      }
    },
  },
};
