var page_function = {
	components: {},
	data () {
		return {
			"VarMenuPage": "data_analysis_single_baseline",
			"VarMenu": "area",
			"VarPageContainerCss" : "padding:20px",

			"search": {
				"year":  new Date(),
				"year_month": new Date(),
				"range": 'month',	//	月：month、年：year
			},

			"chart" : {
				"ice" : {
					"title" : {
						"text" : [ '{icon|}' , '{normal|一期冷凍主機基線}'].join(' '),
						"textStyle" : {
							"color" : "#fff",
							"align" : "center",
							"verticalAlign" : "middle",
							"rich" : {
								"icon" : {
									"fontSize" : 30,
									"backgroundColor" : { 
										"image" : 'img/source/冷凍主機.png'
									}
								},
								"normal": {
									"fontSize" : 20,
									"fontWeight" : "600",
				                }
							},
						},	
					},
					"grid" : {
						"top" : 60,
						"bottom" : 15,
						"right" : 25,
						"left" : 20,
						"containLabel" : true
					},
					"tooltip" : { 
						"trigger" : "axis"
					},
					"legend" : {
						"show" : true,
						"selectedMode" : false,
						"right" : 20,
						"textStyle" : {
							// "fontSize" : 16,
							"fontWeight" : "600",
							"color" : "#fff",
						},
					},
					"xAxis" : {
						"type" : "category",
						"axisLabel" : {
							"fontSize" : 16,
							"color": "#ffffff"  // x軸標籤文字設置為白色
						},
						"axisLine": {
							"lineStyle": {
								"color": "#ffffff"  // x軸線條設置為白色
							}
						},
						"data" : []
					},
					"yAxis" : {
						"type" : "value",
						"axisLabel" : {
							"fontSize" : 16,
							"color": "#ffffff" // x軸標籤文字設置為白色
						},
						"axisLine": {
							"lineStyle": {
								"color": "#ffffff"  // y軸線條設置為白色
							}
						}
					},
					"series" : [
						{
							"name" : "基線",
							"type" : "line",
							"symbolSize" : 10,
							"symbol" : "circle",
							"data" : [],
							"itemStyle" : {
								"color" : "rgba(142,194,241, 1)",
							},
							"label" : {
								"show" : true,
								"fontSize" : 16,
								"position" : 'top',
								"color" : "rgba(255, 255, 255, 2)",
								"backgroundColor" : "rgba(142,194,241, 1)",
								"padding" : 5,
							},
							labelLayout: {
				                hideOverlap: false, // 隱藏重疊的標籤
				                moveOverlap: 'shiftXY' // 垂直移动重叠的标签
				            }
						},
						{
							"name" : "MCC",
							"type" : "line",
							"symbolSize" : 10,
							"symbol" : "circle",
							"data" : [],
							"itemStyle" : {
								"color" : "rgba(200,229,186, 1)",
							},
							"label" : {
								"show" : true,
								"fontSize" : 16,
								"position" : 'top',
								"color" : "rgba(255, 255, 255, 2)",
								"backgroundColor" : "rgba(200,229,186, 1)",
								"padding" : 5
							},
							labelLayout: {
				                hideOverlap: true, // 隱藏重疊的標籤
				                moveOverlap: 'shiftXY' // 垂直移动重叠的标签
				            }
						}
					],
				},
				"infrared" : {
					"title" : {
						"text" : [ '{icon|}' , '{normal|遠紅乾燥爐基線}'].join(' '),
						"textStyle" : {
							"color" : "#fff",
							"align" : "center",
							"verticalAlign" : "middle",
							"rich" : {
								"icon" : {
									"fontSize" : 30,
									"backgroundColor" : { 
										"image" : 'img/source/遠紅乾燥爐.png'
									}
								},
								"normal": {
									"fontSize" : 20,
									"fontWeight" : "bold",
				                }
							},
						},	
					},
					"grid" : {
						"top" : 65,
						"bottom" : 15,
						"right" : 25,
						"left" : 20,
						"containLabel" : true
					},
					"tooltip" : { 
						"trigger" : "axis"
					},
					"legend" : {
						"show" : true,
						"selectedMode" : false,
						"right" : 20,
						"textStyle" : {
							// "fontSize" : 16,
							"fontWeight" : "bold",
							"color" : "#fff",
						},
					},
					"xAxis" : {
						"type" : "category",
						"axisLabel" : {
							"fontSize" : 16,
							"color": "#ffffff"  // x軸標籤文字設置為白色
						},
						"axisLine": {
							"lineStyle": {
								"color": "#ffffff"  // x軸線條設置為白色
							}
						},
						"data" : []
					},
					"yAxis" : {
						"type" : "value",
						"axisLabel" : {
							"fontSize" : 16,
							"color": "#ffffff"  // x軸標籤文字設置為白色
						},
						"axisLine": {
							"lineStyle": {
								"color": "#ffffff"  // x軸線條設置為白色
							}
						},
					},
					"series" : [
						{
							"name" : "基線",
							"type" : "line",
							"symbolSize" : 10,
							"symbol" : "circle",
							"data" : [],
							"itemStyle" : {
								"color" : "rgba(142,194,241, 1)",
							},
							"label" : {
								"show" : true,
								"fontSize" : 16,
								"position" : 'top',
								"color" : "rgba(255, 255, 255, 2)",
								"backgroundColor" : "rgba(142,194,241, 1)",
								"padding" : 5
							},
						},
						{
							"name" : "蒸汽用量",
							"type" : "line",
							"symbolSize" : 10,
							"symbol" : "circle",
							"data" : [],
							"itemStyle" : {
								"color" : "rgba(200,229,186, 1)",
							},
							"label" : {
								"show" : true,
								"fontSize" : 16,
								"position" : 'top',
								"color" : "rgba(255, 255, 255, 2)",
								"backgroundColor" : "rgba(200,229,186, 1)",
								"padding" : 5
							},
						}
					],
				},
				"kettle" : {
					"title" : {
						"text" : [ '{icon|}' , '{normal|殺菌釜基線}'].join(' '),
						"textStyle" : {
							"color" : "#fff",
							"align" : "center",
							"verticalAlign" : "middle",
							"rich" : {
								"icon" : {
									"fontSize" : 30,
									"backgroundColor" : { 
										"image" : 'img/source/殺菌釜.png'
									}
								},
								"normal": {
									"fontSize" : 20,
									"fontWeight" : "bold",
				                }
							},
						},	
					},
					"grid" : {
						"top" : 75,
						"bottom" : 15,
						"right" : 25,
						"left" : 20,
						"containLabel" : true
					},
					"tooltip" : { 
						"trigger" : "axis"
					},
					"legend" : {
						"show" : true,
						"selectedMode" : false,
						"right" : 20,
						"textStyle" : {
							// "fontSize" : 16,
							"fontWeight" : "bold",
							"color" : "#fff",
						},
					},
					"xAxis" : {
						"type" : "category",
						"axisLabel" : {
							"fontSize" : 16,
							"color": "#ffffff"  // x軸標籤文字設置為白色
						},
						"axisLine": {
							"lineStyle": {
								"color": "#ffffff"  // x軸線條設置為白色
							}
						},
						"data" : []
					},
					"yAxis" : {
						"type" : "value",
						"axisLabel" : {
							"fontSize" : 16,
							"color": "#ffffff"  // x軸標籤文字設置為白色
						},
						"axisLine": {
							"lineStyle": {
								"color": "#ffffff"  // x軸線條設置為白色
							}
						},
					},
					"series" : [
						{
							"name" : "基線",
							"type" : "line",
							"symbolSize" : 10,
							"symbol" : "circle",
							"data" : [],
							"itemStyle" : {
								"color" : "rgba(142,194,241, 1)",
							},
							"label" : {
								"show" : true,
								"fontSize" : 16,
								"position" : 'top',
								"color" : "rgba(255, 255, 255, 2)",
								"backgroundColor" : "rgba(142,194,241, 10)",
								"padding" : 5
							},
						},
						{
							"name" : "蒸汽用量",
							"type" : "line",
							"symbolSize" : 10,
							"symbol" : "circle",
							"data" : [],
							"itemStyle" : {
								"color" : "rgba(200,229,186, 1)",
							},
							"label" : {
								"show" : true,
								"fontSize" : 16,
								"position" : 'top',
								"color" : "rgba(255, 255, 255, 2)",
								"backgroundColor" : "rgba(200,229,186, 1)",
								"padding" : 5
							},
						}
					],
				},
			},
			chartClone:{},
			
		}
	},

	computed :{},
	watch : {},

	mounted () {
		this.$set(this.WebSetup, "caption", '單項基線分析');
		this.MenuSetup.opened = false;
		this.VarMenuIsOverlay = true;
		this.chartClone = _.cloneDeep(this.chart);
		this.searchData();
	},
	methods: {


		searchData() {
			this.chart['ice']['xAxis']['data'] = []
			this.chart['ice']['series'][0]['data'] = []
			this.chart['ice']['series'][1]['data'] = []
			this.chart['infrared']['xAxis']['data'] = []
			this.chart['infrared']['series'][0]['data'] = []
			this.chart['infrared']['series'][1]['data'] = []
			this.chart['kettle']['xAxis']['data'] = []
			this.chart['kettle']['series'][0]['data'] = []
			this.chart['kettle']['series'][1]['data'] = []

			this.chart['ice']['title']['text'] = this.chartClone['ice']['title']['text']
			this.chart['infrared']['title']['text'] = this.chartClone['infrared']['title']['text']
			this.chart['kettle']['title']['text'] = this.chartClone['kettle']['title']['text']
			var params = {
				Action : 'SearchData',
				Datas : {
					year : this.search['year'],
					year_month : this.search['year_month'],
					range : this.search['range']
				},
			};
			this.FnWebAPIGet(params).then((res)=> {
				var resData1 = res.data.data.date_data_1;
				var resData2 = res.data.data.date_data_2;
				var resData3 = res.data.data.date_data_3;
				var bl = res.data.data.bl;
				// console.log(resData1)
				_.each(resData1, (item) => {
					this.chart['ice']['xAxis']['data'].push(this.search.range == 'year' ? moment(item['Date']).format('YYYY-MM') : moment(item['Date']).format('MM/DD'))
					this.chart['ice']['series'][0]['data'].push(this.FnRoundToDecimal(item['基線']))
					this.chart['ice']['series'][1]['data'].push(this.FnRoundToDecimal(item['用量']))
				})
				_.each(resData2, (item) => {
					this.chart['infrared']['xAxis']['data'].push(this.search.range == 'year' ? moment(item['Date']).format('YYYY-MM') : moment(item['Date']).format('MM/DD'))
					this.chart['infrared']['series'][0]['data'].push(this.FnRoundToDecimal(item['基線']))
					this.chart['infrared']['series'][1]['data'].push(this.FnRoundToDecimal(item['用量']))
				})
				_.each(resData3, (item) => {
					this.chart['kettle']['xAxis']['data'].push(this.search.range == 'year' ? moment(item['Date']).format('YYYY-MM') : moment(item['Date']).format('MM/DD'))
					this.chart['kettle']['series'][0]['data'].push(this.FnRoundToDecimal(item['基線']))
					this.chart['kettle']['series'][1]['data'].push(this.FnRoundToDecimal(item['用量']))
				})
				if(bl) {
					this.chart['ice']['title']['text'] += `  [基線=截距(${this.FnRoundToDecimal(bl.BL02.intercept,2)})+係數(${this.FnRoundToDecimal(bl.BL02.coef,2)})+室外溫度]`
					this.chart['infrared']['title']['text'] += `  [基線=截距(${this.FnRoundToDecimal(bl.BL03.intercept,2)})+係數(${this.FnRoundToDecimal(bl.BL03.coef,2)})+牛肉乾產量]`
					this.chart['kettle']['title']['text'] += `  [基線=截距(${this.FnRoundToDecimal(bl.BL04.intercept,2)})+係數(${this.FnRoundToDecimal(bl.BL04.coef,2)})+罐頭產量]`
				}
			}).catch((err)=> {
				console.log(err);
			});
		},
	}
}