var page_function = {
  components: {},
  data() {
    return {
      VarMenuPage: "data_analysis_station_indicatros",
      VarMenu: "area",
      VarPageContainerCss: "padding:10px",

      // reloadIntervalSec: 60,
      search: {
        date: moment().format('YYYY-MM-DD'),
      },
      meter_charts: [],
      chart_option: {
        name: null,
        title: {
          text: "",
        },
        info: {
          used: {
            label: "用量",
            value: 0,
            unit: "kg/kg",
          },
          qty: {
            label: "總產量",
            value: 0,
            unit: "噸",
          },
          limit: {
            h: null,
            hh: null,
          },
        },
        series: [
          {
            name: "value",
            type: "gauge",
            min: 0,
            max: 180,
            z: 3,
            splitNumber: 6,
            radius: "50%",
            axisLine: {
              lineStyle: {
                color: [[1, "#000"]],
                width: 3,
              },
            },
            splitLine: {
              length: -12,
              lineStyle: {
                color: "#000",
              },
            },
            axisTick: {
              length: -8,
              lineStyle: {
                color: "#000",
              },
            },
            axisLabel: {
              distance: -26,
              color: "#f00",
              fontSize: 16,
            },
            anchor: {
              show: true,
              size: 20,
              itemStyle: {
                borderColor: "#000",
                borderWidth: 2,
              },
            },
            pointer: {
              width: 6,
              length: "113%",
            },
            detail: {
              valueAnimation: true,
              precision: 1,
              fontSize: 25,
              fontWeight: "bold",
              offsetCenter: ["0%", "70%"],
            },
            title: {
              offsetCenter: [0, "-50%"],
            },
            data: [
              {
                value: 0,
                // name: 'PLP'
              },
            ],
          },
          {
            name: "limit",
            type: "gauge",
            radius: "52%",
            axisLine: {
              lineStyle: {
                color: [
                  [0, "#33cc33"], // 綠
                  [0, "#ff9900"], // 橘
                  [0, "#ff0000"], // 紅
                ],
                width: -8,
              },
            },
            detail: {
              show: false,
            },
            splitLine: {
              show: false,
            },
            axisTick: {
              show: false,
            },
            axisLabel: {
              show: false,
            },
          },
          // {
          // 	name: "inner",
          // 	type: 'gauge',
          // 	min: 0,
          // 	max: 12,
          // 	splitNumber: 6,
          // 	radius: '55%',
          // 	axisLine: {
          // 		lineStyle: {
          // 			color: [[1, '#000']],
          // 			width: 3
          // 		}
          // 	},
          // 	detail: {
          // 		show: false
          // 	},
          // 	splitLine: {
          // 		length: 14,
          // 		lineStyle: {
          // 			color: '#000'
          // 		}
          // 	},
          // 	axisTick: {
          // 		splitNumber: 10,
          // 		length: 9,
          // 		lineStyle: {
          // 			color: '#000'
          // 		}
          // 	},
          // 	axisLabel: {
          // 		distance: 6,
          // 		fontSize: 13,
          // 		color: '#989898'
          // 	},
          // 	pointer: {
          // 		show: false
          // 	},
          // 	title: {
          // 		show: false
          // 	},
          // 	anchor: {
          // 		show: true,
          // 		size: 14,
          // 		itemStyle: {
          // 			color: '#000'
          // 		}
          // 	}
          // },
          {
            name: "frame",
            type: "gauge",
            radius: "91%",
            startAngle: 90,
            endAngle: -269.99,
            axisLine: {
              lineStyle: {
                color: [[1, "#000"]],
                width: 10,
                shadowColor: "rgba(0, 0, 0, 0.3)",
                shadowBlur: 8,
                shadowOffsetX: 6,
                shadowOffsetY: 8,
              },
            },
            detail: {
              show: false,
            },
            splitLine: {
              show: false,
            },
            axisTick: {
              show: false,
            },
            axisLabel: {
              show: false,
            },
          },
        ],
      },
    };
  },
  computed: {},
  watch: {
    meter_charts: {
      immediate: true,
      deep: true,
      handler(nv, ov) {
        if (!_.isUndefined(ov)) {
          _.each(ov, (op) => {
            // 指針
            var usedVal = Number(op["info"]["used"]["value"]); // 日用量
            var qtyVal = Number(op["info"]["qty"]["value"]); // 日產量
            var pointerVal = usedVal / qtyVal;
            if (!_.isFinite(pointerVal) || isNaN(pointerVal)) {
              pointerVal = 0;
            }
            op["series"][0]["data"][0]["value"] = Math.round(pointerVal * 10)/10;
            // 警戒範圍 設定
            var h = op["info"]["limit"]["h"];
            var hh = op["info"]["limit"]["hh"];
            var max = op["series"][0]["max"];
            var g = 0;
            var o = 0;
            var r = 0;
            if (h == null && hh != null) {
              g = hh / max;
              o = hh / max;
              r = 1;
            } else if (h != null && hh == null) {
              g = h / max;
              o = 1;
              r = 1;
            } else if (h != null && hh != null) {
              g = h / max;
              o = hh / max;
              r = 1;
            }
            op["series"][1]["axisLine"]["lineStyle"]["color"][0][0] = g; // 綠
            op["series"][1]["axisLine"]["lineStyle"]["color"][1][0] = o; // 橘
            op["series"][1]["axisLine"]["lineStyle"]["color"][2][0] = r; // 紅
          });
        }
      },
    },
  },
  mounted() {
    this.$set(this.WebSetup, "caption", "數據分析-全廠指標總覽");
    this.MenuSetup.opened = false;
    this.VarMenuIsOverlay = true;
    this.initChart();
  },
  methods: {
    // 初始化儀表參數設定
    initChart() {
      this.meter_charts = [];
      _.each(meter_index, (mc) => {
        var co = _.cloneDeep(this.chart_option);
        co["key"] = mc.key;
        co["name"] = mc.name;
        co["title"]["text"] = mc.name;
        co["info"]["used"]["label"] = `${mc.type}用量`;
        co["info"]["used"]["unit"] = mc.unit1;
        co["info"]["qty"]["unit"] = mc.unit2;
        this.meter_charts.push(co);
      });
      this.loadIndicatorAlarm();
      this.searchData();
      // this.autoReload();
    },
    // autoReload() {
    //   this.searchData();
    //   setTimeout(() => {
    //     this.autoReload();
    //   }, this.reloadIntervalSec * 1000);
    // },
    loadIndicatorAlarm() {
      var params = {
        Action: "IndicatorAlarm",
        Datas: {},
      };
      this.FnWebAPIGet(params).then((res) => {
        var resData = res.data.data;
        _.each(this.meter_charts, (mc)=> {
          mc['info']['limit']['h'] = resData[mc.key]['h']; // 上限
          mc['info']['limit']['hh'] = resData[mc.key]['hh']; // 上上限
        });
      })
      .catch((err) => {
        console.log(err);
      });
    },
    searchData() {
			var dataList = _.map(meter_index, (mi)=> {
				return {
					key: mi.key, 
					name: mi.name, 
					id: mi.ID, 
					table: mi.tableName,
					pid: mi.ProductionID.join()
				}
			});

      var params = {
        Action: "MeterIndex",
        Datas: {
          id_list: dataList,
          date: this.search.date, //查當天不用帶date
        },
      };
      this.FnWebAPIGet(params)
        .then((res) => {
          var resData = res.data.data;
          
          if (_.isObject(resData)) {
            _.each(this.meter_charts, (mc) => {
              // var data = resData[mc.key][0];
              var data = _.last(resData[mc.key]);
              if(!_.isUndefined(data)) {
                mc["info"]["used"]["value"] = Math.round(Number(data.dosage) * 10) / 10; // 日用量
                // mc["info"]["used"]["value"] = Math.round((Number(data.Max_value) - Number(data.Min_value)) * 10) / 10; // 日用量
                mc["info"]["qty"]["value"] = data.day_weight; // 日產量
              }
              
            });
          }
        })
        .catch((err) => {
          console.log(err);
        });
    },
    // 到曆史查詢頁面
    toHistoryPage(_mc) {
      this.FnPageSwitch('indicatros_trend.php', {key: _mc.key});
    },
  },
};
