var page_function = {
    components: {},
    data() {
        return {
            VarMenuPage: "diagram_recycled",
            VarMenu: "area",
            VarPageContainerCss: "padding:0px",

            

        };
    },

    computed: {},
    watch: {},

    mounted() {
        this.$set(this.WebSetup, "caption", "回收水處理圖");
        this.MenuSetup.opened = false;
        this.VarMenuIsOverlay = true;
        console.log(diagram_recycled_base_pic)
        this.loadStatus();
        this.sysNowTime();
    },
    methods: {
        //  刷新頁面
        sysNowTime() {
          let that = this;
          setInterval(function () {
            that.loadStatus();
          }, count_sec * 1000);
        },
        //  區塊定位
        getBillboardAddr(top , left, width, height, zIndex , transform) {
            return {
                "position" : "absolute",
                "zIndex" : `${!_.isNil(zIndex) ? zIndex : '5' }`,
                "top" : `${!_.isNil(top) ? top : '0' }%`,
                "left" : `${!_.isNil(left) ? left : '0' }%`,
                "width" : `${!_.isNil(width) ? width : '250' }px`,
                "height" : `${!_.isNil(height) ? height : '250' }px`,
                "transform" : `rotate(${!_.isNil(transform) ? transform : '0' }deg)`
            }
        },
        //  狀態更新
        loadStatus() {
            var params = {
                Action: "Status",
                Datas: {},
                menu_page : "system_water_flow_chart"
            };
            this.FnWebAPIGet(params).then((res) => {
                if ( !_.isEmpty(res.data.data) ) {
                    var resData = res.data.data;
                    //  設備
                    _.each(diagram_recycled_base_pic, (item) => {
                        if (!_.isNil(item['Id'])) {
                            let resDataIdStates = _.get(resData, [item['Id'], 'States']); 
                            let itemStateValue = _.get(item, ['States', resDataIdStates]);
                            if ( !_.isEmpty(item['alarm_States']) && _.includes(item['alarm_States'], resDataIdStates) ) {
                                item['animation'] = true
                            } else {
                                item['animation'] = false
                            }
                            item['imgUrl'] = itemStateValue;
                        }
                    })
                    //  箭頭
                    _.each(arrow_direction, (item) => {
                        if (!_.isNil(item['Id'])) {
                            let resDataIdStates = _.get(resData, [item['Id'], 'States']); 
                            let itemStateValue = _.get(item, ['States', resDataIdStates]);
                            item['animation'] = resDataIdStates !== '0';
                            item['class'] = itemStateValue;
                        }
                    });
                } else {
                    console.log('無資料')
                }
                



            }).catch((err) => {
                console.log(err);
            });
        }
    },
};
