var page_function = {
	components: {},
	data() {
		return {
			VarMenuPage: "diagram_wastewater",
			VarMenu: "area",
			VarPageContainerCss: "padding:0px",

			billboard: {
			  "14": {
				show: true,
				title: "排放表",
				title_style: "background: linear-gradient(to right, #1c48ae 5% , #102e72 50% , #0c255c 95%);",  //  標體底色
				caption: "ID = 14",
				showButton: false,
				button: {
				  	item01: {
						show: true,
						label: "長條圖",
						icon: "leaderboard",
						linkto: "chart_bar.php",
						params: { options: "排放表" , item_type: "水"},
				  	},
				  	item02: {
						show: true,
						label: "圓餅圖",
						icon: "pie_chart",
						linkto: "chart_pie.php",
						params: { options: "排放表" , item_type: "水"},
					},
				},
				data: {
				  	item01: {
						show: true,
						label: "即時值",
						isDBValue: true,
						DBvalue: 0,
						isSoft: true,
						SoftValue: "",
						unit: "m³/hr",
						icon: "water_drop",
					},
				  	item02: {
						show: true,
						label: "日用量",
						isDBValue: true,
						DBvalue: 0,
						isSoft: true,
						SoftValue: "",
						unit: "m³/hr",
						icon: "water_drop",
					},
				},
				top: "66.5",
				left: "79.5",
				width: "340",
			  },
			}

		};
	},

	computed: {},
	watch: {},

	mounted() {
		this.$set(this.WebSetup, "caption", "廢水處理流程圖");
		this.MenuSetup.opened = false;
		this.VarMenuIsOverlay = true;
		this.loadData()
		this.loadStatus();
		this.sysNowTime();
	},
	methods: {
		//  刷新頁面
		sysNowTime() {
		  	let that = this;
		  	setInterval(function () {
				that.loadData()
				that.loadStatus();
			}, count_sec * 1000);
		},
		//  區塊定位
		getBillboardAddr(top , left, width, height, zIndex , transform) {
			return {
				"position" : "absolute",
				"zIndex" : `${!_.isNil(zIndex) ? zIndex : '5' }`,
				"top" : `${!_.isNil(top) ? top : '0' }%`,
				"left" : `${!_.isNil(left) ? left : '0' }%`,
				"width" : `${!_.isNil(width) ? width : '250' }px`,
				"height" : `${!_.isNil(height) ? height : '250' }px`,
				"transform" : `rotate(${!_.isNil(transform) ? transform : '0' }deg)`
			}
		},
		loadData() {
		  	_.each(this.billboard, (item, key) => {
				_.each(item['data'], (data, data_key) => {
			  		data['DBvalue'] = 0
				})
		  	})
		  	var params = {
				Action: "LoadPageData",
				Datas: {},
				menu_page: "system_water"
		  	};
		  	this.FnWebAPIGet(params).then((res) => {
				var resData = res.data.data;
				var groupByIdData = _.groupBy(resData, 'ID')
				//  基本內容塞值
				_.each(this.billboard, (item, key) => {
			  		if (!_.isNil(groupByIdData[key])) {
						_.each(item['data'], (data , data_key) => {
							if (data_key == "item01" && data['isDBValue'] ) {
								data['DBvalue'] = this.FnRoundToDecimal(!_.isNil(groupByIdData[key][0]['MAX_Flow']) ? groupByIdData[key][0]['MAX_Flow'] : 0, 2) 
							}
							if (data_key == "item02" && data['isDBValue'] ) {
								data['DBvalue'] = this.FnRoundToDecimal(!_.isNil(groupByIdData[key][0]['today_Acc']) ? groupByIdData[key][0]['today_Acc'] : 0, 2) 
							}
						})
			  		} 
				})
				//  數據格式化
				_.each(this.billboard , (detail) => {
				  	_.each(detail['data'] , (item)=> {
						item['DBvalue'] = this.FnFormatNumber(item['DBvalue'], 1 )
				  	})
				})
		  	}).catch((err) => {
				console.log(err);
		 	});
		},
		//  狀態更新
		loadStatus() {
		  	var params = {
			  	Action: "Status",
			  	Datas: {},
			  	menu_page : "system_water_flow_chart"
		  	};
		  	this.FnWebAPIGet(params).then((res) => {
				if ( !_.isEmpty(res.data.data) ) {
			  	var resData = res.data.data;
			  	//  設備
			  	_.each(diagram_wastewater_base_pic, (item) => {
				  	if (!_.isNil(item['Id'])) {
					  	let resDataIdStates = _.get(resData, [item['Id'], 'States']); 
					  	let itemStateValue = _.get(item, ['States', resDataIdStates]);
					  	if ( !_.isEmpty(item['alarm_States']) && _.includes(item['alarm_States'], resDataIdStates) ) {
                            item['animation'] = true
                        } else {
                            item['animation'] = false
                        }
					  	item['imgUrl'] = itemStateValue;
				  	}
			  	})
			  	//  箭頭
			  	_.each(arrow_direction, (item) => {
				  	if (!_.isNil(item['Id'])) {
					  	let resDataIdStates = _.get(resData, [item['Id'], 'States']); 
					  	let itemStateValue = _.get(item, ['States', resDataIdStates]);
					  	item['animation'] = resDataIdStates !== '0';
					  	item['class'] = itemStateValue;
				  	}
			  	});
		  	} else {
			  	console.log('無資料')
		  	}
		  }).catch((err) => {
			  console.log(err);
		  });
		}
	},
};
