var page_function = {
	components: {},
	data () {
		return {
			"VarMenuPage": "energy_estimation",
			"VarMenu": "area",
			"VarPageContainerCss" : "padding:10px",

			//	查詢面板
			"search" : {
				"title" : "全廠能源平衡總覽圖",
				"subTitle" : "查詢",
				"range" : {
					"value" : "month",
					"options" : [
						{ "label" : "月", "value" : "month" },
						{ "label" : "年", "value" : "year"}, 
					]
				},
				"data" : {
					"range" : "month",  //	month => 月, year => 年
					"month" : new Date(),
					"year" : new Date(),
				},
			},
			//	月能源用量占比面板
			"monthEnergy" : {
				"show" : true,
				"label" : "能源用量占比",
				"info" : {
					"power" : {
						"show" : true,
						"label" : "電力",
						"color": "green-3",
						"data" : {
							"label" : "電力",
							"value" : 0,
							"unit" : "% Mcal"
						},
					},
					"steam" : {
						"show" : true,
						"label" : "蒸汽",
						"color": "cyan-3",
						"data" : {
							"label" : "蒸汽",
							"value" : 0,
							"unit" : "% Mcal"
						},
					},
					"steam-2" : {
						"show" : true,
						"label" : "蒸汽-燒臘區",
						"color": "yellow-3",
						"data" : {
							"label" : "燒臘區",
							"value" : 0,
							"unit" : "% Mcal",
						},
					},
					"gas" : {
						"show" : true,
						"label" : "瓦斯",
						"color": "indigo-3",
						"data" : {
							"label" : "瓦斯",
							"value" : 0,
							"unit" : "% Mcal"
						},
					},
					"natural_gas" : {
						"show" : true,
						"label" : "天燃汽",
						"color": "red-3",
						"data" : {
							"label" : "天燃汽",
							"value" : 0,
							"unit" : "% Mcal"
						},
					},
				},
				//	圓餅圖 
				"pieOptions" :{
					"title" : {
						"text" : "loading...",
						"subtext" : "熱值Mcal",
						"left" : "center",
						"top" : "center",
						"textStyle" : {
							"fontSize" : 16,
							"color" : "#25FDFD",
							"lineHeight" : 15,
						},
						"subtextStyle" : {
							"fontSize" : 12,
							"color" : "#fff",

					}
					},
					"tooltip" : {
						"trigger" : "item"
					},
					"legend" : {
						"show" : false,
					    "top" : 'center',
					    "left" : 'center'
					},
					"series" : [
					    {
							"type" : 'pie',
							"radius" : ['60%', '90%'],
							"avoidLabelOverlap" : false,
							"label" : {
							  	"show" : true,
							  	"position" : 'inside',
							  	"formatter" : function (params){
	                             		return  params.value + '%\n'
	                       		},
							},
						    "data" : [
						        // { value: 100, name: '電力', "itemStyle" : { "color" : "#a5d6a7" }},
						        // { value: 100, name: '蒸汽', "itemStyle" : { "color" : "#80deea" }},
						        // { value: 100, name: '瓦斯', "itemStyle" : { "color" : "#9fa8da" }},
						        { value: 0, name: '電力', "itemStyle" : { "color" : "#a5d6a7" }},
						        { value: 0, name: '蒸汽', "itemStyle" : { "color" : "#80deea" }},
						        { value: 0, name: '蒸汽-燒臘區', "itemStyle" : { "color" : "#e8da6f" }},
						        { value: 0, name: '瓦斯', "itemStyle" : { "color" : "#9fa8da" }},
						        { value: 0, name: '天燃汽', "itemStyle" : { "color" : "#da9fa8" }},
						    ]
					    }
					]
				},
			},
			//	能源總類各用量
			"EnergyParamTable" : {
				"title" : {
					"item01" : { "label": "能源種類", "style": "float: left;"},
					"item02" : { "label": "使用量", "style": "float: right;"},
					"item03" : { "label": "熱值Mcal", "style": "float: right;"},
					"item04" : { "label": "公秉油當量", "style": "float: right;"},
					"item05" : { "label": "排碳量", "style": "float: right;"},
					"item06" : { "label": "占比", "style": "float: right;"},
				},
				"data": [
					{ "label" : "外購電力 (kWh)", "total" : "0", "mcal" : "0", "oil" : "0", "co2e" : "0", "percent" : "0" },
					{ "label" : "外購蒸汽 (公噸)", "total" : "0", "mcal" : "0", "oil" : "0", "co2e" : "0", "percent" : "0" },
					{ "label" : "蒸汽-燒臘區", "total" : "0", "mcal" : "0", "oil" : "0", "co2e" : "0", "percent" : "0" },
					{ "label" : "液化石油氣 (公噸)", "total" : "0", "mcal" : "0", "oil" : "0", "co2e" : "0", "percent" : "0" },
					{ "label" : "外購天然瓦斯 (公噸)", "total" : "0", "mcal" : "0", "oil" : "0", "co2e" : "0", "percent" : "0" },
				]
			},
			//	頁籤
			"qTabForm" :{
				//	電力平衡
				"power" : {
					"show" : true,
					"title" : "電力平衡",
					"hidden" : false,
					"default" : true,
					"icon" : "flash_on",
					//	圓餅圖 
					"pieOptions" :{
						"title" : {
							"text" : "loading...",
								"subtext" : "kWh",
								"left" : "center",
								"top" : "center",
								"textStyle" : {
									"fontSize" : 42,
									"color" : "#25FDFD",
									"lineHeight" : 40,
								},
								"subtextStyle" : {
									"fontSize" : 18,
									"color" : "#fff",

								}
						},
						"tooltip" : {
							"trigger" : "item"
						},
						"legend" : {
							"show" : false,
						    "top" : 'center',
						    "left" : 'center'
						},
						"series" : [
						    {
								"type" : 'pie',
								"radius" : ['60%', '90%'],
								"avoidLabelOverlap" : false,
								"label" : {
								  	"show" : true,
								  	"position" : 'inside',
								  	"formatter" : function (params){
	                              		return  params.value + '%\n'
	                        		},
								},
							    "data" : [
							      { value: 0, name: '照明', "itemStyle" : { "color" : "#F57582" }},
								    { value: 0, name: '冷凍空調', "itemStyle" : { "color" : "#FFA940" }},
								    { value: 0, name: '製程動力', "itemStyle" : { "color" : "#FFC53D" }},
								    { value: 0, name: '通風', "itemStyle" : { "color" : "#73D13D" }},
								    { value: 0, name: '空壓', "itemStyle" : { "color" : "#45DAD1" }},
								    { value: 0, name: '公用設備', "itemStyle" : { "color" : "#40A9FF" }},
								    { value: 0, name: '其他', "itemStyle" : { "color" : "#6682F5" }},
							    ]
						    }
						]
					},
					"pieInfo" : {
						"item01" : {
							"show" : true,
							"showBorder" : false,
							"label" : "照明",
							"color": "#F57582",
							"value" : 0,
							"unit" : "%",
						},
						"item02" : {
							"show" : true,
							"showBorder" : false,
							"label" : "冷凍空調",
							"color": "#FFA940",
							"value" : 0,
							"unit" : "%",
						},
						"item03" : {
							"show" : true,
							"showBorder" : false,
							"label" : "製程動力",
							"color": "#FFC53D",
							"value" : 0,
							"unit" : "%",
						},
						"item04" : {
							"show" : true,
							"showBorder" : false,
							"label" : "通風",
							"color": "#73D13D",
							"value" : 0,
							"unit" : "%",
						},
						"item05" : {
							"show" : true,
							"showBorder" : false,
							"label" : "空壓",
							"color": "#45DAD1",
							"value" : 0,
							"unit" : "%",
						},
						"item06" : {
							"show" : true,
							"showBorder" : false,
							"label" : "公用設備",
							"color": "#40A9FF",
							"value" : 0,
							"unit" : "%",
						},
						"item07" : {
							"show" : true,
							"showBorder" : false,
							"label" : "其他",
							"color": "#6682F5",
							"value" : 0,
							"unit" : "%",
						}
					},	
					"table" : {
						"block_01" : {
							"titleClass" : "w3-row w3-center q-pa-sm bg-blue-9 text-white", 
							"dataClass" : "w3-row w3-center q-pa-sm q-ma-sm bg-blue-1 text-black",
							"title" : {
								"item01" : { "label": "區域", "class" : "w3-col l2 m2 s2 w3-left-align"},
								"item02" : { "label": "使用量", "class" : "w3-col l2 m2 s2 w3-right-align"},
								"item03" : { "label": "熱值Mcal", "class" : "w3-col l2 m2 s2 w3-right-align"},
								"item04" : { "label": "公秉油當量", "class" : "w3-col l2 m2 s2 w3-right-align"},
								"item05" : { "label": "排碳量", "class" : "w3-col l2 m2 s2 w3-right-align"},
								"item06" : { "label": "占比", "class" : "w3-col l2 m2 s2 w3-right-align"},
							},
							"data": [
								{ "label" : "照明", "total" : "0", "mcal" : "1", "oil" : "2", "co2e" : "3", "percent" : "4" },
								{ "label" : "冷凍空調", "total" : "0", "mcal" : "1", "oil" : "2", "co2e" : "3", "percent" : "4" },
								{ "label" : "製程動力", "total" : "0", "mcal" : "1", "oil" : "2", "co2e" : "3", "percent" : "4" },
								{ "label" : "通風", "total" : "0", "mcal" : "1", "oil" : "2", "co2e" : "3", "percent" : "4" },
								{ "label" : "空壓", "total" : "0", "mcal" : "1", "oil" : "2", "co2e" : "3", "percent" : "4" },
								{ "label" : "公用設備", "total" : "0", "mcal" : "1", "oil" : "2", "co2e" : "3", "percent" : "4" },
								{ "label" : "其他", "total" : "0", "mcal" : "1", "oil" : "2", "co2e" : "3", "percent" : "4" },
							]
						},
						"block_02" : {
							"titleClass" : "w3-row w3-center q-pa-sm bg-blue-9 text-white", 
							"dataClass" : "w3-row w3-center q-pa-sm q-ma-sm bg-blue-1 text-black",
							"title" : {
								"item01" : { "label": "太陽能", "class" : "w3-col l2 m2 s2 w3-left-align"},
								"item02" : { "label": "度", "class" : "w3-col l2 m2 s2 w3-right-align"},
								"item03" : { "label": "" },
								"item04" : { "label": "" },
								"item05" : { "label": "" },
								"item06" : { "label": "" },
							},
							"data": [
								{ "label" : "外售電力", "total" : "0",},
								{ "label" : "新東陽大園廠 ", "total" : "0", "exception" : true , "linkTo" : "http://61.216.85.251/Solar-Enterprise_Security/#/single?stn=39"},
								{ "label" : "新東陽大園廠(B倉)", "total" : "0", "exception" : true , "linkTo" : "http://61.216.85.251/Solar-Enterprise_Security/#/single?stn=177"},
							]
						}
					}

				},
				//	熱能平衡
				"gas_steam" : {
					"show" : true,
					"title" : "熱能平衡",
					"hidden" : false,
					"default" : false,
					"icon" : "local_fire_department",
					"pieOptions" :{
						"title" : {
							"text" : "loading...",
								"subtext" : "公噸",
								"left" : "center",
								"top" : "center",
								"textStyle" : {
									"fontSize" : 42,
									"color" : "#25FDFD",
									"lineHeight" : 40,
								},
								"subtextStyle" : {
									"fontSize" : 18,
									"color" : "#fff",

								}
						},
						"tooltip" : {
							"trigger" : "item"
						},
						"legend" : {
							"show" : false,
						    "top" : 'center',
						    "left" : 'center'
						},
						"series" : [
						    {
								"type" : 'pie',
								"radius" : ['60%', '90%'],
								"avoidLabelOverlap" : false,
								"label" : {
							  	"show" : true,
							  	"position" : 'inside',
							  	"formatter" : function (params){
                    return  params.value + '%\n'
                	},
								},
							  "data" : [
							    { value: 0, name: '蒸汽系統', "itemStyle" : { "color" : "#91cc75" }},
							    { value: 0, name: '瓦斯系統', "itemStyle" : { "color" : "#fac858" }},      
							  ]
						  }
						]
					},
					"pieInfo" : {
						"item01" : {
							"show" : true,
							"showBorder" : false,
							"label" : "蒸汽系統",
							"color": "#91cc75",
							"value" : 0,
							"unit" : "%",
						},
						"item02" : {
							"show" : true,
							"showBorder" : false,
							"label" : "瓦斯系統",
							"color": "#fac858",
							"value" : 0,
							"unit" : "%",
						},	
					},
					"table" : {
						"block_01" : {
							"titleClass" : "w3-row w3-center q-pa-sm bg-green-5 text-white", 
							"dataClass" : "w3-row w3-center q-pa-sm q-ma-sm  bg-grey-1 text-black",
							"title" : {
								"item01" : { "label": "蒸汽系統 - 區域", "class" : "w3-col l2 m2 s2 w3-left-align"},
								"item02" : { "label": "使用量", "class" : "w3-col l2 m2 s2 w3-right-align"},
								"item03" : { "label": "熱值Mcal", "class" : "w3-col l2 m2 s2 w3-right-align"},
								"item04" : { "label": "公秉油當量", "class" : "w3-col l2 m2 s2 w3-right-align"},
								"item05" : { "label": "排碳量", "class" : "w3-col l2 m2 s2 w3-right-align"},
								"item06" : { "label": "占比", "class" : "w3-col l2 m2 s2 w3-right-align"},
							},
							"data": [
								{ "label" : "蒸煮室", "total" : "0", "mcal" : "0", "oil" : "0", "co2e" : "0", "percent" : "0" },
								{ "label" : "罐頭加工室", "total" : "0", "mcal" : "0", "oil" : "0", "co2e" : "0", "percent" : "0" },
								{ "label" : "肉品烘烤室", "total" : "0", "mcal" : "0", "oil" : "0", "co2e" : "0", "percent" : "0" },
								{ "label" : "燒臘區", "total" : "0", "mcal" : "0", "oil" : "0", "co2e" : "0", "percent" : "0" },
								{ "label" : "屋頂", "total" : "0", "mcal" : "0", "oil" : "0", "co2e" : "0", "percent" : "0" },
								{ "label" : "熟食包裝室", "total" : "0", "mcal" : "0", "oil" : "0", "co2e" : "0", "percent" : "0" },
								{ "label" : "糕餅調理室", "total" : "0", "mcal" : "0", "oil" : "0", "co2e" : "0", "percent" : "0" },
							]
						},
						"block_02" : {
							"titleClass" : "w3-row w3-center q-pa-sm bg-amber-13 text-white", 
							"dataClass" : "w3-row w3-center q-pa-sm q-ma-sm bg-grey-1 text-black",
							"title" : {
								"item01" : { "label": "瓦斯系統 - 區域", "class" : "w3-col l2 m2 s2 w3-left-align" },
								"item02" : { "label": "使用量", "class" : "w3-col l2 m2 s2 w3-right-align" },
								"item03" : { "label": "熱值Mcal", "class" : "w3-col l2 m2 s2 w3-right-align" },
								"item04" : { "label": "公秉油當量", "class" : "w3-col l2 m2 s2 w3-right-align" },
								"item05" : { "label": "排碳量", "class" : "w3-col l2 m2 s2 w3-right-align" },
								"item06" : { "label": "占比", "class" : "w3-col l2 m2 s2 w3-right-align" },
							},
							"data": [
								{ "label" : "肉品烘烤室", "total" : "0", "mcal" : "0", "oil" : "0", "co2e" : "0", "percent" : "0" },
								{ "label" : "蒸煮室", "total" : "0", "mcal" : "0", "oil" : "0", "co2e" : "0", "percent" : "0" },
								{ "label" : "西點烘培室", "total" : "0", "mcal" : "0", "oil" : "0", "co2e" : "0", "percent" : "0" },
								{ "label" : "燒臘區", "total" : "0", "mcal" : "0", "oil" : "0", "co2e" : "0", "percent" : "0" },
								{ "label" : "中點調理室", "total" : "0", "mcal" : "0", "oil" : "0", "co2e" : "0", "percent" : "0" },
								{ "label" : "發電機", "total" : "0", "mcal" : "0", "oil" : "0", "co2e" : "0", "percent" : "0" },
							]
						}
					}
				}
			}
		}
	},

	computed :{
		titleName(){
			return _.reduce(this.search['range']['options'] , (obj , key) => {
				obj[key['value']] = key['label']
				return obj
			},{})
		}
	},
	watch : {},

	mounted () {
		this.$set(this.WebSetup, "caption", '全廠能源佔比');
		this.MenuSetup.opened = false;
		this.VarMenuIsOverlay = true;
		this.searchData()
	},
	methods: {
		//樹狀陣列平扁化
    get_options_id(array, key, group) {
      var that = this;
      // console.log(key, group);
      if (device_item[group][key]) {
        device_item[group][key]["options"].forEach((el) => {
          if (!isNaN(Number(el.value, 10))) {
            array.push(el.value);
          } else if (device_item[group].hasOwnProperty(el.label)) {
            return that.get_options_id(array, el.label, group);
          }
        });
      }
    },
		//	所有按鈕事件
		btnEvent(btn, value) {
			btn.fn(value)
		},

		//	分佈圖，跳至相對應的畫面
		async jumpToDashboard (link) {
			if (await this.FnConfirm("提醒", `是否轉跳至${link['label']}？`)) {
				this.FnPageSwitch(link['value']);
			}
		},

		searchData() {
			var params = {
				Action : 'SearchData',
				Datas : {
					year_month : moment(this.search['data']['month']).format('YYYY-MM'),
					year : moment(this.search['data']['year']).format('YYYY'),
					range : this.search['range']['value']
				},
			};
			
			this.FnWebAPIGet(params).then((res)=> {
				if ( _.isEmpty(res.data.data['energy_data']) ){
					this.monthEnergy['pieOptions']['title']['text'] = this.FnFormatNumber(0,0)
					_.each(this.monthEnergy.info , (item) => {
						item['data']['value'] = 0
					})
					_.each(this.monthEnergy['pieOptions']['series'][0]['data'] , (item) => {
						item['value'] = this.FnRoundToDecimal(0,2)	
					})
				}
				//	=========================================================	 清除資料
				if ( _.isEmpty(res.data.data['pm_data']) ){
					this.FnNotify(`${_.includes(this.search['range']['value'] , 'month')?moment(this.search['data']['month']).format('YYYY-MM'):moment(this.search['data']['year']).format('YYYY')}${this.titleName[this.search['range']['value']]}外購電力無資料`,'warning')
					this.EnergyParamTable['data'][0]['total'] = this.FnFormatNumber(0,0)
					this.EnergyParamTable['data'][0]['mcal'] = this.FnFormatNumber(0,0)
					this.EnergyParamTable['data'][0]['oil'] = this.FnFormatNumber(0,0)
					this.EnergyParamTable['data'][0]['co2e'] = this.FnFormatNumber(0,0)
					this.EnergyParamTable['data'][0]['percent'] = this.FnFormatNumber(0,0)
					this.qTabForm['power']['pieOptions']['title']['text'] = this.FnFormatNumber(0,0) 
					_.each(this.qTabForm['power']['pieOptions']['series'][0]['data'] , (item) => { item['value'] = this.FnRoundToDecimal(0,0) })
					_.each(this.qTabForm['power']['pieInfo'] , (item) => { item['value'] = this.FnRoundToDecimal(0,0) })
					_.each(this.qTabForm['power']['table']['block_01']['data'] , (item) => {
						item['total'] = this.FnFormatNumber(0,0)
						item['mcal'] = this.FnFormatNumber(0,0)
						item['oil'] = this.FnFormatNumber(0,0)
						item['co2e'] = this.FnFormatNumber(0,0)
						item['percent'] = this.FnFormatNumber(0,0)
					})
					this.qTabForm['power']['table']['block_02']['data'][0]['total'] = this.FnFormatNumber(0,0)
					this.qTabForm['power']['table']['block_02']['data'][1]['total'] = this.FnFormatNumber(0,0)
				}
				if ( _.isEmpty(res.data.data['sm_data']) ){
					this.FnNotify(`${_.includes(this.search['range']['value'] , 'month')?moment(this.search['data']['month']).format('YYYY-MM'):moment(this.search['data']['year']).format('YYYY')}${this.titleName[this.search['range']['value']]}外購蒸汽無資料`,'warning')
					this.EnergyParamTable['data'][1]['total'] = this.FnFormatNumber(0,0)
					this.EnergyParamTable['data'][1]['mcal'] = this.FnFormatNumber(0,0)
					this.EnergyParamTable['data'][1]['oil'] = this.FnFormatNumber(0,0)
					this.EnergyParamTable['data'][1]['co2e'] = this.FnFormatNumber(0,0)
					this.EnergyParamTable['data'][1]['percent'] = this.FnFormatNumber(0,0)
					this.qTabForm['gas_steam']['pieOptions']['title']['text'] = this.FnFormatNumber(0,0) 
					this.qTabForm['gas_steam']['pieOptions']['series'][0]['data'][0]['value'] = this.FnRoundToDecimal(0,0) 
					this.qTabForm['gas_steam']['pieInfo']['item01']['value'] = this.FnRoundToDecimal(0,0) 					
					_.each(this.qTabForm['gas_steam']['table']['block_01']['data'] , (item) => {
						item['total'] = this.FnFormatNumber(0,0)
						item['mcal'] = this.FnFormatNumber(0,0)
						item['oil'] = this.FnFormatNumber(0,0)
						item['co2e'] = this.FnFormatNumber(0,0)
						item['percent'] = this.FnFormatNumber(0,0)
					})
				}
				if ( _.isEmpty(res.data.data['gm_data']) ){
					this.FnNotify(`${_.includes(this.search['range']['value'] , 'month')?moment(this.search['data']['month']).format('YYYY-MM'):moment(this.search['data']['year']).format('YYYY')}${this.titleName[this.search['range']['value']]}液化石油氣無資料`,'warning')
					this.EnergyParamTable['data'][2]['total'] = this.FnFormatNumber(0,0)
					this.EnergyParamTable['data'][2]['mcal'] = this.FnFormatNumber(0,0)
					this.EnergyParamTable['data'][2]['oil'] = this.FnFormatNumber(0,0)
					this.EnergyParamTable['data'][2]['co2e'] = this.FnFormatNumber(0,0)
					this.EnergyParamTable['data'][2]['percent'] = this.FnFormatNumber(0,0)
					this.qTabForm['gas_steam']['pieOptions']['title']['text'] = this.FnFormatNumber(0,0) 
					this.qTabForm['gas_steam']['pieOptions']['series'][0]['data'][1]['value'] = this.FnRoundToDecimal(0,0) 
					this.qTabForm['gas_steam']['pieInfo']['item02']['value'] = this.FnRoundToDecimal(0,0) 
					_.each(this.qTabForm['gas_steam']['table']['block_02']['data'] , (item) => {
						item['total'] = this.FnFormatNumber(0,0)
						item['mcal'] = this.FnFormatNumber(0,0)
						item['oil'] = this.FnFormatNumber(0,0)
						item['co2e'] = this.FnFormatNumber(0,0)
						item['percent'] = this.FnFormatNumber(0,0)
					})
				}

				var resData = res.data.data;
				var ep_power = res.data.data.ep['電力'];
				var ep_steam = res.data.data.ep['蒸汽'];
				var ep_gas = res.data.data.ep['液化石油氣（瓦斯LPG）'];
				//	月能源用量占比
				//	月能源用量占比 - 加總
				var mcal_total = _.sumBy(resData['energy_data'], (item) => { return !_.isNil(item['mcal']) ? parseFloat(item['mcal']) : 0 } )
				var groupItem = _.groupBy(resData['energy_data'] , 'name')
				console.log(groupItem)
				//	月能源用量占比 - 項目
				_.each(this.monthEnergy.info , (item) => {
					item['data']['value'] = groupItem[item['label']] !== 0  ? this.FnFormatNumber(groupItem[item['label']][0]['mcal'] / mcal_total * 100 ) : 0
				})
				// 月能源用量占比 - 圓餅圖數值 
				this.monthEnergy['pieOptions']['title']['text'] = this.FnFormatNumber(mcal_total)
				_.each(this.monthEnergy['pieOptions']['series'][0]['data'] , (item) => {
					if ( !_.isNil(groupItem[item['name']]) ) {
						item['value'] = this.FnRoundToDecimal( 
							groupItem[item['name']] !== 0 ? groupItem[item['name']][0]['mcal'] / mcal_total * 100 : 0 
						)	
					}
				})
				//	能源總類各用量 (這裡可能會出bug)
				/*
					energy_data:
					[0]電力
					[1]蒸汽
					[2]蒸汽-燒臘區
					[3]瓦斯
					[4]天燃汽
				*/
				//	外購電力
				this.EnergyParamTable['data'][0]['total'] = this.FnFormatNumber(resData['energy_data'][0]['dosage'])
				this.EnergyParamTable['data'][0]['mcal'] = this.FnFormatNumber(resData['energy_data'][0]['mcal'])
				this.EnergyParamTable['data'][0]['oil'] = this.FnFormatNumber(resData['energy_data'][0]['kloe'])
				this.EnergyParamTable['data'][0]['co2e'] = this.FnFormatNumber(resData['energy_data'][0]['co2e'])
				this.EnergyParamTable['data'][0]['percent'] = this.FnFormatNumber( (resData['energy_data'][0]['mcal'] / mcal_total) * 100)
				//	外購蒸汽 (公噸)
				this.EnergyParamTable['data'][1]['total'] = this.FnFormatNumber(resData['energy_data'][1]['dosage'])
				this.EnergyParamTable['data'][1]['mcal'] = this.FnFormatNumber(resData['energy_data'][1]['mcal'])
				this.EnergyParamTable['data'][1]['oil'] = this.FnFormatNumber(resData['energy_data'][1]['kloe'])
				this.EnergyParamTable['data'][1]['co2e'] = this.FnFormatNumber(resData['energy_data'][1]['co2e'])
				this.EnergyParamTable['data'][1]['percent'] = this.FnFormatNumber( (resData['energy_data'][1]['mcal'] / mcal_total) * 100)
				//	蒸汽-燒臘區
				this.EnergyParamTable['data'][2]['total'] = this.FnFormatNumber(resData['energy_data'][2]['dosage'])
				this.EnergyParamTable['data'][2]['mcal'] = this.FnFormatNumber(resData['energy_data'][2]['mcal'])
				this.EnergyParamTable['data'][2]['oil'] = this.FnFormatNumber(resData['energy_data'][2]['kloe'])
				this.EnergyParamTable['data'][2]['co2e'] = this.FnFormatNumber(resData['energy_data'][2]['co2e'])
				this.EnergyParamTable['data'][2]['percent'] = this.FnFormatNumber( (resData['energy_data'][2]['mcal'] / mcal_total) * 100)
				//	液化石油氣 (公噸)
				this.EnergyParamTable['data'][3]['total'] = this.FnFormatNumber(resData['energy_data'][3]['dosage'])
				this.EnergyParamTable['data'][3]['mcal'] = this.FnFormatNumber(resData['energy_data'][3]['mcal'])
				this.EnergyParamTable['data'][3]['oil'] = this.FnFormatNumber(resData['energy_data'][3]['kloe'])
				this.EnergyParamTable['data'][3]['co2e'] = this.FnFormatNumber(resData['energy_data'][3]['co2e'])
				this.EnergyParamTable['data'][3]['percent'] = this.FnFormatNumber( (resData['energy_data'][3]['mcal'] / mcal_total) * 100)
				//	外購天然瓦斯 (公噸)
				this.EnergyParamTable['data'][4]['total'] = this.FnFormatNumber(resData['energy_data'][4]['dosage'])
				this.EnergyParamTable['data'][4]['mcal'] = this.FnFormatNumber(resData['energy_data'][4]['mcal'])
				this.EnergyParamTable['data'][4]['oil'] = this.FnFormatNumber(resData['energy_data'][4]['kloe'])
				this.EnergyParamTable['data'][4]['co2e'] = this.FnFormatNumber(resData['energy_data'][4]['co2e'])
				this.EnergyParamTable['data'][4]['percent'] = this.FnFormatNumber( (resData['energy_data'][4]['mcal'] / mcal_total) * 100)

				// 電力平衡
				var temp_total_value = 0
				var groupByPm = _.groupBy(resData['pm_data'] , 'ID')
				_.each(this.qTabForm['power']['pieInfo'] , (item) => {
					_.each(this.treeMap('電力', item['label']) , (id) => {
						temp_total_value += !_.isNil(groupByPm[id['value']]) ? parseFloat(groupByPm[id['value']][0]['dosage']) : 0
					})
				})
				//	趨勢圖整理
				this.qTabForm['power']['pieOptions']['title']['text'] = this.FnFormatNumber(temp_total_value , 0) 
				_.each(this.qTabForm['power']['pieOptions']['series'][0]['data'] , (item) => {
					temp_info_value = 0 
					_.each(this.treeMap('電力', item['name']) , (id) => {
						temp_info_value += !_.isNil(groupByPm[id['value']]) ? parseFloat(groupByPm[id['value']][0]['dosage']) : 0
					})
					item['value'] = this.FnRoundToDecimal(  !_.isNaN(temp_info_value / temp_total_value) ? temp_info_value / temp_total_value * 100 : 0 , 0)
				})
				//	趨勢圖資訊欄整理
				var temp_info_value = 0
				_.each(this.qTabForm['power']['pieInfo'] , (item) => {
					temp_info_value = 0 
					_.each(this.treeMap('電力', item['label']) , (id) => {
						temp_info_value += !_.isNil(groupByPm[id['value']]) ? parseFloat(groupByPm[id['value']][0]['dosage']) : 0
					})
					item['value'] = this.FnRoundToDecimal(  !_.isNaN(temp_info_value / temp_total_value) ? temp_info_value / temp_total_value * 100 : 0 , 0)
				})
				//	表格資訊欄整理
				var temp_info_value = 0
				_.each(this.qTabForm['power']['table']['block_01']['data'] , (item) => {
					temp_info_value = 0 
					_.each(this.treeMap('電力', item['label']) , (id) => {
						temp_info_value += !_.isNil(groupByPm[id['value']]) ? parseFloat(groupByPm[id['value']][0]['dosage']) : 0
					})
					item['total'] = this.FnFormatNumber(temp_info_value, 2)
					item['mcal'] = this.FnFormatNumber( (temp_info_value * Number(ep_power['convert_rate_mcal']) * Number(ep_power['mcal'])) )
					item['oil'] = this.FnFormatNumber( (temp_info_value * Number(ep_power['convert_rate_kloe']) * Number(ep_power['kloe'])) )
					item['co2e'] = this.FnFormatNumber( (temp_info_value * Number(ep_power['convert_rate_co2e']) * Number(ep_power['co2e'])) )
					item['percent'] = this.FnRoundToDecimal(  !_.isNaN(temp_info_value / temp_total_value) ? temp_info_value / temp_total_value * 100 : 0 , 0)
				})

				//	三惟太陽能雲端系統 - 企安 新東陽大園廠
				var con = {
					stn  : "39",
					year_month : moment(this.search['data']['month']).format('YYYY-MM'),
					year : moment(this.search['data']['year']).format('YYYY'),
					type : this.search['range']['value']
				}
				axios.get('http://61.216.85.251/web_api/get_api.php',  {
				  params: con
				})
				.then(response => {
					this.qTabForm['power']['table']['block_02']['data'][1]['total'] = this.FnFormatNumber(response.data.Today_kwh)
				  // console.log(response.data);
				})
				.catch(error => {
				  console.error('Error fetching data:', error);
				});
				//	三惟太陽能雲端系統 - 企安 新東陽大園廠(B倉)
				var con = {
					stn  : "177",
					year_month : moment(this.search['data']['month']).format('YYYY-MM'),
					year : moment(this.search['data']['year']).format('YYYY'),
					type : this.search['range']['value']
				}
				axios.get('http://61.216.85.251/web_api/get_api.php',  {
				  params: con
				})
				.then(response => {
					this.qTabForm['power']['table']['block_02']['data'][2]['total'] = this.FnFormatNumber(response.data.Today_kwh)
				  // console.log(response.data);
				})
				.catch(error => {
				  console.error('Error fetching data:', error);
				});

				//	熱能平衡
				var groupByGm = _.groupBy(resData['gm_data'] , 'ID')
				var groupBySm = _.groupBy(resData['sm_data'] , 'ID')
				// 	瓦斯加總
				var gm_total = _.sumBy(resData['gm_data'], (item) => { return !_.isNil(item['dosage']) ? parseFloat(item['dosage']) : 0 } )
				// 	蒸汽加總
				var sm_total = _.sumBy(resData['sm_data'], (item) => { return !_.isNil(item['dosage']) ? parseFloat(item['dosage']) : 0 } )
				var temp_total_value = gm_total + sm_total
				//	趨勢圖整理
				this.qTabForm['gas_steam']['pieOptions']['title']['text'] = this.FnFormatNumber(gm_total + sm_total , 0) 
				this.qTabForm['gas_steam']['pieOptions']['series'][0]['data'][0]['value'] = this.FnRoundToDecimal(  !_.isNaN(sm_total / temp_total_value) ? sm_total / temp_total_value * 100 : 0 , 2) 
				this.qTabForm['gas_steam']['pieOptions']['series'][0]['data'][1]['value'] = this.FnRoundToDecimal(  !_.isNaN(gm_total / temp_total_value) ? gm_total / temp_total_value * 100 : 0 , 2) 
				this.qTabForm['gas_steam']['pieInfo']['item01']['value'] = this.FnRoundToDecimal( !_.isNaN(sm_total / temp_total_value) ? sm_total / temp_total_value * 100 : 0  , 2) 
				this.qTabForm['gas_steam']['pieInfo']['item02']['value'] = this.FnRoundToDecimal( !_.isNaN(gm_total / temp_total_value) ? gm_total / temp_total_value * 100 : 0 , 2) 

				//	表格資訊欄整理
				var temp_info_value = 0
				_.each(this.qTabForm['gas_steam']['table']['block_01']['data'] , (item) => {
					temp_info_value = 0 
					_.each(this.treeMap('蒸汽', item['label']) , (id) => {
						temp_info_value += !_.isNil(groupBySm[id['value']]) ? parseFloat(groupBySm[id['value']][0]['dosage']) : 0
					})
					item['total'] = this.FnFormatNumber(temp_info_value, 2)
					item['mcal'] = this.FnFormatNumber( (temp_info_value * Number(ep_steam['convert_rate_mcal']) * Number(ep_steam['mcal'])) )
					item['oil'] = this.FnFormatNumber( (temp_info_value * Number(ep_steam['convert_rate_kloe']) * Number(ep_steam['kloe'])) )
					item['co2e'] = this.FnFormatNumber( (temp_info_value * Number(ep_steam['convert_rate_co2e']) * Number(ep_steam['co2e'])) )
					item['percent'] = this.FnRoundToDecimal(  !_.isNaN(temp_info_value / temp_total_value) ? temp_info_value / sm_total * 100 : 0 , 2)
				})
				var temp_info_value = 0
				_.each(this.qTabForm['gas_steam']['table']['block_02']['data'] , (item) => {
					temp_info_value = 0 
					_.each(this.treeMap('瓦斯', item['label']) , (id) => {
						temp_info_value += !_.isNil(groupByGm[id['value']]) ? parseFloat(groupByGm[id['value']][0]['dosage']) : 0
					})
					item['total'] = this.FnFormatNumber(temp_info_value, 2)
					item['mcal'] = this.FnFormatNumber( (temp_info_value * Number(ep_gas['convert_rate_mcal']) * Number(ep_gas['mcal'])) )
					item['oil'] = this.FnFormatNumber( (temp_info_value * Number(ep_gas['convert_rate_kloe']) * Number(ep_gas['kloe'])) )
					item['co2e'] = this.FnFormatNumber( (temp_info_value * Number(ep_gas['convert_rate_co2e']) * Number(ep_gas['co2e'])) )
					item['percent'] = this.FnRoundToDecimal(  !_.isNaN(temp_info_value / temp_total_value) ? temp_info_value / sm_total * 100 : 0 , 2)
				})

			}).catch((err)=> {
				console.log(err);
			});
		},

		//  樹狀爸爸
    treeMap (item_type, keyWord) {
   		if (!_.isNil(index_chartPie_config[item_type][keyWord])) {
   			return _.map(index_chartPie_config[item_type][keyWord]['options'] , (item ) => {
       			return {  "value" : item['value'] , "label" : item['label'] } 
     			})
   		} else {
   		}
    },
    //樹狀陣列平扁化
    get_options_id(array, key, group) {
      var that = this;
      device_item[group][key]["options"].forEach((el) => {
        if (!isNaN(Number(el.value, 10))) {
          array.push(el.value);
        }
        if (device_item.hasOwnProperty(el.label)) {
          return that.get_options_id(array, el.label, group);
        }
      });
    },

	}
}