var page_function = {
	components: {},
	data () {
		return {
			"VarMenuPage": "index",
			"VarMenu": "area",
			"VarPageContainerCss" : "padding:10px",
			reloadIntervalSec: 300,
			"billboard" : {
				"info" : {
					"item01" : {																						
						"show" : true,																			//	是否顯示
						"label" : "超約次數" ,																	//	標籤，標題
						"value" :  [																			//	數值
							{ "label" : "本月超約次數" , "value" : 0 , "unit" : null ,  "show" : true, "tbNameKey" : null },
							{ "label" : "今年超約次數" , "value" : 0 , "unit" : null ,  "show" : true, "tbNameKey" : null },
						], 
						"unit" : null,																			//	單位
						"button" : [],																			//	按鈕
						"layout" : "one", 																		//	區分 最後走的樣式 one、 two、 three，以此類推
						"tbNameKey" : null,																		//	定義資料庫欄位的數值	
						"class" : "shadow-1 q-pa-sm w3-border q-mb-md index-flexRadius",													
						"style" : "height:248px",
					},
					"day_dosage" : {
						"show" : true,
						"label" : "全日累計用電" ,
						"value" : 0, 
						"unit" : "kWh",
						"button" : [
							{ "show" : false ,"label" : "資訊頁", "color" : "blue-2", "textColor" : "primary", "icon" : "list", "glossy" : false, "size" : "0.8rem", "round" : false, "fn" : () => { vm.FnPageSwitch('') } },
							{ "show" : false ,"label" : "長條圖", "color" : "blue-2", "textColor" : "primary", "icon" : "assessment", "glossy" : false, "size" : "0.8rem", "round" : false, "fn" : () => { vm.closeQWindow() } },
							{ "show" : false ,"label" : "圓餅圖", "color" : "blue-2", "textColor" : "primary", "icon" : "pie_chart", "glossy" : false, "size" : "0.8rem", "round" : false, "fn" : () => { vm.sendProductionInfo() } },
						],
						"layout" : "two", 		
						"class" : "shadow-1 q-pa-sm q-mb-sm index-flexRadius",
					},
					"month_dosage" : {
						"show" : true,
						"label" : "本月累計用電" ,
						"value" : 0, 
						"unit" : "kWh",
						"button" : [
							{ "show" : false ,"label" : "資訊頁", "color" : "blue-2", "textColor" : "primary", "icon" : "list", "glossy" : false, "size" : "0.8rem", "round" : false, "fn" : () => { vm.FnPageSwitch('') } },
							{ "show" : false ,"label" : "長條圖", "color" : "blue-2", "textColor" : "primary", "icon" : "assessment", "glossy" : false, "size" : "0.8rem", "round" : false, "fn" : () => { vm.closeQWindow() } },
							{ "show" : false ,"label" : "圓餅圖", "color" : "blue-2", "textColor" : "primary", "icon" : "pie_chart", "glossy" : false, "size" : "0.8rem", "round" : false, "fn" : () => { vm.sendProductionInfo() } },
						],
						"layout" : "two", 		
						"class" : "shadow-1 q-pa-sm q-mb-sm index-flexRadius",
					},
					"year_dosage" : {
						"show" : true,
						"label" : "本年累計用電" ,
						"value" : 0, 
						"unit" : "kWh",
						"button" : [
							{ "show" : false ,"label" : "資訊頁", "color" : "blue-2", "textColor" : "primary", "icon" : "list", "glossy" : false, "size" : "0.8rem", "round" : false, "fn" : () => { vm.FnPageSwitch('') } },
							{ "show" : false ,"label" : "長條圖", "color" : "blue-2", "textColor" : "primary", "icon" : "assessment", "glossy" : false, "size" : "0.8rem", "round" : false, "fn" : () => { vm.closeQWindow() } },
							{ "show" : false ,"label" : "圓餅圖", "color" : "blue-2", "textColor" : "primary", "icon" : "pie_chart", "glossy" : false, "size" : "0.8rem", "round" : false, "fn" : () => { vm.sendProductionInfo() } },
						],
						"layout" : "two", 		
						"class" : "shadow-1 q-pa-sm q-mb-sm index-flexRadius",
					},
					"year_co2e" : {
						"show" : true,
						"label" : "本年用電碳排放" ,
						"value" : 0, 
						"unit" : "co2e / Year",
						"button" : [
							{ "show" : false ,"label" : "資訊頁", "color" : "blue-2", "textColor" : "primary", "icon" : "list", "glossy" : false, "size" : "0.8rem", "round" : false, "fn" : () => { vm.FnPageSwitch('') } },
							{ "show" : false ,"label" : "長條圖", "color" : "blue-2", "textColor" : "primary", "icon" : "assessment", "glossy" : false, "size" : "0.8rem", "round" : false, "fn" : () => { vm.closeQWindow() } },
							{ "show" : false ,"label" : "圓餅圖", "color" : "blue-2", "textColor" : "primary", "icon" : "pie_chart", "glossy" : false, "size" : "0.8rem", "round" : false, "fn" : () => { vm.sendProductionInfo() } },
						],
						"layout" : "two", 		
						"class" : "shadow-1 q-pa-sm q-mb-sm index-flexRadius",
					},
					"year_kloe" : {
						"show" : true,
						"label" : "本年用電換算公秉油當量" ,
						"value" : 0, 
						"unit" : "KLOE",
						"button" : [
							{ "show" : false ,"label" : "資訊頁", "color" : "blue-2", "textColor" : "primary", "icon" : "list", "glossy" : false, "size" : "0.8rem", "round" : false, "fn" : () => { vm.FnPageSwitch('') } },
							{ "show" : false ,"label" : "長條圖", "color" : "blue-2", "textColor" : "primary", "icon" : "assessment", "glossy" : false, "size" : "0.8rem", "round" : false, "fn" : () => { vm.closeQWindow() } },
							{ "show" : false ,"label" : "圓餅圖", "color" : "blue-2", "textColor" : "primary", "icon" : "pie_chart", "glossy" : false, "size" : "0.8rem", "round" : false, "fn" : () => { vm.sendProductionInfo() } },
						],
						"layout" : "two", 		
						"class" : "shadow-1 q-pa-sm q-mb-sm index-flexRadius",
					},
					"year_mcal" : {
						"show" : true,
						"label" : "本年用電換算熱值" ,
						"value" : 0, 
						"unit" : "MCal",
						"button" : [
							{ "show" : false ,"label" : "資訊頁", "color" : "blue-2", "textColor" : "primary", "icon" : "list", "glossy" : false, "size" : "0.8rem", "round" : false, "fn" : () => { vm.FnPageSwitch('') } },
							{ "show" : false ,"label" : "長條圖", "color" : "blue-2", "textColor" : "primary", "icon" : "assessment", "glossy" : false, "size" : "0.8rem", "round" : false, "fn" : () => { vm.closeQWindow() } },
							{ "show" : false ,"label" : "圓餅圖", "color" : "blue-2", "textColor" : "primary", "icon" : "pie_chart", "glossy" : false, "size" : "0.8rem", "round" : false, "fn" : () => { vm.sendProductionInfo() } },
						],
						"layout" : "two", 		
						"class" : "shadow-1 q-pa-sm q-mb-sm index-flexRadius",
					}
				},
				"monthEnergy" : {
					"show" : true,
					"label" : "月能源用量占比",
					"info" : {
						"power" : {
							"show" : true,
							"label" : "電力",
							"color": "green-3",
							"data" : {
								"label" : "電力",
								"value" : 0,
								"unit" : "% Mcal"
							},
						},
						"steam" : {
							"show" : true,
							"label" : "蒸汽",
							"color": "cyan-3",
							"data" : {
								"label" : "蒸汽",
								"value" : 0,
								"unit" : "% Mcal",
							},
						},
						"steam-2" : {
							"show" : true,
							"label" : "蒸汽-燒臘區",
							"color": "yellow-3",
							"data" : {
								"label" : "燒臘區",
								"value" : 0,
								"unit" : "% Mcal",
							},
						},
						"gas" : {
							"show" : true,
							"label" : "瓦斯",
							"color": "indigo-3",
							"data" : {
								"label" : "瓦斯",
								"value" : 0,
								"unit" : "% Mcal"
							},
						},
						"natural_gas" : {
							"show" : true,
							"label" : "天燃汽",
							"color": "red-3",
							"data" : {
								"label" : "天燃汽",
								"value" : 0,
								"unit" : "% Mcal"
							},
						},
					},
					//	圓餅圖 
					"pieOptions" :{
						"title" : {
							"text" : "loading...",
							"subtext" : "熱值Mcal",
							"left" : "center",
							"top" : "center",
							"textStyle" : {
								"fontSize" : 16,
								"color" : "#25FDFD",
								"lineHeight" : 15,
							},
							"subtextStyle" : {
								"fontSize" : 12,
								"color" : "#fff",

							}
						},
						"tooltip" : {
							"trigger" : "item"
						},
						"legend" : {
							"show" : false,
						    "top" : 'center',
						    "left" : 'center'
						},
						"series" : [
						    {
								"type" : 'pie',
								"radius" : ['60%', '90%'],
								"avoidLabelOverlap" : false,
								"label" : {
								  	"show" : true,
								  	"position" : 'inside',
								  	"formatter" : function (params){
	                              		return  params.value + '%\n'
	                        		},
								},
							    "data" : [
							        { value: 0, name: '電力', "itemStyle" : { "color" : "#a5d6a7" }},
							        { value: 0, name: '蒸汽', "itemStyle" : { "color" : "#80deea" }},
							        { value: 0, name: '蒸汽-燒臘區', "itemStyle" : { "color" : "#e8da6f" }},
							        { value: 0, name: '瓦斯', "itemStyle" : { "color" : "#9fa8da" }},
							        { value: 0, name: '天燃汽', "itemStyle" : { "color" : "#da9fa8" }},
							    ]
						    }
						]
					},
				},
				"monthNeedTime" : {
					"show" : true,
					"label" : "每日最高需量時間",
					"button" : [
						{ "show" : false ,"label" : "資訊頁", "color" : "blue-2", "textColor" : "primary", "icon" : "list", "glossy" : false, "size" : "0.8rem", "round" : false, "fn" : () => { vm.FnPageSwitch('') } },	
					],
					//	趨勢圖 
					"chartOptions" :{
						"tooltip" : {
							"trigger" : "item",
						},
						"grid" : { 
							"top" : "25%", 
							"left" : 30 , 
							"right" : 30 , 
							"bottom" : "0%", 
							"containLabel" : true,
						},
						"legend" : {
							"show" : false,
						    "top" : 'center',
						    "left" : 'center'
						},
						"xAxis" : {
							"type" : "category",
							"data" : ['Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat', 'Sun'],
							"axisLabel" : { 
								"fontSize" : "14",
								"color" : "#fff"  ,
							},
							"axisLine" : {
								"show" : true,
								"lineStyle" : {
									"color" : "#fff" ,
								},
							},
						},
						"yAxis" : {
							"type" : "value",
							"name" : "需量 kW",
							"position" : 'left',
							"alignTicks" : true,
							"nameTextStyle" : {
      							"color" : "#fff",
      							"fontSize" : "14",
      							// "padding": [0, 0, 10, 50],
    						},
							"axisLabel" : { 
								"fontSize" : "14",
								"color" : "#fff"  ,
							},
							"axisLine" : {
								"show" : true,
								"lineStyle" : {
									"color" : "#fff" ,
								},
							},
							"splitLine":{
								"show" : true,
								"lineStyle" : {
									"color" : "#fff",
									// "type" : "line",
								}
							},

						},
						"series" : [
						    {
								"data" : [120, 200, 150, 80, 70, 110, 130],
     							"type" : 'line',
			     				"symbol" : 'triangle',
     							"symbolSize" : 20,
     							"lineStyle" : {
       								"show"  : false,
       								"color" : '#fff',
       								"width" : 4,
	       							"type" : 'dashed',
       							},
     							"itemStyle" : {
       								"borderWidth" : 2,
       								"borderColor" : 'red',
       								"color" : 'red'
       							}
  							}
						]
					},
				},
				"distribution" : {
					"power" : {
						"show" : true,
						"label" : "日 - 電力分佈圖",
						"link" : {
							"label" : "電力系統",
							"value" : "system_power.php",
						},
						//	圓餅圖 
						"pieOptions" :{
							"title" : {
								// "text" : [ '123','{normal|kWh}'].join(' '),	//	這在寫回資料時可能要客製 => billboard.distribution.power.pieOptions.title.text[0] = 加總
								// "left" : "center",
								// "top" : "center",
								// "textStyle" : {
								// 	"fontSize" : 64,
								// 	"color" : "#000",
								// 	"lineHeight" : 0,
								// 	"align" : "center",
								// 	"verticalAlign" : "bottom",
								// 	"rich" : {
								// 		"normal": {
						        //         	"fontSize" : 16,
						        //         	"color": '#a6a6a6', 
						        //         	"align" : "center",
						        //         	"verticalAlign" : "top"
						        //     	}
								// 	},
								// },	
								"text" : "loading...",
								"subtext" : "kWh",
								"left" : "center",
								"top" : "center",
								"textStyle" : {
									"fontSize" : 42,
									"color" : "#25FDFD",
									"lineHeight" : 40,
								},
								"subtextStyle" : {
									"fontSize" : 18,
									"color" : "#fff",

								}
								
							},
							"tooltip" : {
								"trigger" : "item"
							},
							"legend" : {
								"show" : false,
							    "top" : 'center',
							    "left" : 'center'
							},
							"series" : [
							    {
									"type" : 'pie',
									"radius" : ['60%', '90%'],
									"avoidLabelOverlap" : false,
									"label" : {
									  	"show" : true,
									  	"position" : 'inside',
									  	"formatter" : function (params){
		                              		return  params.value + '%\n'
		                        		},
									},
								    "data" : [
								        { value: 0, name: '照明', "itemStyle" : { "color" : "#F57582" }},
								        { value: 0, name: '冷凍空調', "itemStyle" : { "color" : "#FFA940" }},
								        { value: 0, name: '製程動力', "itemStyle" : { "color" : "#FFC53D" }},
								        { value: 0, name: '通風', "itemStyle" : { "color" : "#73D13D" }},
								        { value: 0, name: '空壓', "itemStyle" : { "color" : "#45DAD1" }},
								        { value: 0, name: '公用設備', "itemStyle" : { "color" : "#40A9FF" }},
								        { value: 0, name: '其他', "itemStyle" : { "color" : "#6682F5" }},
								    ]
							    }
							]
						},
						"info" : {
							"item01" : {
								"show" : true,
								"showBorder" : false,
								"label" : "照明",
								"color": "#F57582",
								"value" : 0,
								"unit" : "%",
							},
							"item02" : {
								"show" : true,
								"showBorder" : false,
								"label" : "冷凍空調",
								"color": "#FFA940",
								"value" : 0,
								"unit" : "%",
							},
							"item03" : {
								"show" : true,
								"showBorder" : false,
								"label" : "製程動力",
								"color": "#FFC53D",
								"value" : 0,
								"unit" : "%",
							},
							"item04" : {
								"show" : true,
								"showBorder" : false,
								"label" : "通風",
								"color": "#73D13D",
								"value" : 0,
								"unit" : "%",
							},
							"item05" : {
								"show" : true,
								"showBorder" : false,
								"label" : "空壓",
								"color": "#45DAD1",
								"value" : 0,
								"unit" : "%",
							},
							"item06" : {
								"show" : true,
								"showBorder" : false,
								"label" : "公用設備",
								"color": "#40A9FF",
								"value" : 0,
								"unit" : "%",
							},
							"item07" : {
								"show" : true,
								"showBorder" : false,
								"label" : "其他",
								"color": "#6682F5",
								"value" : 0,
								"unit" : "%",
							}
						},

					},
					"steam" : {
						"show" : true,
						"label" : "日 - 蒸汽分佈圖",
						"link" : {
							"label" : "蒸汽系統",
							"value" : "system_steam.php",
						},
						//	圓餅圖 
						"pieOptions" :{
							"title" : {
								// "text" : [ '123','{normal|m³/hr}'].join(' '),	//	這在寫回資料時可能要客製 => billboard.distribution.power.pieOptions.title.text[0] = 加總
								// "left" : "center",
								// "top" : "center",
								// "textStyle" : {
								// 	"fontSize" : 64,
								// 	"color" : "#000",
								// 	"lineHeight" : 0,
								// 	"align" : "center",
								// 	"verticalAlign" : "bottom",
								// 	"rich" : {
								// 		"normal": {
						        //         	"fontSize" : 16,
						        //         	"color": '#a6a6a6', 
						        //         	"align" : "center",
						        //         	"verticalAlign" : "top"
						        //     	}
								// 	},
								// },	
								"text" : "loading...",
								"subtext" : "m³/hr",
								"left" : "center",
								"top" : "center",
								"textStyle" : {
									"fontSize" : 42,
									"color" : "#25FDFD",
									"lineHeight" : 40,
								},
								"subtextStyle" : {
									"fontSize" : 18,
									"color" : "#fff",

								}
							},
							"tooltip" : {
								"trigger" : "item"
							},
							"legend" : {
								"show" : false,
							    "top" : 'center',
							    "left" : 'center'
							},
							"series" : [
							    {
									"type" : 'pie',
									"radius" : ['60%', '90%'],
									"avoidLabelOverlap" : false,
									"label" : {
									  	"show" : true,
									  	"position" : 'inside',
									  	"formatter" : function (params){
		                              		return  params.value + '%\n'
		                        		},
									},
								    "data" : [
								        { value: 0, name: '蒸煮室', "itemStyle" : { "color": "#F57582", }},
								        { value: 0, name: '罐頭加工室', "itemStyle" : { "color": "#FFA940", }},
								        { value: 0, name: '肉品烘烤室', "itemStyle" : { "color": "#FFC53D", }},
								        { value: 0, name: '燒臘區', "itemStyle" : { "color": "#73D13D", }},
								        { value: 0, name: '屋頂', "itemStyle" : { "color": "#45DAD1", }},
								        { value: 0, name: '熟食包裝室', "itemStyle" : { "color": "#40A9FF", }},
								        { value: 0, name: '糕餅調理室', "itemStyle" : { "color": "#6682F5", }},
								    ]
							    }
							]
						},
						"info" : {
							"item01" : {
								"show" : true,
								"showBorder" : false,
								"label" : "蒸煮室",
								"color": "#F57582",
								"value" : 0,
								"unit" : "%",
							},
							"item02" : {
								"show" : true,
								"showBorder" : false,
								"label" : "罐頭加工室",
								"color": "#FFA940",
								"value" : 0,
								"unit" : "%",
							},
							"item03" : {
								"show" : true,
								"showBorder" : false,
								"label" : "肉品烘烤室",
								"color": "#FFC53D",
								"value" : 0,
								"unit" : "%",
							},
							"item04" : {
								"show" : true,
								"showBorder" : false,
								"label" : "燒臘區",
								"color": "#73D13D",
								"value" : 0,
								"unit" : "%",
							},
							"item05" : {
								"show" : true,
								"showBorder" : false,
								"label" : "屋頂",
								"color": "#45DAD1",
								"value" : 0,
								"unit" : "%",
							},
							"item06" : {
								"show" : true,
								"showBorder" : false,
								"label" : "熟食包裝室",
								"color": "#40A9FF",
								"value" : 0,
								"unit" : "%",
							},
							"item07" : {
								"show" : true,
								"showBorder" : false,
								"label" : "糕餅調理室",
								"color": "#6682F5",
								"value" : 0,
								"unit" : "%",
							},
						},

					},
					"gas" : {
						"show" : true,
						"label" : "日 - 瓦斯分佈圖",
						"link" : {
							"label" : "瓦斯系統",
							"value" : "system_gas.php",
						},
						//	圓餅圖 
						"pieOptions" :{
							"title" : {
								// "text" : [ '123','{normal|m³/hr}'].join(' '),	//	這在寫回資料時可能要客製 => billboard.distribution.power.pieOptions.title.text[0] = 加總
								// "left" : "center",
								// "top" : "center",
								// "textStyle" : {
								// 	"fontSize" : 64,
								// 	"color" : "#000",
								// 	"lineHeight" : 0,
								// 	"align" : "center",
								// 	"verticalAlign" : "bottom",
								// 	"rich" : {
								// 		"normal": {
						        //         	"fontSize" : 16,
						        //         	"color": '#a6a6a6', 
						        //         	"align" : "center",
						        //         	"verticalAlign" : "top"
						        //     	}
								// 	},
								// },	
								"text" : "loading...",
								"subtext" : "m³/hr",
								"left" : "center",
								"top" : "center",
								"textStyle" : {
									"fontSize" : 42,
									"color" : "#25FDFD",
									"lineHeight" : 40,
								},
								"subtextStyle" : {
									"fontSize" : 18,
									"color" : "#fff",

								}
							},
							"tooltip" : {
								"trigger" : "item"
							},
							"legend" : {
								"show" : false,
							    "top" : 'center',
							    "left" : 'center'
							},
							"series" : [
							    {
									"type" : 'pie',
									"radius" : ['60%', '90%'],
									"avoidLabelOverlap" : false,
									"label" : {
									  	"show" : true,
									  	"position" : 'inside',
									  	"formatter" : function (params){
		                              		return  params.value + '%\n'
		                        		},
									},
								    "data" : [
								        { value: 0, name: '肉品烘烤室', "itemStyle" : { "color": "#F57582", }},
								        { value: 0, name: '蒸煮室', "itemStyle" : { "color": "#FFA940", }},
								        { value: 0, name: '西點烘培室', "itemStyle" : { "color": "#FFC53D", }},
								        { value: 0, name: '燒臘區', "itemStyle" : { "color": "#73D13D", }},
								        { value: 0, name: '中點調理室', "itemStyle" : { "color": "#45DAD1", }},
								        { value: 0, name: '天燃氣瓦斯', "itemStyle" : { "color": "#40A9FF", }},
								    ]
							    }
							]
						},
						"info" : {
							"item01" : {
								"show" : true,
								"showBorder" : false,
								"label" : "肉品烘烤室",
								"color": "#F57582",
								"value" : 0,
								"unit" : "%",
							},
							"item02" : {
								"show" : true,
								"showBorder" : false,
								"label" : "蒸煮室",
								"color": "#FFA940",
								"value" : 0,
								"unit" : "%",
							},
							"item03" : {
								"show" : true,
								"showBorder" : false,
								"label" : "西點烘培室",
								"color": "#FFC53D",
								"value" : 0,
								"unit" : "%",
							},
							"item04" : {
								"show" : true,
								"showBorder" : false,
								"label" : "燒臘區",
								"color": "#73D13D",
								"value" : 0,
								"unit" : "%",
							},
							"item05" : {
								"show" : true,
								"showBorder" : false,
								"label" : "中點調理室",
								"color": "#45DAD1",
								"value" : 0,
								"unit" : "%",
							},
							"item06" : {
								"show" : true,
								"showBorder" : false,
								"label" : "天燃氣瓦斯",
								"color": "#40A9FF",
								"value" : 0,
								"unit" : "%",
							},
						},

					},
				}
			}

			
		}
	},

	computed :{},
	watch : {},

	mounted () {
		this.$set(this.WebSetup, "caption", '全廠能源分佈');
		this.MenuSetup.opened = false;
		this.VarMenuIsOverlay = true;
		this.autoReload();
	},
	methods: {
		
		//	所有按鈕事件
		btnEvent(btn, value) {
			btn.fn(value)
		},

		//	分佈圖，跳至相對應的畫面
		async jumpToDashboard (link) {
			if (await this.FnConfirm("提醒", `是否轉跳至${link['label']}？`)) {
				this.FnPageSwitch(link['value']);
			}
		},
		autoReload() {
      		this.loadData();
			this.loadDemandData();
      		setTimeout(() => {
        		this.autoReload();
      		}, this.reloadIntervalSec * 1000);
    	},
		// 載入頁面資料
		loadData() {
			var params = {
				Action : 'Index',
				Datas : {},
			};			
			this.FnWebAPIGet(params).then((res)=> {
				var resData = res.data.data;

				/**
				 * over_contract: 超約次數
				 * pm_data: 左側用電日、月、年、年碳排、年公秉、年熱值
				 * month_mcal：圓餅月佔用
				 * pm_day：電力日分佈
				 * sm_day：蒸汽日分佈
				 * gm_day：瓦斯日分佈
				 */
				//	over_contract
				this.billboard['info']['item01']['value'][0]['value'] = _.isNil(resData.over_contract['month']) ? 0 : resData.over_contract['month']
				this.billboard['info']['item01']['value'][1]['value'] = _.isNil(resData.over_contract['year']) ? 0 : resData.over_contract['year']
				//	pm_data
				_.each(this.billboard['info'] , (item, key) => {
					if ( item['layout'] == 'two' ) {
						item['value'] = this.FnFormatNumber(!_.isNil(resData.pm_data[key]) ? resData.pm_data[key] : 0 , 2 )
					}
				})
				//	month_mcal：圓餅月佔用
				_.each(this.billboard['monthEnergy']['info'] , (item, key) => {
					if ( !_.isNil(resData.month_mcal[item['label']]) ) {
						item['data']['value'] = this.FnRoundToDecimal( 
								resData.month_mcal[item['label']] !== 0 ? resData.month_mcal[item['label']] / resData.month_mcal['total'] * 100 : 0 
							)	
					}
				})
				_.each(this.billboard['monthEnergy']['pieOptions']['series'][0]['data'] , (item) => {
					if ( !_.isNil(resData.month_mcal[item['name']]) ) {
						item['value'] = this.FnRoundToDecimal( 
							resData.month_mcal[item['name']] !== 0 ? resData.month_mcal[item['name']] / resData.month_mcal['total'] * 100 : 0 
						)	
					}
				})
				this.billboard['monthEnergy']['pieOptions']['title']['text'] = this.FnFormatNumber(resData.month_mcal['total'])
				//	pm_day：電力日分佈
				//	加總
				// var sumPm = _.sumBy(_.values(resData.pm_day), (v) => { return parseFloat(v) })
				var temp_total_value = 0
				_.each(this.billboard['distribution']['power']['info'] , (item) => {
					_.each(this.treeMap('電力', item['label']) , (id) => {
						temp_total_value += !_.isNil(resData.pm_day[id['value']]) ? parseFloat(resData.pm_day[id['value']]) : 0
					})
				})
				//	資訊欄整理
				var temp_info_value = 0
				_.each(this.billboard['distribution']['power']['info'] , (item) => {
					temp_info_value = 0 
					_.each(this.treeMap('電力', item['label']) , (id) => {
						temp_info_value += !_.isNil(resData.pm_day[id['value']]) ? parseFloat(resData.pm_day[id['value']]) : 0
					})
					item['value'] = this.FnRoundToDecimal(  !_.isNaN(temp_info_value / temp_total_value) ? temp_info_value / temp_total_value * 100 : 0 , 0)
				})
				//	趨勢圖整理
				this.billboard['distribution']['power']['pieOptions']['title']['text'] = this.FnFormatNumber(temp_total_value , 0) 
				_.each(this.billboard['distribution']['power']['pieOptions']['series'][0]['data'] , (item) => {
					temp_info_value = 0 
					_.each(this.treeMap('電力', item['name']) , (id) => {
						temp_info_value += !_.isNil(resData.pm_day[id['value']]) ? parseFloat(resData.pm_day[id['value']]) : 0
					})
					item['value'] = this.FnRoundToDecimal(  !_.isNaN(temp_info_value / temp_total_value) ? temp_info_value / temp_total_value * 100 : 0 , 0)
				})
				//	sm_day：蒸汽日分佈
				// var sumPm = _.sumBy(_.values(resData.sm_day), (v) => { return parseFloat(v) })
				var temp_total_value = 0
				_.each(this.billboard['distribution']['steam']['info'] , (item) => {
					_.each(this.treeMap('蒸汽', item['label']) , (id) => {
						temp_total_value += !_.isNil(resData.sm_day[id['value']]) ? parseFloat(resData.sm_day[id['value']]) : 0
					})
				})
				//	資訊欄整理
				var temp_info_value = 0
				_.each(this.billboard['distribution']['steam']['info'] , (item) => {
					temp_info_value = 0 
					_.each(this.treeMap('蒸汽', item['label']) , (id) => {
						temp_info_value += !_.isNil(resData.sm_day[id['value']]) ? parseFloat(resData.sm_day[id['value']]) : 0
					})
					item['value'] = this.FnRoundToDecimal(  !_.isNaN(temp_info_value / temp_total_value) ? temp_info_value / temp_total_value * 100 : 0 , 0)
				})
				//	趨勢圖整理
				this.billboard['distribution']['steam']['pieOptions']['title']['text'] = this.FnFormatNumber(temp_total_value , 0) 
				_.each(this.billboard['distribution']['steam']['pieOptions']['series'][0]['data'] , (item) => {
					temp_info_value = 0 
					_.each(this.treeMap('蒸汽', item['name']) , (id) => {
						temp_info_value += !_.isNil(resData.sm_day[id['value']]) ? parseFloat(resData.sm_day[id['value']]) : 0
					})
					item['value'] = this.FnRoundToDecimal(  !_.isNaN(temp_info_value / temp_total_value) ? temp_info_value / temp_total_value * 100 : 0 , 0)
				})
				//	gm_day：瓦斯日分佈
				// var sumPm = _.sumBy(_.values(resData.gm_day), (v) => { return parseFloat(v) })
				var temp_total_value = 0
				_.each(this.billboard['distribution']['gas']['info'] , (item) => {
					_.each(this.treeMap('瓦斯', item['label']) , (id) => {
						temp_total_value += !_.isNil(resData.gm_day[id['value']]) ? parseFloat(resData.gm_day[id['value']]) : 0
					})
				})
				//	資訊欄整理
				var temp_info_value = 0
				_.each(this.billboard['distribution']['gas']['info'] , (item) => {
					temp_info_value = 0 
					_.each(this.treeMap('瓦斯', item['label']) , (id) => {
						temp_info_value += !_.isNil(resData.gm_day[id['value']]) ? parseFloat(resData.gm_day[id['value']]) : 0
					})
					item['value'] = this.FnRoundToDecimal( !_.isNaN(temp_info_value / temp_total_value) ? temp_info_value / temp_total_value * 100 : 0 , 0)
				})
				//	趨勢圖整理
				this.billboard['distribution']['gas']['pieOptions']['title']['text'] = this.FnFormatNumber(temp_total_value , 0) 
				_.each(this.billboard['distribution']['gas']['pieOptions']['series'][0]['data'] , (item) => {
					temp_info_value = 0 
					_.each(this.treeMap('瓦斯', item['name']) , (id) => {
						temp_info_value += !_.isNil(resData.gm_day[id['value']]) ? parseFloat(resData.gm_day[id['value']]) : 0
					})
					item['value'] = this.FnRoundToDecimal( !_.isNaN(temp_info_value / temp_total_value) ? temp_info_value / temp_total_value * 100 : 0 , 0)
				})

			}).catch((err)=> {
				console.log(err);
			});
		},
		// 載入需量資料
		loadDemandData() {
			this.billboard['monthNeedTime']['chartOptions']['xAxis']['data'] = []
			this.billboard['monthNeedTime']['chartOptions']['series'][0]['data'] = []
			var params = {
				Action : 'SearchData',
				Datas : {
					search: {
						"start_date": moment().startOf('month'),
						"end_date": moment(),
					},
				},
				menu_page: 'demand_query'
			};			
			this.FnWebAPIGet(params).then((res)=> {
				var resData = res.data.data;
				var monthMaxDay = moment().endOf('month').format('DD')
				for (var i = 0 ; i < monthMaxDay ; i++ ) {
					if ( !_.isNil(resData[i])) {
						this.billboard['monthNeedTime']['chartOptions']['xAxis']['data'].push( moment(resData[i]['DATE_TIME']).format('DD')+'日')
						this.billboard['monthNeedTime']['chartOptions']['series'][0]['data'].push( resData[i]['需量'] )
					} else {
						this.billboard['monthNeedTime']['chartOptions']['xAxis']['data'].push( (i+1)+'日')
						this.billboard['monthNeedTime']['chartOptions']['series'][0]['data'].push( null )
					}
				}
				
				
			}).catch((err)=> {
				console.log(err);
			});
		},
	
		//  樹狀爸爸
    	treeMap (item_type, keyWord) {
    		if (!_.isNil(index_chartPie_config[item_type][keyWord])) {
    			return _.map(index_chartPie_config[item_type][keyWord]['options'] , (item ) => {
        			return {  "value" : item['value'] , "label" : item['label'] } 
      			})
    		} else {

    		}
    	}
	}
}