var page_function = {
  components: {},
  data() {
    return {
      VarMenuPage: "parameter_settings",
      VarMenu: "area",
      VarPageContainerCss: "padding:20px",

      EnergyParam: {
        isEdit: false,
        data: [],
      },
      BaselineParam: {
        isEdit: false,
        data: [],
      },
      IndicatorAlarm: {
        isEdit: false,
        data: [],
      },
      CfgPowerRange: {
        isEdit: false,
        data: [],
      },
    };
  },
  computed: {},
  watch: {},
  mounted() {
    this.$set(this.WebSetup, "caption", "參數設定");
    this.MenuSetup.opened = false;
    this.VarMenuIsOverlay = true;
  },
  methods: {
    // ======================================== 能源 ========================================
    loadEnergyParameter() {
      var params = {
        Action: "EnergyParameter",
        Datas: {},
      };
      this.FnWebAPIGet(params).then((res) => {
        var resData = res.data.data;
        if(_.isArray(resData)) {
          _.each(resData, (item) => {
            item['co2e'] = this.formatFloat(item['co2e'] , 9);
            item['kloe'] = this.formatFloat(item['kloe'] , 9);
            item['mcal'] = this.formatFloat(item['mcal'] , 9);
          })
          this.EnergyParam.data = resData;
        }
      })
      .catch((err) => {
        console.log(err);
      });
    },
    SaveEnergyParameter() {
      var params = {
        Action: "EnergyParameter",
        Datas: {
          input_data: this.EnergyParam.data
        },
      };
      this.FnWebAPIPost(params).then((res) => {
        var resData = res.data.data;
        if(resData) {
          this.FnNotify('寫入成功','success');
          this.loadEnergyParameter();
          this.EnergyParam.isEdit = false;
        } else {
          this.FnNotify('寫入失敗','error');
        }
      })
      .catch((err) => {
        console.log(err);
      });
    },
    // ======================================== 基線 ========================================
    loadBaselineParameter() {
      var params = {
        Action: "BaselineParameter",
        Datas: {},
      };
      this.FnWebAPIGet(params).then((res) => {
        var resData = res.data.data;
        if(_.isArray(resData)) {
          _.each(resData, (item) => {
            item['intercept'] = this.formatFloat(item['intercept'] , 9);
            item['product_coef'] = this.formatFloat(item['product_coef'] , 9);
            item['temperature_coef'] = this.formatFloat(item['temperature_coef'] , 9);
            item['coef'] = this.formatFloat(item['coef'] , 9);
          })
          this.BaselineParam.data = resData;
        }
      })
      .catch((err) => {
        console.log(err);
      });
    },
    SaveBaselineParam() {
      var params = {
        Action: "BaselineParameter",
        Datas: {
          input_data: this.BaselineParam.data
        },
      };
      this.FnWebAPIPost(params).then((res) => {
        var resData = res.data.data;
        if(resData) {
          this.FnNotify('寫入成功','success');
          this.loadBaselineParameter();
          this.BaselineParam.isEdit = false;
        } else {
          this.FnNotify('寫入失敗','error');
        }
      })
      .catch((err) => {
        console.log(err);
      });
    },
    // ======================================== 全廠指標警戒範圍 ========================================
    loadIndicatorAlarm() {
      var params = {
        Action: "IndicatorAlarm",
        Datas: {},
      };
      this.FnWebAPIGet(params).then((res) => {
        var resData = res.data.data;
        if(_.isArray(resData)) {
          _.each(resData, (item) => {
            item['h'] = this.formatFloat(item['h'] , 2);
            item['hh'] = this.formatFloat(item['hh'] , 2);
          })
          this.IndicatorAlarm.data = resData;
        }
      })
      .catch((err) => {
        console.log(err);
      });
    },
    SaveIndicatorAlarm() {
      var isOk = true;
      var errorItemName = '';
      _.each(this.IndicatorAlarm.data, (r)=> {
        if(r.h !== null && r.hh !== null) {
          if(r.h >= r.hh) {
            isOk = false;
            errorItemName = r.item_label;
            return false;
          }
        }
      });
      if(!isOk) {
        this.FnNotify(`H必須小於HH，項目：${errorItemName}`,'warning');
        return;
      }
      var params = {
        Action: "IndicatorAlarm",
        Datas: {
          input_data: this.IndicatorAlarm.data
        },
      };
      this.FnWebAPIPost(params).then((res) => {
        var resData = res.data.data;
        if(resData) {
          this.FnNotify('寫入成功','success');
          this.loadIndicatorAlarm();
          this.IndicatorAlarm.isEdit = false;
        } else {
          this.FnNotify('寫入失敗','error');
        }
      })
      .catch((err) => {
        console.log(err);
      });
    },
    // ======================================== 用電價錢 ========================================
    loadCfgPowerRange() {
      var params = {
        Action: "CfgPowerRange",
        Datas: {},
      };
      this.FnWebAPIGet(params).then((res) => {
        var resData = res.data.data;
        if(_.isArray(resData)) {
          _.each(resData, (item) => {
            console.log(typeof(item['start_time']))
            item['start_time'] = moment(item['start_time'] , "HH:mm").format("HH:mm")
            if (item['end_time'] == "23:59:59") {
              item['end_time'] = "24:00"
            } else {
              item['end_time'] = moment(item['end_time'] , "HH:mm").add(1 , "minute").format("HH:mm")
            }
            item['price'] = this.formatFloat(item['price'] , 2);
          })
          this.CfgPowerRange.data = resData;
        }
      })
      .catch((err) => {
        console.log(err);
      });
    },
    SaveCfgPowerRange(){
      var isOk = true;
      var errorItemName = '';
      _.each(this.CfgPowerRange.data, (r)=> {
        if( _.isNil(r.price) || r.price == '0') {
          isOk = false;
          errorItemName = _.isNil(r.price) ? '必須填寫，項目：'+r.comment : r.price == '0' ? '項目：'+r.comment+' 不能是0' : '無回應';
          return false;
        }
      });
      if(!isOk) {
        this.FnNotify(errorItemName,'warning');
        return;
      }
      var params = {
        Action: "CfgPowerRange",
        Datas: {
          input_data: this.CfgPowerRange.data
        },
      };
      this.FnWebAPIPost(params).then((res) => {
        var resData = res.data.data;
        if(resData) {
          this.FnNotify('寫入成功','success');
          this.loadCfgPowerRange();
          this.CfgPowerRange.isEdit = false;
        } else {
          this.FnNotify('寫入失敗','error');
        }
      })
      .catch((err) => {
        console.log(err);
      });
    },
    formatFloat(_num, _dec) {
      return _num === null ? null : this.FnRoundToDecimal(_num, _dec);
    }
  },
};
