var  page_function  =  {
    components: {
    	"data-table": httpVueLoader("components/layout/data_table.vue"),
    },
    data()  {
        return  {
            VarMenuPage:  "report_date",
            VarMenu:  "area",
            VarPageContainerCss:  "padding:20px",

           "tableData": [],

           "search" : {
           		"dateType" : {
           			"label": "報表類型",
           			"value" : "daily",
           			"options" : [
           				{ "label": "日", "value": "daily" },
           				{ "label": "月", "value": "monthly"},
           				{ "label": "年", "value": "yearly" }
           			],
           		},
           		"fileType" : {
           			"label": "能源類型",
           			"value" : "power",
           			"options" : [
           				{ "label": "電力", "value": "power" },
           				{ "label": "蒸汽", "value": "steam"},
           				{ "label": "瓦斯", "value": "gas" },
           				{ "label": "用水", "value": "water" }
           			],
           		},
                "fileQuantity" : {
                    "label": "類型輸出",
                    "value" : "dosage",
                    "options" : {
                        "power":[
                            { "label": "用量", "value": "dosage" },
                            { "label": "碳排量", "value": "carbon"},
                        ],
                        "steam":[
                            { "label": "用量", "value": "dosage" },
                            { "label": "碳排量", "value": "carbon"},
                        ],
                        "gas":[
                            { "label": "用量", "value": "dosage" },
                            { "label": "碳排量", "value": "carbon"},
                        ],
                        "water":[
                            { "label": "用量", "value": "dosage" },
                        ],
                    },
                },
           		"data" : {
           			"title" : "資料區間",
           			"daily" : [ new Date(new Date().getFullYear(), new Date().getMonth(), 1), new Date() ],  
					"month" : [ new Date(new Date().getFullYear(), 0, 1) , new Date() ], 
					"year" : [ new Date(new Date().getFullYear() -1, 0) , new Date() ], 
           		}
           }
        };
    },
    computed:  {

    	tableTitle () {
    		return _.reduce(this.search['dateType']['options'] , (obj , key) => {
				obj[key['value']] = key['label']
				return obj
			},{})
    	},
    	columns () { // 為了配合多國語系, columns 需使用 computed
			return [{
				name: "FileName",
				required: true,
				label: "檔案名稱",
				align: "center",
				field: "FileName",
				sortable: true,
				$$is_num_format: false,
				style: "font-size: 12pt",
			} ]
		},
    },
    watch:  {
      search: {
        immediate: false,
        deep: true,
        handler(nv, ov) {
          console.log()
          if(nv['fileType']['value'] == 'water') {
            // 若選用水，類型輸出則設用量
            this.search['fileQuantity']['value'] = 'dosage';
          }
        }
      },
    },
    mounted()  {
        this.$set(this.WebSetup,  "caption",  "日月年報");
        this.MenuSetup.opened  =  false;
        this.VarMenuIsOverlay  =  true;
        this.searchList();
    },
    methods:  {

        searchList()  {
            this.tableData = []
            var  params  =  {
                Action:  "ReportFileList",
                Datas:  {
                    "folder" : this.search['dateType']['value'],
                    "fileType" : this.search['fileType']['value'],
                    "fileQuantity" : this.search['fileQuantity']['value'],
                    "dataRange" : this.search['dateType']['value'] == 'daily' ? this.search['data']['daily'] : 
                                    this.search['dateType']['value'] == 'monthly' ? this.search['data']['month'] :
                                        this.search['dateType']['value'] == 'yearly' ? this.search['data']['year'] : null,
                },
            };
            this.FnWebAPIGet(params).then((res)  =>  {
                var resData = res.data.data    
                if ( _.size(resData) > 0) {
                    this.tableData = resData
                } else {
                    this.FnNotify('查無檔案', 'warning')
                }
            })
            .catch((err)  =>  {
                console.log(err);
            });
        },
        
        //  檔案下載
        reportdownload(row){
          //console.log(row.FileName)
          var url = row.FileUrl
          var parameters = {
            fileName: row.FileName
          }
          var request = new XMLHttpRequest()
          request.open('GET', url + '?' + 'fileName=' + parameters.fileName, true)
          request.responseType = 'blob'

          request.onload = function (e) {
            if (this.status === 200) {
              var blob = this.response
              if (window.navigator.msSaveOrOpenBlob) {
                window.navigator.msSaveBlob(blob, parameters.fileName)
              } else {
                var downloadLink = window.document.createElement('a')
                downloadLink.href = window.URL.createObjectURL(new Blob([blob], { type: 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet' }))
                downloadLink.download = parameters.fileName
                document.body.appendChild(downloadLink)
                downloadLink.click()
                document.body.removeChild(downloadLink)
              }
            }
          }
          request.send(parameters)  
        },
        
    },
};
